/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.locks.DLockGrantor;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.LockGrantorDestroyedException;
import com.gemstone.gemfire.distributed.internal.locks.RemoteThread;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class DLockQueryProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    private volatile DLockQueryReplyMessage reply;

    static DLockQueryReplyMessage query(InternalDistributedMember grantor, String serviceName, Object objectName, boolean lockBatch, DM dm) {
        DLockQueryProcessor processor = new DLockQueryProcessor(dm, grantor, serviceName);
        DLockQueryMessage msg = new DLockQueryMessage();
        msg.processorId = processor.getProcessorId();
        msg.serviceName = serviceName;
        msg.objectName = objectName;
        msg.lockBatch = lockBatch;
        msg.setRecipient(grantor);
        if (grantor.equals(dm.getId())) {
            msg.setSender(grantor);
            msg.processLocally(dm);
        } else {
            dm.putOutgoing(msg);
        }
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleAsUnexpected();
        }
        if (processor.reply == null) {
            return null;
        }
        return processor.reply;
    }

    private DLockQueryProcessor(DM dm, InternalDistributedMember grantor, String serviceName) {
        super(dm, grantor);
    }

    @Override
    protected boolean allowReplyFromSender() {
        return true;
    }

    @Override
    public void process(DistributionMessage msg) {
        try {
            DLockQueryReplyMessage myReply = (DLockQueryReplyMessage)msg;
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "Handling: {}", new Object[]{myReply});
            }
            this.reply = myReply;
        }
        finally {
            super.process(msg);
        }
    }

    public static final class DLockQueryReplyMessage
    extends ReplyMessage {
        static final int NOT_GRANTOR = 0;
        static final int OK = 1;
        protected int replyCode = 0;
        protected RemoteThread lesseeThread;
        protected int leaseId;
        protected long leaseExpireTime;

        boolean repliedOK() {
            return this.replyCode == 1;
        }

        boolean repliedNotGrantor() {
            return this.replyCode == 0;
        }

        DistributedMember getLessee() {
            if (this.lesseeThread != null) {
                return this.lesseeThread.getDistributedMember();
            }
            return null;
        }

        RemoteThread getLesseeThread() {
            return this.lesseeThread;
        }

        int getLeaseId() {
            return this.leaseId;
        }

        long getLeaseExpireTime() {
            return this.leaseExpireTime;
        }

        @Override
        public int getDSFID() {
            return -127;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.replyCode = in.readInt();
            if (this.replyCode == 1) {
                InternalDistributedMember lessee = (InternalDistributedMember)DataSerializer.readObject(in);
                if (lessee != null) {
                    this.lesseeThread = new RemoteThread(lessee, in.readInt());
                }
                this.leaseId = in.readInt();
                this.leaseExpireTime = in.readLong();
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.replyCode);
            if (this.replyCode == 1) {
                if (this.lesseeThread == null) {
                    DataSerializer.writeObject(null, out);
                } else {
                    DataSerializer.writeObject(this.lesseeThread.getDistributedMember(), out);
                    out.writeInt(this.lesseeThread.getThreadId());
                }
                out.writeInt(this.leaseId);
                out.writeLong(this.leaseExpireTime);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("DLockQueryReplyMessage@");
            sb.append(Integer.toHexString(this.hashCode()));
            sb.append(", replyCode: ");
            switch (this.replyCode) {
                case 0: {
                    sb.append("NOT_GRANTOR");
                    break;
                }
                case 1: {
                    sb.append("OK");
                    break;
                }
                default: {
                    sb.append(String.valueOf(this.replyCode));
                }
            }
            sb.append(", lesseeThread: ").append(this.lesseeThread);
            sb.append(", leaseId: ").append(this.leaseId);
            sb.append(", leaseExpireTime: ").append(this.leaseExpireTime);
            sb.append(", processorId: ").append(this.processorId);
            return sb.toString();
        }
    }

    public static final class DLockQueryMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        protected String serviceName;
        protected Object objectName;
        protected boolean lockBatch;
        protected int processorId;
        protected transient DLockService svc;
        protected transient DLockGrantor grantor;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void process(DistributionManager dm) {
            boolean failed = true;
            ReplyException replyException = null;
            try {
                this.svc = DLockService.getInternalServiceNamed(this.serviceName);
                if (this.svc == null) {
                    failed = false;
                    this.basicProcess(dm, false);
                } else {
                    this.executeBasicProcess(dm);
                }
                failed = false;
                if (!failed) return;
            }
            catch (RuntimeException e) {
                try {
                    replyException = new ReplyException(e);
                    throw e;
                    catch (VirtualMachineError e2) {
                        SystemFailure.initiateFailure(e2);
                        replyException = new ReplyException(e2);
                        throw e2;
                    }
                    catch (Error e3) {
                        SystemFailure.checkFailure();
                        replyException = new ReplyException(e3);
                        throw e3;
                    }
                }
                catch (Throwable throwable) {
                    if (!failed) throw throwable;
                    if (logger.isTraceEnabled(LogMarker.DLS)) {
                        logger.trace(LogMarker.DLS, "DLockQueryMessage.process failed for <{}>", new Object[]{this});
                    }
                    DLockQueryReplyMessage replyMsg = new DLockQueryReplyMessage();
                    replyMsg.setProcessorId(this.processorId);
                    replyMsg.setRecipient(this.getSender());
                    replyMsg.setException(replyException);
                    if (dm.getId().equals(this.getSender())) {
                        replyMsg.setSender(this.getSender());
                        replyMsg.dmProcess(dm);
                        throw throwable;
                    }
                    dm.putOutgoing(replyMsg);
                    throw throwable;
                }
            }
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "DLockQueryMessage.process failed for <{}>", new Object[]{this});
            }
            DLockQueryReplyMessage replyMsg = new DLockQueryReplyMessage();
            replyMsg.setProcessorId(this.processorId);
            replyMsg.setRecipient(this.getSender());
            replyMsg.setException(replyException);
            if (dm.getId().equals(this.getSender())) {
                replyMsg.setSender(this.getSender());
                replyMsg.dmProcess(dm);
                return;
            }
            dm.putOutgoing(replyMsg);
        }

        protected void processLocally(DM dm) {
            this.svc = DLockService.getInternalServiceNamed(this.serviceName);
            this.basicProcess(dm, true);
        }

        private void executeBasicProcess(final DM dm) {
            final DLockQueryMessage msg = this;
            dm.getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    if (logger.isTraceEnabled(LogMarker.DLS)) {
                        logger.trace(LogMarker.DLS, "[executeBasicProcess] {}", new Object[]{msg});
                    }
                    this.basicProcess(dm, true);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void basicProcess(DM dm, boolean waitForGrantor) {
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[basicProcess] {}", new Object[]{this});
            }
            DLockQueryReplyMessage replyMsg = new DLockQueryReplyMessage();
            replyMsg.setProcessorId(this.processorId);
            replyMsg.setRecipient(this.getSender());
            replyMsg.replyCode = 0;
            replyMsg.lesseeThread = null;
            replyMsg.leaseId = -1;
            replyMsg.leaseExpireTime = 0L;
            try {
                DLockGrantor.DLockGrantToken grantToken;
                if (this.svc == null || this.svc.isDestroyed()) {
                    return;
                }
                if (waitForGrantor) {
                    try {
                        this.grantor = DLockGrantor.waitForGrantor(this.svc);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.grantor = null;
                    }
                }
                if (this.grantor == null || this.grantor.isDestroyed()) {
                    return;
                }
                if (this.lockBatch) {
                    throw new UnsupportedOperationException("DLockQueryProcessor does not support lock batches");
                }
                try {
                    grantToken = this.grantor.handleLockQuery(this);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    grantToken = null;
                }
                if (grantToken != null) {
                    DLockGrantor.DLockGrantToken dLockGrantToken = grantToken;
                    synchronized (dLockGrantToken) {
                        if (!grantToken.isDestroyed()) {
                            replyMsg.lesseeThread = grantToken.getRemoteThread();
                            replyMsg.leaseId = grantToken.getLockId();
                            replyMsg.leaseExpireTime = grantToken.getLeaseExpireTime();
                        }
                    }
                }
                replyMsg.replyCode = 1;
            }
            catch (LockGrantorDestroyedException grantToken) {
            }
            catch (LockServiceDestroyedException grantToken) {
            }
            catch (RuntimeException e) {
                replyMsg.setException(new ReplyException(e));
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[basicProcess] caught RuntimeException", (Throwable)e);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                replyMsg.setException(new ReplyException(e));
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[basicProcess] caught Error", (Throwable)e);
                }
            }
            finally {
                if (dm.getId().equals(this.getSender())) {
                    replyMsg.setSender(this.getSender());
                    replyMsg.dmProcess(dm);
                } else {
                    dm.putOutgoing(replyMsg);
                }
            }
        }

        @Override
        public int getDSFID() {
            return -128;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.serviceName, out);
            DataSerializer.writeObject(this.objectName, out);
            out.writeBoolean(this.lockBatch);
            out.writeInt(this.processorId);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.serviceName = DataSerializer.readString(in);
            this.objectName = DataSerializer.readObject(in);
            this.lockBatch = in.readBoolean();
            this.processorId = in.readInt();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("DLockQueryMessage@");
            sb.append(Integer.toHexString(this.hashCode()));
            sb.append(", serviceName: ").append(this.serviceName);
            sb.append(", objectName: ").append(this.objectName);
            sb.append(", lockBatch: ").append(this.lockBatch);
            sb.append(", processorId: ").append(this.processorId);
            return sb.toString();
        }
    }
}

