/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.locks.DLockBatch;
import com.gemstone.gemfire.distributed.internal.locks.DLockLessorDepartureHandler;
import com.gemstone.gemfire.distributed.internal.locks.DLockQueryProcessor;
import com.gemstone.gemfire.distributed.internal.locks.DLockRemoteToken;
import com.gemstone.gemfire.distributed.internal.locks.DLockRequestProcessor;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.DistributedLockStats;
import com.gemstone.gemfire.distributed.internal.locks.LockGrantorDestroyedException;
import com.gemstone.gemfire.distributed.internal.locks.RemoteThread;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.IdentityArrayList;
import com.gemstone.gemfire.internal.cache.TXReservationMgr;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCountDownLatch;
import com.gemstone.gemfire.internal.util.concurrent.StoppableReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DLockGrantor {
    private static final Logger logger = LogService.getLogger();
    public static final boolean DEBUG_SUSPEND_LOCK = Boolean.getBoolean("gemfire.DLockService.DLockGrantor.debugSuspendLock");
    public static final long GRANTOR_THREAD_MAX_WAIT = 60000L;
    private static final int INITIALIZING = 0;
    private static final int READY = 1;
    private static final int DESTROYED = 5;
    protected final DLockService dlock;
    private final Map grantTokens = new HashMap();
    protected final DLockGrantorThread thread;
    private volatile int state = 0;
    private final StoppableReentrantReadWriteLock destroyLock;
    private final Map batchLocks = new HashMap();
    private final TXReservationMgr resMgr = new TXReservationMgr(false);
    private final StoppableCountDownLatch whileInitializing;
    private final StoppableCountDownLatch untilDestroyed;
    private final AtomicLong versionId = new AtomicLong(-1L);
    protected final DM dm;
    protected final Object suspendLock = new Object();
    protected RemoteThread lockingSuspendedBy = null;
    protected static final int INVALID_LOCK_ID = -1;
    protected int suspendedLockId = -1;
    private final LinkedList suspendQueue = new LinkedList();
    private final HashMap readLockCountMap = new HashMap();
    private int writeLockWaiters = 0;
    private int totalReadLockCount = 0;
    private ArrayList permittedRequests = new ArrayList();
    private final List permittedRequestsDrain = Collections.synchronizedList(new LinkedList());
    private int debugHandleSuspendTimeouts = 0;
    private MembershipListener membershipListener = new MembershipListener(){

        @Override
        public void memberJoined(InternalDistributedMember id) {
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void memberDeparted(final InternalDistributedMember id, final boolean crashed) {
            block4: {
                final DLockGrantor me = DLockGrantor.this;
                DM distMgr = me.dlock.getDistributionManager();
                if (distMgr.getCancelCriterion().cancelInProgress() != null) {
                    return;
                }
                final boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
                try {
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS, "[DLockGrantor.memberDeparted] waiting thread pool will process id={}", new Object[]{id});
                    }
                    distMgr.getWaitingThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    this.processMemberDeparted(id, crashed, me);
                                }
                                catch (InterruptedException e) {
                                    if (!isDebugEnabled_DLS) break block2;
                                    logger.trace(LogMarker.DLS, "Ignored interrupt processing departed member");
                                }
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    if (!isDebugEnabled_DLS) break block4;
                    logger.trace(LogMarker.DLS, "[DLockGrantor.memberDeparted] rejected handling of id={}", new Object[]{id});
                }
            }
        }

        protected void processMemberDeparted(InternalDistributedMember id, boolean crashed, DLockGrantor me) throws InterruptedException {
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[DLockGrantor.processMemberDeparted] id={}", new Object[]{id});
            }
            try {
                me.waitWhileInitializing();
                me.handleDepartureOf(id);
            }
            catch (LockGrantorDestroyedException lockGrantorDestroyedException) {
                // empty catch block
            }
        }
    };

    static DLockGrantor createGrantor(DLockService dlock, long versionId) {
        return new DLockGrantor(dlock, versionId);
    }

    static DLockGrantor getGrantorForService(DLockService dlock) {
        if (dlock == null) {
            return null;
        }
        return dlock.getGrantor();
    }

    public static DLockGrantor waitForGrantor(DLockService svc) throws InterruptedException {
        if (svc == null) {
            return null;
        }
        DLockGrantor oldGrantor = null;
        DLockGrantor grantor = DLockGrantor.getGrantorForService(svc);
        do {
            if (grantor == null || grantor.isDestroyed()) {
                return null;
            }
            grantor.waitWhileInitializing();
            if (svc.isDestroyed()) {
                return null;
            }
            if (!svc.isCurrentlyOrIsMakingLockGrantor()) {
                return null;
            }
            if (grantor.isReady()) continue;
            return null;
        } while ((oldGrantor = grantor) != (grantor = DLockGrantor.getGrantorForService(svc)));
        return grantor;
    }

    private DLockGrantor(DLockService dlock, long vId) {
        this.dm = dlock.getDistributionManager();
        CancelCriterion stopper = this.dm.getCancelCriterion();
        this.whileInitializing = new StoppableCountDownLatch(stopper, 1);
        this.untilDestroyed = new StoppableCountDownLatch(stopper, 1);
        this.dlock = dlock;
        this.destroyLock = new StoppableReentrantReadWriteLock(stopper);
        this.versionId.set(vId);
        this.dm.addMembershipListener(this.membershipListener);
        this.thread = new DLockGrantorThread(this, stopper);
        this.dlock.getStats().incGrantors(1);
    }

    public long getVersionId() {
        return this.versionId.get();
    }

    public void setVersionId(long v) {
        this.versionId.set(v);
    }

    public void waitWhileInitializing() throws InterruptedException {
        boolean interrupted = Thread.interrupted();
        try {
            if (interrupted && this.dlock.isInterruptibleLockRequest()) {
                throw new InterruptedException();
            }
            while (true) {
                try {
                    this.whileInitializing.await();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.throwIfInterruptible(e);
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitUntilDestroyed() throws InterruptedException {
        while (true) {
            boolean interrupted = Thread.interrupted();
            try {
                this.untilDestroyed.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.throwIfInterruptible(e);
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('<').append("DLockGrantor").append("@").append(Integer.toHexString(System.identityHashCode(this))).append(" state=").append(this.stateToString(this.state)).append(" name=").append(this.dlock.getName()).append(" version=").append(this.getVersionId()).append('>');
        return buffer.toString();
    }

    boolean isReady() {
        return this.state == 1;
    }

    boolean isInitializing() {
        return this.state == 0;
    }

    public boolean isDestroyed() {
        return this.state == 5;
    }

    void checkDestroyed() {
        this.throwIfDestroyed(this.isDestroyed());
    }

    private void throwIfDestroyed(boolean destroyed) {
        if (destroyed) {
            throw new LockGrantorDestroyedException(LocalizedStrings.DLockGrantor_GRANTOR_IS_DESTROYED.toLocalizedString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleLockBatch(DLockRequestProcessor.DLockRequestMessage request) throws InterruptedException {
        Map map = this.batchLocks;
        synchronized (map) {
            this.waitWhileInitializing();
            if (request.checkForTimeout()) {
                this.cleanupSuspendState(request);
                return;
            }
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[DLockGrantor.handleLockBatch]");
            }
            if (!this.acquireDestroyReadLock(0L)) {
                this.waitUntilDestroyed();
                this.checkDestroyed();
            }
            try {
                this.checkDestroyed();
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.handleLockBatch] request: {}", new Object[]{request});
                }
                DLockBatch batch = (DLockBatch)request.getObjectName();
                this.resMgr.makeReservation((IdentityArrayList)((Object)batch.getReqs()));
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.handleLockBatch] granting {}", new Object[]{batch.getBatchId()});
                }
                this.batchLocks.put(batch.getBatchId(), batch);
                request.respondWithGrant(Long.MAX_VALUE);
            }
            catch (CommitConflictException ex) {
                request.respondWithTryLockFailed(ex.getMessage());
            }
            finally {
                this.releaseDestroyReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLockBatch[] getLockBatches(InternalDistributedMember owner) {
        Map map = this.batchLocks;
        synchronized (map) {
            ArrayList<DLockBatch> batchList = new ArrayList<DLockBatch>();
            for (DLockBatch batch : this.batchLocks.values()) {
                if (!batch.getOwner().equals(owner)) continue;
                batchList.add(batch);
            }
            return batchList.toArray(new DLockBatch[batchList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLockBatch getLockBatch(Object batchId) throws InterruptedException {
        DLockBatch ret = null;
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.getLockBatch] enter: {}", new Object[]{batchId});
        }
        Map map = this.batchLocks;
        synchronized (map) {
            this.waitWhileInitializing();
            if (!this.acquireDestroyReadLock(0L)) {
                this.waitUntilDestroyed();
                this.checkDestroyed();
            }
            try {
                this.checkDestroyed();
                ret = (DLockBatch)this.batchLocks.get(batchId);
            }
            finally {
                this.releaseDestroyReadLock();
            }
        }
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.getLockBatch] exit: {}", new Object[]{batchId});
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLockBatch(Object batchId, DLockBatch newBatch) throws InterruptedException {
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.updateLockBatch] enter: {}", new Object[]{batchId});
        }
        Map map = this.batchLocks;
        synchronized (map) {
            this.waitWhileInitializing();
            if (!this.acquireDestroyReadLock(0L)) {
                this.waitUntilDestroyed();
                this.checkDestroyed();
            }
            try {
                this.checkDestroyed();
                DLockBatch oldBatch = (DLockBatch)this.batchLocks.get(batchId);
                if (oldBatch != null) {
                    this.batchLocks.put(batchId, newBatch);
                }
            }
            finally {
                this.releaseDestroyReadLock();
            }
        }
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.updateLockBatch] exit: {}", new Object[]{batchId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLockBatch(Object batchId, InternalDistributedMember owner) throws InterruptedException {
        if (logger.isTraceEnabled(LogMarker.DLS)) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.releaseLockBatch]");
        }
        Map map = this.batchLocks;
        synchronized (map) {
            this.waitWhileInitializing();
            if (!this.acquireDestroyReadLock(0L)) {
                this.waitUntilDestroyed();
                this.checkDestroyed();
            }
            try {
                this.checkDestroyed();
                DLockBatch batch = (DLockBatch)this.batchLocks.remove(batchId);
                if (batch != null) {
                    this.resMgr.releaseReservation((IdentityArrayList)((Object)batch.getReqs()));
                }
            }
            finally {
                this.releaseDestroyReadLock();
            }
        }
    }

    private boolean isLocalRequest(DLockRequestProcessor.DLockRequestMessage request) {
        return request.getSender().equals(this.dlock.getDistributionManager().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasWaitingRequests(Object name) {
        DLockGrantToken grant = this.getGrantToken(name);
        if (grant == null) {
            return false;
        }
        DLockGrantToken dLockGrantToken = grant;
        synchronized (dLockGrantToken) {
            return grant.hasWaitingRequests();
        }
    }

    DLockGrantToken handleLockQuery(DLockQueryProcessor.DLockQueryMessage query) throws InterruptedException {
        if (logger.isTraceEnabled(LogMarker.DLS)) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.handleLockQuery] {}", new Object[]{query});
        }
        if (this.acquireDestroyReadLock(0L)) {
            try {
                this.checkDestroyed();
                DLockGrantToken dLockGrantToken = this.getGrantToken(query.objectName);
                return dLockGrantToken;
            }
            finally {
                this.releaseDestroyReadLock();
            }
        }
        return null;
    }

    void handleLockRequest(DLockRequestProcessor.DLockRequestMessage request) throws InterruptedException {
        Assert.assertTrue(request.getRemoteThread() != null);
        if (request.getObjectName() instanceof DLockBatch) {
            this.handleLockBatch(request);
            return;
        }
        this.waitWhileInitializing();
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.handleLockRequest] {}", new Object[]{request});
        }
        if (!this.acquireDestroyReadLock(0L)) {
            if (this.isLocalRequest(request) && this.dlock.isDestroyed()) {
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.handleLockRequest] about to throwIfDestroyed");
                }
                this.throwIfDestroyed(true);
            } else {
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.handleLockRequest] about to waitUntilDestroyed");
                }
                this.waitUntilDestroyed();
                this.checkDestroyed();
            }
        }
        try {
            this.checkDestroyed();
            if (this.acquireLockPermission(request)) {
                this.handlePermittedLockRequest(request);
            }
        }
        finally {
            this.releaseDestroyReadLock();
        }
    }

    private void handlePermittedLockRequest(DLockRequestProcessor.DLockRequestMessage request) {
        if (logger.isTraceEnabled(LogMarker.DLS)) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.handlePermittedLockRequest] {}", new Object[]{request});
        }
        Assert.assertTrue(request.getRemoteThread() != null);
        DLockGrantToken grant = this.getOrCreateGrant(request.getObjectName());
        try {
            if (grant.grantLockToRequest(request)) {
            } else if (request.responded()) {
            } else if (request.isTryLock()) {
                this.cleanupSuspendState(request);
                request.respondWithTryLockFailed(request.getObjectName());
            } else if (request.checkForTimeout()) {
                this.cleanupSuspendState(request);
            } else {
                grant.schedule(request);
                this.thread.checkTimeToWait(this.calcWaitMillisFromNow(request), false);
            }
        }
        finally {
            grant.decAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeHeldLocks(InternalDistributedMember owner, Set tokens) throws InterruptedException {
        Object object = this;
        synchronized (object) {
            if (this.isDestroyed()) {
                return;
            }
            if (!this.acquireDestroyReadLock(0L)) {
                return;
            }
        }
        try {
            object = this.grantTokens;
            synchronized (object) {
                Set members = this.dlock.getDistributionManager().getDistributionManagerIds();
                boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
                for (DLockRemoteToken token : tokens) {
                    DLockGrantToken grantToken = this.getOrCreateGrant(token.getName());
                    try {
                        if (!members.contains(owner)) {
                            if (!isDebugEnabled_DLS) continue;
                            logger.trace(LogMarker.DLS, "Initialization of held locks is skipping {} because owner {} is not in view: ", new Object[]{token, owner, members});
                            continue;
                        }
                        RemoteThread rThread = null;
                        boolean isSuspendLock = false;
                        int lockId = -1;
                        Object object2 = grantToken;
                        synchronized (object2) {
                            block28: {
                                if (!grantToken.isLeaseHeld()) break block28;
                                logger.error(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.DLockGrantor_INITIALIZATION_OF_HELD_LOCKS_IS_SKIPPING_0_BECAUSE_LOCK_IS_ALREADY_HELD_1, new Object[]{token, grantToken}));
                                continue;
                            }
                            grantToken.grantLock(owner, token.getLeaseExpireTime(), token.getLeaseId(), token.getLesseeThread());
                            if (grantToken.getLeaseExpireTime() > -1L && grantToken.getLeaseExpireTime() < Long.MAX_VALUE) {
                                long now = DLockService.getLockTimeStamp(this.dm);
                                this.thread.checkTimeToWait(grantToken.getLeaseExpireTime() - now, true);
                            }
                            rThread = grantToken.getRemoteThread();
                            isSuspendLock = grantToken.isSuspendLockingToken();
                            lockId = grantToken.getLockId();
                        }
                        object2 = this.suspendLock;
                        synchronized (object2) {
                            if (isSuspendLock) {
                                this.suspendLocking(rThread, lockId);
                            } else {
                                Assert.assertTrue(!this.isLockingSuspended() || this.isLockingSuspendedBy(rThread), "Locking is suspended by a different thread: " + token);
                                Integer integer = (Integer)this.readLockCountMap.get(rThread);
                                int readLockCount = integer == null ? 0 : integer;
                                this.readLockCountMap.put(rThread, ++readLockCount);
                                ++this.totalReadLockCount;
                                this.checkTotalReadLockCount();
                            }
                        }
                    }
                    finally {
                        grantToken.decAccess();
                    }
                }
            }
            return;
        }
        finally {
            this.releaseDestroyReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    long reenterLock(DLockRequestProcessor.DLockRequestMessage request) throws InterruptedException {
        DLockGrantToken grant;
        block13: {
            this.waitWhileInitializing();
            if (!this.acquireDestroyReadLock(0L)) {
                this.waitUntilDestroyed();
                this.checkDestroyed();
            }
            try {
                this.checkDestroyed();
                grant = this.getGrantToken(request.getObjectName());
                if (grant == null) {
                    if (logger.isTraceEnabled(LogMarker.DLS)) {
                        logger.trace(LogMarker.DLS, "[DLockGrantor.reenterLock] no grantToken found for {}", new Object[]{request.getObjectName()});
                    }
                    long l = 0L;
                    this.releaseDestroyReadLock();
                    return l;
                }
                DLockGrantToken dLockGrantToken = grant;
                // MONITORENTER : dLockGrantToken
                if (!this.dm.isCurrentMember(request.getSender()) || grant.isDestroyed()) {
                    long l = 0L;
                    // MONITOREXIT : dLockGrantToken
                    this.releaseDestroyReadLock();
                    return l;
                }
                if (grant.isLockedBy(request.getSender(), request.getLockId())) break block13;
            }
            catch (Throwable throwable) {
                this.releaseDestroyReadLock();
                throw throwable;
            }
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[DLockGrantor.reenterLock] grant is not locked by sender={} lockId={} grant={}", new Object[]{request.getSender(), request.getLockId(), grant});
            }
            long l = 0L;
            // MONITOREXIT : dLockGrantToken
            this.releaseDestroyReadLock();
            return l;
        }
        long leaseExpireTime = Math.max(grant.getLeaseExpireTime(), grant.calcLeaseExpireTime(request.getLeaseTime()));
        grant.grantLock(request.getSender(), leaseExpireTime, request.getLockId(), grant.getRemoteThread());
        long l = grant.getLeaseExpireTime();
        // MONITOREXIT : dLockGrantToken
        this.releaseDestroyReadLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseIfLocked(Object name, InternalDistributedMember owner, int lockId) throws InterruptedException {
        this.waitWhileInitializing();
        if (!this.acquireDestroyReadLock(0L)) {
            this.waitUntilDestroyed();
            this.checkDestroyed();
        }
        try {
            this.checkDestroyed();
            this.getAndReleaseGrantIfLockedBy(name, owner, lockId);
        }
        finally {
            this.releaseDestroyReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndReleaseGrantIfLockedBy(Object name, InternalDistributedMember owner, int lockId) {
        Map map = this.grantTokens;
        synchronized (map) {
            DLockGrantToken grantToken = this.basicGetGrantToken(name);
            if (grantToken != null) {
                DLockGrantToken dLockGrantToken = grantToken;
                synchronized (dLockGrantToken) {
                    try {
                        grantToken.releaseIfLockedBy(owner, lockId);
                        this.removeGrantIfUnused(grantToken);
                    }
                    catch (IllegalStateException e) {
                        this.dlock.checkDestroyed();
                        this.checkDestroyed();
                        return;
                    }
                }
            }
        }
    }

    void grantLock(Object name) throws InterruptedException {
        this.waitWhileInitializing();
        if (!this.acquireDestroyReadLock(0L)) {
            this.waitUntilDestroyed();
            this.checkDestroyed();
        }
        try {
            this.checkDestroyed();
            DLockGrantToken grant = this.getGrantToken(name);
            if (grant != null) {
                this.removeGrantIfUnused(grant);
            }
        }
        finally {
            this.releaseDestroyReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDepartureOf(InternalDistributedMember owner) throws InterruptedException {
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
        if (this.acquireDestroyReadLock(0L)) {
            try {
                if (this.isDestroyed()) {
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS, "[DLockGrantor.handleDepartureOf] grantor is destroyed; ignoring {}", new Object[]{owner});
                    }
                    return;
                }
                try {
                    DLockLessorDepartureHandler handler = this.dlock.getDLockLessorDepartureHandler();
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS, "[DLockGrantor.handleDepartureOf] handler = {}", new Object[]{handler});
                    }
                    if (handler != null) {
                        handler.handleDepartureOf(owner, this);
                    }
                }
                catch (CancelException e) {
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS, "[DlockGrantor.handleDepartureOf] ignored cancellation (1)");
                    }
                }
                finally {
                    Object object = this.suspendLock;
                    synchronized (object) {
                        HashSet<RemoteThread> removals = new HashSet<RemoteThread>();
                        for (Map.Entry entry : this.readLockCountMap.entrySet()) {
                            RemoteThread rThread = (RemoteThread)entry.getKey();
                            if (!rThread.getDistributedMember().equals(owner)) continue;
                            removals.add(rThread);
                        }
                        Iterator it = removals.iterator();
                        while (it.hasNext()) {
                            try {
                                this.postReleaseLock((RemoteThread)((Object)it.next()), null);
                            }
                            catch (CancelException e) {
                                if (!isDebugEnabled_DLS) continue;
                                logger.trace(LogMarker.DLS, "[DlockGrantor.handleDepartureOf] ignored cancellation (2)");
                            }
                        }
                    }
                    object = this.grantTokens;
                    synchronized (object) {
                        ArrayList grantsReferencingMember = new ArrayList();
                        Collection grants = this.grantTokens.values();
                        for (DLockGrantToken grant : grants) {
                            try {
                                grant.checkDepartureOf(owner, grantsReferencingMember);
                            }
                            catch (CancelException e) {
                                if (!isDebugEnabled_DLS) continue;
                                logger.trace(LogMarker.DLS, "[DlockGrantor.handleDepartureOf] ignored cancellation (3)");
                            }
                        }
                        ArrayList grantsToRemoveIfUnused = new ArrayList();
                        for (DLockGrantToken grant : grantsReferencingMember) {
                            try {
                                grant.handleDepartureOf(owner, grantsToRemoveIfUnused);
                            }
                            catch (CancelException e) {
                                if (!isDebugEnabled_DLS) continue;
                                logger.trace(LogMarker.DLS, "[DlockGrantor.handleDepartureOf] ignored cancellation (4)");
                            }
                        }
                        for (DLockGrantToken grant : grantsToRemoveIfUnused) {
                            try {
                                this.removeGrantIfUnused(grant);
                            }
                            catch (CancelException e) {
                                if (!isDebugEnabled_DLS) continue;
                                logger.trace(LogMarker.DLS, "[DlockGrantor.handleDepartureOf] ignored cancellation (5)");
                            }
                        }
                    }
                }
            }
            finally {
                this.releaseDestroyReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        DLockGrantor dLockGrantor = this;
        synchronized (dLockGrantor) {
            if (this.isDestroyed()) {
                return;
            }
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[simpleDestroy]");
            }
            boolean acquired = false;
            try {
                boolean locksHeld = false;
                try {
                    this.acquireDestroyWriteLock(Long.MAX_VALUE);
                    acquired = true;
                    if (this.isInitializing()) {
                        locksHeld = true;
                    } else {
                        Map map = this.grantTokens;
                        synchronized (map) {
                            InternalDistributedMember me = this.dlock.getDistributionManager().getId();
                            for (DLockGrantToken grant : this.grantTokens.values()) {
                                InternalDistributedMember owner = grant.getOwner();
                                if (owner == null || owner.equals(me)) continue;
                                locksHeld = true;
                                break;
                            }
                        }
                    }
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS, "[simpleDestroy] {} locks held", new Object[]{locksHeld ? "with" : "without"});
                    }
                }
                finally {
                    try {
                        this.destroyGrantor();
                    }
                    finally {
                        this.dlock.clearGrantor(this.getVersionId(), locksHeld);
                    }
                }
            }
            finally {
                if (acquired) {
                    this.releaseDestroyWriteLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyGrantor() {
        Assert.assertHoldsLock(this, true);
        this.makeDestroyed();
        Object object = this.grantTokens;
        synchronized (object) {
            Collection grants = this.grantTokens.values();
            for (DLockGrantToken grant : grants) {
                grant.handleGrantorDestruction();
            }
        }
        object = this.suspendLock;
        synchronized (object) {
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[DLockGrantor.destroyAndRemove] responding to {} permitted requests.", new Object[]{this.permittedRequests.size()});
            }
            this.respondWithNotGrantor(this.permittedRequests.iterator());
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[DLockGrantor.destroyAndRemove] responding to {} requests awaiting permission.", new Object[]{this.suspendQueue.size()});
            }
            this.respondWithNotGrantor(this.suspendQueue.iterator());
            for (List drain : this.permittedRequestsDrain) {
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.destroyAndRemove] responding to {} drained permitted requests.", new Object[]{drain.size()});
                }
                this.respondWithNotGrantor(drain.iterator());
            }
        }
    }

    private void respondWithNotGrantor(Iterator requests) {
        while (requests.hasNext()) {
            DLockRequestProcessor.DLockRequestMessage request = (DLockRequestProcessor.DLockRequestMessage)requests.next();
            request.respondWithNotGrantor();
        }
    }

    void debug() {
        logger.info(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.TESTING, "[DLockGrantor.debug] svc=" + this.dlock.getName() + "; state=" + this.state + "; initLatch.ct=" + this.whileInitializing.getCount()));
    }

    synchronized boolean makeReady(boolean enforceInitializing) {
        if (this.isDestroyed()) {
            this.dlock.checkDestroyed();
        }
        if (!enforceInitializing && !this.isInitializing()) {
            return false;
        }
        this.assertInitializing();
        if (logger.isTraceEnabled(LogMarker.DLS)) {
            StringBuffer sb = new StringBuffer("DLockGrantor " + this.dlock.getName() + " initialized with:");
            Iterator tokens = this.grantTokens.values().iterator();
            while (tokens.hasNext()) {
                sb.append("\n\t" + tokens.next());
            }
            logger.trace(LogMarker.DLS, sb.toString());
        }
        this.state = 1;
        this.whileInitializing.countDown();
        this.thread.start();
        return true;
    }

    void postRemoteReleaseLock(Object objectName) throws InterruptedException {
        if (!this.acquireDestroyReadLock(0L)) {
            return;
        }
        try {
            this.checkDestroyed();
            this.drainPermittedRequests();
            this.grantLock(objectName);
        }
        catch (LockServiceDestroyedException lockServiceDestroyedException) {
        }
        catch (LockGrantorDestroyedException lockGrantorDestroyedException) {
        }
        finally {
            this.releaseDestroyReadLock();
        }
    }

    private boolean acquireDestroyReadLock(long millis) throws InterruptedException {
        boolean interrupted = Thread.interrupted();
        try {
            if (interrupted && this.dlock.isInterruptibleLockRequest()) {
                throw new InterruptedException();
            }
            while (true) {
                try {
                    boolean acquired;
                    this.dm.getCancelCriterion().checkCancelInProgress(null);
                    boolean bl = acquired = this.destroyLock.readLock().tryLock(millis);
                    return bl;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.throwIfInterruptible(e);
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void releaseDestroyReadLock() {
        this.destroyLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireDestroyWriteLock(long millis) {
        while (true) {
            boolean interrupted = Thread.interrupted();
            try {
                this.dm.getCancelCriterion().checkCancelInProgress(null);
                boolean acquired = this.destroyLock.writeLock().tryLock(millis);
                if (!acquired) continue;
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void releaseDestroyWriteLock() {
        this.destroyLock.writeLock().unlock();
    }

    private long calcWaitMillisFromNow(DLockRequestProcessor.DLockRequestMessage request) {
        long result = request.getTimeoutTS();
        if (result != Long.MAX_VALUE) {
            long now = DLockService.getLockTimeStamp(this.dlock.getDistributionManager());
            result -= now;
        }
        return result;
    }

    private void makeDestroyed() {
        try {
            this.thread.shutdown();
            this.state = 5;
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "DLockGrantor {} state is DESTROYED", new Object[]{this.dlock.getName()});
            }
            if (this.untilDestroyed.getCount() > 0L) {
                this.untilDestroyed.countDown();
            }
            if (this.whileInitializing.getCount() > 0L) {
                this.whileInitializing.countDown();
            }
            this.dlock.getDistributionManager().removeMembershipListener(this.membershipListener);
        }
        finally {
            this.dlock.getStats().incGrantors(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection snapshotGrantTokens() {
        ArrayList snapshot = null;
        Map map = this.grantTokens;
        synchronized (map) {
            snapshot = new ArrayList(this.grantTokens.values());
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DLockGrantToken getOrCreateGrant(Object name) {
        DLockGrantToken grantToken = null;
        Map map = this.grantTokens;
        synchronized (map) {
            grantToken = this.basicGetGrantToken(name);
            if (grantToken == null) {
                grantToken = new DLockGrantToken(this.dlock, this, name);
                grantToken.incAccess();
                this.basicPutGrantToken(grantToken);
            } else {
                DLockGrantToken dLockGrantToken = grantToken;
                synchronized (dLockGrantToken) {
                    if (grantToken.isDestroyed()) {
                        grantToken = new DLockGrantToken(this.dlock, this, name);
                        grantToken.incAccess();
                        this.basicPutGrantToken(grantToken);
                    } else {
                        grantToken.incAccess();
                    }
                }
            }
        }
        return grantToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getGrantTokens() {
        Map map = this.grantTokens;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.grantTokens.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeGrantIfUnused(DLockGrantToken grant) {
        Map map = this.grantTokens;
        synchronized (map) {
            DLockGrantToken dLockGrantToken = grant;
            synchronized (dLockGrantToken) {
                if (this.isDestroyed() || grant.isDestroyed()) {
                    return;
                }
                if (grant.grantLockToNextRequest()) {
                    return;
                }
                if (!(grant.isBeingAccessed() || grant.isGranted(false) || grant.hasWaitingRequests())) {
                    this.basicRemoveGrantToken(grant);
                }
            }
        }
    }

    protected void removeUnusedGrants(Iterator grants) {
        while (grants.hasNext()) {
            DLockGrantToken grant = (DLockGrantToken)grants.next();
            this.removeGrantIfUnused(grant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLockGrantToken getGrantToken(Object name) {
        Map map = this.grantTokens;
        synchronized (map) {
            return this.basicGetGrantToken(name);
        }
    }

    private DLockGrantToken basicGetGrantToken(Object name) {
        return (DLockGrantToken)this.grantTokens.get(name);
    }

    private void basicPutGrantToken(DLockGrantToken grantToken) {
        this.grantTokens.put(grantToken.getName(), grantToken);
        this.dlock.getStats().incGrantTokens(1);
    }

    private void basicRemoveGrantToken(DLockGrantToken grantToken) {
        Object removed = this.grantTokens.remove(grantToken.getName());
        if (removed != null) {
            Assert.assertTrue(removed == grantToken);
            grantToken.destroy();
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[DLockGrantor.basicRemoveGrantToken] removed {}; removed={}", new Object[]{grantToken, removed});
            }
        }
    }

    protected long expireAndGrantLocks(Iterator grants) {
        long smallestExpire = Long.MAX_VALUE;
        while (grants.hasNext()) {
            long expire;
            DLockGrantToken grant = (DLockGrantToken)grants.next();
            if (grant.isDestroyed() || (expire = grant.expireAndGrantLock()) >= smallestExpire) continue;
            smallestExpire = expire;
        }
        return smallestExpire;
    }

    protected long handleRequestTimeouts(Iterator grants) {
        long smallestTimeout = Long.MAX_VALUE;
        while (grants.hasNext()) {
            long timeout;
            DLockGrantToken grant = (DLockGrantToken)grants.next();
            if (grant.isDestroyed() || (timeout = grant.handleRequestTimeouts()) >= smallestTimeout) continue;
            smallestTimeout = timeout;
        }
        return smallestTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebugHandleSuspendTimeouts(int value) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.debugHandleSuspendTimeouts = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long handleSuspendTimeouts() {
        Object req22;
        long smallestTimeout = Long.MAX_VALUE;
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.suspendQueue.isEmpty()) {
                return smallestTimeout;
            }
            if (this.isDestroyed()) {
                return smallestTimeout;
            }
        }
        ArrayList<Object> timeouts = new ArrayList<Object>();
        ArrayList copySuspendQueue = null;
        Object object2 = this.suspendLock;
        synchronized (object2) {
            copySuspendQueue = new ArrayList(this.suspendQueue);
        }
        for (Object req22 : copySuspendQueue) {
            if (((DLockRequestProcessor.DLockRequestMessage)req22).checkForTimeout()) {
                this.cleanupSuspendState((DLockRequestProcessor.DLockRequestMessage)req22);
                timeouts.add(req22);
                continue;
            }
            long timeout = ((DLockRequestProcessor.DLockRequestMessage)req22).getTimeoutTS();
            if (timeout >= smallestTimeout) continue;
            smallestTimeout = timeout;
        }
        int localDebugHandleSuspendTimeouts = 0;
        req22 = this.suspendLock;
        synchronized (req22) {
            localDebugHandleSuspendTimeouts = this.debugHandleSuspendTimeouts;
        }
        if (localDebugHandleSuspendTimeouts > 0) {
            try {
                logger.info(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.DLockGrantor_DEBUGHANDLESUSPENDTIMEOUTS_SLEEPING_FOR__0, localDebugHandleSuspendTimeouts));
                Thread.sleep(localDebugHandleSuspendTimeouts);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!timeouts.isEmpty()) {
            Object object3 = this.suspendLock;
            synchronized (object3) {
                if (this.writeLockWaiters > 0) {
                    for (DLockRequestProcessor.DLockRequestMessage dLockRequestMessage : timeouts) {
                        if (!this.suspendQueue.remove(dLockRequestMessage) || !dLockRequestMessage.isSuspendLockingRequest()) continue;
                        --this.writeLockWaiters;
                    }
                } else {
                    Assert.assertTrue(this.writeLockWaiters == 0, "Grantor state writeLockWaiters changed while holding suspendLock");
                    this.suspendQueue.removeAll(timeouts);
                }
                this.checkWriteLockWaiters();
            }
        }
        return smallestTimeout;
    }

    private String stateToString(int stateInt) {
        String stateDesc = null;
        switch (stateInt) {
            case 0: {
                stateDesc = "INITIALIZING";
                break;
            }
            case 1: {
                stateDesc = "READY";
                break;
            }
            case 5: {
                stateDesc = "DESTROYED";
                break;
            }
            default: {
                stateDesc = null;
            }
        }
        if (stateDesc == null) {
            throw new IllegalArgumentException(LocalizedStrings.DLockGrantor_UNKNOWN_STATE_FOR_GRANTOR_0.toLocalizedString(this.state));
        }
        return stateDesc;
    }

    private void assertInitializing() {
        if (this.state != 0) {
            String stateDesc = this.stateToString(this.state);
            throw new IllegalStateException(LocalizedStrings.DLockGrantor_DLOCKGRANTOR_OPERATION_ONLY_ALLOWED_WHEN_INITIALIZING_NOT_0.toLocalizedString(stateDesc));
        }
    }

    protected void suspendLocking(RemoteThread myRThread, int lockId) {
        if (DEBUG_SUSPEND_LOCK) {
            Assert.assertHoldsLock(this.suspendLock, true);
        }
        if (logger.isTraceEnabled(LogMarker.DLS)) {
            logger.trace(LogMarker.DLS, "Suspend locking of {} by {} with lockId of {}", new Object[]{this.dlock, myRThread, lockId});
        }
        Assert.assertTrue(myRThread != null, "Attempted to suspend locking for null RemoteThread");
        Assert.assertTrue(this.lockingSuspendedBy == null || this.lockingSuspendedBy.equals(myRThread), "Attempted to suspend locking for " + myRThread + " but locking is already suspended by " + this.lockingSuspendedBy);
        this.suspendedLockId = lockId;
        this.lockingSuspendedBy = myRThread;
    }

    private void resumeLocking() {
        if (DEBUG_SUSPEND_LOCK) {
            Assert.assertHoldsLock(this.suspendLock, true);
        }
        if (logger.isTraceEnabled(LogMarker.DLS)) {
            logger.trace(LogMarker.DLS, "Resume locking of {}", new Object[]{this.dlock});
        }
        this.lockingSuspendedBy = null;
        this.suspendedLockId = -1;
    }

    protected boolean isLockingSuspended() {
        if (DEBUG_SUSPEND_LOCK) {
            Assert.assertHoldsLock(this.suspendLock, true);
        }
        return this.lockingSuspendedBy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLockingSuspendedWithSync() {
        Object object = this.suspendLock;
        synchronized (object) {
            return this.lockingSuspendedBy != null;
        }
    }

    protected boolean isLockingSuspendedBy(RemoteThread rThread) {
        if (DEBUG_SUSPEND_LOCK) {
            Assert.assertHoldsLock(this.suspendLock, true);
        }
        if (rThread == null) {
            return false;
        }
        return rThread.equals(this.lockingSuspendedBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String displayStatus(RemoteThread rThread, Object name) {
        StringBuffer sb = new StringBuffer();
        Object object = this.suspendLock;
        synchronized (object) {
            sb.append(' ');
            sb.append(this.toString());
            sb.append(" id=" + this.hashCode());
            sb.append(" rThread=" + rThread);
            if (name != null) {
                sb.append(" name=" + name);
            }
            sb.append(" permittedRequests (" + this.permittedRequests.size() + ")=" + this.permittedRequests.toString() + "");
            sb.append(" suspendedLockId = " + this.suspendedLockId);
            sb.append(" lockingSuspendedBy = " + this.lockingSuspendedBy);
            sb.append(" writeLockWaiters = " + this.writeLockWaiters);
            sb.append(" totalReadLockCount = " + this.totalReadLockCount);
            sb.append("\nsuspendQueue (" + this.suspendQueue.size() + ")=" + this.suspendQueue.toString());
            sb.append("\nreadLockers (" + this.readLockCountMap.size() + ")");
        }
        return sb.toString();
    }

    private void postReleaseSuspendLock(RemoteThread rThread, Object lock) {
        DLockRequestProcessor.DLockRequestMessage nextRequest;
        int readLockCount;
        if (!this.isLockingSuspendedBy(rThread)) {
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[postReleaseSuspendLock] locking is no longer suspended by {}", new Object[]{rThread});
            }
            return;
        }
        boolean resume = true;
        Integer integer = (Integer)this.readLockCountMap.get(rThread);
        int n = readLockCount = integer == null ? 0 : integer;
        if (readLockCount == 0 && !this.suspendQueue.isEmpty() && (nextRequest = (DLockRequestProcessor.DLockRequestMessage)this.suspendQueue.getFirst()).isSuspendLockingRequest()) {
            resume = false;
            this.resumeLocking();
            this.suspendLocking(nextRequest.getRemoteThread(), nextRequest.getLockId());
            this.permittedRequests.add(this.suspendQueue.removeFirst());
            --this.writeLockWaiters;
            this.checkWriteLockWaiters();
        }
        if (resume) {
            this.resumeLocking();
            while (!this.suspendQueue.isEmpty()) {
                nextRequest = (DLockRequestProcessor.DLockRequestMessage)this.suspendQueue.getFirst();
                if (nextRequest.isSuspendLockingRequest()) {
                    Assert.assertTrue(this.writeLockWaiters > 0, "SuspendLocking request is waiting but writeLockWaiters is 0");
                    break;
                }
                RemoteThread nextRThread = nextRequest.getRemoteThread();
                integer = (Integer)this.readLockCountMap.get(nextRThread);
                readLockCount = integer == null ? 0 : integer;
                this.readLockCountMap.put(nextRThread, ++readLockCount);
                ++this.totalReadLockCount;
                this.checkTotalReadLockCount();
                this.permittedRequests.add(this.suspendQueue.removeFirst());
            }
        }
        if (logger.isTraceEnabled(LogMarker.DLS)) {
            logger.trace(LogMarker.DLS, "[postReleaseSuspendLock] new status {}", new Object[]{this.displayStatus(rThread, null)});
        }
    }

    private void postReleaseReadLock(RemoteThread rThread, Object lock) {
        int readLockCount;
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
        Integer integer = (Integer)this.readLockCountMap.get(rThread);
        int n = readLockCount = integer == null ? 0 : integer;
        if (readLockCount < 1) {
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[postReleaseReadLock] no locks are currently held by {}", new Object[]{rThread});
            }
            return;
        }
        if (--readLockCount == 0) {
            this.readLockCountMap.remove(rThread);
        } else {
            this.readLockCountMap.put(rThread, readLockCount);
        }
        --this.totalReadLockCount;
        if (this.totalReadLockCount < 0 && isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS, "Total readlock count has dropped to {} for {}", new Object[]{this.totalReadLockCount, this});
        }
        if (this.totalReadLockCount == 0 && !this.suspendQueue.isEmpty()) {
            DLockRequestProcessor.DLockRequestMessage nextRequest = (DLockRequestProcessor.DLockRequestMessage)this.suspendQueue.getFirst();
            if (nextRequest.isSuspendLockingRequest()) {
                this.suspendLocking(nextRequest.getRemoteThread(), nextRequest.getLockId());
                --this.writeLockWaiters;
                this.permittedRequests.add(this.suspendQueue.removeFirst());
                this.checkWriteLockWaiters();
            } else {
                String s = "\n (readLockCount=" + readLockCount + ", totalReadLockCount=" + this.totalReadLockCount + ", writeLockWaiters=" + this.writeLockWaiters + ",\nsuspendQueue=" + this.suspendQueue + ",\npermittedRequests=" + this.permittedRequests;
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DLockGrantor_RELEASED_REGULAR_LOCK_WITH_WAITING_READ_LOCK_0, s));
                Assert.assertTrue(false, LocalizedStrings.DLockGrantor_RELEASED_REGULAR_LOCK_WITH_WAITING_READ_LOCK_0.toString(s));
            }
        }
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS, "[postReleaseReadLock] new status {}", new Object[]{this.displayStatus(rThread, null)});
        }
        this.checkTotalReadLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postReleaseLock(RemoteThread rThread, Object lock) {
        Assert.assertTrue(rThread != null);
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkDestroyed();
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[postReleaseLock] rThread={} lock={} permittedRequests={} suspendQueue={}", new Object[]{rThread, lock, this.permittedRequests, this.suspendQueue});
            }
            if (DLockService.SUSPEND_LOCKING_TOKEN.equals(lock)) {
                this.postReleaseSuspendLock(rThread, lock);
            } else {
                this.postReleaseReadLock(rThread, lock);
            }
        }
    }

    protected void cleanupSuspendState(DLockRequestProcessor.DLockRequestMessage request) {
        this.postReleaseLock(request.getRemoteThread(), request.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainPermittedRequests() {
        ArrayList drain = null;
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.permittedRequests.isEmpty()) {
                return;
            }
            drain = this.permittedRequests;
            this.permittedRequestsDrain.add(drain);
            this.permittedRequests = new ArrayList();
        }
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS, "[drainPermittedRequests] draining {}", new Object[]{drain});
        }
        for (DLockRequestProcessor.DLockRequestMessage request : drain) {
            this.checkDestroyed();
            try {
                this.handlePermittedLockRequest(request);
            }
            catch (LockGrantorDestroyedException e) {
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "LockGrantorDestroyedException respondWithNotGrantor to {}", new Object[]{request});
                }
                request.respondWithNotGrantor();
            }
            catch (LockServiceDestroyedException e) {
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "LockServiceDestroyedException respondWithNotGrantor to {}", new Object[]{request});
                }
                request.respondWithNotGrantor();
            }
            catch (RuntimeException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.DLockGrantor_PROCESSING_OF_POSTREMOTERELEASELOCK_THREW_UNEXPECTED_RUNTIMEEXCEPTION, e));
                request.respondWithException(e);
            }
        }
        Object object2 = this.suspendLock;
        synchronized (object2) {
            this.checkDestroyed();
            this.permittedRequestsDrain.remove(drain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireSuspendLockPermission(DLockRequestProcessor.DLockRequestMessage request) {
        boolean permitLockRequest = false;
        RemoteThread rThread = request.getRemoteThread();
        Assert.assertTrue(rThread != null);
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkDestroyed();
            if (!this.dm.isCurrentMember(request.getSender())) {
                logger.info(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.DLockGrantor_IGNORING_LOCK_REQUEST_FROM_NONMEMBER_0, request));
                return false;
            }
            Integer integer = (Integer)this.readLockCountMap.get(rThread);
            int readLockCount = integer == null ? 0 : integer;
            boolean othersHaveReadLocks = this.totalReadLockCount > readLockCount;
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
            if (this.isLockingSuspended() || this.writeLockWaiters > 0 || othersHaveReadLocks) {
                ++this.writeLockWaiters;
                this.suspendQueue.addLast(request);
                this.thread.checkTimeToWait(this.calcWaitMillisFromNow(request), false);
                this.checkWriteLockWaiters();
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.acquireSuspend] added '{}' to end of suspendQueue.", new Object[]{request});
                }
            } else {
                permitLockRequest = true;
                this.suspendLocking(rThread, request.getLockId());
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.acquireSuspendLockPermission] permitted and suspended for {}", new Object[]{request});
                }
            }
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[DLockGrantor.acquireSuspendLockPermission] new status  permitLockRequest = {}{}", new Object[]{permitLockRequest, this.displayStatus(rThread, null)});
            }
        }
        return permitLockRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireReadLockPermission(DLockRequestProcessor.DLockRequestMessage request) {
        boolean permitLockRequest = false;
        RemoteThread rThread = request.getRemoteThread();
        Assert.assertTrue(rThread != null);
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkDestroyed();
            if (!this.dm.isCurrentMember(request.getSender())) {
                logger.info(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.DLockGrantor_IGNORING_LOCK_REQUEST_FROM_NONMEMBER_0, request));
                return false;
            }
            Integer integer = (Integer)this.readLockCountMap.get(rThread);
            int readLockCount = integer == null ? 0 : integer;
            boolean threadHoldsLock = readLockCount > 0 || this.isLockingSuspendedBy(rThread);
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
            if (!threadHoldsLock && (this.isLockingSuspended() || this.writeLockWaiters > 0)) {
                this.suspendQueue.addLast(request);
                this.thread.checkTimeToWait(this.calcWaitMillisFromNow(request), false);
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.acquireReadLockPermission] added {} to end of suspendQueue.", new Object[]{request});
                }
            } else {
                this.readLockCountMap.put(rThread, ++readLockCount);
                ++this.totalReadLockCount;
                permitLockRequest = true;
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS, "[DLockGrantor.acquireReadLockPermission] permitted {}", new Object[]{request});
                }
            }
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[DLockGrantor.acquireReadLockPermission] new status  threadHoldsLock = {} permitLockRequest = {}{}", new Object[]{threadHoldsLock, permitLockRequest, this.displayStatus(rThread, null)});
            }
            this.checkTotalReadLockCount();
        }
        return permitLockRequest;
    }

    private boolean acquireLockPermission(DLockRequestProcessor.DLockRequestMessage request) {
        if (logger.isTraceEnabled(LogMarker.DLS)) {
            logger.trace(LogMarker.DLS, "[DLockGrantor.acquireLockPermission] {}", new Object[]{request});
        }
        boolean permitLockRequest = false;
        permitLockRequest = request.getObjectName().equals(DLockService.SUSPEND_LOCKING_TOKEN) ? this.acquireSuspendLockPermission(request) : this.acquireReadLockPermission(request);
        return permitLockRequest;
    }

    private void throwIfInterruptible(InterruptedException e) throws InterruptedException {
        this.dm.getCancelCriterion().checkCancelInProgress(e);
        if (this.dlock.isInterruptibleLockRequest()) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpService() {
        Map map = this.grantTokens;
        synchronized (map) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("DLockGrantor.dumpService() for ").append(this);
            buffer.append("\n").append(this.grantTokens.size()).append(" grantTokens\n");
            for (Map.Entry entry : this.grantTokens.entrySet()) {
                buffer.append("    ").append(entry.getKey()).append(": ");
                DLockGrantToken token = (DLockGrantToken)entry.getValue();
                buffer.append(token.toString()).append("\n");
            }
            logger.info(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.TESTING, buffer));
            logger.info(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.TESTING, "\nreadLockCountMap:\n" + this.readLockCountMap));
        }
    }

    private void checkWriteLockWaiters() {
        if (!DEBUG_SUSPEND_LOCK) {
            return;
        }
        Assert.assertHoldsLock(this.suspendLock, true);
        int result = 0;
        for (DLockRequestProcessor.DLockRequestMessage r : this.suspendQueue) {
            if (!r.isSuspendLockingRequest()) continue;
            ++result;
        }
        Assert.assertTrue(result == this.writeLockWaiters);
    }

    private void checkTotalReadLockCount() {
        if (!DEBUG_SUSPEND_LOCK) {
            return;
        }
        Assert.assertHoldsLock(this.suspendLock, true);
        int result = 0;
        Iterator it = this.readLockCountMap.values().iterator();
        while (it.hasNext()) {
            result += ((Integer)it.next()).intValue();
        }
        Assert.assertTrue(result == this.totalReadLockCount);
    }

    private static class DLockGrantorThread
    extends Thread {
        private static final long MAX_WAIT = 60000L;
        private volatile boolean shutdown = false;
        private boolean waiting = false;
        private boolean requireTimeToWait = false;
        private boolean goIntoWait = false;
        private long timeToWait = 60000L;
        private long expectedWakeupTimeStamp = 0L;
        private final Object lock = new Object();
        private final DLockGrantor grantor;
        private final CancelCriterion stopper;
        private long nextTimeout = 60000L;
        private long nextExpire = 60000L;

        DLockGrantorThread(DLockGrantor grantor, CancelCriterion stopper) {
            super(DLockService.getThreadGroup(), "Lock Grantor for " + grantor.dlock.getName());
            this.setDaemon(true);
            this.grantor = grantor;
            this.stopper = stopper;
        }

        private long now() {
            DM dm = this.grantor.dlock.getDistributionManager();
            return DLockService.getLockTimeStamp(dm);
        }

        protected void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkTimeToWait(long newTimeToWaitArg, boolean expire) {
            long newTimeToWait = newTimeToWaitArg;
            if (newTimeToWait == Long.MAX_VALUE) {
                return;
            }
            if (newTimeToWait < 0L) {
                newTimeToWait = 0L;
            }
            Object object = this.lock;
            synchronized (object) {
                if (expire && newTimeToWait < this.nextExpire) {
                    this.nextExpire = newTimeToWait;
                }
                if (!expire && newTimeToWait < this.nextTimeout) {
                    this.nextTimeout = newTimeToWait;
                }
                if (newTimeToWait < this.timeToWait) {
                    if (this.waiting) {
                        long newWakeupTimeStamp = this.now() + newTimeToWait;
                        if (newWakeupTimeStamp > -1L && newWakeupTimeStamp < this.expectedWakeupTimeStamp) {
                            this.timeToWait = newTimeToWait;
                            this.requireTimeToWait = true;
                            this.goIntoWait = true;
                            this.lock.notify();
                        }
                    } else {
                        this.timeToWait = newTimeToWait;
                        this.requireTimeToWait = true;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
            DistributedLockStats stats = this.grantor.dlock.getStats();
            boolean recalcTimeToWait = false;
            while (!this.shutdown && this.stopper.cancelInProgress() == null) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        if (recalcTimeToWait || this.requireTimeToWait) {
                            recalcTimeToWait = false;
                            long nextTS = Math.min(this.nextExpire, this.nextTimeout);
                            this.nextExpire = Long.MAX_VALUE;
                            this.nextTimeout = Long.MAX_VALUE;
                            if (nextTS != Long.MAX_VALUE || this.requireTimeToWait) {
                                this.requireTimeToWait = false;
                                long now = this.now();
                                long newTimeToWait = nextTS - now;
                                this.timeToWait = this.requireTimeToWait ? Math.min(this.timeToWait, newTimeToWait) : newTimeToWait;
                                if (this.timeToWait < 0L) {
                                    this.timeToWait = 0L;
                                }
                                if (isDebugEnabled_DLS) {
                                    logger.trace(LogMarker.DLS, "DLockGrantorThread will wait for {} ms. nextExpire={} nextTimeout={} now={}", new Object[]{this.timeToWait, this.nextExpire, this.nextTimeout, now});
                                }
                            } else {
                                this.timeToWait = Long.MAX_VALUE;
                                if (isDebugEnabled_DLS) {
                                    logger.trace(LogMarker.DLS, "DLockGrantorThread will wait until rescheduled.");
                                }
                            }
                        }
                        if (this.timeToWait > 0L) {
                            if (isDebugEnabled_DLS) {
                                logger.trace(LogMarker.DLS, "DLockGrantorThread is about to wait for {} ms.", new Object[]{this.timeToWait});
                            }
                            if (this.timeToWait != Long.MAX_VALUE) {
                                this.expectedWakeupTimeStamp = this.now() + this.timeToWait;
                                if (this.expectedWakeupTimeStamp < 0L) {
                                    this.expectedWakeupTimeStamp = Long.MAX_VALUE;
                                }
                            } else {
                                this.expectedWakeupTimeStamp = Long.MAX_VALUE;
                            }
                            if (this.expectedWakeupTimeStamp == Long.MAX_VALUE) {
                                while (!this.goIntoWait) {
                                    this.waiting = true;
                                    this.lock.wait();
                                    this.waiting = false;
                                }
                            } else {
                                long timeToWaitThisTime = this.timeToWait;
                                do {
                                    this.waiting = true;
                                    this.lock.wait(timeToWaitThisTime);
                                    this.waiting = false;
                                } while (!this.goIntoWait && (timeToWaitThisTime = this.expectedWakeupTimeStamp - this.now()) > 0L);
                            }
                            if (isDebugEnabled_DLS) {
                                logger.trace(LogMarker.DLS, "DLockGrantorThread has woken up...");
                            }
                            if (this.shutdown) {
                                break;
                            }
                            if (this.goIntoWait) {
                                this.goIntoWait = false;
                                continue;
                            }
                        }
                    }
                    long statStart = stats.startGrantorThread();
                    try {
                        Collection grants = this.grantor.snapshotGrantTokens();
                        if (this.shutdown) {
                            return;
                        }
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS, "DLockGrantorThread about to expireAndGrantLocks...");
                        }
                        long smallestExpire = this.grantor.expireAndGrantLocks(grants.iterator());
                        Object newTimeToWait = this.lock;
                        synchronized (newTimeToWait) {
                            if (smallestExpire < this.nextExpire) {
                                this.nextExpire = smallestExpire;
                            }
                        }
                        long timing = stats.endGrantorThreadExpireAndGrantLocks(statStart);
                        if (this.shutdown) {
                            return;
                        }
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS, "DLockGrantorThread about to handleRequestTimeouts...");
                        }
                        long smallestRequestTimeout = this.grantor.handleRequestTimeouts(grants.iterator());
                        long smallestSuspendTimeout = this.grantor.handleSuspendTimeouts();
                        Object object2 = this.lock;
                        synchronized (object2) {
                            if (smallestRequestTimeout < this.nextTimeout) {
                                this.nextTimeout = smallestRequestTimeout;
                            }
                            if (smallestSuspendTimeout < this.nextTimeout) {
                                this.nextTimeout = smallestSuspendTimeout;
                            }
                        }
                        timing = stats.endGrantorThreadHandleRequestTimeouts(timing);
                        if (this.shutdown) {
                            return;
                        }
                        if (isDebugEnabled_DLS) {
                            logger.trace(LogMarker.DLS, "DLockGrantorThread about to removeUnusedGrants...");
                        }
                        this.grantor.removeUnusedGrants(grants.iterator());
                        stats.endGrantorThreadRemoveUnusedTokens(timing);
                    }
                    catch (CancelException cancelException) {}
                    continue;
                    finally {
                        recalcTimeToWait = true;
                        stats.endGrantorThread(statStart);
                    }
                }
                catch (InterruptedException e) {
                    if (this.shutdown) continue;
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DLockGrantor_DLOCKGRANTORTHREAD_WAS_UNEXPECTEDLY_INTERRUPTED), (Throwable)e);
                    this.stopper.checkCancelInProgress(e);
                }
            }
        }
    }

    public static class DLockGrantToken {
        private final DLockService dlock;
        private final DLockGrantor grantor;
        private final Object lockName;
        private LinkedList pendingRequests;
        private int leaseId = -1;
        private InternalDistributedMember lessee;
        private long leaseExpireTime = -1L;
        private int accessCount = 0;
        private boolean destroyed = false;
        private RemoteThread lesseeThread = null;

        protected DLockGrantToken(DLockService dlock, DLockGrantor grantor, Object name) {
            this.lockName = name;
            this.dlock = dlock;
            this.grantor = grantor;
        }

        protected synchronized boolean schedule(DLockRequestProcessor.DLockRequestMessage request) {
            if (!this.grantor.dm.isCurrentMember(request.getSender())) {
                this.grantor.cleanupSuspendState(request);
                return false;
            }
            if (!this.isGranted(false) && !this.hasWaitingRequests() && this.grantLockToRequest(request)) {
                return true;
            }
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[DLockGrantToken.schedule] {} scheduling: {}", new Object[]{this, request});
            }
            if (this.pendingRequests == null) {
                this.pendingRequests = new LinkedList();
                this.dlock.getStats().incRequestQueues(1);
            }
            this.pendingRequests.add(request);
            this.dlock.getStats().incPendingRequests(1);
            return true;
        }

        protected synchronized void handleGrantorDestruction() {
            try {
                if (this.pendingRequests != null) {
                    for (DLockRequestProcessor.DLockRequestMessage request : this.pendingRequests) {
                        request.respondWithNotGrantor();
                    }
                }
            }
            finally {
                this.destroy();
            }
        }

        protected synchronized long expireAndGrantLock() {
            long result;
            if (this.grantor.isDestroyed()) {
                return Long.MAX_VALUE;
            }
            if (!this.isGranted(true) && !this.grantor.isLockingSuspendedWithSync()) {
                this.grantLockToNextRequest();
            }
            if ((result = this.getLeaseExpireTime()) <= 0L) {
                result = Long.MAX_VALUE;
            }
            return result;
        }

        protected synchronized boolean hasWaitingRequests() {
            if (this.pendingRequests == null) {
                return false;
            }
            return !this.pendingRequests.isEmpty();
        }

        protected synchronized boolean grantLockToRequest(DLockRequestProcessor.DLockRequestMessage request) {
            long newLeaseExpireTime;
            Assert.assertTrue(request.getRemoteThread() != null);
            if (this.isGranted(true) || this.hasWaitingRequests()) {
                return false;
            }
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[DLockGrantToken.grantLockToRequest] granting: {}", new Object[]{request});
            }
            if ((newLeaseExpireTime = this.grantAndRespondToRequest(request)) == -1L) {
                return false;
            }
            if (newLeaseExpireTime < Long.MAX_VALUE) {
                long now = DLockService.getLockTimeStamp(this.grantor.dm);
                this.grantor.thread.checkTimeToWait(newLeaseExpireTime - now, true);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void releaseIfLockedBy(InternalDistributedMember owner, int lockId) {
            RemoteThread rThread = this.getRemoteThread();
            boolean released = false;
            try {
                released = this.releaseLock(owner, lockId);
            }
            catch (IllegalStateException e) {
                this.dlock.checkDestroyed();
                this.grantor.checkDestroyed();
                return;
            }
            if (released) {
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    DLockGrantToken dLockGrantToken = this;
                    synchronized (dLockGrantToken) {
                        logger.trace(LogMarker.DLS, "[DLockGrantToken.releaseIfLockedBy] pending requests: {}", new Object[]{this.pendingRequests == null ? "none" : "" + this.pendingRequests.size()});
                    }
                }
                Assert.assertTrue(rThread != null);
                this.grantor.postReleaseLock(rThread, this.getName());
            }
        }

        protected boolean isLockedBy(InternalDistributedMember owner, int lockId) {
            return this.isLeaseHeldBy(owner, lockId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long handleRequestTimeouts() {
            long smallestTimeout = Long.MAX_VALUE;
            DLockGrantToken dLockGrantToken = this;
            synchronized (dLockGrantToken) {
                if (this.pendingRequests == null) {
                    return smallestTimeout;
                }
                if (this.grantor.isDestroyed()) {
                    return smallestTimeout;
                }
            }
            ArrayList<DLockRequestProcessor.DLockRequestMessage> timeouts = new ArrayList<DLockRequestProcessor.DLockRequestMessage>();
            DLockRequestProcessor.DLockRequestMessage req2 = null;
            DLockGrantToken dLockGrantToken2 = this;
            synchronized (dLockGrantToken2) {
                for (DLockRequestProcessor.DLockRequestMessage req2 : this.pendingRequests) {
                    if (req2.checkForTimeout()) {
                        this.grantor.cleanupSuspendState(req2);
                        timeouts.add(req2);
                        continue;
                    }
                    long timeout = req2.getTimeoutTS();
                    if (timeout >= smallestTimeout) continue;
                    smallestTimeout = timeout;
                }
                this.removeRequests(timeouts);
            }
            return smallestTimeout;
        }

        /*
         * Exception decompiling
         */
        protected void handleDepartureOf(InternalDistributedMember member, ArrayList grantsToRemoveIfUnused) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 35[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected synchronized void checkDepartureOf(InternalDistributedMember member, List grantsReferencingMember) {
            if (this.destroyed) {
                return;
            }
            if (member.equals(this.lessee)) {
                grantsReferencingMember.add(this);
                return;
            }
            if (this.pendingRequests != null) {
                DLockRequestProcessor.DLockRequestMessage req2 = null;
                for (DLockRequestProcessor.DLockRequestMessage req2 : this.pendingRequests) {
                    if (!member.equals(req2.getSender())) continue;
                    grantsReferencingMember.add(this);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRequests(Collection requestsToRemove) {
            if (!requestsToRemove.isEmpty()) {
                DLockGrantToken dLockGrantToken = this;
                synchronized (dLockGrantToken) {
                    this.pendingRequests.removeAll(requestsToRemove);
                }
                this.dlock.getStats().incPendingRequests(-requestsToRemove.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean grantLockToNextRequest() {
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS, "[DLockGrantToken.grantLock] {} isGranted={} hasWaitingRequests={}", new Object[]{this.getName(), this.isLeaseHeld(), this.hasWaitingRequests()});
            }
            while (!this.isGranted(true) && this.hasWaitingRequests()) {
                try {
                    long newLeaseExpireTime;
                    DLockRequestProcessor.DLockRequestMessage request = null;
                    DLockGrantToken dLockGrantToken = this;
                    synchronized (dLockGrantToken) {
                        request = (DLockRequestProcessor.DLockRequestMessage)this.pendingRequests.remove(0);
                    }
                    this.dlock.getStats().incPendingRequests(-1);
                    if (request.checkForTimeout()) {
                        this.grantor.cleanupSuspendState(request);
                        continue;
                    }
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS, "[DLockGrantToken.grantLock] granting {} to {}", new Object[]{this.getName(), request.getSender()});
                    }
                    if ((newLeaseExpireTime = this.grantAndRespondToRequest(request)) == -1L || newLeaseExpireTime >= Long.MAX_VALUE) continue;
                    long now = DLockService.getLockTimeStamp(this.grantor.dm);
                    this.grantor.thread.checkTimeToWait(newLeaseExpireTime - now, true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
            return this.isGranted(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long grantAndRespondToRequest(DLockRequestProcessor.DLockRequestMessage request) {
            DLockRequestProcessor.DLockRequestMessage dLockRequestMessage = request;
            synchronized (dLockRequestMessage) {
                if (request.respondedNoSync()) {
                    return -1L;
                }
                Assert.assertTrue(request.getRemoteThread() != null);
                if (!this.grantor.dm.isCurrentMember(request.getSender())) {
                    this.grantor.cleanupSuspendState(request);
                    return -1L;
                }
                if (this.isSuspendLockingToken()) {
                    Object object = this.grantor.suspendLock;
                    synchronized (object) {
                        Assert.assertTrue(this.grantor.lockingSuspendedBy == null || this.grantor.isLockingSuspendedBy(request.getRemoteThread()), "Locking is suspended by " + this.grantor.lockingSuspendedBy + " with lockId of " + this.grantor.suspendedLockId + " instead of " + request.getRemoteThread() + " with lockId of " + request.getLockId());
                    }
                }
                long newLeaseExpireTime = this.calcLeaseExpireTime(request.getLeaseTime());
                this.grantLock(request.getSender(), newLeaseExpireTime, request.getLockId(), request.getRemoteThread());
                if (this.isSuspendLockingToken()) {
                    Object object = this.grantor.suspendLock;
                    synchronized (object) {
                        this.grantor.suspendLocking(request.getRemoteThread(), request.getLockId());
                        Assert.assertTrue(this.grantor.isLockingSuspendedBy(request.getRemoteThread()), "Locking should now be suspended by " + request.getRemoteThread() + " with lockId of " + request.getLockId() + " instead of " + this.grantor.lockingSuspendedBy + " with lockId of " + this.grantor.suspendedLockId);
                    }
                }
                request.respondWithGrant(newLeaseExpireTime);
                if (!this.isLeaseHeldBy(request.getSender(), request.getLockId())) {
                    return -1L;
                }
                return newLeaseExpireTime;
            }
        }

        protected long calcLeaseExpireTime(long leaseTime) {
            if (leaseTime == Long.MAX_VALUE || leaseTime == -1L) {
                return Long.MAX_VALUE;
            }
            long currentTime = this.getCurrentTime();
            long newLeaseExpireTime = currentTime + leaseTime;
            if (newLeaseExpireTime < leaseTime) {
                newLeaseExpireTime = Long.MAX_VALUE;
            }
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[DLockGrantToken.calcLeaseExpireTime] currentTime={} newLeaseExpireTime={}", new Object[]{currentTime, newLeaseExpireTime});
            }
            return newLeaseExpireTime;
        }

        protected boolean isGranted(boolean checkForExpiration) {
            if (checkForExpiration) {
                this.checkForExpiration();
            }
            return this.isLeaseHeld();
        }

        private String pendingRequestsToString() {
            if (this.pendingRequests == null) {
                return "(null)";
            }
            StringBuffer sb = new StringBuffer();
            for (Object req : this.pendingRequests) {
                sb.append("[");
                sb.append(req.toString());
                sb.append("]");
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString(boolean displayPendingRequests) {
            StringBuffer sb = new StringBuffer("DLockGrantToken");
            sb.append("@").append(Integer.toHexString(this.hashCode()));
            DLockGrantToken dLockGrantToken = this;
            synchronized (dLockGrantToken) {
                sb.append(" {name: ").append(this.getName());
                sb.append(", isGranted: ").append(this.isLeaseHeld());
                sb.append(", isDestroyed: ").append(this.destroyed);
                sb.append(", accessCount: ").append(this.accessCount);
                sb.append(", lessee: ").append(this.lessee);
                sb.append(", leaseExpireTime: ").append(this.leaseExpireTime);
                sb.append(", leaseId: ").append(this.leaseId);
                sb.append(", lesseeThread: ").append(this.lesseeThread);
                if (displayPendingRequests) {
                    sb.append(", pendingRequests: ").append(this.pendingRequestsToString());
                }
                sb.append("}");
            }
            return sb.toString();
        }

        Object getName() {
            return this.lockName;
        }

        boolean isSuspendLockingToken() {
            return DLockService.SUSPEND_LOCKING_TOKEN.equals(this.lockName);
        }

        int getLockId() {
            return this.leaseId;
        }

        RemoteThread getRemoteThread() {
            return this.lesseeThread;
        }

        private synchronized void incAccess(int amount) {
            if (amount < 0) {
                Assert.assertTrue(this.accessCount - amount >= 0, amount + " cannot be subtracted from accessCount " + this.accessCount);
            }
            this.accessCount += amount;
        }

        void incAccess() {
            this.incAccess(1);
        }

        void decAccess() {
            this.incAccess(-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isBeingAccessed() {
            DLockGrantToken dLockGrantToken = this;
            synchronized (dLockGrantToken) {
                return this.accessCount > 0;
            }
        }

        public synchronized InternalDistributedMember getOwner() {
            return this.lessee;
        }

        public long getLeaseExpireTime() {
            return this.leaseExpireTime;
        }

        public synchronized boolean isDestroyed() {
            return this.destroyed;
        }

        long getCurrentTime() {
            return DLockService.getLockTimeStamp(this.grantor.dm);
        }

        synchronized boolean checkForExpiration() {
            if (this.lessee != null && this.leaseId > -1) {
                if (this.leaseExpireTime == Long.MAX_VALUE) {
                    return false;
                }
                long currentTime = this.getCurrentTime();
                if (currentTime > this.leaseExpireTime) {
                    RemoteThread rThread = this.lesseeThread;
                    this.lessee = null;
                    this.leaseId = -1;
                    this.lesseeThread = null;
                    this.leaseExpireTime = -1L;
                    if (logger.isTraceEnabled(LogMarker.DLS)) {
                        logger.trace(LogMarker.DLS, "[checkForExpiration] Expired token at {}: {}", new Object[]{currentTime, this.toString(true)});
                    }
                    this.grantor.postReleaseLock(rThread, this.lockName);
                    return true;
                }
            }
            return false;
        }

        void grantLock(InternalDistributedMember owner, long newLeaseExpireTime, int lockId, RemoteThread remoteThread) {
            Assert.assertTrue(remoteThread != null);
            this.checkDestroyed();
            this.basicGrantLock(owner, newLeaseExpireTime, lockId, remoteThread);
        }

        private void basicGrantLock(InternalDistributedMember owner, long newLeaseExpireTime, int lockId, RemoteThread remoteThread) {
            Assert.assertTrue(remoteThread != null);
            Assert.assertTrue(lockId > -1, "Invalid attempt to grant lock with lockId " + lockId);
            this.lessee = owner;
            this.leaseExpireTime = newLeaseExpireTime;
            this.leaseId = lockId;
            this.lesseeThread = remoteThread;
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[DLockGrantToken.grantLock.grantor] Granting {}", new Object[]{this.toString(false)});
            }
        }

        boolean isLeaseHeld() {
            return this.lessee != null && this.leaseId > -1;
        }

        void destroy() {
            if (!this.destroyed) {
                this.destroyed = true;
                this.dlock.getStats().incGrantTokens(-1);
                if (this.pendingRequests != null) {
                    this.dlock.getStats().incPendingRequests(-this.pendingRequests.size());
                    this.dlock.getStats().incRequestQueues(-1);
                }
            }
        }

        private void checkDestroyed() {
            if (this.destroyed) {
                String s = "Attempting to use destroyed grant token: " + this;
                IllegalStateException e = new IllegalStateException(s);
                throw e;
            }
        }

        private boolean releaseLock(InternalDistributedMember member, int lockId) {
            if (lockId == -1) {
                return false;
            }
            this.checkDestroyed();
            if (this.isLeaseHeldBy(member, lockId)) {
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "[DLockGrantToken.releaseLock] releasing ownership: {}", new Object[]{this});
                }
                this.lessee = null;
                this.leaseId = -1;
                this.lesseeThread = null;
                this.leaseExpireTime = -1L;
                return true;
            }
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "[DLockGrantToken.releaseLock] {} attempted to release: {}", new Object[]{member, this});
            }
            return false;
        }

        private boolean isLeaseHeldBy(InternalDistributedMember sender, int lockId) {
            Assert.assertTrue(sender != null, "sender is null: " + this);
            Assert.assertTrue(lockId > -1, "lockId is < 0: " + this);
            return sender.equals(this.lessee) && lockId == this.leaseId;
        }
    }
}

