/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import com.gemstone.gemfire.distributed.internal.deadlock.Dependency;
import com.gemstone.gemfire.distributed.internal.deadlock.LocalThread;
import com.gemstone.gemfire.distributed.internal.deadlock.MessageDependencyMonitor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraph
implements Serializable {
    private static final long serialVersionUID = -6794339771271587648L;
    private Map<Object, Set<Dependency>> vertices = new LinkedHashMap<Object, Set<Dependency>>();
    private Set<Dependency> edges = new LinkedHashSet<Dependency>();

    public void addEdges(Collection<Dependency> edges) {
        for (Dependency dep : edges) {
            this.addEdge(dep);
        }
    }

    public void addEdge(Dependency dependency) {
        if (!this.edges.contains(dependency)) {
            this.edges.add(dependency);
            Set<Dependency> outboundEdges = this.vertices.get(dependency.getDepender());
            if (outboundEdges == null) {
                outboundEdges = new HashSet<Dependency>();
                this.vertices.put(dependency.getDepender(), outboundEdges);
            }
            outboundEdges.add(dependency);
            if (this.vertices.get(dependency.getDependsOn()) == null) {
                this.vertices.put(dependency.getDependsOn(), new HashSet());
            }
        }
    }

    public LinkedList<Dependency> findCycle() {
        HashSet<Object> unvisited = new HashSet<Object>(this.vertices.keySet());
        HashSet<Object> finished = new HashSet<Object>(this.vertices.size());
        while (unvisited.size() > 0) {
            CycleHolder cycle;
            Object start = unvisited.iterator().next();
            boolean foundCycle = this.visitCycle(start, unvisited, finished, cycle = new CycleHolder(), 0);
            if (!foundCycle) continue;
            return cycle.cycle;
        }
        return null;
    }

    public DependencyGraph findLongestCallChain() {
        int depth = 0;
        DependencyGraph deepest = null;
        for (Object dep : this.vertices.keySet()) {
            int itsDepth = this.getDepth(dep);
            if (itsDepth <= depth) continue;
            deepest = this.getSubGraph(dep);
            depth = itsDepth;
        }
        return deepest;
    }

    public List<DependencyGraph> findDependenciesWith(String objectName) {
        Object obj = null;
        Dependency objDep = null;
        for (Dependency dep : this.edges) {
            if (dep.depender.toString().contains(objectName)) {
                obj = dep.depender;
                objDep = dep;
                break;
            }
            if (!dep.dependsOn.toString().contains(objectName)) continue;
            obj = dep.dependsOn;
            objDep = dep;
            break;
        }
        if (obj == null) {
            return Collections.emptyList();
        }
        HashSet dependsOnObj = new HashSet();
        dependsOnObj.add(obj);
        boolean anyAdded = true;
        while (anyAdded) {
            anyAdded = false;
            for (Dependency dependency : this.edges) {
                if (!dependsOnObj.contains(dependency.dependsOn) || dependsOnObj.contains(dependency.depender)) continue;
                anyAdded = true;
                dependsOnObj.add(dependency.depender);
            }
        }
        HashSet allDependants = new HashSet();
        for (Dependency dep : this.edges) {
            if (dep.dependsOn instanceof LocalThread) {
                if (!(dep.depender instanceof MessageDependencyMonitor.MessageKey)) continue;
                allDependants.add(dep.dependsOn);
                continue;
            }
            allDependants.add(dep.dependsOn);
        }
        LinkedList<DependencyGraph> linkedList = new LinkedList<DependencyGraph>();
        for (Object depender : dependsOnObj) {
            if (allDependants.contains(depender)) continue;
            linkedList.add(this.getSubGraph(depender));
        }
        return linkedList;
    }

    private boolean visitCycle(Object start, Set<Object> unvisited, Set<Object> finished, CycleHolder cycle, int depth) {
        if (finished.contains(start)) {
            return false;
        }
        if (!unvisited.remove(start)) {
            return true;
        }
        cycle.processDepth(depth);
        boolean foundCycle = false;
        for (Dependency dep : this.vertices.get(start)) {
            if (!(foundCycle |= this.visitCycle(dep.getDependsOn(), unvisited, finished, cycle, depth + 1))) continue;
            cycle.add(dep);
            break;
        }
        finished.add(start);
        return foundCycle;
    }

    private int getDepth(Object depender) {
        CycleHolder cycle;
        HashSet<Object> finished;
        Object start = depender;
        HashSet<Object> unvisited = new HashSet<Object>(this.vertices.keySet());
        boolean foundCycle = this.visitCycle(start, unvisited, finished = new HashSet<Object>(this.vertices.size()), cycle = new CycleHolder(), 0);
        if (foundCycle) {
            return Integer.MAX_VALUE;
        }
        return cycle.getMaxDepth();
    }

    public DependencyGraph getSubGraph(Object start) {
        DependencyGraph result = new DependencyGraph();
        this.populateSubGraph(start, result);
        return result;
    }

    private void populateSubGraph(Object start, DependencyGraph result) {
        if (result.vertices.keySet().contains(start)) {
            return;
        }
        if (this.vertices.get(start) == null) {
            return;
        }
        result.addVertex(start, this.vertices.get(start));
        for (Dependency dep : result.vertices.get(start)) {
            this.populateSubGraph(dep.getDependsOn(), result);
        }
    }

    private void addVertex(Object start, Set<Dependency> set) {
        this.vertices.put(start, set);
        this.edges.addAll(set);
    }

    public Collection<Dependency> getEdges() {
        return this.edges;
    }

    public Collection<Object> getVertices() {
        return this.vertices.keySet();
    }

    private static class CycleHolder {
        private LinkedList<Dependency> cycle = new LinkedList();
        private boolean cycleDone;
        private int maxDepth = 0;

        private CycleHolder() {
        }

        public void processDepth(int depth) {
            if (depth > this.maxDepth) {
                this.maxDepth = depth;
            }
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public void add(Dependency dep) {
            if (this.cycleDone) {
                return;
            }
            this.cycle.addFirst(dep);
            Object lastVertex = this.cycle.getLast().getDependsOn();
            if (dep.depender.equals(lastVertex)) {
                this.cycleDone = true;
            }
        }
    }
}

