/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.logging.log4j.Logger;

public class WaitForViewInstallation
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private long viewId;
    private int processorId;

    public static void send(DistributionManager dm) throws InterruptedException {
        block2: {
            long viewId = dm.getMembershipManager().getView().getViewId();
            ReplyProcessor21 rp = new ReplyProcessor21((DM)dm, (Collection)dm.getOtherDistributionManagerIds());
            rp.enableSevereAlertProcessing();
            dm.putOutgoing(new WaitForViewInstallation(viewId, rp.getProcessorId()));
            try {
                rp.waitForReplies();
            }
            catch (ReplyException e) {
                if (e.getCause() == null || e.getCause() instanceof CancelException || !logger.isDebugEnabled()) break block2;
                logger.debug("Reply to WaitForViewInstallation received odd exception", e.getCause());
            }
        }
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    public WaitForViewInstallation() {
    }

    private WaitForViewInstallation(long viewId, int processorId) {
        this.viewId = viewId;
        this.processorId = processorId;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public int getDSFID() {
        return -130;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this.viewId);
        out.writeInt(this.processorId);
    }

    @Override
    public void fromData(DataInput in) throws ClassNotFoundException, IOException {
        super.fromData(in);
        this.viewId = in.readLong();
        this.processorId = in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        boolean interrupted = false;
        try {
            dm.waitForViewInstallation(this.viewId);
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        finally {
            if (!interrupted) {
                ReplyMessage.send(this.getSender(), this.processorId, null, this.getReplySender(dm));
            }
        }
    }
}

