/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionRequest;
import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionResponse;
import com.gemstone.gemfire.cache.client.internal.locator.ClientReplacementRequest;
import com.gemstone.gemfire.cache.client.internal.locator.GetAllServersRequest;
import com.gemstone.gemfire.cache.client.internal.locator.GetAllServersResponse;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorListRequest;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorListResponse;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorStatusRequest;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorStatusResponse;
import com.gemstone.gemfire.cache.client.internal.locator.QueueConnectionRequest;
import com.gemstone.gemfire.cache.client.internal.locator.QueueConnectionResponse;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationRequest;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.LocatorLoadSnapshot;
import com.gemstone.gemfire.distributed.internal.LocatorStats;
import com.gemstone.gemfire.distributed.internal.ProductUseLog;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpHandler;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpServer;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.CacheServerAdvisor;
import com.gemstone.gemfire.internal.cache.ControllerAdvisor;
import com.gemstone.gemfire.internal.cache.FindDurableQueueProcessor;
import com.gemstone.gemfire.internal.cache.GridAdvisor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class ServerLocator
implements TcpHandler,
DistributionAdvisee {
    private static final Logger logger = LogService.getLogger();
    private final int port;
    private final String hostNameForClients;
    private InternalDistributedSystem ds;
    private ControllerAdvisor advisor;
    private final int serialNumber = ServerLocator.createSerialNumber();
    private final LocatorStats stats;
    private LocatorLoadSnapshot loadSnapshot = new LocatorLoadSnapshot();
    private Map<ServerLocation, DistributedMember> ownerMap = new HashMap<ServerLocation, DistributedMember>();
    private volatile List<ServerLocation> cachedLocators;
    private final Object cachedLocatorsLock = new Object();
    private static final AtomicInteger profileSN = new AtomicInteger();
    private static final long SERVER_LOAD_LOG_INTERVAL = 3600000L;
    private final String logFile;
    private final String hostName;
    private final String memberName;
    private ProductUseLog productUseLog;
    private volatile long lastLogTime;

    ServerLocator() throws IOException {
        this.port = 10334;
        this.hostNameForClients = this.hostName = SocketCreator.getLocalHost().getCanonicalHostName();
        this.logFile = null;
        this.memberName = null;
        this.ds = null;
        this.advisor = null;
        this.stats = null;
    }

    public ServerLocator(int port, InetAddress bindAddress, String hostNameForClients, File logFile, ProductUseLog productUseLogWriter, String memberName, InternalDistributedSystem ds, LocatorStats stats) throws IOException {
        this.port = port;
        this.hostName = bindAddress == null ? SocketCreator.getLocalHost().getCanonicalHostName() : bindAddress.getHostAddress();
        this.hostNameForClients = hostNameForClients != null && !hostNameForClients.equals("") ? hostNameForClients : this.hostName;
        this.logFile = logFile != null ? logFile.getCanonicalPath() : null;
        this.memberName = memberName;
        this.productUseLog = productUseLogWriter;
        this.ds = ds;
        this.advisor = ControllerAdvisor.createControllerAdvisor(this);
        this.stats = stats;
    }

    public String getHostName() {
        return this.hostNameForClients;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.ds.getCancelCriterion();
    }

    @Override
    public void init(TcpServer tcpServer) {
        if (this.ds != null && !this.ds.isReconnecting()) {
            this.advisor.handshake();
        }
    }

    protected boolean readyToProcessRequests() {
        return this.ds != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object processRequest(Object request) {
        Object response;
        if (!this.readyToProcessRequests()) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ServerLocator: Received request {}", new Object[]{request});
        }
        if (!(request instanceof ServerLocationRequest)) throw new InternalGemFireException("Expected ServerLocationRequest, got " + request.getClass());
        if (request instanceof LocatorStatusRequest) {
            response = new LocatorStatusResponse().initialize(this.port, this.hostName, this.logFile, this.memberName);
        } else if (request instanceof LocatorListRequest) {
            response = this.getLocatorListResponse((LocatorListRequest)request);
        } else if (request instanceof ClientReplacementRequest) {
            response = this.pickReplacementServer((ClientReplacementRequest)request);
        } else if (request instanceof GetAllServersRequest) {
            response = this.pickAllServers((GetAllServersRequest)request);
        } else if (request instanceof ClientConnectionRequest) {
            response = this.pickServer((ClientConnectionRequest)request);
        } else {
            if (!(request instanceof QueueConnectionRequest)) throw new InternalGemFireException("Unknown ServerLocationRequest: " + request.getClass());
            response = this.pickQueueServers((QueueConnectionRequest)request);
        }
        if (!logger.isDebugEnabled()) return response;
        logger.debug("ServerLocator: Sending response {}", new Object[]{response});
        return response;
    }

    private ClientConnectionResponse pickServer(ClientConnectionRequest clientRequest) {
        ServerLocation location = this.loadSnapshot.getServerForConnection(clientRequest.getServerGroup(), clientRequest.getExcludedServers());
        return new ClientConnectionResponse(location);
    }

    private ClientConnectionResponse pickReplacementServer(ClientReplacementRequest clientRequest) {
        ServerLocation location = this.loadSnapshot.getReplacementServerForConnection(clientRequest.getCurrentServer(), clientRequest.getServerGroup(), clientRequest.getExcludedServers());
        return new ClientConnectionResponse(location);
    }

    private GetAllServersResponse pickAllServers(GetAllServersRequest clientRequest) {
        ArrayList servers = this.loadSnapshot.getServers(clientRequest.getServerGroup());
        return new GetAllServersResponse(servers);
    }

    private Object getLocatorListResponse(LocatorListRequest request) {
        List<ServerLocation> controllers = this.getLocators();
        boolean balanced = this.loadSnapshot.hasBalancedConnections(request.getServerGroup());
        return new LocatorListResponse(controllers, balanced);
    }

    private Object pickQueueServers(QueueConnectionRequest clientRequest) {
        List candidates;
        HashSet excludedServers = new HashSet(clientRequest.getExcludedServers());
        ArrayList servers = new ArrayList();
        boolean durableQueueFound = false;
        if (clientRequest.isFindDurable() && clientRequest.getProxyId().isDurable()) {
            servers = FindDurableQueueProcessor.sendAndFind(this, clientRequest.getProxyId(), this.getDistributionManager());
            excludedServers.addAll(servers);
            boolean bl = durableQueueFound = servers.size() > 0;
        }
        if (clientRequest.getRedundantCopies() == -1) {
            candidates = this.loadSnapshot.getServersForQueue(clientRequest.getProxyId(), clientRequest.getServerGroup(), excludedServers, -1);
        } else if (clientRequest.getRedundantCopies() > servers.size()) {
            int count = clientRequest.getRedundantCopies() - servers.size();
            candidates = this.loadSnapshot.getServersForQueue(clientRequest.getProxyId(), clientRequest.getServerGroup(), excludedServers, count);
        } else {
            candidates = Collections.EMPTY_LIST;
        }
        if (candidates.size() > 1) {
            Collections.shuffle(candidates);
        }
        servers.addAll(candidates);
        return new QueueConnectionResponse(durableQueueFound, servers);
    }

    @Override
    public void shutDown() {
        this.advisor.close();
        this.loadSnapshot.shutDown();
    }

    @Override
    public void restarting(DistributedSystem ds, GemFireCache cache, SharedConfiguration sharedConfig) {
        if (ds != null) {
            this.loadSnapshot = new LocatorLoadSnapshot();
            this.ds = (InternalDistributedSystem)ds;
            this.advisor = ControllerAdvisor.createControllerAdvisor(this);
        }
    }

    @Override
    public DM getDistributionManager() {
        return this.getSystem().getDistributionManager();
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.advisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.getDistributionAdvisor().createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.ds;
    }

    @Override
    public String getName() {
        return "ServerLocator";
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getFullPath() {
        return this.getName();
    }

    public InternalDistributedSystem getDs() {
        return this.ds;
    }

    private static int createSerialNumber() {
        return profileSN.incrementAndGet();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof ControllerAdvisor.ControllerProfile);
        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)profile;
        cp.setHost(this.hostNameForClients);
        cp.setPort(this.port);
        cp.serialNumber = this.getSerialNumber();
        cp.finishInit();
    }

    public void setLocatorCount(int count) {
        this.stats.setLocatorCount(count);
    }

    public void setServerCount(int count) {
        this.stats.setServerCount(count);
    }

    @Override
    public void endRequest(Object request, long startTime) {
        this.stats.endLocatorRequest(startTime);
    }

    @Override
    public void endResponse(Object request, long startTime) {
        this.stats.endLocatorResponse(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServerLocation> getLocators() {
        if (this.cachedLocators != null) {
            return this.cachedLocators;
        }
        Object object = this.cachedLocatorsLock;
        synchronized (object) {
            List profiles = this.advisor.fetchControllers();
            ArrayList<ServerLocation> result = new ArrayList<ServerLocation>(profiles.size() + 1);
            for (ControllerAdvisor.ControllerProfile profile : profiles) {
                result.add(ServerLocator.buildServerLocation(profile));
            }
            result.add(new ServerLocation(this.hostNameForClients, this.port));
            this.cachedLocators = result;
            return result;
        }
    }

    protected static ServerLocation buildServerLocation(GridAdvisor.GridProfile p) {
        return new ServerLocation(p.getHost(), p.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void profileCreated(DistributionAdvisor.Profile profile) {
        if (profile instanceof CacheServerAdvisor.CacheServerProfile) {
            CacheServerAdvisor.CacheServerProfile bp = (CacheServerAdvisor.CacheServerProfile)profile;
            ServerLocation location = ServerLocator.buildServerLocation(bp);
            String[] groups = bp.getGroups();
            this.loadSnapshot.addServer(location, groups, bp.getInitialLoad(), bp.getLoadPollInterval());
            if (logger.isDebugEnabled()) {
                logger.debug("ServerLocator: Received load from a new server {}, {}", new Object[]{location, bp.getInitialLoad()});
            }
            Map<ServerLocation, DistributedMember> map = this.ownerMap;
            synchronized (map) {
                this.ownerMap.put(location, profile.getDistributedMember());
            }
        } else {
            this.cachedLocators = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void profileRemoved(DistributionAdvisor.Profile profile) {
        if (profile instanceof CacheServerAdvisor.CacheServerProfile) {
            CacheServerAdvisor.CacheServerProfile bp = (CacheServerAdvisor.CacheServerProfile)profile;
            ServerLocation location = ServerLocator.buildServerLocation(bp);
            this.loadSnapshot.removeServer(location);
            if (logger.isDebugEnabled()) {
                logger.debug("ServerLocator: server departed {}", new Object[]{location});
            }
            Map<ServerLocation, DistributedMember> map = this.ownerMap;
            synchronized (map) {
                this.ownerMap.remove(location);
            }
        } else {
            this.cachedLocators = null;
        }
    }

    public void profileUpdated(DistributionAdvisor.Profile profile) {
        this.cachedLocators = null;
        this.getLogWriterI18n().warning(LocalizedStrings.ServerLocator_SERVERLOCATOR_UNEXPECTED_PROFILE_UPDATE);
    }

    public void updateLoad(ServerLocation location, ServerLoad load, List clientIds) {
        if (this.getLogWriterI18n().fineEnabled()) {
            this.getLogWriterI18n().fine("ServerLocator: Received a load update from " + location + ", " + load);
        }
        this.loadSnapshot.updateLoad(location, load, clientIds);
        this.stats.incServerLoadUpdates();
        this.logServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logServers() {
        if (this.productUseLog != null) {
            HashSet<DistributedMember> servers;
            Object l2;
            long lastLogTime;
            Map loadMap = this.getLoadMap();
            if (loadMap.size() == 0) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now < (lastLogTime = this.lastLogTime) + 3600000L) {
                return;
            }
            this.lastLogTime = now;
            int queues = 0;
            int connections = 0;
            for (Object l2 : loadMap.values()) {
                queues = (int)((float)queues + ((ServerLoad)l2).getSubscriptionConnectionLoad());
                connections = (int)Math.ceil(((ServerLoad)l2).getConnectionLoad() / ((ServerLoad)l2).getLoadPerConnection());
            }
            l2 = this.ownerMap;
            synchronized (l2) {
                servers = new HashSet<DistributedMember>(this.ownerMap.values());
            }
            StringBuilder sb = new StringBuilder(1000);
            sb.append("server count: ").append(servers.size()).append(" connected client count: ").append(connections).append(" client subscription queue count: ").append(queues).append(System.lineSeparator()).append("current servers : ");
            Object[] ids = new String[servers.size()];
            int i = 0;
            for (DistributedMember id : servers) {
                ids[i++] = id.toString();
            }
            Arrays.sort(ids);
            for (i = 0; i < ids.length; ++i) {
                sb.append((String)ids[i]).append(' ');
            }
            this.productUseLog.log(sb.toString());
        }
    }

    public Map getLoadMap() {
        return this.loadSnapshot.getLoadMap();
    }

    LogWriterI18n getLogWriterI18n() {
        return this.ds.getLogWriter().convertToLogWriterI18n();
    }
}

