/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.CollectingReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class HighPriorityAckedMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private InternalDistributedMember id;
    private int processorId;
    private operationType op;
    transient DistributionManager originDm;
    private transient ReplyProcessor21 rp;
    private boolean useNative;

    public HighPriorityAckedMessage() {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        if (ds != null) {
            this.originDm = (DistributionManager)ds.getDistributionManager();
        }
        if (this.originDm != null) {
            this.id = this.originDm.getDistributionManagerId();
        }
    }

    public Map<InternalDistributedMember, byte[]> dumpStacks(Set recipients, boolean useNative, boolean returnStacks) {
        this.op = operationType.DUMP_STACK;
        this.useNative = useNative;
        HashSet recips = new HashSet(recipients);
        InternalDistributedMember me = this.originDm.getDistributionManagerId();
        if (recips.contains(me)) {
            recips.remove(me);
        }
        CollectingReplyProcessor cp = null;
        if (returnStacks) {
            cp = new CollectingReplyProcessor((DM)this.originDm, recips);
            this.processorId = cp.getProcessorId();
        }
        this.originDm.putOutgoing(this);
        if (cp != null) {
            try {
                cp.waitForReplies();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return cp.getResults();
        }
        return null;
    }

    public void send(Set recipients, boolean multicast) throws InterruptedException, ReplyException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.op = operationType.DRAIN_POOL;
        HashSet recips = new HashSet(recipients);
        InternalDistributedMember me = this.originDm.getDistributionManagerId();
        if (recips.contains(me)) {
            recips.remove(me);
        }
        this.rp = new ReplyProcessor21((DM)this.originDm, recips);
        this.processorId = this.rp.getProcessorId();
        this.setRecipients(recips);
        this.setMulticast(multicast);
        this.originDm.putOutgoing(this);
        this.rp.waitForReplies();
    }

    void setDistributionManagerId(InternalDistributedMember id) {
        this.id = id;
    }

    public void setProcessorId(int pid) {
        this.processorId = pid;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        switch (this.op) {
            case DRAIN_POOL: {
                Assert.assertTrue(this.id != null);
                long endTime = System.currentTimeMillis() + 10000L;
                ThreadPoolExecutor pool = (ThreadPoolExecutor)dm.getHighPriorityThreadPool();
                while (pool.getActiveCount() > 1 && System.currentTimeMillis() < endTime) {
                    boolean interrupted = Thread.interrupted();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                        dm.getCancelCriterion().checkCancelInProgress(ie);
                        return;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                    }
                }
                if (pool.getActiveCount() > 1) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HighPriorityAckedMessage_0_THERE_ARE_STILL_1_OTHER_THREADS_ACTIVE_IN_THE_HIGH_PRIORITY_THREAD_POOL, new Object[]{this, pool.getActiveCount() - 1}));
                }
                ReplyMessage.send(this.getSender(), this.processorId, null, (ReplySender)dm);
                break;
            }
            case DUMP_STACK: {
                if (this.processorId > 0) {
                    try {
                        byte[] zippedStacks = OSProcess.zipStacks();
                        ReplyMessage.send(this.getSender(), this.processorId, zippedStacks, (ReplySender)dm);
                    }
                    catch (IOException e) {
                        ReplyMessage.send(this.getSender(), this.processorId, new ReplyException(e), (ReplySender)dm);
                    }
                    break;
                }
                OSProcess.printStacks(0, this.useNative);
            }
        }
    }

    @Override
    public int getDSFID() {
        return 2000;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        out.writeInt(this.op.ordinal());
        out.writeBoolean(this.useNative);
        DataSerializer.writeObject(this.id, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.op = operationType.values()[in.readInt()];
        this.useNative = in.readBoolean();
        this.id = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "<HighPriorityAckedMessage from=" + this.id + ";processorId=" + this.processorId + ">";
    }

    static enum operationType {
        DRAIN_POOL,
        DUMP_STACK;

    }
}

