/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class DistributedSystem
implements StatisticsFactory {
    protected static volatile List existingSystems = Collections.EMPTY_LIST;
    protected static final Object existingSystemsLock = new Object();
    public static final String PROPERTIES_FILE_PROPERTY = "gemfirePropertyFile";
    public static final String PROPERTIES_FILE_DEFAULT = "gemfire.properties";
    public static String PROPERTY_FILE = DistributedSystem.getPropertiesFile();
    public static final String SECURITY_PROPERTIES_FILE_PROPERTY = "gemfireSecurityPropertyFile";
    public static final String SECURITY_PROPERTIES_FILE_DEFAULT = "gfsecurity.properties";
    public static String SECURITY_PROPERTY_FILE = DistributedSystem.getSecurityPropertiesFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributedSystem connect(Properties config) {
        if (config == null) {
            config = new Properties();
        }
        Object object = existingSystemsLock;
        synchronized (object) {
            if (DistributionManager.isDedicatedAdminVM) {
                DistributedSystem existingSystem = DistributedSystem.getConnection(config);
                if (existingSystem != null) {
                    return existingSystem;
                }
            } else {
                boolean existingSystemDisconnecting = true;
                while (!existingSystems.isEmpty() && existingSystemDisconnecting) {
                    Assert.assertTrue(existingSystems.size() == 1);
                    InternalDistributedSystem existingSystem = (InternalDistributedSystem)existingSystems.get(0);
                    existingSystemDisconnecting = existingSystem.isDisconnecting();
                    if (existingSystemDisconnecting) {
                        boolean interrupted = Thread.interrupted();
                        try {
                            existingSystemsLock.wait(50L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                            continue;
                        }
                        finally {
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                    }
                    if (existingSystem.isConnected()) {
                        existingSystem.validateSameProperties(config, existingSystem.isConnected());
                        return existingSystem;
                    }
                    throw new AssertionError((Object)"system should not be disconnecting==false and isConnected==falsed");
                }
            }
            try {
                InternalDistributedSystem newSystem = InternalDistributedSystem.newInstance(config);
                DistributedSystem.addSystem(newSystem);
                return newSystem;
            }
            catch (GemFireSecurityException ex) {
                ex.fillInStackTrace();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addSystem(InternalDistributedSystem newSystem) {
        Object object = existingSystemsLock;
        synchronized (object) {
            int size = existingSystems.size();
            if (size == 0) {
                existingSystems = Collections.singletonList(newSystem);
            } else {
                ArrayList<InternalDistributedSystem> l = new ArrayList<InternalDistributedSystem>(size + 1);
                l.addAll(existingSystems);
                l.add(0, newSystem);
                existingSystems = Collections.unmodifiableList(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean removeSystem(InternalDistributedSystem oldSystem) {
        Object object = existingSystemsLock;
        synchronized (object) {
            ArrayList l = new ArrayList(existingSystems);
            boolean result = l.remove(oldSystem);
            if (result) {
                int size = l.size();
                existingSystems = size == 0 ? Collections.EMPTY_LIST : (size == 1 ? Collections.singletonList(l.get(0)) : Collections.unmodifiableList(l));
            }
            return result;
        }
    }

    public static void setThreadsSocketPolicy(boolean conserveSockets) {
        if (conserveSockets) {
            ConnectionTable.threadWantsSharedResources();
        } else {
            ConnectionTable.threadWantsOwnResources();
        }
    }

    public static void releaseThreadsSockets() {
        ConnectionTable.releaseThreadsSockets();
    }

    private static DistributedSystem getConnection(Properties config) {
        List l = existingSystems;
        for (InternalDistributedSystem existingSystem : l) {
            if (!existingSystem.sameSystemAs(config)) continue;
            Assert.assertTrue(existingSystem.isConnected());
            return existingSystem;
        }
        return null;
    }

    protected static DistributedSystem connectForAdmin(Properties props) {
        DistributedSystem existing = DistributedSystem.getConnection(props);
        if (existing != null) {
            return existing;
        }
        props.setProperty("conserve-sockets", "true");
        return DistributedSystem.connect(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setEnableAdministrationOnly(boolean adminOnly) {
        Object object = existingSystemsLock;
        synchronized (object) {
            if (existingSystems != null && !existingSystems.isEmpty()) {
                throw new IllegalStateException(LocalizedStrings.DistributedSystem_THIS_VM_ALREADY_HAS_ONE_OR_MORE_DISTRIBUTED_SYSTEM_CONNECTIONS_0.toLocalizedString(existingSystems));
            }
            DistributionManager.isDedicatedAdminVM = adminOnly;
        }
    }

    protected DistributedSystem() {
    }

    public abstract LogWriter getLogWriter();

    public abstract LogWriter getSecurityLogWriter();

    public abstract Properties getProperties();

    public abstract Properties getSecurityProperties();

    public abstract CancelCriterion getCancelCriterion();

    public abstract void disconnect();

    public abstract boolean isConnected();

    @Deprecated
    public abstract long getId();

    @Deprecated
    public abstract String getMemberId();

    public abstract DistributedMember getDistributedMember();

    public abstract Set<DistributedMember> getAllOtherMembers();

    public abstract Set<DistributedMember> getGroupMembers(String var1);

    public abstract Set<DistributedMember> findDistributedMembers(InetAddress var1);

    public abstract DistributedMember findDistributedMember(String var1);

    public abstract String getName();

    public static String getPropertiesFile() {
        return System.getProperty(PROPERTIES_FILE_PROPERTY, PROPERTIES_FILE_DEFAULT);
    }

    public static String getSecurityPropertiesFile() {
        return System.getProperty(SECURITY_PROPERTIES_FILE_PROPERTY, SECURITY_PROPERTIES_FILE_DEFAULT);
    }

    public static URL getPropertiesFileURL() {
        return DistributedSystem.getFileURL(DistributedSystem.getPropertiesFile());
    }

    public static URL getPropertyFileURL() {
        return DistributedSystem.getPropertiesFileURL();
    }

    public static URL getSecurityPropertiesFileURL() {
        return DistributedSystem.getFileURL(DistributedSystem.getSecurityPropertiesFile());
    }

    private static URL getFileURL(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            try {
                return IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(file).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((file = new File(System.getProperty("user.home"), fileName)).exists()) {
            try {
                return IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(file).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return ClassPathLoader.getLatest().getResource(DistributedSystem.class, fileName);
    }

    public abstract boolean isReconnecting();

    public abstract boolean waitUntilReconnected(long var1, TimeUnit var3) throws InterruptedException;

    public abstract void stopReconnecting();

    public abstract DistributedSystem getReconnectedSystem();
}

