/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.compression;

import com.gemstone.gemfire.compression.CompressionException;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyError;

public final class SnappyCompressor
implements Compressor,
Serializable {
    private static final long serialVersionUID = 496609875302446099L;
    private static final AtomicReference<SnappyCompressor> defaultInstance = new AtomicReference();
    private static boolean nativeLibraryLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnappyCompressor() {
        AtomicReference<SnappyCompressor> atomicReference = defaultInstance;
        synchronized (atomicReference) {
            if (!nativeLibraryLoaded) {
                try {
                    String s = Snappy.getNativeLibraryVersion();
                    System.out.println(s);
                }
                catch (SnappyError se) {
                    throw new IllegalStateException(LocalizedStrings.SnappyCompressor_UNABLE_TO_LOAD_NATIVE_SNAPPY_LIBRARY.toLocalizedString(), se);
                }
                nativeLibraryLoaded = true;
            }
        }
    }

    public static final SnappyCompressor getDefaultInstance() {
        SnappyCompressor instance = defaultInstance.get();
        if (instance != null) {
            return instance;
        }
        defaultInstance.compareAndSet(null, new SnappyCompressor());
        return defaultInstance.get();
    }

    @Override
    public byte[] compress(byte[] input) {
        try {
            return Snappy.compress((byte[])input);
        }
        catch (IOException e) {
            throw new CompressionException(e);
        }
    }

    @Override
    public byte[] decompress(byte[] input) {
        try {
            return Snappy.uncompress((byte[])input);
        }
        catch (IOException e) {
            throw new CompressionException(e);
        }
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return this.getClass().getName().equals(other.getClass().getName());
    }
}

