/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.parse;

import antlr.Token;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.QCompiler;
import com.gemstone.gemfire.cache.query.internal.parse.GemFireAST;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;

public class ASTLiteral
extends GemFireAST {
    private static final long serialVersionUID = 8374021603235812835L;

    public ASTLiteral() {
    }

    public ASTLiteral(Token t) {
        super(t);
    }

    private Object computeValue() throws QueryInvalidException {
        switch (this.getType()) {
            case 41: {
                return this.getString(this.getText(), '\'');
            }
            case 36: {
                return this.getInt(this.getText());
            }
            case 148: {
                return this.getDouble(this.getText());
            }
            case 147: {
                return this.getFloat(this.getText());
            }
            case 146: {
                return this.getLong(this.getText());
            }
            case 141: 
            case 142: {
                return null;
            }
            case 143: {
                return QueryService.UNDEFINED;
            }
            case 144: {
                return Boolean.TRUE;
            }
            case 145: {
                return Boolean.FALSE;
            }
            case 128: {
                return this.getChar(this.getFirstChild().getText());
            }
            case 134: {
                return this.getDate(this.getFirstChild().getText());
            }
            case 137: {
                return this.getTimestamp(this.getFirstChild().getText());
            }
            case 135: {
                return this.getTime(this.getFirstChild().getText());
            }
        }
        throw new Error("unknown literal type: " + this.getType());
    }

    public Integer getInt(String s) throws QueryInvalidException {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new QueryInvalidException(LocalizedStrings.ASTLiteral_UNABLE_TO_PARSE_INTEGER_0.toLocalizedString(s), e);
        }
    }

    public Long getLong(String s) throws QueryInvalidException {
        boolean strip;
        char last = s.charAt(s.length() - 1);
        boolean bl = strip = last == 'L' || last == 'l';
        if (strip) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new QueryInvalidException(LocalizedStrings.ASTLiteral_UNABLE_TO_PARSE_FLOAT_0.toLocalizedString(s));
        }
    }

    public Float getFloat(String s) throws QueryInvalidException {
        boolean strip;
        char last = s.charAt(s.length() - 1);
        boolean bl = strip = last == 'F' || last == 'f';
        if (strip) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            return new Float(s);
        }
        catch (NumberFormatException e) {
            throw new QueryInvalidException(s);
        }
    }

    public Double getDouble(String s) throws QueryInvalidException {
        boolean strip;
        char last = s.charAt(s.length() - 1);
        boolean bl = strip = last == 'D' || last == 'd';
        if (strip) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new QueryInvalidException(LocalizedStrings.ASTLiteral_UNABLE_TO_PARSE_DOUBLE_0.toLocalizedString(s));
        }
    }

    private String getString(String s, char delim) {
        StringBuffer buf = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == delim && i < s.length() - 1 && s.charAt(i + 1) == delim) {
                ++i;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Override
    public void compile(QCompiler compiler) throws QueryInvalidException {
        Object value = this.computeValue();
        compiler.pushLiteral(value);
    }

    private Character getChar(String s) {
        if (s.length() != 1) {
            throw new QueryInvalidException(LocalizedStrings.ASTLiteral_ILLEGAL_FORMAT_FOR_CHAR_LITERAL_A_CHARACTER_LITERAL_MUST_HAVE_EXACTLY_ONE_CHARACTER.toLocalizedString());
        }
        return new Character(s.charAt(0));
    }

    private Date getDate(String s) {
        try {
            Date date = Date.valueOf(s);
            int firstDash = s.indexOf(45);
            int secondDash = s.indexOf(45, firstDash + 1);
            int month = Integer.parseInt(s.substring(firstDash + 1, secondDash));
            int day = Integer.parseInt(s.substring(secondDash + 1));
            if (month < 1 || month > 12) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_MONTH_MUST_BE_112_IN_DATE_LITERAL.toLocalizedString());
            }
            if (day < 1 || day > 31) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_DAY_MUST_BE_131_IN_DATE_LITERAL.toLocalizedString());
            }
            return date;
        }
        catch (IllegalArgumentException e) {
            throw new QueryInvalidException(LocalizedStrings.ASTLiteral_ILLEGAL_FORMAT_FOR_DATE_LITERAL_0_EXPECTED_FORMAT_IS_YYYYMMDD.toLocalizedString(s));
        }
    }

    private Time getTime(String s) {
        try {
            Time time = Time.valueOf(s);
            int firstColon = s.indexOf(58);
            int secondColon = s.indexOf(58, firstColon + 1);
            int hour = Integer.parseInt(s.substring(0, firstColon));
            int minute = Integer.parseInt(s.substring(firstColon + 1, secondColon));
            int second = Integer.parseInt(s.substring(secondColon + 1));
            if (hour < 0 || hour > 23) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_HOUR_MUST_BE_023_IN_TIME_LITERAL.toLocalizedString());
            }
            if (minute < 0 || minute > 59) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_MINUTE_MUST_BE_059_IN_TIME_LITERAL.toLocalizedString());
            }
            if (second < 0 || second > 59) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_SECOND_MUST_BE_059_IN_TIME_LITERAL.toLocalizedString());
            }
            return time;
        }
        catch (IllegalArgumentException e) {
            throw new QueryInvalidException(LocalizedStrings.ASTLiteral_ILLEGAL_FORMAT_FOR_TIME_LITERAL_0_EXPECTED_FORMAT_IS_HHMMSS.toLocalizedString(s));
        }
    }

    private Timestamp getTimestamp(String s) {
        try {
            Timestamp timestamp = Timestamp.valueOf(s);
            int count = 0;
            int index = -1;
            while ((index = s.indexOf(45, index + 1)) >= 0) {
                ++count;
            }
            if (count > 2) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_NEGATIVE_NUMBERS_NOT_ALLOWED_IN_TIMESTAMP_LITERAL.toLocalizedString());
            }
            StringTokenizer tokenizer = new StringTokenizer(s, ":-\t\n\r\f ");
            tokenizer.nextToken();
            int month = Integer.parseInt(tokenizer.nextToken());
            if (month < 1 || month > 12) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_MONTH_MUST_BE_112_IN_TIMESTAMP_LITERAL.toLocalizedString());
            }
            int day = Integer.parseInt(tokenizer.nextToken());
            if (day < 1 || day > 31) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_DAY_MUST_BE_131_IN_TIMESTAMP_LITERAL.toLocalizedString());
            }
            int hour = Integer.parseInt(tokenizer.nextToken());
            if (hour < 0 || hour > 23) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_HOUR_MUST_BE_023_IN_TIMESTAMP_LITERAL.toLocalizedString());
            }
            int minute = Integer.parseInt(tokenizer.nextToken());
            if (minute < 0 || minute > 59) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_MINUTE_MUST_BE_059_IN_TIMESTAMP_LITERAL.toLocalizedString());
            }
            String sec_s = tokenizer.nextToken();
            int period = sec_s.indexOf(46);
            int second = period >= 0 ? Integer.parseInt(sec_s.substring(0, period)) : Integer.parseInt(sec_s);
            if (second < 0 || second > 59) {
                throw new QueryInvalidException(LocalizedStrings.ASTLiteral_SECOND_MUST_BE_059_IN_TIMESTAMP_LITERAL.toLocalizedString());
            }
            return timestamp;
        }
        catch (IllegalArgumentException e) {
            throw new QueryInvalidException(LocalizedStrings.ASTLiteral_ILLEGAL_FORMAT_FOR_TIMESTAMP_LITERAL_0_EXPECTED_FORMAT_IS_YYYYMMDD_HHMMSSFFFFFFFFF.toLocalizedString(s));
        }
    }
}

