/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.index.AbstractIndex;
import com.gemstone.gemfire.cache.query.internal.index.IMQException;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.internal.PdxString;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrimaryKeyIndex
extends AbstractIndex {
    protected long numUses = 0L;
    ObjectType indexResultType;

    public PrimaryKeyIndex(String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndxExpr, String[] defintions, IndexStatistics indexStatistics) {
        super(indexName, region, fromClause, indexedExpression, projectionAttributes, origFromClause, origIndxExpr, defintions, indexStatistics);
        Class<Object> constr = region.getAttributes().getValueConstraint();
        if (constr == null) {
            constr = Object.class;
        }
        this.indexResultType = new ObjectTypeImpl(constr);
        this.markValid(true);
    }

    @Override
    public IndexType getType() {
        return IndexType.PRIMARY_KEY;
    }

    @Override
    protected boolean isCompactRangeIndex() {
        return false;
    }

    @Override
    public ObjectType getResultSetType() {
        return this.indexResultType;
    }

    @Override
    void removeMapping(RegionEntry entry, int opCode) {
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper ich) {
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        Boolean applyLimit;
        assert (keysToRemove == null);
        int limit = -1;
        if (key instanceof PdxString) {
            key = key.toString();
        }
        if ((applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index")) != null && applyLimit.booleanValue()) {
            limit = (Integer)context.cacheGet("limit");
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        if (limit != -1 && results.size() == limit) {
            observer.limitAppliedAtIndexLevel(this, limit, results);
            return;
        }
        switch (operator) {
            case 13: {
                Object value;
                Region.Entry entry;
                if (key == null || key == QueryService.UNDEFINED || (entry = ((LocalRegion)this.getRegion()).accessEntry(key, false)) == null || (value = entry.getValue()) == null) break;
                results.add(value);
                break;
            }
            case 20: 
            case 21: {
                Iterator itr;
                Region.Entry entry;
                boolean removeOneRow;
                Set values = (Set)this.getRegion().values();
                if (limit != -1) {
                    ++limit;
                }
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    QueryMonitor.isQueryExecutionCanceled();
                    results.add(iter.next());
                    if (limit == -1 || results.size() != limit) continue;
                    observer.limitAppliedAtIndexLevel(this, limit, results);
                    return;
                }
                boolean bl = removeOneRow = limit != -1;
                if (key != null && key != QueryService.UNDEFINED && (entry = ((LocalRegion)this.getRegion()).accessEntry(key, false)) != null && entry.getValue() != null) {
                    results.remove(entry.getValue());
                    removeOneRow = false;
                }
                if (!removeOneRow || !(itr = results.iterator()).hasNext()) break;
                itr.next();
                itr.remove();
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalizedStrings.PrimaryKeyIndex_INVALID_OPERATOR.toLocalizedString());
            }
        }
        ++this.numUses;
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        QueryObserver observer = QueryObserverHolder.getInstance();
        int limit = -1;
        Boolean applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index");
        if (applyLimit != null && applyLimit.booleanValue()) {
            limit = (Integer)context.cacheGet("limit");
        }
        if (limit != -1 && results.size() == limit) {
            observer.limitAppliedAtIndexLevel(this, limit, results);
            return;
        }
        if (key instanceof PdxString) {
            key = key.toString();
        }
        block0 : switch (operator) {
            case 13: {
                Object value;
                Region.Entry entry;
                if (key == null || key == QueryService.UNDEFINED || (entry = ((LocalRegion)this.getRegion()).accessEntry(key, false)) == null || (value = entry.getValue()) == null) break;
                boolean ok = true;
                if (runtimeItr != null) {
                    runtimeItr.setCurrent(value);
                    ok = QueryUtils.applyCondition(iterOps, context);
                }
                if (!ok) break;
                this.applyProjection(projAttrib, context, results, value, intermediateResults, isIntersection);
                break;
            }
            case 20: 
            case 21: {
                Set entries = this.getRegion().entrySet();
                for (Map.Entry entry : entries) {
                    Object val;
                    if (key != null && key != QueryService.UNDEFINED && key.equals(entry.getKey()) || (val = entry.getValue()) == null) continue;
                    boolean ok = true;
                    if (runtimeItr != null) {
                        runtimeItr.setCurrent(val);
                        ok = QueryUtils.applyCondition(iterOps, context);
                    }
                    if (ok) {
                        this.applyProjection(projAttrib, context, results, val, intermediateResults, isIntersection);
                    }
                    if (limit == -1 || results.size() != limit) continue;
                    observer.limitAppliedAtIndexLevel(this, limit, results);
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Operator");
            }
        }
        ++this.numUses;
    }

    @Override
    void recreateIndexData() throws IMQException {
        Support.Assert(false, "PrimaryKeyIndex::recreateIndexData: This method should not have got invoked at all");
    }

    @Override
    public boolean clear() throws QueryException {
        return true;
    }

    @Override
    protected AbstractIndex.InternalIndexStatistics createStats(String indexName) {
        return new PrimaryKeyIndexStatistics();
    }

    @Override
    void lockedQuery(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        throw new UnsupportedOperationException(LocalizedStrings.PrimaryKeyIndex_FOR_A_PRIMARYKEY_INDEX_A_RANGE_HAS_NO_MEANING.toLocalizedString());
    }

    @Override
    public int getSizeEstimate(Object key, int op, int matchLevel) {
        return 1;
    }

    @Override
    void addMapping(Object key, Object value, RegionEntry entry) throws IMQException {
    }

    @Override
    void saveMapping(Object key, Object value, RegionEntry entry) throws IMQException {
    }

    @Override
    public boolean isEmpty() {
        return this.createStats("primaryKeyIndex").getNumberOfKeys() == 0L;
    }

    class PrimaryKeyIndexStatistics
    extends AbstractIndex.InternalIndexStatistics {
        PrimaryKeyIndexStatistics() {
        }

        @Override
        public long getTotalUses() {
            return PrimaryKeyIndex.this.numUses;
        }

        @Override
        public long getNumberOfKeys() {
            return PrimaryKeyIndex.this.getRegion().keys().size();
        }

        @Override
        public long getNumberOfValues() {
            return PrimaryKeyIndex.this.getRegion().values().size();
        }

        @Override
        public long getNumberOfValues(Object key) {
            if (PrimaryKeyIndex.this.getRegion().containsValueForKey(key)) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("No Keys = ").append(this.getNumberOfKeys()).append("\n");
            sb.append("No Values = ").append(this.getNumberOfValues()).append("\n");
            sb.append("No Uses = ").append(this.getTotalUses()).append("\n");
            sb.append("No Updates = ").append(this.getNumUpdates()).append("\n");
            sb.append("Total Update time = ").append(this.getTotalUpdateTime()).append("\n");
            return sb.toString();
        }
    }
}

