/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.index.AbstractIndex;
import com.gemstone.gemfire.cache.query.internal.index.IMQException;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexStats;
import com.gemstone.gemfire.cache.query.internal.index.IndexUtils;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartitionedIndex
extends AbstractIndex {
    private Map<Region, List<Index>> bucketIndexes = Collections.synchronizedMap(new HashMap());
    private IndexType type;
    private int numRemoteBucektsIndexed;
    private String imports;
    private HashSet mapIndexKeys = new HashSet();
    private volatile boolean populateInProgress;

    public PartitionedIndex(IndexType iType, String indexName, Region r, String indexedExpression, String fromClause, String imports) {
        super(indexName, r, fromClause, indexedExpression, null, fromClause, indexedExpression, null, null);
        this.type = iType;
        this.imports = imports;
        if (iType == IndexType.HASH && !this.getRegion().getAttributes().getIndexMaintenanceSynchronous()) {
            throw new UnsupportedOperationException(LocalizedStrings.DefaultQueryService_HASH_INDEX_CREATION_IS_NOT_SUPPORTED_FOR_ASYNC_MAINTENANCE.toLocalizedString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToBucketIndexes(Region r, Index index) {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            List<Index> indexes = this.bucketIndexes.get(r);
            if (indexes == null) {
                indexes = new ArrayList<Index>();
            }
            indexes.add(index);
            this.bucketIndexes.put(r, indexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromBucketIndexes(Region r, Index index) {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            List<Index> indexes = this.bucketIndexes.get(r);
            if (indexes != null) {
                indexes.remove(index);
                if (indexes.isEmpty()) {
                    this.bucketIndexes.remove(r);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfIndexedBuckets() {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            int size = 0;
            for (List<Index> indexList : this.bucketIndexes.values()) {
                size += indexList.size();
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBucketIndexes() {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            for (List<Index> indexList : this.bucketIndexes.values()) {
                indexes.addAll(indexList);
            }
            return indexes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Index> getBucketIndexes(Region r) {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            List<Index> indexList = this.bucketIndexes.get(r);
            if (indexList != null) {
                indexes.addAll(indexList);
            }
            return indexes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index getBucketIndex() {
        Index index = null;
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            List<Index> indexList;
            if (this.bucketIndexes.size() > 0 && (indexList = this.bucketIndexes.values().iterator().next()) != null && indexList.size() > 0) {
                index = indexList.get(0);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<Region, List<Index>> getFirstBucketIndex() {
        Map.Entry<Region, List<Index>> firstIndexEntry = null;
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            if (this.bucketIndexes.size() > 0) {
                firstIndexEntry = this.bucketIndexes.entrySet().iterator().next();
            }
        }
        return firstIndexEntry;
    }

    @Override
    public IndexType getType() {
        return this.type;
    }

    public static AbstractIndex getBucketIndex(PartitionedRegion pr, String indexName, Integer bId) throws QueryInvocationTargetException {
        try {
            pr.checkReadiness();
        }
        catch (Exception ex) {
            throw new QueryInvocationTargetException(ex.getMessage());
        }
        PartitionedRegionDataStore prds = pr.getDataStore();
        BucketRegion bukRegion = prds.getLocalBucketById(bId);
        if (bukRegion == null) {
            throw new BucketMovedException("Bucket not found for the id :" + bId);
        }
        AbstractIndex index = null;
        if (bukRegion.getIndexManager() == null) {
            if (pr.getCache().getLogger().fineEnabled()) {
                pr.getCache().getLogger().fine("Index Manager not found for the bucket region " + bukRegion.getFullPath() + " unable to fetch the index " + indexName);
            }
            throw new QueryInvocationTargetException("Index Manager not found,  unable to fetch the index " + indexName);
        }
        index = (AbstractIndex)bukRegion.getIndexManager().getIndex(indexName);
        return index;
    }

    public void verifyAndCreateMissingIndex(List buckets) throws QueryInvocationTargetException {
        PartitionedRegion pr = (PartitionedRegion)this.getRegion();
        PartitionedRegionDataStore prds = pr.getDataStore();
        for (Object bId : buckets) {
            BucketRegion bukRegion = prds.getLocalBucketById((Integer)bId);
            if (bukRegion == null) {
                throw new QueryInvocationTargetException("Bucket not found for the id :" + bId);
            }
            IndexManager im = IndexUtils.getIndexManager(bukRegion, true);
            if (im == null || im.getIndex(this.indexName) != null) continue;
            try {
                if (pr.getCache().getLogger().fineEnabled()) {
                    pr.getCache().getLogger().fine("Verifying index presence on bucket region.  Found index " + this.indexName + " not present on the bucket region " + bukRegion.getFullPath() + ", index will be created on this region.");
                }
                ExecutionContext externalContext = new ExecutionContext(null, bukRegion.getCache());
                externalContext.setBucketRegion(pr, bukRegion);
                im.createIndex(this.indexName, this.type, this.originalIndexedExpression, this.fromClause, this.imports, externalContext, this, true);
            }
            catch (IndexExistsException indexExistsException) {
            }
            catch (IndexNameConflictException indexNameConflictException) {}
        }
    }

    @Override
    protected boolean isCompactRangeIndex() {
        return false;
    }

    public void setRemoteBucketesIndexed(int remoteBucketsIndexed) {
        this.numRemoteBucektsIndexed = remoteBucketsIndexed;
    }

    public int getNumRemoteBucketsIndexed() {
        return this.numRemoteBucektsIndexed;
    }

    @Override
    public Region getRegion() {
        return super.getRegion();
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
        throw new RuntimeException(LocalizedStrings.PartitionedIndex_NOT_SUPPORTED_ON_PARTITIONED_INDEX.toLocalizedString());
    }

    @Override
    public void initializeIndex(boolean loadEntries) throws IMQException {
        throw new RuntimeException(LocalizedStrings.PartitionedIndex_NOT_SUPPORTED_ON_PARTITIONED_INDEX.toLocalizedString());
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator indpndntItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) {
        throw new RuntimeException(LocalizedStrings.PartitionedIndex_NOT_SUPPORTED_ON_PARTITIONED_INDEX.toLocalizedString());
    }

    @Override
    void recreateIndexData() throws IMQException {
        throw new RuntimeException(LocalizedStrings.PartitionedIndex_NOT_SUPPORTED_ON_PARTITIONED_INDEX.toLocalizedString());
    }

    @Override
    void removeMapping(RegionEntry entry, int opCode) {
        throw new RuntimeException(LocalizedStrings.PartitionedIndex_NOT_SUPPORTED_ON_PARTITIONED_INDEX.toLocalizedString());
    }

    @Override
    public boolean clear() throws QueryException {
        return false;
    }

    @Override
    public IndexStatistics getStatistics() {
        return this.internalIndexStats;
    }

    public String getImports() {
        return this.imports;
    }

    @Override
    public String toString() {
        StringBuffer st = new StringBuffer();
        st.append(super.toString()).append("imports : ").append(this.imports);
        return st.toString();
    }

    @Override
    protected AbstractIndex.InternalIndexStatistics createStats(String indexName) {
        if (this.internalIndexStats == null) {
            this.internalIndexStats = new PartitionedIndexStatistics(this.indexName);
        }
        return this.internalIndexStats;
    }

    protected AbstractIndex.InternalIndexStatistics createExplicitStats(String indexName) {
        return new PartitionedIndexStatistics(indexName);
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper ich) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectType getResultSetType() {
        throw new UnsupportedOperationException();
    }

    @Override
    void lockedQuery(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        throw new RuntimeException(LocalizedStrings.PartitionedIndex_NOT_SUPPORTED_ON_PARTITIONED_INDEX.toLocalizedString());
    }

    @Override
    public int getSizeEstimate(Object key, int op, int matchLevel) {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    void addMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        throw new RuntimeException(LocalizedStrings.PartitionedIndex_NOT_SUPPORTED_ON_PARTITIONED_INDEX.toLocalizedString());
    }

    @Override
    void saveMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        throw new RuntimeException(LocalizedStrings.PartitionedIndex_NOT_SUPPORTED_ON_PARTITIONED_INDEX.toLocalizedString());
    }

    public void incNumMapKeysStats(Object mapKey) {
        if (this.internalIndexStats != null && !this.mapIndexKeys.contains(mapKey)) {
            this.mapIndexKeys.add(mapKey);
            this.internalIndexStats.incNumMapIndexKeys(1L);
        }
    }

    public void incNumBucketIndexes() {
        if (this.internalIndexStats != null) {
            this.internalIndexStats.incNumBucketIndexes(1);
        }
    }

    @Override
    public boolean isEmpty() {
        boolean empty = true;
        for (Object index : this.getBucketIndexes()) {
            empty = ((AbstractIndex)index).isEmpty();
            if (empty) continue;
            return false;
        }
        return empty;
    }

    public boolean isPopulateInProgress() {
        return this.populateInProgress;
    }

    public void setPopulateInProgress(boolean populateInProgress) {
        this.populateInProgress = populateInProgress;
    }

    class PartitionedIndexStatistics
    extends AbstractIndex.InternalIndexStatistics {
        private IndexStats vsdStats;

        public PartitionedIndexStatistics(String indexName) {
            this.vsdStats = new IndexStats(PartitionedIndex.this.getRegion().getCache().getDistributedSystem(), indexName);
        }

        @Override
        public long getNumUpdates() {
            return this.vsdStats.getNumUpdates();
        }

        @Override
        public void incNumValues(int delta) {
            this.vsdStats.incNumValues(delta);
        }

        @Override
        public void incNumUpdates() {
            this.vsdStats.incNumUpdates();
        }

        @Override
        public void incNumUpdates(int delta) {
            this.vsdStats.incNumUpdates(delta);
        }

        @Override
        public void updateNumKeys(long numKeys) {
            this.vsdStats.updateNumKeys(numKeys);
        }

        @Override
        public void incNumKeys(long numKeys) {
            this.vsdStats.incNumKeys(numKeys);
        }

        @Override
        public void incNumMapIndexKeys(long numKeys) {
            this.vsdStats.incNumMapIndexKeys(numKeys);
        }

        @Override
        public void incUpdateTime(long delta) {
            this.vsdStats.incUpdateTime(delta);
        }

        @Override
        public void incUpdatesInProgress(int delta) {
            this.vsdStats.incUpdatesInProgress(delta);
        }

        @Override
        public void incNumUses() {
            this.vsdStats.incNumUses();
        }

        @Override
        public void incUseTime(long delta) {
            this.vsdStats.incUseTime(delta);
        }

        @Override
        public void incUsesInProgress(int delta) {
            this.vsdStats.incUsesInProgress(delta);
        }

        @Override
        public void incReadLockCount(int delta) {
            this.vsdStats.incReadLockCount(delta);
        }

        @Override
        public void incNumBucketIndexes(int delta) {
            this.vsdStats.incNumBucketIndexes(delta);
        }

        @Override
        public long getNumberOfMapIndexKeys() {
            return this.vsdStats.getNumberOfMapIndexKeys();
        }

        @Override
        public long getTotalUpdateTime() {
            return this.vsdStats.getTotalUpdateTime();
        }

        @Override
        public long getTotalUses() {
            return this.vsdStats.getTotalUses();
        }

        @Override
        public long getNumberOfKeys() {
            return this.vsdStats.getNumberOfKeys();
        }

        @Override
        public long getNumberOfValues() {
            return this.vsdStats.getNumberOfValues();
        }

        @Override
        public int getReadLockCount() {
            return this.vsdStats.getReadLockCount();
        }

        @Override
        public int getNumberOfBucketIndexes() {
            return this.vsdStats.getNumberOfBucketIndexes();
        }

        @Override
        public void close() {
            this.vsdStats.close();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("No Keys = ").append(this.getNumberOfKeys()).append("\n");
            sb.append("No Map Index Keys = ").append(this.getNumberOfMapIndexKeys()).append("\n");
            sb.append("No Values = ").append(this.getNumberOfValues()).append("\n");
            sb.append("No Uses = ").append(this.getTotalUses()).append("\n");
            sb.append("No Updates = ").append(this.getNumUpdates()).append("\n");
            sb.append("Total Update time = ").append(this.getTotalUpdateTime()).append("\n");
            return sb.toString();
        }
    }
}

