/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.index.HashIndex;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.pdx.internal.PdxString;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashIndexSet
implements Set {
    private transient CachePerfStats cacheStats;
    protected transient int _size;
    protected transient int _free;
    transient int _removedTokens;
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 128;
    protected float _loadFactor;
    protected int n;
    protected int _mask;
    protected int _maxSize;
    protected static final float CONDITIONAL_REMOVED_TOKEN_REHASH_FACTOR = 0.7f;
    protected transient Object[] _set;
    protected HashIndex.IMQEvaluator _imqEvaluator;
    protected static final Object REMOVED = new Object();
    static boolean TEST_ALWAYS_REHASH = false;

    public HashIndexSet() {
        this(128, 0.5f);
    }

    private HashIndexSet(int initialCapacity, float loadFactor) {
        this.setUp(initialCapacity, loadFactor);
    }

    public void setEvaluator(HashIndex.IMQEvaluator evaluator) {
        this._imqEvaluator = evaluator;
    }

    public void setCachePerfStats(CachePerfStats stats) {
        this.cacheStats = stats;
    }

    @Override
    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    private int computeHash(Object object) {
        return object.hashCode();
    }

    protected int index(Object obj) {
        return this.index(this._imqEvaluator.evaluateKey(obj), obj);
    }

    protected int index(Object key, Object obj) {
        return this.index(key, obj, -1);
    }

    protected int index(Object key, Object obj, int ignoreThisSlot) {
        int mask = this._mask;
        Object[] set = this._set;
        int hash = this.computeHash(key);
        int pos = HashCommon.mix((int)hash) & mask;
        Object curr = set[pos];
        if (curr != null && curr != REMOVED) {
            if (curr.equals(obj) && pos != ignoreThisSlot) {
                return pos;
            }
            while ((curr = set[pos = pos + 1 & mask]) != null && curr != REMOVED) {
                if (!curr.equals(obj) || pos == ignoreThisSlot) continue;
                return pos;
            }
        }
        return -1;
    }

    public Iterator getAll() {
        return this.getAllNotMatching(Collections.EMPTY_LIST);
    }

    public Iterator getAllNotMatching(Collection keysToRemove) {
        return new HashIndexSetIterator(keysToRemove, this._set);
    }

    public Iterator get(Object indexKey) {
        return new HashIndexSetIterator(indexKey, this._set);
    }

    private boolean addObjectToSet(Object[] set, int index, Object newObject) {
        boolean added = true;
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot add:" + newObject + " into array position:" + index);
        }
        Object oldObject = set[index];
        if (oldObject == null || oldObject == REMOVED) {
            set[index] = newObject;
        }
        return added;
    }

    @Override
    public synchronized boolean add(Object obj) {
        throw new UnsupportedOperationException("add(Object) not supported, try add(Object key, Object obj) instead");
    }

    public synchronized int add(Object indexKey, Object obj) throws TypeMismatchException {
        if (indexKey == null) {
            indexKey = IndexManager.NULL;
        }
        this.preInsertHook();
        int indexSlot = this.insertionIndex(indexKey, obj, this._set);
        Object old = this._set[indexSlot];
        this.addObjectToSet(this._set, indexSlot, obj);
        if (old == null) {
            this.postInsertHook(true);
        } else {
            this.postInsertHook(false);
        }
        return indexSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertionIndex(Object indexKey, Object obj, Object[] set) {
        int mask = this._mask;
        Object[] array = set;
        int hash = this.computeHash(indexKey);
        long start = -1L;
        if (this.cacheStats != null) {
            HashIndexSet hashIndexSet = this;
            start = hashIndexSet.cacheStats.getStatTime();
            this.cacheStats.incQueryResultsHashCollisions();
        }
        try {
            int pos = HashCommon.mix((int)hash) & mask;
            Object curr = array[pos];
            if (curr != null && curr != REMOVED) {
                while ((curr = array[pos = pos + 1 & mask]) != null && curr != REMOVED) {
                }
            }
            int n = pos;
            return n;
        }
        finally {
            if (this.cacheStats != null) {
                this.cacheStats.endQueryResultsHashCollisionProbe(start);
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof HashIndexSet)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll((Collection)that);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED) continue;
            hash += set[i].hashCode();
        }
        return hash;
    }

    protected void rehash(int newN) {
        if (TEST_ALWAYS_REHASH) {
            Thread.yield();
        }
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        this._removedTokens = 0;
        this.n = newN;
        this._mask = this.n - 1;
        this._maxSize = this.computeMaxSize(this.n, this._loadFactor);
        this._free = this.computeNumFree();
        Object[] newSet = new Object[this.n + 1];
        int i = oldCapacity;
        while (i-- > 0) {
            int index;
            if (oldSet[i] == null || oldSet[i] == REMOVED) continue;
            Object o = oldSet[i];
            Object key = this._imqEvaluator.evaluateKey(o);
            if (key == null) {
                key = IndexManager.NULL;
            }
            if ((index = this.insertionIndex(key, o, newSet)) < 0) continue;
            this.addObjectToSet(newSet, index, o);
        }
        this._set = newSet;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("toArray not yet supported");
    }

    @Override
    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException("toArray(Object[] a) not yet supported");
    }

    @Override
    public void clear() {
        this._size = 0;
        this._free = this.capacity();
        this._removedTokens = 0;
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    protected int capacity() {
        return this._set.length;
    }

    @Override
    public boolean remove(Object obj) {
        return this.remove(this._imqEvaluator.evaluateKey(obj), obj);
    }

    public synchronized boolean remove(Object key, Object obj) {
        return this.remove(key, obj, -1);
    }

    public synchronized boolean remove(Object key, Object obj, int newIndexSlot) {
        int indexSlot = this.index(key, obj, newIndexSlot);
        boolean removed = false;
        if (indexSlot >= 0 && indexSlot != newIndexSlot) {
            removed = this.removeAt(indexSlot);
            return removed;
        }
        if (!IndexManager.isObjectModificationInplace()) {
            HashIndexSetIterator iterator = (HashIndexSetIterator)this.getAll();
            while (iterator.hasNext()) {
                Object indexedObject = iterator.next();
                if (!this.areObjectsEqual(indexedObject, obj) || iterator.currentObjectIndex() == newIndexSlot) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    public final boolean areObjectsEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        try {
            return TypeUtils.compare(o1, o2, 13).equals(Boolean.TRUE);
        }
        catch (TypeMismatchException e) {
            return o1.equals(o2);
        }
    }

    @Override
    public Iterator iterator() {
        return this.getAll();
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Add all not implemented");
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean changed = false;
        int size = collection.size();
        Iterator it = collection.iterator();
        while (size-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean changed = false;
        int size = this.size();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (collection.contains(object)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public int size() {
        return this._size;
    }

    public int size(Object indexKey) {
        return this._size;
    }

    public void compact() {
        this.trimToSize(this._size);
    }

    public boolean trimToSize(int n) {
        int l = HashCommon.nextPowerOfTwo((int)((int)Math.ceil((float)n / this._loadFactor)));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected boolean removeAt(int index) {
        Object cur = this._set[index];
        if (cur == null || cur == REMOVED) {
            return false;
        }
        this._set[index] = REMOVED;
        --this._size;
        ++this._removedTokens;
        return true;
    }

    protected int setUp(int expectedCapacity, float loadFactor) {
        this.n = HashCommon.arraySize((int)expectedCapacity, (float)loadFactor);
        this._loadFactor = loadFactor;
        this._maxSize = this.computeMaxSize(this.n, loadFactor);
        this._mask = this.n - 1;
        this._free = this.computeNumFree();
        this._set = new Object[this.n + 1];
        return this.n;
    }

    private int computeNumFree() {
        return this.n - this._size;
    }

    private int computeMaxSize(int n, float loadFactor) {
        return Math.min((int)Math.ceil((float)n * loadFactor), n - 1);
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        } else {
            --this._removedTokens;
        }
        ++this._size;
    }

    protected final void preInsertHook() {
        if (this._size > this._maxSize || this._free == 0 || TEST_ALWAYS_REHASH) {
            this.rehash(HashCommon.arraySize((int)(this._size + 1), (float)this._loadFactor));
            this.computeMaxSize(this.capacity(), this._loadFactor);
            this._free = this.computeNumFree();
        } else if ((float)this._removedTokens > (float)this._maxSize * 0.7f) {
            this.compact();
        }
    }

    private class HashIndexSetIterator
    implements Iterator {
        private Object keyToMatch;
        private final Object[] objects;
        private int pos;
        private int prevPos;
        private Collection keysToRemove;
        private Object current;
        private int hash;
        private int mask;
        private int probe;

        private HashIndexSetIterator(Collection keysToRemove, Object[] objects) {
            this.keysToRemove = keysToRemove;
            this.pos = 0;
            this.prevPos = 0;
            this.objects = objects;
            this.current = objects[this.pos];
        }

        private HashIndexSetIterator(Object keyToMatch, Object[] objects) {
            this.keyToMatch = keyToMatch;
            this.objects = objects;
            this.mask = HashIndexSet.this._mask;
            this.hash = HashIndexSet.this.computeHash(keyToMatch);
            this.prevPos = this.pos = HashCommon.mix((int)this.hash) & this.mask;
            this.current = objects[this.pos];
        }

        private void setPos(int pos) {
            this.prevPos = this.pos;
            this.pos = pos;
        }

        @Override
        public boolean hasNext() {
            if (this.keysToRemove != null) {
                while (this.pos < this.objects.length) {
                    this.current = this.objects[this.pos];
                    if (this.current != null && !this.current.equals(REMOVED) && this.notMatchingAnyKeyToRemove(this.keysToRemove, this.current)) {
                        return true;
                    }
                    this.setPos(this.pos + 1);
                }
                return false;
            }
            this.current = this.objects[this.pos];
            while (this.current != null) {
                if (this.current != REMOVED && this.objectMatchesIndexKey(this.keyToMatch, this.current)) {
                    return true;
                }
                this.setPos(this.pos + 1 & this.mask);
                this.current = this.objects[this.pos];
            }
            return false;
        }

        private boolean notMatchingAnyKeyToRemove(Collection keysToRemove, Object current) {
            for (Object keyToMatch : keysToRemove) {
                if (!this.objectMatchesIndexKey(keyToMatch, current)) continue;
                return false;
            }
            return true;
        }

        public Object next() throws NoSuchElementException {
            Object obj = this.current;
            if (this.keysToRemove != null) {
                this.setPos(this.pos + 1);
            } else {
                this.setPos(this.pos + 1 & this.mask);
            }
            return obj;
        }

        int currentObjectIndex() {
            return this.prevPos;
        }

        @Override
        public void remove() {
            HashIndexSet.this.removeAt(this.currentObjectIndex());
        }

        public boolean objectMatchesIndexKey(Object indexKey, Object o) {
            Object fieldValue = HashIndexSet.this._imqEvaluator.evaluateKey(o);
            if (fieldValue == IndexManager.NULL && indexKey == IndexManager.NULL) {
                return true;
            }
            try {
                if (fieldValue instanceof PdxString) {
                    if (indexKey instanceof String) {
                        fieldValue = ((PdxString)fieldValue).toString();
                    }
                } else if (indexKey instanceof PdxString && fieldValue instanceof String) {
                    fieldValue = new PdxString((String)fieldValue);
                }
                return TypeUtils.compare(fieldValue, indexKey, 13).equals(Boolean.TRUE);
            }
            catch (TypeMismatchException e) {
                return fieldValue.equals(indexKey);
            }
        }
    }
}

