/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.CompiledBindArgument;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.CompiledLiteral;
import com.gemstone.gemfire.cache.query.internal.CompiledPath;
import com.gemstone.gemfire.cache.query.internal.CompiledSortCriterion;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.CqEntry;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.IndexInfo;
import com.gemstone.gemfire.cache.query.internal.QRegion;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.index.AbstractIndex;
import com.gemstone.gemfire.cache.query.internal.index.DummyQRegion;
import com.gemstone.gemfire.cache.query.internal.index.FunctionalIndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.index.IMQException;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexProtocol;
import com.gemstone.gemfire.cache.query.internal.index.IndexStats;
import com.gemstone.gemfire.cache.query.internal.index.IndexStore;
import com.gemstone.gemfire.cache.query.internal.index.IndexedExpressionEvaluator;
import com.gemstone.gemfire.cache.query.internal.index.MapIndexStore;
import com.gemstone.gemfire.cache.query.internal.index.MemoryIndexStore;
import com.gemstone.gemfire.cache.query.internal.index.RangeIndex;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.internal.PdxString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CompactRangeIndex
extends AbstractIndex {
    private static IndexManager.TestHook testHook;
    protected ThreadLocal<OldKeyValuePair> oldKeyValue;
    private IndexStore indexStore;
    static boolean TEST_ALWAYS_UPDATE_IN_PROGRESS;

    public CompactRangeIndex(String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndexExpr, String[] definitions, IndexStatistics stats) {
        super(indexName, region, fromClause, indexedExpression, projectionAttributes, origFromClause, origIndexExpr, definitions, stats);
        this.indexStore = IndexManager.IS_TEST_LDM ? new MapIndexStore(((LocalRegion)region).getIndexMap(indexName, indexedExpression, origFromClause), region) : new MemoryIndexStore(region, this.internalIndexStats);
    }

    public IndexStore getIndexStorage() {
        return this.indexStore;
    }

    @Override
    public IndexType getType() {
        return IndexType.FUNCTIONAL;
    }

    @Override
    protected boolean isCompactRangeIndex() {
        return true;
    }

    @Override
    public void initializeIndex(boolean loadEntries) throws IMQException {
        long startTime = System.nanoTime();
        this.evaluator.initializeIndex(loadEntries);
        this.internalIndexStats.incNumUpdates(((IMQEvaluator)this.evaluator).getTotalEntriesUpdated());
        long endTime = System.nanoTime();
        this.internalIndexStats.incUpdateTime(endTime - startTime);
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
        this.evaluator.evaluate(entry, true);
        this.internalIndexStats.incNumUpdates();
    }

    @Override
    void removeMapping(RegionEntry entry, int opCode) throws IMQException {
        if (opCode == 1) {
            if (!IndexManager.isObjectModificationInplace()) {
                if (this.oldKeyValue == null) {
                    this.oldKeyValue = new ThreadLocal();
                }
                this.oldKeyValue.set(new OldKeyValuePair());
                this.evaluator.evaluate(entry, false);
            }
        } else {
            if (this.oldKeyValue != null) {
                this.oldKeyValue.remove();
            }
            this.evaluator.evaluate(entry, false);
            this.internalIndexStats.incNumUpdates();
        }
    }

    void removeMapping(Object key, RegionEntry entry) throws IMQException {
        this.indexStore.removeMapping(key, entry);
    }

    @Override
    public boolean clear() {
        return this.indexStore.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List queryEquijoinCondition(IndexProtocol indx, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        ArrayList arrayList;
        long start = this.updateIndexUseStats();
        ((AbstractIndex)indx).updateIndexUseStats();
        ArrayList data = new ArrayList();
        CloseableIterator<IndexStore.IndexStoreEntry> outer = null;
        Iterator<Object> inner = null;
        try {
            outer = this.indexStore.iterator(null);
            inner = indx instanceof CompactRangeIndex ? ((CompactRangeIndex)indx).getIndexStorage().iterator(null) : ((RangeIndex)indx).getValueToEntriesMap().entrySet().iterator();
            IndexStore.IndexStoreEntry outerEntry = null;
            Object innerEntry = null;
            Object outerKey = null;
            Object innerKey = null;
            boolean incrementInner = true;
            block5: while (outer.hasNext()) {
                outerEntry = (IndexStore.IndexStoreEntry)outer.next();
                outerKey = outerEntry.getDeserializedKey();
                while (!incrementInner || inner.hasNext()) {
                    int compare;
                    if (incrementInner) {
                        innerEntry = inner.next();
                        innerKey = innerEntry instanceof IndexStore.IndexStoreEntry ? ((IndexStore.IndexStoreEntry)innerEntry).getDeserializedKey() : ((Map.Entry)innerEntry).getKey();
                    }
                    if ((compare = ((Comparable)outerKey).compareTo(innerKey)) == 0) {
                        CloseableIterator<IndexStore.IndexStoreEntry> innerValue = null;
                        CloseableIterator<IndexStore.IndexStoreEntry> iter = null;
                        try {
                            innerValue = innerEntry instanceof IndexStore.IndexStoreEntry ? ((CompactRangeIndex)indx).getIndexStorage().get(outerKey) : (CloseableIterator<IndexStore.IndexStoreEntry>)((Map.Entry)innerEntry).getValue();
                            iter = this.indexStore.get(outerKey);
                            this.populateListForEquiJoin(data, iter, innerValue, context, innerKey);
                        }
                        finally {
                            if (iter != null) {
                                iter.close();
                            }
                            if (innerValue != null && innerValue instanceof CloseableIterator) {
                                innerValue.close();
                            }
                        }
                        incrementInner = true;
                        continue block5;
                    }
                    if (compare < 0) {
                        incrementInner = false;
                        continue block5;
                    }
                    incrementInner = true;
                }
                break block5;
            }
            arrayList = data;
            ((AbstractIndex)indx).updateIndexUseEndStats(start);
        }
        catch (Throwable throwable) {
            ((AbstractIndex)indx).updateIndexUseEndStats(start);
            this.updateIndexUseEndStats(start);
            if (outer != null) {
                outer.close();
            }
            if (inner != null && indx instanceof CompactRangeIndex) {
                inner.close();
            }
            throw throwable;
        }
        this.updateIndexUseEndStats(start);
        if (outer != null) {
            outer.close();
        }
        if (inner != null && indx instanceof CompactRangeIndex) {
            ((CloseableIterator)inner).close();
        }
        return arrayList;
    }

    protected boolean verifyInnerAndOuterEntryValues(IndexStore.IndexStoreEntry entry, ExecutionContext context, IndexInfo indexInfo, Object keyVal) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompactRangeIndex index = (CompactRangeIndex)indexInfo._getIndex();
        RuntimeIterator runtimeItr = index.getRuntimeIteratorForThisIndex(context, indexInfo);
        if (runtimeItr != null) {
            runtimeItr.setCurrent(((MemoryIndexStore.MemoryIndexStoreEntry)entry).getDeserializedValue());
        }
        return this.evaluateEntry(indexInfo, context, keyVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSizeEstimate(Object key, int operator, int matchLevel) throws TypeMismatchException {
        int size = 0;
        if (key == null) {
            key = IndexManager.NULL;
        }
        long start = this.updateIndexUseStats(false);
        try {
            switch (operator) {
                case 13: {
                    key = TypeUtils.indexKeyFor(key);
                    key = this.getPdxStringForIndexedPdxKeys(key);
                    size = this.indexStore.size(key);
                    return size;
                }
                case 20: 
                case 21: {
                    size = this.region.size();
                    key = TypeUtils.indexKeyFor(key);
                    key = this.getPdxStringForIndexedPdxKeys(key);
                    return size -= this.indexStore.size(key);
                }
                case 18: 
                case 22: {
                    if (matchLevel <= 0 && key instanceof Number) {
                        int totalSize = this.indexStore.size();
                        if (testHook != null) {
                            testHook.hook(1);
                        }
                        if (totalSize > 1) {
                            Number keyAsNum = (Number)key;
                            int x = 0;
                            IndexStore.IndexStoreEntry firstEntry = null;
                            CloseableIterator<IndexStore.IndexStoreEntry> iter1 = null;
                            CloseableIterator<IndexStore.IndexStoreEntry> iter2 = null;
                            try {
                                iter1 = this.indexStore.iterator(null);
                                if (!iter1.hasNext()) return size;
                                firstEntry = (IndexStore.IndexStoreEntry)iter1.next();
                                IndexStore.IndexStoreEntry lastEntry = null;
                                iter2 = this.indexStore.descendingIterator(null);
                                if (iter2.hasNext()) {
                                    lastEntry = (IndexStore.IndexStoreEntry)iter2.next();
                                }
                                if (firstEntry != null && lastEntry != null) {
                                    Number first = (Number)firstEntry.getDeserializedKey();
                                    Number last = (Number)lastEntry.getDeserializedKey();
                                    if (first.doubleValue() != last.doubleValue()) {
                                        x = (int)((keyAsNum.doubleValue() - first.doubleValue()) * (double)totalSize / (last.doubleValue() - first.doubleValue()));
                                    }
                                }
                                if (x < 0) {
                                    x = 0;
                                }
                                size = x;
                                return size;
                            }
                            finally {
                                if (iter1 != null) {
                                    iter1.close();
                                }
                                if (iter2 != null) {
                                    iter1.close();
                                }
                            }
                        }
                        size = this.indexStore.size(key) > 0 ? 1 : 0;
                        return size;
                    }
                    size = Integer.MAX_VALUE;
                    return size;
                }
                case 19: 
                case 23: {
                    if (matchLevel <= 0 && key instanceof Number) {
                        int totalSize = this.indexStore.size();
                        if (testHook != null) {
                            testHook.hook(2);
                        }
                        if (totalSize > 1) {
                            Number keyAsNum = (Number)key;
                            int x = 0;
                            IndexStore.IndexStoreEntry firstEntry = null;
                            CloseableIterator<IndexStore.IndexStoreEntry> iter2 = null;
                            try (CloseableIterator<IndexStore.IndexStoreEntry> iter1 = null;){
                                iter1 = this.indexStore.iterator(null);
                                if (iter1.hasNext()) {
                                    firstEntry = (IndexStore.IndexStoreEntry)iter1.next();
                                }
                                IndexStore.IndexStoreEntry lastEntry = null;
                                iter2 = this.indexStore.descendingIterator(null);
                                if (iter2.hasNext()) {
                                    lastEntry = (IndexStore.IndexStoreEntry)iter2.next();
                                }
                                if (firstEntry != null && lastEntry != null) {
                                    Number first = (Number)firstEntry.getDeserializedKey();
                                    Number last = (Number)lastEntry.getDeserializedKey();
                                    if (first.doubleValue() != last.doubleValue()) {
                                        x = (int)((last.doubleValue() - keyAsNum.doubleValue()) * (double)totalSize / (last.doubleValue() - first.doubleValue()));
                                    }
                                }
                                if (x < 0) {
                                    x = 0;
                                }
                                size = x;
                                return size;
                            }
                        }
                        size = this.indexStore.size(key) > 0 ? 1 : 0;
                        return size;
                    }
                    size = Integer.MAX_VALUE;
                    return size;
                }
            }
            return size;
        }
        finally {
            this.updateIndexUseEndStats(start, false);
        }
    }

    private void lockedQueryPrivate(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, Set keysToRemove, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (keysToRemove == null) {
            keysToRemove = new HashSet(0);
        }
        int limit = -1;
        Boolean applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index");
        if (applyLimit != null && applyLimit.booleanValue()) {
            limit = (Integer)context.cacheGet("limit");
        }
        Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        boolean applyOrderBy = false;
        boolean asc = true;
        List orderByAttrs = null;
        boolean multiColOrderBy = false;
        if (orderByClause != null && orderByClause.booleanValue()) {
            orderByAttrs = (List)context.cacheGet("orderby");
            CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttrs.get(0);
            asc = !csc.getCriterion();
            applyOrderBy = true;
            boolean bl = multiColOrderBy = orderByAttrs.size() > 1;
        }
        if (this.isEmpty()) {
            return;
        }
        key = this.getPdxStringForIndexedPdxKeys(key);
        this.evaluate(key, operator, results, iterOps, runtimeItr, context, keysToRemove, projAttrib, intermediateResults, isIntersection, limit, applyOrderBy, orderByAttrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void lockedQuery(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        lowerBoundKey = TypeUtils.indexKeyFor(lowerBoundKey);
        upperBoundKey = TypeUtils.indexKeyFor(upperBoundKey);
        boolean lowerBoundInclusive = lowerBoundOperator == 19;
        boolean upperBoundInclusive = upperBoundOperator == 18;
        int limit = -1;
        Boolean applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index");
        if (applyLimit != null && applyLimit.booleanValue()) {
            limit = (Integer)context.cacheGet("limit");
        }
        Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        List orderByAttrs = null;
        boolean asc = true;
        boolean multiColOrderBy = false;
        if (orderByClause != null && orderByClause.booleanValue()) {
            orderByAttrs = (List)context.cacheGet("orderby");
            CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttrs.get(0);
            asc = !csc.getCriterion();
            boolean bl = multiColOrderBy = orderByAttrs.size() > 1;
        }
        if (this.isEmpty()) {
            return;
        }
        lowerBoundKey = this.getPdxStringForIndexedPdxKeys(lowerBoundKey);
        upperBoundKey = this.getPdxStringForIndexedPdxKeys(upperBoundKey);
        if (keysToRemove == null) {
            keysToRemove = new HashSet();
        }
        try (CloseableIterator<IndexStore.IndexStoreEntry> iterator = null;){
            iterator = asc ? this.indexStore.iterator(lowerBoundKey, lowerBoundInclusive, upperBoundKey, upperBoundInclusive, keysToRemove) : this.indexStore.descendingIterator(lowerBoundKey, lowerBoundInclusive, upperBoundKey, upperBoundInclusive, keysToRemove);
            this.addToResultsFromEntries(lowerBoundKey, upperBoundKey, lowerBoundOperator, upperBoundOperator, iterator, results, null, null, context, null, null, true, multiColOrderBy ? -1 : limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void evaluate(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, Set keysToRemove, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit, boolean applyOrderBy, List orderByAttribs) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        boolean multiColOrderBy = false;
        if (keysToRemove == null) {
            keysToRemove = new HashSet(0);
        }
        if ((key = TypeUtils.indexKeyFor(key)) == null) {
            key = IndexManager.NULL;
        }
        boolean asc = true;
        if (applyOrderBy) {
            CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttribs.get(0);
            asc = !csc.getCriterion();
            multiColOrderBy = orderByAttribs.size() > 1;
        }
        try (CloseableIterator<IndexStore.IndexStoreEntry> iterator = null;){
            switch (operator) {
                case 13: {
                    assert (keysToRemove.isEmpty());
                    iterator = this.indexStore.get(key);
                    this.addToResultsFromEntries(key, operator, iterator, results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                    return;
                }
                case 22: {
                    iterator = asc ? this.indexStore.iterator(null, true, key, false, keysToRemove) : this.indexStore.descendingIterator(null, true, key, false, keysToRemove);
                    this.addToResultsFromEntries(key, operator, iterator, results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                    return;
                }
                case 18: {
                    iterator = asc ? this.indexStore.iterator(null, true, key, true, keysToRemove) : this.indexStore.descendingIterator(null, true, key, true, keysToRemove);
                    this.addToResultsFromEntries(key, operator, iterator, results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                    return;
                }
                case 23: {
                    iterator = asc ? this.indexStore.iterator(key, false, keysToRemove) : this.indexStore.descendingIterator(key, false, keysToRemove);
                    this.addToResultsFromEntries(key, operator, iterator, results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                    return;
                }
                case 19: {
                    iterator = asc ? this.indexStore.iterator(key, true, keysToRemove) : this.indexStore.descendingIterator(key, true, keysToRemove);
                    this.addToResultsFromEntries(key, operator, iterator, results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                    return;
                }
                case 20: 
                case 21: {
                    keysToRemove.add(key);
                    iterator = asc ? this.indexStore.iterator(keysToRemove) : this.indexStore.descendingIterator(keysToRemove);
                    this.addToResultsFromEntries(key, operator, iterator, results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                    if (!IndexManager.NULL.equals(key)) {
                        this.addToResultsFromEntries(IndexManager.NULL, 13, this.indexStore.get(IndexManager.NULL), results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                    }
                    if (QueryService.UNDEFINED.equals(key)) return;
                    this.addToResultsFromEntries(QueryService.UNDEFINED, 13, this.indexStore.get(QueryService.UNDEFINED), results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                    return;
                }
                default: {
                    throw new AssertionError((Object)("Operator = " + operator));
                }
            }
        }
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper ich) {
        this.evaluator = new IMQEvaluator(ich);
    }

    void instantiateEvaluator(IndexCreationHelper ich, ObjectType objectType) {
        this.instantiateEvaluator(ich);
        ((IMQEvaluator)this.evaluator).indexResultSetType = objectType;
    }

    @Override
    public ObjectType getResultSetType() {
        return this.evaluator.getIndexResultSetType();
    }

    private void addToResultsFromEntries(Object lowerBoundKey, int lowerBoundOperator, CloseableIterator<IndexStore.IndexStoreEntry> entriesIter, Collection result, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        this.addToResultsFromEntries(lowerBoundKey, null, lowerBoundOperator, -1, entriesIter, result, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
    }

    private void addToResultsFromEntries(Object lowerBoundKey, Object upperBoundKey, int lowerBoundOperator, int upperBoundOperator, CloseableIterator<IndexStore.IndexStoreEntry> entriesIter, Collection result, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryObserver observer = QueryObserverHolder.getInstance();
        boolean limitApplied = false;
        if (entriesIter == null || (limitApplied = this.verifyLimit(result, limit, context))) {
            if (limitApplied && observer != null) {
                observer.limitAppliedAtIndexLevel(this, limit, result);
            }
            return;
        }
        HashSet<Object> seenKey = null;
        if (IndexManager.IS_TEST_EXPANSION) {
            seenKey = new HashSet<Object>();
        }
        while (entriesIter.hasNext()) {
            try {
                QueryMonitor.isQueryExecutionCanceled();
                if (IndexManager.testHook != null) {
                    if (this.region.getCache().getLogger().fineEnabled()) {
                        this.region.getCache().getLogger().fine("IndexManager TestHook is set in addToResultsFromEntries.");
                    }
                    IndexManager.testHook.hook(11);
                }
                IndexStore.IndexStoreEntry indexEntry = null;
                try {
                    indexEntry = (IndexStore.IndexStoreEntry)entriesIter.next();
                }
                catch (NoSuchElementException ex) {
                    continue;
                }
                Object value2 = indexEntry.getDeserializedValue();
                if (IndexManager.IS_TEST_EXPANSION) {
                    Object rk = indexEntry.getDeserializedRegionKey();
                    if (seenKey.contains(rk)) continue;
                    seenKey.add(rk);
                    List expandedResults = this.expandValue(context, lowerBoundKey, upperBoundKey, lowerBoundOperator, upperBoundOperator, value2);
                    for (Object value2 : expandedResults) {
                        if (value2 == null) continue;
                        boolean ok = true;
                        if (runtimeItr != null) {
                            runtimeItr.setCurrent(value2);
                        }
                        if (ok && runtimeItr != null && iterOps != null) {
                            ok = QueryUtils.applyCondition(iterOps, context);
                        }
                        if (!ok) continue;
                        if (context != null && context.isCqQueryContext()) {
                            result.add(new CqEntry(indexEntry.getDeserializedRegionKey(), value2));
                        } else {
                            this.applyProjection(projAttrib, context, result, value2, intermediateResults, isIntersection);
                        }
                        if (!this.verifyLimit(result, limit, context)) continue;
                        observer.limitAppliedAtIndexLevel(this, limit, result);
                        return;
                    }
                    continue;
                }
                if (value2 == null) continue;
                boolean ok = true;
                if (indexEntry.isUpdateInProgress() || TEST_ALWAYS_UPDATE_IN_PROGRESS) {
                    IndexInfo indexInfo = (IndexInfo)context.cacheGet("index_info");
                    if (runtimeItr == null && (runtimeItr = this.getRuntimeIteratorForThisIndex(context, indexInfo)) == null) {
                        throw new QueryInvocationTargetException("Query alias's must be used consistently");
                    }
                    runtimeItr.setCurrent(value2);
                    ok = this.evaluateEntry(indexInfo, context, null);
                }
                if (runtimeItr != null) {
                    runtimeItr.setCurrent(value2);
                }
                if (ok && runtimeItr != null && iterOps != null) {
                    ok = QueryUtils.applyCondition(iterOps, context);
                }
                if (!ok) continue;
                if (context != null && context.isCqQueryContext()) {
                    result.add(new CqEntry(indexEntry.getDeserializedRegionKey(), value2));
                } else {
                    if (IndexManager.testHook != null) {
                        IndexManager.testHook.hook(200);
                    }
                    this.applyProjection(projAttrib, context, result, value2, intermediateResults, isIntersection);
                }
                if (!this.verifyLimit(result, limit, context)) continue;
                observer.limitAppliedAtIndexLevel(this, limit, result);
                return;
            }
            catch (ClassCastException classCastException) {
            }
            catch (EntryDestroyedException entryDestroyedException) {
            }
        }
    }

    public List expandValue(ExecutionContext context, Object lowerBoundKey, Object upperBoundKey, int lowerBoundOperator, int upperBoundOperator, Object value) {
        try {
            ArrayList expandedResults = new ArrayList();
            this.evaluator.expansion(expandedResults, lowerBoundKey, upperBoundKey, lowerBoundOperator, upperBoundOperator, value);
            return expandedResults;
        }
        catch (IMQException e) {
            e.printStackTrace();
            throw new CacheException((Throwable)e){};
        }
    }

    protected boolean evaluateEntry(IndexInfo indexInfo, ExecutionContext context, Object keyVal) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object result;
        CompiledValue path = indexInfo._path();
        Object left = path.evaluate(context);
        CompiledValue key = indexInfo._key();
        Object right = null;
        if (keyVal == null && key == null) {
            return left == QueryService.UNDEFINED;
        }
        right = key != null ? key.evaluate(context) : keyVal;
        int operator = indexInfo._operator();
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left instanceof PdxString && right instanceof String) {
            switch (key.getType()) {
                case -4: {
                    right = ((CompiledLiteral)key).getSavedPdxString();
                    break;
                }
                case 47: {
                    right = ((CompiledBindArgument)key).getSavedPdxString(context);
                    break;
                }
                case -5: 
                case -2: {
                    right = new PdxString((String)right);
                }
            }
        }
        if ((result = TypeUtils.compare(left, right, operator)) == QueryService.UNDEFINED) {
            if (operator != 20 || operator != 21) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return (Boolean)result;
    }

    @Override
    void recreateIndexData() throws IMQException {
        int updates;
        int numValues;
        this.indexStore.clear();
        int numKeys = (int)this.internalIndexStats.getNumberOfKeys();
        if (numKeys > 0) {
            this.internalIndexStats.incNumKeys(-numKeys);
        }
        if ((numValues = (int)this.internalIndexStats.getNumberOfValues()) > 0) {
            this.internalIndexStats.incNumValues(-numValues);
        }
        if ((updates = (int)this.internalIndexStats.getNumUpdates()) > 0) {
            this.internalIndexStats.incNumUpdates(updates);
        }
        this.initializeIndex(true);
    }

    public String dump() {
        return this.indexStore.printAll();
    }

    @Override
    protected AbstractIndex.InternalIndexStatistics createStats(String indexName) {
        return new RangeIndexStatistics(indexName);
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator indpndntItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        this.lockedQueryPrivate(key, operator, results, iterOps, indpndntItr, context, null, projAttrib, intermediateResults, isIntersection);
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        this.lockedQueryPrivate(key, operator, results, null, null, context, keysToRemove, null, null, true);
    }

    @Override
    void addMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        this.indexStore.addMapping(key, entry);
    }

    public static void setTestHook(IndexManager.TestHook hook) {
        testHook = hook;
    }

    @Override
    void saveMapping(Object key, Object value, RegionEntry entry) throws IMQException {
    }

    @Override
    public boolean isEmpty() {
        return this.indexStore.size() == 0;
    }

    @Override
    public Map getValueToEntriesMap() {
        throw new UnsupportedOperationException("valuesToEntriesMap should not be accessed directly");
    }

    public void addSavedMappings(RegionEntry entry) {
    }

    static {
        TEST_ALWAYS_UPDATE_IN_PROGRESS = false;
    }

    private class OldKeyValuePair {
        private Object oldKey;
        private Object oldValue;

        private OldKeyValuePair() {
        }

        public void setOldKeyValuePair(Object oldKey, RegionEntry entry) {
            this.oldKey = oldKey;
            this.oldValue = CompactRangeIndex.this.indexStore.getTargetObjectInVM(entry);
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getOldKey() {
            return this.oldKey;
        }
    }

    class IMQEvaluator
    implements IndexedExpressionEvaluator {
        private Cache cache;
        private List fromIterators = null;
        private CompiledValue indexedExpr = null;
        private final String[] canonicalIterNames;
        private ObjectType indexResultSetType = null;
        private Region rgn = null;
        private Map dependencyGraph = null;
        private boolean isFirstItrOnEntry = false;
        private List indexInitIterators = null;
        private CompiledValue additionalProj = null;
        private CompiledValue modifiedIndexExpr = null;
        private ObjectType addnlProjType = null;
        private int initEntriesUpdated = 0;
        private boolean hasInitOccuredOnce = false;
        private boolean hasIndxUpdateOccuredOnce = false;
        private ExecutionContext initContext = null;
        private int iteratorSize = -1;

        IMQEvaluator(IndexCreationHelper helper) {
            this.cache = helper.getCache();
            this.fromIterators = helper.getIterators();
            this.indexedExpr = helper.getCompiledIndexedExpression();
            this.canonicalIterNames = ((FunctionalIndexCreationHelper)helper).canonicalizedIteratorNames;
            this.rgn = helper.getRegion();
            this.isFirstItrOnEntry = ((FunctionalIndexCreationHelper)helper).isFirstIteratorRegionEntry;
            this.additionalProj = ((FunctionalIndexCreationHelper)helper).additionalProj;
            Object[] params1 = new Object[]{new QRegion(this.rgn, false)};
            this.initContext = new ExecutionContext(params1, this.cache);
            if (this.isFirstItrOnEntry) {
                this.indexInitIterators = this.fromIterators;
            } else {
                this.indexInitIterators = ((FunctionalIndexCreationHelper)helper).indexInitIterators;
                this.modifiedIndexExpr = ((FunctionalIndexCreationHelper)helper).modifiedIndexExpr;
                this.addnlProjType = ((FunctionalIndexCreationHelper)helper).addnlProjType;
            }
            this.iteratorSize = this.indexInitIterators.size();
            if (this.additionalProj instanceof CompiledPath) {
                String tailId = ((CompiledPath)this.additionalProj).getTailID();
                if (tailId.equals("key")) {
                    CompactRangeIndex.this.indexOnRegionKeys = true;
                    CompactRangeIndex.this.indexStore.setIndexOnRegionKeys(true);
                } else if (!this.isFirstItrOnEntry) {
                    CompactRangeIndex.this.indexOnValues = true;
                    CompactRangeIndex.this.indexStore.setIndexOnValues(true);
                }
            }
        }

        @Override
        public String getIndexedExpression() {
            return CompactRangeIndex.this.getCanonicalizedIndexedExpression();
        }

        @Override
        public String getProjectionAttributes() {
            return CompactRangeIndex.this.getCanonicalizedProjectionAttributes();
        }

        @Override
        public String getFromClause() {
            return CompactRangeIndex.this.getCanonicalizedFromClause();
        }

        @Override
        public void expansion(List expandedResults, Object lowerBoundKey, Object upperBoundKey, int lowerBoundOperator, int upperBoundOperator, Object value) throws IMQException {
            try {
                ExecutionContext expansionContext = this.createExecutionContext(value);
                List iterators = expansionContext.getCurrentIterators();
                RuntimeIterator iter = (RuntimeIterator)iterators.get(0);
                iter.setCurrent(value);
                this.doNestedExpansion(1, expansionContext, expandedResults, lowerBoundKey, upperBoundKey, lowerBoundOperator, upperBoundOperator, value);
            }
            catch (Exception e) {
                throw new IMQException((Throwable)e){};
            }
        }

        private void doNestedExpansion(int level, ExecutionContext expansionContext, List expandedResults, Object lowerBoundKey, Object upperBoundKey, int lowerBoundOperator, int upperBoundOperator, Object value) throws TypeMismatchException, AmbiguousNameException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            List iterList = expansionContext.getCurrentIterators();
            int iteratorSize = iterList.size();
            if (level == iteratorSize) {
                this.expand(expansionContext, expandedResults, lowerBoundKey, upperBoundKey, lowerBoundOperator, upperBoundOperator, value);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)iterList.get(level);
                SelectResults c = rIter.evaluateCollection(expansionContext);
                if (c == null) {
                    return;
                }
                Iterator cIter = c.iterator();
                while (cIter.hasNext()) {
                    rIter.setCurrent(cIter.next());
                    this.doNestedExpansion(level + 1, expansionContext, expandedResults, lowerBoundKey, upperBoundKey, lowerBoundOperator, upperBoundOperator, value);
                }
            }
        }

        public void expand(ExecutionContext expansionContext, List expandedResults, Object lowerBoundKey, Object upperBoundKey, int lowerBoundOperator, int upperBoundOperator, Object value) throws IMQException {
            try {
                Boolean ok;
                Object compResult;
                RuntimeIterator runtimeItr = CompactRangeIndex.this.getRuntimeIteratorForThisIndex(expansionContext);
                if (runtimeItr != null) {
                    runtimeItr.setCurrent(value);
                }
                Object tupleIndexKey = this.indexedExpr.evaluate(expansionContext);
                tupleIndexKey = CompactRangeIndex.this.getPdxStringForIndexedPdxKeys(tupleIndexKey);
                if (upperBoundKey != null && (compResult = TypeUtils.compare(tupleIndexKey, upperBoundKey, upperBoundOperator)) instanceof Boolean && !(ok = (Boolean)compResult).booleanValue()) {
                    return;
                }
                if (tupleIndexKey instanceof Map ? (lowerBoundOperator == 13 ? !((Map)tupleIndexKey).containsKey(lowerBoundKey) : lowerBoundOperator == 20 && ((Map)tupleIndexKey).containsKey(lowerBoundKey)) : (compResult = TypeUtils.compare(tupleIndexKey, lowerBoundKey, lowerBoundOperator)) instanceof Boolean && (ok = (Boolean)compResult) == false) {
                    return;
                }
                List currentRuntimeIters = expansionContext.getCurrentIterators();
                int iteratorSize = currentRuntimeIters.size();
                Object indxResultSet = null;
                boolean structType = this.indexResultSetType instanceof StructType;
                if (iteratorSize == 1 && !structType) {
                    RuntimeIterator iter = (RuntimeIterator)currentRuntimeIters.get(0);
                    iter.setCurrent(value);
                    indxResultSet = iter.evaluate(expansionContext);
                    indxResultSet = value;
                } else {
                    Object[] tuple = new Object[iteratorSize];
                    tuple[0] = value;
                    if (iteratorSize > 1) {
                        for (int i = 1; i < iteratorSize; ++i) {
                            RuntimeIterator iter = (RuntimeIterator)currentRuntimeIters.get(i);
                            tuple[i] = iter.evaluate(expansionContext);
                        }
                        Support.Assert(this.indexResultSetType instanceof StructTypeImpl, "The Index ResultType should have been an instance of StructTypeImpl rather than ObjectTypeImpl. The indxeResultType is " + this.indexResultSetType);
                    }
                    indxResultSet = new StructImpl((StructTypeImpl)this.indexResultSetType, tuple);
                }
                expandedResults.add(indxResultSet);
            }
            catch (Exception e) {
                throw new IMQException(e);
            }
        }

        private ExecutionContext createExecutionContext(Object value) {
            DummyQRegion dQRegion = new DummyQRegion(this.rgn);
            dQRegion.setEntry(VMThinRegionEntryHeap.getEntryFactory().createEntry((RegionEntryContext)((Object)this.rgn), 0, value));
            Object[] params = new Object[]{dQRegion};
            ExecutionContext context = new ExecutionContext(params, this.cache);
            context.newScope(IndexCreationHelper.INDEX_QUERY_SCOPE_ID);
            try {
                if (this.dependencyGraph != null) {
                    context.setDependencyGraph(this.dependencyGraph);
                }
                for (int i = 0; i < this.iteratorSize; ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)this.fromIterators.get(i);
                    if (this.dependencyGraph == null) {
                        iterDef.computeDependencies(context);
                    }
                    RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
                    context.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                    context.bindIterator(rIter);
                }
                if (this.dependencyGraph == null) {
                    this.dependencyGraph = context.getDependencyGraph();
                }
                Support.Assert(this.indexResultSetType != null, "IMQEvaluator::evaluate:The StrcutType should have been initialized during index creation");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                throw new Error("Unable to reevaluate, this should not happen");
            }
            return context;
        }

        @Override
        public void evaluate(RegionEntry target, boolean add) throws IMQException {
            assert (!target.isInvalid()) : "value in RegionEntry should not be INVALID";
            DummyQRegion dQRegion = new DummyQRegion(this.rgn);
            dQRegion.setEntry(target);
            Object[] params = new Object[]{dQRegion};
            ExecutionContext context = new ExecutionContext(params, this.cache);
            context.newScope(IndexCreationHelper.INDEX_QUERY_SCOPE_ID);
            try {
                if (this.dependencyGraph != null) {
                    context.setDependencyGraph(this.dependencyGraph);
                }
                for (int i = 0; i < this.iteratorSize; ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)this.fromIterators.get(i);
                    if (this.dependencyGraph == null) {
                        iterDef.computeDependencies(context);
                    }
                    RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
                    context.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                    context.bindIterator(rIter);
                }
                if (this.dependencyGraph == null) {
                    this.dependencyGraph = context.getDependencyGraph();
                }
                Support.Assert(this.indexResultSetType != null, "IMQEvaluator::evaluate:The StrcutType should have been initialized during index creation");
                this.doNestedIterations(0, add, context);
            }
            catch (IMQException imqe) {
                throw imqe;
            }
            catch (Exception e) {
                throw new IMQException(e);
            }
            finally {
                context.popScope();
            }
        }

        @Override
        public void initializeIndex(boolean loadEntries) throws IMQException {
            this.initEntriesUpdated = 0;
            try {
                this.initContext.newScope(1);
                for (int i = 0; i < this.iteratorSize; ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)this.indexInitIterators.get(i);
                    RuntimeIterator rIter = null;
                    if (!this.hasInitOccuredOnce) {
                        iterDef.computeDependencies(this.initContext);
                        rIter = iterDef.getRuntimeIterator(this.initContext);
                        this.initContext.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                    }
                    if (rIter == null) {
                        rIter = iterDef.getRuntimeIterator(this.initContext);
                    }
                    this.initContext.bindIterator(rIter);
                }
                this.hasInitOccuredOnce = true;
                if (this.indexResultSetType == null) {
                    this.indexResultSetType = this.createIndexResultSetType();
                }
                if (loadEntries) {
                    this.doNestedIterationsForIndexInit(0, this.initContext.getCurrentIterators());
                }
            }
            catch (IMQException imqe) {
                throw imqe;
            }
            catch (Exception e) {
                throw new IMQException(e);
            }
            finally {
                this.initContext.popScope();
            }
        }

        private void doNestedIterationsForIndexInit(int level, List runtimeIterators) throws TypeMismatchException, AmbiguousNameException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            if (level == 1) {
                ++this.initEntriesUpdated;
            }
            if (level == this.iteratorSize) {
                this.applyProjectionForIndexInit(runtimeIterators);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)runtimeIterators.get(level);
                SelectResults c = rIter.evaluateCollection(this.initContext);
                if (c == null) {
                    return;
                }
                Iterator cIter = c.iterator();
                while (cIter.hasNext()) {
                    rIter.setCurrent(cIter.next());
                    this.doNestedIterationsForIndexInit(level + 1, runtimeIterators);
                }
            }
        }

        private void applyProjectionForIndexInit(List currentRuntimeIters) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, IMQException {
            Object indexKey;
            if (QueryMonitor.isLowMemory()) {
                throw new IMQException(LocalizedStrings.IndexCreationMsg_CANCELED_DUE_TO_LOW_MEMORY.toLocalizedString());
            }
            Object object = indexKey = this.isFirstItrOnEntry ? this.indexedExpr.evaluate(this.initContext) : this.modifiedIndexExpr.evaluate(this.initContext);
            if (indexKey == null) {
                indexKey = IndexManager.NULL;
            }
            if (!CompactRangeIndex.this.isIndexedPdxKeysFlagSet.booleanValue()) {
                CompactRangeIndex.this.setPdxStringFlag(indexKey);
            }
            indexKey = CompactRangeIndex.this.getPdxStringForIndexedPdxKeys(indexKey);
            LocalRegion.NonTXEntry temp = null;
            temp = this.isFirstItrOnEntry && this.additionalProj != null ? (LocalRegion.NonTXEntry)this.additionalProj.evaluate(this.initContext) : (LocalRegion.NonTXEntry)((RuntimeIterator)currentRuntimeIters.get(0)).evaluate(this.initContext);
            RegionEntry re = temp.getRegionEntry();
            CompactRangeIndex.this.indexStore.addMapping(indexKey, re);
        }

        private void doNestedIterations(int level, boolean add, ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            List iterList = context.getCurrentIterators();
            if (level == this.iteratorSize) {
                this.applyProjection(add, context);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)iterList.get(level);
                SelectResults c = rIter.evaluateCollection(context);
                if (c == null) {
                    return;
                }
                Iterator cIter = c.iterator();
                while (cIter.hasNext()) {
                    rIter.setCurrent(cIter.next());
                    this.doNestedIterations(level + 1, add, context);
                }
            }
        }

        private void applyProjection(boolean add, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, IMQException {
            Object indexKey = this.indexedExpr.evaluate(context);
            if (indexKey == null) {
                indexKey = IndexManager.NULL;
            }
            if (!CompactRangeIndex.this.isIndexedPdxKeysFlagSet.booleanValue()) {
                CompactRangeIndex.this.setPdxStringFlag(indexKey);
            }
            indexKey = CompactRangeIndex.this.getPdxStringForIndexedPdxKeys(indexKey);
            RegionEntry entry = ((DummyQRegion)context.getBindArgument(1)).getEntry();
            OldKeyValuePair oldKeyValuePair = null;
            if (CompactRangeIndex.this.oldKeyValue != null) {
                oldKeyValuePair = CompactRangeIndex.this.oldKeyValue.get();
            }
            if (add) {
                Object oldKey = null;
                Object oldValue = null;
                if (oldKeyValuePair != null) {
                    oldKey = oldKeyValuePair.getOldKey();
                    oldValue = oldKeyValuePair.getOldValue();
                }
                if (oldKey == null) {
                    CompactRangeIndex.this.indexStore.addMapping(indexKey, entry);
                } else {
                    CompactRangeIndex.this.indexStore.updateMapping(indexKey, oldKey, entry, oldValue);
                    if (CompactRangeIndex.this.oldKeyValue != null) {
                        CompactRangeIndex.this.oldKeyValue.remove();
                    }
                }
            } else if (oldKeyValuePair != null) {
                oldKeyValuePair.setOldKeyValuePair(indexKey, entry);
            } else {
                CompactRangeIndex.this.indexStore.removeMapping(indexKey, entry);
            }
        }

        private ObjectType createIndexResultSetType() {
            int start;
            List currentIterators = this.initContext.getCurrentIterators();
            int len = currentIterators.size();
            ObjectType type = null;
            ObjectType[] fieldTypes = new ObjectType[len];
            int n = start = this.isFirstItrOnEntry ? 0 : 1;
            while (start < len) {
                RuntimeIterator iter = (RuntimeIterator)currentIterators.get(start);
                fieldTypes[start] = iter.getElementType();
                ++start;
            }
            if (!this.isFirstItrOnEntry) {
                fieldTypes[0] = this.addnlProjType;
            }
            type = len == 1 ? fieldTypes[0] : new StructTypeImpl(this.canonicalIterNames, fieldTypes);
            return type;
        }

        int getTotalEntriesUpdated() {
            return this.initEntriesUpdated;
        }

        @Override
        public ObjectType getIndexResultSetType() {
            return this.indexResultSetType;
        }

        @Override
        public List getAllDependentIterators() {
            return this.fromIterators;
        }
    }

    class RangeIndexStatistics
    extends AbstractIndex.InternalIndexStatistics {
        private IndexStats vsdStats;

        public RangeIndexStatistics(String indexName) {
            this.vsdStats = new IndexStats(CompactRangeIndex.this.getRegion().getCache().getDistributedSystem(), indexName);
        }

        @Override
        public long getNumUpdates() {
            return this.vsdStats.getNumUpdates();
        }

        @Override
        public void incNumValues(int delta) {
            this.vsdStats.incNumValues(delta);
        }

        @Override
        public void incNumUpdates() {
            this.vsdStats.incNumUpdates();
        }

        @Override
        public void incNumUpdates(int delta) {
            this.vsdStats.incNumUpdates(delta);
        }

        @Override
        public void updateNumKeys(long numKeys) {
            this.vsdStats.updateNumKeys(numKeys);
        }

        @Override
        public void incNumKeys(long numKeys) {
            this.vsdStats.incNumKeys(numKeys);
        }

        @Override
        public void incUpdateTime(long delta) {
            this.vsdStats.incUpdateTime(delta);
        }

        @Override
        public void incUpdatesInProgress(int delta) {
            this.vsdStats.incUpdatesInProgress(delta);
        }

        @Override
        public void incNumUses() {
            this.vsdStats.incNumUses();
        }

        @Override
        public void incUseTime(long delta) {
            this.vsdStats.incUseTime(delta);
        }

        @Override
        public void incUsesInProgress(int delta) {
            this.vsdStats.incUsesInProgress(delta);
        }

        @Override
        public void incReadLockCount(int delta) {
            this.vsdStats.incReadLockCount(delta);
        }

        @Override
        public long getTotalUpdateTime() {
            return this.vsdStats.getTotalUpdateTime();
        }

        @Override
        public long getTotalUses() {
            return this.vsdStats.getTotalUses();
        }

        @Override
        public long getNumberOfKeys() {
            return this.vsdStats.getNumberOfKeys();
        }

        @Override
        public long getNumberOfValues() {
            return this.vsdStats.getNumberOfValues();
        }

        @Override
        public long getNumberOfValues(Object key) {
            return CompactRangeIndex.this.indexStore.size(key);
        }

        @Override
        public int getReadLockCount() {
            return this.vsdStats.getReadLockCount();
        }

        @Override
        public void close() {
            this.vsdStats.close();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("No Keys = ").append(this.getNumberOfKeys()).append("\n");
            sb.append("No Values = ").append(this.getNumberOfValues()).append("\n");
            sb.append("No Uses = ").append(this.getTotalUses()).append("\n");
            sb.append("No Updates = ").append(this.getNumUpdates()).append("\n");
            sb.append("Total Update time = ").append(this.getTotalUpdateTime()).append("\n");
            return sb.toString();
        }
    }
}

