/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.index.AbstractIndex;
import com.gemstone.gemfire.cache.query.internal.index.AbstractMapIndex;
import com.gemstone.gemfire.cache.query.internal.index.CompactRangeIndex;
import com.gemstone.gemfire.cache.query.internal.index.IMQException;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompactMapRangeIndex
extends AbstractMapIndex {
    private final Map<Object, Map> entryToMapKeyIndexKeyMap;
    private IndexCreationHelper ich;

    CompactMapRangeIndex(String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndxExpr, String[] defintions, boolean isAllKeys, String[] multiIndexingKeysPattern, Object[] mapKeys, IndexStatistics stats) {
        super(indexName, region, fromClause, indexedExpression, projectionAttributes, origFromClause, origIndxExpr, defintions, isAllKeys, multiIndexingKeysPattern, mapKeys, stats);
        RegionAttributes ra = region.getAttributes();
        this.entryToMapKeyIndexKeyMap = new ConcurrentHashMap<Object, Map>(ra.getInitialCapacity(), ra.getLoadFactor(), ra.getConcurrencyLevel());
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper ich) {
        this.evaluator = new AbstractIndex.IMQEvaluator(ich);
        this.ich = ich;
    }

    @Override
    public boolean containsEntry(RegionEntry entry) {
        return this.entryToMapKeyIndexKeyMap.containsKey(entry);
    }

    @Override
    void recreateIndexData() throws IMQException {
        this.entryToMapKeyIndexKeyMap.clear();
        this.mapKeyToValueIndex.clear();
        this.initializeIndex(true);
    }

    @Override
    protected void removeMapping(RegionEntry entry, int opCode) throws IMQException {
        if (opCode == 1) {
            return;
        }
        Map mapKeyToIndexKey = this.entryToMapKeyIndexKeyMap.remove(entry);
        if (mapKeyToIndexKey == null) {
            return;
        }
        for (Map.Entry mapEntry : mapKeyToIndexKey.entrySet()) {
            Object mapKey = mapEntry.getKey();
            Object indexKey = mapEntry.getValue();
            CompactRangeIndex ri = (CompactRangeIndex)this.mapKeyToValueIndex.get(mapKey);
            long start = System.nanoTime();
            this.internalIndexStats.incUpdatesInProgress(1);
            ri.removeMapping(indexKey, entry);
            this.internalIndexStats.incUpdatesInProgress(-1);
            long end = System.nanoTime() - start;
            this.internalIndexStats.incUpdateTime(end);
            this.internalIndexStats.incNumUpdates();
        }
    }

    @Override
    void saveMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        if (key == QueryService.UNDEFINED || !(key instanceof Map)) {
            return;
        }
        if (this.isAllKeys) {
            for (Map.Entry mapEntry : ((Map)key).entrySet()) {
                Object mapKey = mapEntry.getKey();
                Object indexKey = mapEntry.getValue();
                this.saveIndexAddition(mapKey, indexKey, value, entry);
            }
        } else {
            for (Object mapKey : this.mapKeys) {
                Object indexKey = ((Map)key).get(mapKey);
                if (indexKey == null) continue;
                this.saveIndexAddition(mapKey, indexKey, value, entry);
            }
        }
    }

    @Override
    protected void doIndexAddition(Object mapKey, Object indexKey, Object value, RegionEntry entry) throws IMQException {
        boolean isPr = this.region instanceof BucketRegion;
        CompactRangeIndex rg = (CompactRangeIndex)this.mapKeyToValueIndex.get(mapKey);
        if (rg == null) {
            AbstractIndex.InternalIndexStatistics stats = this.internalIndexStats;
            PartitionedIndex prIndex = null;
            if (isPr) {
                prIndex = (PartitionedIndex)this.getPRIndex();
                prIndex.incNumMapKeysStats(mapKey);
            }
            rg = new CompactRangeIndex(this.indexName + "-" + mapKey, this.region, this.fromClause, this.indexedExpression, this.projectionAttributes, this.originalFromClause, this.originalIndexedExpression, this.canonicalizedDefinitions, stats);
            rg.instantiateEvaluator(this.ich, ((AbstractIndex.IMQEvaluator)this.evaluator).getIndexResultSetType());
            this.mapKeyToValueIndex.put(mapKey, rg);
            if (!isPr) {
                this.internalIndexStats.incNumMapIndexKeys(1L);
            }
        }
        long start = System.nanoTime();
        rg.addMapping(indexKey, value, entry);
        this.internalIndexStats.incUpdatesInProgress(-1);
        long end = System.nanoTime() - start;
        this.internalIndexStats.incUpdateTime(end);
        this.internalIndexStats.incNumUpdates();
        HashMap<Object, Object> mapKeyToIndexKey = this.entryToMapKeyIndexKeyMap.get(entry);
        if (mapKeyToIndexKey == null) {
            mapKeyToIndexKey = new HashMap<Object, Object>();
            this.entryToMapKeyIndexKeyMap.put(entry, mapKeyToIndexKey);
        }
        mapKeyToIndexKey.put(mapKey, indexKey);
    }

    @Override
    protected void saveIndexAddition(Object mapKey, Object indexKey, Object value, RegionEntry entry) throws IMQException {
        Object oldKey;
        if (indexKey == null) {
            indexKey = IndexManager.NULL;
        }
        boolean isPr = this.region instanceof BucketRegion;
        CompactRangeIndex rg = (CompactRangeIndex)this.mapKeyToValueIndex.get(mapKey);
        if (rg == null) {
            AbstractIndex.InternalIndexStatistics stats = this.internalIndexStats;
            PartitionedIndex prIndex = null;
            if (isPr) {
                prIndex = (PartitionedIndex)this.getPRIndex();
                prIndex.incNumMapKeysStats(mapKey);
            }
            rg = new CompactRangeIndex(this.indexName + "-" + mapKey, this.region, this.fromClause, this.indexedExpression, this.projectionAttributes, this.originalFromClause, this.originalIndexedExpression, this.canonicalizedDefinitions, stats);
            rg.instantiateEvaluator(this.ich, ((AbstractIndex.IMQEvaluator)this.evaluator).getIndexResultSetType());
            this.mapKeyToValueIndex.put(mapKey, rg);
            if (!isPr) {
                this.internalIndexStats.incNumMapIndexKeys(1L);
            }
        }
        this.internalIndexStats.incUpdatesInProgress(1);
        long start = System.nanoTime();
        HashMap<Object, Object> mapKeyToIndexKey = this.entryToMapKeyIndexKeyMap.get(entry);
        if (mapKeyToIndexKey == null) {
            mapKeyToIndexKey = new HashMap<Object, Object>();
            this.entryToMapKeyIndexKeyMap.put(entry, mapKeyToIndexKey);
        }
        if ((oldKey = mapKeyToIndexKey.get(mapKey)) == null) {
            rg.addMapping(indexKey, value, entry);
        } else if (oldKey != null && !oldKey.equals(indexKey)) {
            rg.addMapping(indexKey, value, entry);
            rg.removeMapping(oldKey, entry);
        }
        this.internalIndexStats.incUpdatesInProgress(-1);
        long end = System.nanoTime() - start;
        this.internalIndexStats.incUpdateTime(end);
        this.internalIndexStats.incNumUpdates();
        mapKeyToIndexKey.put(mapKey, indexKey);
    }
}

