/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.Bag;
import com.gemstone.gemfire.cache.query.internal.HashingStrategy;
import com.gemstone.gemfire.cache.query.internal.ObjectIntHashMap;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class ResultsBag
extends Bag
implements DataSerializableFixedID {
    protected ObjectIntHashMap map;

    public ResultsBag() {
        this.map = new ObjectIntHashMap();
    }

    public ResultsBag(boolean ignored) {
        super(ignored);
    }

    public ResultsBag(CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap();
    }

    protected ResultsBag(HashingStrategy strategy, CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap(strategy);
    }

    ResultsBag(Collection c, CachePerfStats stats) {
        this(stats);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    protected ResultsBag(Collection c, HashingStrategy strategy, CachePerfStats stats) {
        this(strategy, stats);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    ResultsBag(SelectResults sr, CachePerfStats stats) {
        this((Collection)sr, stats);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    ResultsBag(ObjectType elementType, CachePerfStats stats) {
        this(stats);
        this.setElementType(elementType);
    }

    ResultsBag(ObjectType elementType, int initialCapacity, CachePerfStats stats) {
        this(initialCapacity, stats);
        this.setElementType(elementType);
    }

    ResultsBag(int initialCapacity, float loadFactor, CachePerfStats stats) {
        this.map = new ObjectIntHashMap(initialCapacity, loadFactor);
    }

    protected ResultsBag(int initialCapacity, float loadFactor, HashingStrategy strategy, CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap(initialCapacity, loadFactor, strategy);
    }

    ResultsBag(int initialCapacity, CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap(initialCapacity);
    }

    protected ResultsBag(int initialCapacity, HashingStrategy strategy, CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap(initialCapacity, strategy);
    }

    protected ObjectIntHashMap createMapForFromData() {
        return new ObjectIntHashMap(this.size);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int occurence;
        this.elementType = (ObjectType)DataSerializer.readObject(in);
        this.size = in.readInt();
        assert (this.size >= 0) : this.size;
        this.map = this.createMapForFromData();
        this.readNumNulls(in);
        for (int numLeft = this.size - this.numNulls; numLeft > 0; numLeft -= occurence) {
            Object key = DataSerializer.readObject(in);
            occurence = in.readInt();
            this.map.put(key, occurence);
        }
    }

    @Override
    public int getDSFID() {
        return 15;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        int occurence;
        DataSerializer.writeObject(this.elementType, out);
        out.writeInt(this.size());
        this.writeNumNulls(out);
        Iterator<ObjectIntHashMap.Entry> itr = this.map.entrySet().iterator();
        for (int numLeft = this.size() - this.numNulls; itr.hasNext() && numLeft > 0; numLeft -= occurence) {
            ObjectIntHashMap.Entry entry = itr.next();
            Object key = entry.getKey();
            DataSerializer.writeObject(key, out);
            occurence = entry.getValue();
            if (numLeft < occurence) {
                occurence = numLeft;
            }
            out.writeInt(occurence);
        }
    }

    void createIntHashMap() {
        this.map = new ObjectIntHashMap(this.size - this.numNulls);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    protected int mapGet(Object element) {
        return this.map.get(element);
    }

    @Override
    protected boolean mapContainsKey(Object element) {
        return this.map.containsKey(element);
    }

    @Override
    protected void mapPut(Object element, int count) {
        this.map.put(element, count);
    }

    @Override
    protected int mapSize() {
        return this.map.size();
    }

    @Override
    protected int mapRemove(Object element) {
        return this.map.remove(element);
    }

    @Override
    protected void mapClear() {
        this.map.clear();
    }

    @Override
    protected Object getMap() {
        return this.map;
    }

    @Override
    protected int mapHashCode() {
        return this.map.hashCode();
    }

    @Override
    protected boolean mapEmpty() {
        return this.map.isEmpty();
    }

    @Override
    protected Iterator mapEntryIterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    protected Iterator mapKeyIterator() {
        return this.map.keySet().iterator();
    }

    @Override
    protected Object keyFromEntry(Object entry) {
        return ((ObjectIntHashMap.Entry)entry).getKey();
    }

    @Override
    protected Integer valueFromEntry(Object entry) {
        return ((ObjectIntHashMap.Entry)entry).getValue();
    }
}

