/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompiledComparison;
import com.gemstone.gemfire.cache.query.internal.CompiledID;
import com.gemstone.gemfire.cache.query.internal.CompiledIndexOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledJunction;
import com.gemstone.gemfire.cache.query.internal.CompiledOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledPath;
import com.gemstone.gemfire.cache.query.internal.CompiledSortCriterion;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.DerivedInfo;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.IndexConditioningHelper;
import com.gemstone.gemfire.cache.query.internal.IndexCutDownExpansionHelper;
import com.gemstone.gemfire.cache.query.internal.IndexInfo;
import com.gemstone.gemfire.cache.query.internal.LinkedResultSet;
import com.gemstone.gemfire.cache.query.internal.LinkedStructSet;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.query.internal.ResultsCollectionWrapper;
import com.gemstone.gemfire.cache.query.internal.ResultsSet;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.SortedResultsBag;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.internal.StructFields;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.StructSet;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.index.AbstractIndex;
import com.gemstone.gemfire.cache.query.internal.index.IndexData;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexProtocol;
import com.gemstone.gemfire.cache.query.internal.index.IndexUtils;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class QueryUtils {
    private static final Logger logger = LogService.getLogger();

    public static SelectResults intersection(SelectResults c1, SelectResults c2, ExecutionContext contextOrNull) {
        QueryObserverHolder.getInstance().invokedQueryUtilsIntersection(c1, c2);
        QueryUtils.assertCompatible(c1, c2);
        if (c1.isEmpty()) {
            return c1;
        }
        if (c2.isEmpty()) {
            return c2;
        }
        if (c1.size() < c2.size()) {
            return QueryUtils.sizeSortedIntersection(c1, c2, contextOrNull);
        }
        return QueryUtils.sizeSortedIntersection(c2, c1, contextOrNull);
    }

    public static SelectResults union(SelectResults c1, SelectResults c2, ExecutionContext contextOrNull) {
        QueryObserverHolder.getInstance().invokedQueryUtilsUnion(c1, c2);
        QueryUtils.assertCompatible(c1, c2);
        if (c1.size() < c2.size()) {
            return QueryUtils.sizeSortedUnion(c1, c2, contextOrNull);
        }
        return QueryUtils.sizeSortedUnion(c2, c1, contextOrNull);
    }

    public static void assertCompatible(SelectResults sr1, SelectResults sr2) {
        Assert.assertTrue(sr1.getCollectionType().getElementType().equals(sr2.getCollectionType().getElementType()));
    }

    public static SelectResults createResultCollection(ExecutionContext context, ObjectType elementType) {
        return context.isDistinct() ? new ResultsSet(elementType) : new ResultsBag(elementType, context.getCachePerfStats());
    }

    public static SelectResults createStructCollection(ExecutionContext context, StructType elementType) {
        return context.isDistinct() ? new StructSet(elementType) : new StructBag(elementType, context.getCachePerfStats());
    }

    public static SelectResults createResultCollection(boolean distinct, ObjectType elementType, ExecutionContext context) {
        return distinct ? new ResultsSet(elementType) : new ResultsBag(elementType, context.getCachePerfStats());
    }

    public static SelectResults createStructCollection(boolean distinct, StructType elementType, ExecutionContext context) {
        return distinct ? new StructSet(elementType) : new StructBag(elementType, context.getCachePerfStats());
    }

    public static SelectResults getEmptySelectResults(ObjectType objectType, CachePerfStats statsOrNull) {
        ResultsBag emptyResults = null;
        emptyResults = objectType instanceof StructType ? new StructBag((StructTypeImpl)objectType, statsOrNull) : new ResultsBag(objectType, statsOrNull);
        return emptyResults;
    }

    public static SelectResults getEmptySelectResults(CollectionType collectionType, CachePerfStats statsOrNull) {
        SelectResults emptyResults = null;
        emptyResults = collectionType.isOrdered() ? new ResultsCollectionWrapper(collectionType.getElementType(), new ArrayList()) : (!collectionType.allowsDuplicates() ? new ResultsCollectionWrapper(collectionType.getElementType(), new HashSet()) : QueryUtils.getEmptySelectResults(collectionType.getElementType(), statsOrNull));
        return emptyResults;
    }

    private static boolean isBag(SelectResults coln) {
        return coln.getCollectionType().allowsDuplicates();
    }

    private static SelectResults sizeSortedIntersection(SelectResults small, SelectResults large, ExecutionContext contextOrNull) {
        boolean largeModifiable;
        boolean smallModifiable = small.isModifiable() && (QueryUtils.isBag(small) || !QueryUtils.isBag(large));
        boolean bl = largeModifiable = large.isModifiable() && (QueryUtils.isBag(large) || !QueryUtils.isBag(small));
        if (smallModifiable) {
            try {
                Iterator itr = small.iterator();
                while (itr.hasNext()) {
                    Object element = itr.next();
                    int count = large.occurrences(element);
                    if (small.occurrences(element) <= count) continue;
                    itr.remove();
                }
                return small;
            }
            catch (UnsupportedOperationException itr) {
                // empty catch block
            }
        }
        if (largeModifiable) {
            try {
                Iterator itr = large.iterator();
                while (itr.hasNext()) {
                    Object element = itr.next();
                    int count = small.occurrences(element);
                    if (large.occurrences(element) <= count) continue;
                    itr.remove();
                }
                return large;
            }
            catch (UnsupportedOperationException itr) {
                // empty catch block
            }
        }
        AbstractCollection rs = contextOrNull != null ? (contextOrNull.isDistinct() ? new ResultsSet(small) : new ResultsBag(small, contextOrNull.getCachePerfStats())) : new ResultsBag(small, null);
        Iterator itr = rs.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            int count = large.occurrences(element);
            if (rs.occurrences(element) <= count) continue;
            itr.remove();
        }
        return rs;
    }

    private static SelectResults sizeSortedUnion(SelectResults small, SelectResults large, ExecutionContext contextOrNull) {
        boolean largeModifiable;
        boolean smallModifiable = small.isModifiable() && (QueryUtils.isBag(small) || !QueryUtils.isBag(large));
        boolean bl = largeModifiable = large.isModifiable() && (QueryUtils.isBag(large) || !QueryUtils.isBag(small));
        if (largeModifiable) {
            try {
                for (Object element : small) {
                    int count = small.occurrences(element);
                    if (large.occurrences(element) >= count) continue;
                    large.add(element);
                }
                return large;
            }
            catch (UnsupportedOperationException itr) {
                // empty catch block
            }
        }
        if (smallModifiable) {
            try {
                for (Object element : large) {
                    int count = large.occurrences(element);
                    if (small.occurrences(element) >= count) continue;
                    small.add(element);
                }
                return small;
            }
            catch (UnsupportedOperationException itr) {
                // empty catch block
            }
        }
        AbstractCollection rs = contextOrNull != null ? (contextOrNull.isDistinct() ? new ResultsSet(large) : new ResultsBag(large, contextOrNull.getCachePerfStats())) : new ResultsBag(large, null);
        for (Object element : small) {
            rs.add(element);
        }
        return rs;
    }

    public static List getDependentItrChainForIndpndntItrs(RuntimeIterator[] indpndntItrs, ExecutionContext context) {
        ArrayList ret = new ArrayList();
        for (int k = 0; k < indpndntItrs.length; ++k) {
            ret.addAll(context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(indpndntItrs[k]));
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SelectResults cartesian(SelectResults[] results, RuntimeIterator[][] itrsForResultFields, List expansionList, List finalList, ExecutionContext context, CompiledValue operand) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults returnSet = null;
        if (finalList.size() == 1) {
            ObjectType type = ((RuntimeIterator)finalList.iterator().next()).getElementType();
            if (!(type instanceof StructType)) return QueryUtils.createResultCollection(context, type);
            returnSet = QueryUtils.createStructCollection(context, (StructTypeImpl)type);
        } else {
            StructType structType = QueryUtils.createStructTypeForRuntimeIterators(finalList);
            returnSet = QueryUtils.createStructCollection(context, structType);
        }
        ListIterator expnItr = expansionList.listIterator();
        QueryUtils.doNestedIterations(0, returnSet, results, itrsForResultFields, finalList, expnItr, results.length + expansionList.size(), context, operand);
        return returnSet;
    }

    private static void doNestedIterations(int level, SelectResults returnSet, SelectResults[] results, RuntimeIterator[][] itrsForResultFields, List finalItrs, ListIterator expansionItrs, int finalLevel, ExecutionContext context, CompiledValue operand) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (level == finalLevel) {
            boolean select = true;
            if (operand != null) {
                select = QueryUtils.applyCondition(operand, context);
            }
            Iterator itr = finalItrs.iterator();
            int len = finalItrs.size();
            if (len > 1) {
                Object[] values = new Object[len];
                int j = 0;
                while (itr.hasNext()) {
                    values[j++] = ((RuntimeIterator)itr.next()).evaluate(context);
                }
                if (select) {
                    ((StructFields)((Object)returnSet)).addFieldValues(values);
                }
            } else if (select) {
                returnSet.add(((RuntimeIterator)itr.next()).evaluate(context));
            }
        } else if (level < results.length) {
            SelectResults individualResultSet = results[level];
            RuntimeIterator[] itrsForFields = itrsForResultFields[level];
            int len = itrsForFields.length;
            Iterator itr = individualResultSet.iterator();
            while (itr.hasNext()) {
                QueryMonitor.isQueryExecutionCanceled();
                Object value = itr.next();
                if (len == 1) {
                    itrsForFields[0].setCurrent(value);
                } else {
                    Struct struct = (Struct)value;
                    Object[] fieldValues = struct.getFieldValues();
                    int size = fieldValues.length;
                    for (int i = 0; i < size; ++i) {
                        itrsForFields[i].setCurrent(fieldValues[i]);
                    }
                }
                QueryUtils.doNestedIterations(level + 1, returnSet, results, itrsForResultFields, finalItrs, expansionItrs, finalLevel, context, operand);
            }
        } else {
            RuntimeIterator currLevel = (RuntimeIterator)expansionItrs.next();
            SelectResults c = currLevel.evaluateCollection(context);
            if (c == null) {
                expansionItrs.previous();
                return;
            }
            Iterator cIter = c.iterator();
            while (cIter.hasNext()) {
                currLevel.setCurrent(cIter.next());
                QueryUtils.doNestedIterations(level + 1, returnSet, results, itrsForResultFields, finalItrs, expansionItrs, finalLevel, context, operand);
            }
            expansionItrs.previous();
        }
    }

    public static boolean applyCondition(CompiledValue operand, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (operand == null) {
            return true;
        }
        Object result = operand.evaluate(context);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result != null && result != QueryService.UNDEFINED) {
            throw new TypeMismatchException(LocalizedStrings.QueryUtils_ANDOR_OPERANDS_MUST_BE_OF_TYPE_BOOLEAN_NOT_TYPE_0.toLocalizedString(result.getClass().getName()));
        }
        return false;
    }

    private static void mergeRelationshipIndexResultsWithIntermediateResults(SelectResults returnSet, SelectResults[] intermediateResults, RuntimeIterator[][] itrsForIntermediateResults, Object[][] indexResults, RuntimeIterator[][] indexFieldToItrsMapping, ListIterator expansionListItr, List finalItrs, ExecutionContext context, List[] checkList, CompiledValue iterOps, IndexCutDownExpansionHelper[] icdeh, int level, int maxExpnCartesianDepth) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        int resultSize = indexResults[level].length;
        for (int j = 0; j < resultSize; ++j) {
            if (!QueryUtils.setIndexFieldValuesInRespectiveIterators(indexResults[level][j], indexFieldToItrsMapping[level], icdeh[level])) continue;
            if (level == indexResults.length - 1) {
                QueryUtils.doNestedIterations(0, returnSet, intermediateResults, itrsForIntermediateResults, finalItrs, expansionListItr, maxExpnCartesianDepth, context, iterOps);
                continue;
            }
            QueryUtils.mergeRelationshipIndexResultsWithIntermediateResults(returnSet, intermediateResults, itrsForIntermediateResults, indexResults, indexFieldToItrsMapping, expansionListItr, finalItrs, context, checkList, iterOps, icdeh, level + 1, maxExpnCartesianDepth);
            if (!icdeh[level + 1].cutDownNeeded) continue;
            icdeh[level + 1].checkSet.clear();
        }
    }

    private static void mergeAndExpandCutDownRelationshipIndexResults(Object[][] values, SelectResults result, RuntimeIterator[][] indexFieldToItrsMapping, ListIterator expansionListIterator, List finalItrs, ExecutionContext context, List[] checkList, CompiledValue iterOps, IndexCutDownExpansionHelper[] icdeh, int level) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        int resultSize = values[level].length;
        int limit = QueryUtils.getLimitValue(context);
        if (limit != -1 && result.size() >= limit) {
            return;
        }
        for (int j = 0; j < resultSize; ++j) {
            QueryMonitor.isQueryExecutionCanceled();
            if (!QueryUtils.setIndexFieldValuesInRespectiveIterators(values[level][j], indexFieldToItrsMapping[level], icdeh[level])) continue;
            if (level == values.length - 1) {
                QueryUtils.doNestedIterationsForIndex(expansionListIterator.hasNext(), result, finalItrs, expansionListIterator, context, iterOps, limit, null);
                if (limit == -1 || result.size() < limit) continue;
                break;
            }
            QueryUtils.mergeAndExpandCutDownRelationshipIndexResults(values, result, indexFieldToItrsMapping, expansionListIterator, finalItrs, context, checkList, iterOps, icdeh, level + 1);
            if (!icdeh[level + 1].cutDownNeeded) continue;
            icdeh[level + 1].checkSet.clear();
        }
    }

    private static boolean setIndexFieldValuesInRespectiveIterators(Object value, RuntimeIterator[] indexFieldToItrsMapping, IndexCutDownExpansionHelper icdeh) {
        Object[] checkFields = null;
        boolean select = true;
        int len = indexFieldToItrsMapping.length;
        RuntimeIterator rItr = null;
        if (len == 1) {
            Support.Assert(!icdeh.cutDownNeeded, "If the index fields to iter mapping is of of size 1 then cut down cannot occur");
            indexFieldToItrsMapping[0].setCurrent(value);
        } else {
            Struct struct = (Struct)value;
            Object[] fieldValues = struct.getFieldValues();
            int size = fieldValues.length;
            if (icdeh.cutDownNeeded) {
                checkFields = new Object[icdeh.checkSize];
            }
            int j = 0;
            for (int i = 0; i < size; ++i) {
                rItr = indexFieldToItrsMapping[i];
                if (rItr == null) continue;
                rItr.setCurrent(fieldValues[i]);
                if (!icdeh.cutDownNeeded) continue;
                checkFields[j++] = fieldValues[i];
            }
            if (icdeh.cutDownNeeded) {
                Object temp = null;
                temp = icdeh.checkSize == 1 ? checkFields[0] : new StructImpl((StructTypeImpl)icdeh.checkType, checkFields);
                if (icdeh.checkSet.contains(temp)) {
                    select = false;
                } else {
                    icdeh.checkSet.add(temp);
                }
            }
        }
        return select;
    }

    private static SelectResults cutDownAndExpandIndexResults(SelectResults result, RuntimeIterator[] indexFieldToItrsMapping, List expansionList, List finalItrs, ExecutionContext context, List checkList, CompiledValue iterOps, IndexInfo theFilteringIndex) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ObjectType resultType;
        Collection returnSet = null;
        boolean useLinkedDataStructure = false;
        boolean nullValuesAtStart = true;
        Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        if (orderByClause != null && orderByClause.booleanValue()) {
            List orderByAttrs = (List)context.cacheGet("orderby");
            useLinkedDataStructure = orderByAttrs.size() == 1;
            boolean bl = nullValuesAtStart = !((CompiledSortCriterion)orderByAttrs.get(0)).getCriterion();
        }
        if (finalItrs.size() == 1) {
            resultType = ((RuntimeIterator)finalItrs.iterator().next()).getElementType();
            returnSet = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
        } else {
            resultType = (StructTypeImpl)QueryUtils.createStructTypeForRuntimeIterators(finalItrs);
            returnSet = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, resultType);
        }
        QueryUtils.cutDownAndExpandIndexResults(returnSet, result, indexFieldToItrsMapping, expansionList, finalItrs, context, checkList, iterOps, theFilteringIndex);
        return returnSet;
    }

    private static void cutDownAndExpandIndexResults(SelectResults returnSet, SelectResults result, RuntimeIterator[] indexFieldToItrsMapping, List expansionList, List finalItrs, ExecutionContext context, List checkList, CompiledValue iterOps, IndexInfo theFilteringIndex) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        IndexCutDownExpansionHelper icdeh = new IndexCutDownExpansionHelper(checkList, context);
        int len = indexFieldToItrsMapping.length;
        if (result.getClass() == ResultsBag.class) {
            Support.Assert(len == 1, "The array size of iterators should be 1 here, but got " + len);
        }
        Iterator itr = result.iterator();
        ListIterator expansionListIterator = expansionList.listIterator();
        int limit = QueryUtils.getLimitValue(context);
        while (itr.hasNext()) {
            Object value;
            DerivedInfo derivedInfo = null;
            if (IndexManager.JOIN_OPTIMIZATION) {
                derivedInfo = new DerivedInfo();
                derivedInfo.setExpansionList(expansionList);
            }
            if (!QueryUtils.setIndexFieldValuesInRespectiveIterators(value = itr.next(), indexFieldToItrsMapping, icdeh)) continue;
            if (IndexManager.JOIN_OPTIMIZATION) {
                derivedInfo.computeDerivedJoinResults(theFilteringIndex, context, iterOps);
            }
            QueryUtils.doNestedIterationsForIndex(expansionListIterator.hasNext(), returnSet, finalItrs, expansionListIterator, context, iterOps, limit, derivedInfo.derivedResults);
            if (limit == -1 || returnSet.size() < limit) continue;
            break;
        }
    }

    private static int getLimitValue(ExecutionContext context) {
        int limit = -1;
        if (context.cacheGet("orderby") == null) {
            limit = (Integer)context.cacheGet("limit") != null ? (Integer)context.cacheGet("limit") : -1;
        }
        return limit;
    }

    public static CompiledID getCompiledIdFromPath(CompiledValue path) {
        int type = path.getType();
        if (type == 34) {
            return (CompiledID)path;
        }
        return QueryUtils.getCompiledIdFromPath(path.getReceiver());
    }

    private static void doNestedIterationsForIndex(boolean continueRecursion, SelectResults resultSet, List finalItrs, ListIterator expansionItrs, ExecutionContext context, CompiledValue iterOps, int limit, Map<String, SelectResults> derivedResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (!continueRecursion) {
            Iterator itr = finalItrs.iterator();
            int len = finalItrs.size();
            boolean select = true;
            if (iterOps != null) {
                select = QueryUtils.applyCondition(iterOps, context);
            }
            if (len > 1) {
                boolean isOrdered = resultSet.getCollectionType().isOrdered();
                StructTypeImpl elementType = (StructTypeImpl)resultSet.getCollectionType().getElementType();
                Object[] values = new Object[len];
                int j = 0;
                while (itr.hasNext()) {
                    QueryMonitor.isQueryExecutionCanceled();
                    values[j++] = ((RuntimeIterator)itr.next()).evaluate(context);
                }
                if (select) {
                    if (isOrdered) {
                        resultSet.add(new StructImpl(elementType, values));
                    } else {
                        ((StructFields)((Object)resultSet)).addFieldValues(values);
                    }
                }
            } else if (select) {
                resultSet.add(((RuntimeIterator)itr.next()).evaluate(context));
            }
        } else {
            RuntimeIterator currentLevel = (RuntimeIterator)expansionItrs.next();
            SelectResults c = null;
            CompiledValue collectionExpression = currentLevel.getCmpIteratorDefn().getCollectionExpr();
            String key = null;
            boolean useDerivedResults = true;
            if (currentLevel.getCmpIteratorDefn().getCollectionExpr().getType() == 35) {
                key = currentLevel.getCmpIteratorDefn().getName() + ":" + currentLevel.getDefinition();
            } else if (currentLevel.getCmpIteratorDefn().getCollectionExpr().getType() == 73) {
                useDerivedResults = false;
            } else {
                key = QueryUtils.getCompiledIdFromPath(currentLevel.getCmpIteratorDefn().getCollectionExpr()).getId() + ":" + currentLevel.getDefinition();
            }
            c = useDerivedResults && derivedResults != null && derivedResults.containsKey(key) ? derivedResults.get(key) : currentLevel.evaluateCollection(context);
            if (c == null) {
                expansionItrs.previous();
                return;
            }
            Iterator cIter = c.iterator();
            while (cIter.hasNext()) {
                QueryMonitor.isQueryExecutionCanceled();
                currentLevel.setCurrent(cIter.next());
                QueryUtils.doNestedIterationsForIndex(expansionItrs.hasNext(), resultSet, finalItrs, expansionItrs, context, iterOps, limit, derivedResults);
                if (limit == -1 || resultSet.size() < limit) continue;
            }
            expansionItrs.previous();
        }
    }

    public static CompiledValue obtainTheBottomMostCompiledValue(CompiledValue expr) {
        boolean toContinue = true;
        int exprType = expr.getType();
        while (toContinue) {
            switch (exprType) {
                case 35: {
                    toContinue = false;
                    break;
                }
                case 53: {
                    CompiledOperation operation = (CompiledOperation)expr;
                    expr = operation.getReceiver(null);
                    if (expr != null) break;
                    expr = operation;
                    toContinue = false;
                    break;
                }
                case -5: {
                    expr = ((CompiledPath)expr).getReceiver();
                    break;
                }
                case 24: {
                    expr = ((CompiledIndexOperation)expr).getReceiver();
                    break;
                }
                default: {
                    toContinue = false;
                }
            }
            if (!toContinue) continue;
            exprType = expr.getType();
        }
        return expr;
    }

    public static StructType createStructTypeForRuntimeIterators(List runTimeIterators) {
        Support.Assert(runTimeIterators.size() > 1, "The number of Iterators passed should be greater than 1 to create a structSet");
        int len = runTimeIterators.size();
        String[] fieldNames = new String[len];
        String[] indexAlternativeFieldNames = new String[len];
        ObjectType[] fieldTypes = new ObjectType[len];
        Iterator itr = runTimeIterators.iterator();
        int i = 0;
        while (itr.hasNext()) {
            RuntimeIterator iter = (RuntimeIterator)itr.next();
            fieldNames[i] = iter.getInternalId();
            indexAlternativeFieldNames[i] = iter.getIndexInternalID();
            fieldTypes[i++] = iter.getElementType();
        }
        StructTypeImpl type = new StructTypeImpl(fieldNames, indexAlternativeFieldNames, fieldTypes);
        return type;
    }

    public static Set getCurrentScopeUltimateRuntimeIteratorsIfAny(CompiledValue compiledValue, ExecutionContext context) {
        HashSet set = new HashSet();
        context.computeUtlimateDependencies(compiledValue, set);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            RuntimeIterator rIter = (RuntimeIterator)iter.next();
            if (rIter.getScopeID() == context.currentScope().getScopeID()) continue;
            iter.remove();
        }
        return set;
    }

    static IndexData[] getRelationshipIndexIfAny(CompiledValue lhs, CompiledValue rhs, ExecutionContext context, int operator) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        if (operator != 13) {
            return null;
        }
        IndexData lhsIndxData = QueryUtils.getAvailableIndexIfAny(lhs, context, false);
        if (lhsIndxData == null) {
            return null;
        }
        IndexData rhsIndxData = QueryUtils.getAvailableIndexIfAny(rhs, context, false);
        if (rhsIndxData == null) {
            IndexProtocol index = lhsIndxData.getIndex();
            Index prIndex = ((AbstractIndex)index).getPRIndex();
            if (prIndex != null) {
                ((PartitionedIndex)prIndex).releaseIndexReadLockForRemove();
            } else {
                ((AbstractIndex)index).releaseIndexReadLockForRemove();
            }
            return null;
        }
        IndexProtocol lhsIndx = lhsIndxData.getIndex();
        IndexProtocol rhsIndx = rhsIndxData.getIndex();
        if (lhsIndx.isValid() && rhsIndx.isValid()) {
            return new IndexData[]{lhsIndxData, rhsIndxData};
        }
        return null;
    }

    static IndexData getAvailableIndexIfAny(CompiledValue cv, ExecutionContext context, int operator) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        boolean usePrimaryIndex = operator == 13 || operator == 20;
        return QueryUtils.getAvailableIndexIfAny(cv, context, usePrimaryIndex);
    }

    private static IndexData getAvailableIndexIfAny(CompiledValue cv, ExecutionContext context, boolean usePrimaryIndex) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        HashSet set = new HashSet();
        context.computeUtlimateDependencies(cv, set);
        if (set.size() != 1) {
            return null;
        }
        RuntimeIterator rIter = (RuntimeIterator)set.iterator().next();
        String regionPath = null;
        if (rIter.getScopeID() != context.currentScope().getScopeID() || (regionPath = context.getRegionPathForIndependentRuntimeIterator(rIter)) == null) {
            return null;
        }
        List groupRuntimeItrs = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(rIter);
        String[] definitions = new String[groupRuntimeItrs.size()];
        Iterator iterator = groupRuntimeItrs.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            RuntimeIterator rIterator = (RuntimeIterator)iterator.next();
            definitions[i++] = rIterator.getDefinition();
        }
        IndexData indexData = IndexUtils.findIndex(regionPath, definitions, cv, "*", context.getCache(), usePrimaryIndex, context);
        if (indexData != null && logger.isDebugEnabled()) {
            logger.debug("Indexed expression for indexed data : {}  for region : {}", new Object[]{indexData.getIndex().getCanonicalizedIndexedExpression(), regionPath});
        }
        return indexData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SelectResults getconditionedIndexResults(SelectResults indexResults, IndexInfo indexInfo, ExecutionContext context, int indexFieldsSize, boolean completeExpansion, CompiledValue iterOperands, RuntimeIterator[] grpIndpndntItr) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (!completeExpansion && grpIndpndntItr != null && grpIndpndntItr.length > 1) {
            IndexConditioningHelper ich = new IndexConditioningHelper(indexInfo, context, indexFieldsSize, completeExpansion, iterOperands, null);
            ich.finalList = QueryUtils.getDependentItrChainForIndpndntItrs(grpIndpndntItr, context);
            ArrayList newExpList = new ArrayList();
            int len = grpIndpndntItr.length;
            RuntimeIterator tempItr = null;
            for (int i = 0; i < len; ++i) {
                tempItr = grpIndpndntItr[i];
                if (tempItr == ich.indpndntItr) continue;
                newExpList.addAll(context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(tempItr));
            }
            newExpList.addAll(ich.expansionList);
            ich.expansionList = newExpList;
            QueryObserver observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeCutDownAndExpansionOfSingleIndexResult(indexInfo._index, indexResults);
                indexResults = QueryUtils.cutDownAndExpandIndexResults(indexResults, ich.indexFieldToItrsMapping, ich.expansionList, ich.finalList, context, ich.checkList, iterOperands, indexInfo);
            }
            finally {
                observer.afterCutDownAndExpansionOfSingleIndexResult(indexResults);
            }
        } else {
            IndexConditioningHelper ich = new IndexConditioningHelper(indexInfo, context, indexFieldsSize, completeExpansion, iterOperands, grpIndpndntItr != null ? grpIndpndntItr[0] : null);
            if (ich.shufflingNeeded) {
                QueryObserver observer = QueryObserverHolder.getInstance();
                try {
                    observer.beforeCutDownAndExpansionOfSingleIndexResult(indexInfo._index, indexResults);
                    indexResults = QueryUtils.cutDownAndExpandIndexResults(indexResults, ich.indexFieldToItrsMapping, ich.expansionList, ich.finalList, context, ich.checkList, iterOperands, indexInfo);
                }
                finally {
                    observer.afterCutDownAndExpansionOfSingleIndexResult(indexResults);
                }
            } else if (indexInfo.mapping.length > 1) {
                indexResults.setElementType(ich.structType);
            }
        }
        return indexResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SelectResults getRelationshipIndexResultsMergedWithIntermediateResults(SelectResults intermediateResults, IndexInfo[] indxInfo, ExecutionContext context, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpdntItrs) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompiledComparison reconstructedVal;
        ObjectType resultType1 = indxInfo[0]._index.getResultSetType();
        int indexFieldsSize1 = resultType1 instanceof StructType ? ((StructTypeImpl)resultType1).getFieldNames().length : 1;
        ObjectType resultType2 = indxInfo[1]._index.getResultSetType();
        int indexFieldsSize2 = resultType2 instanceof StructType ? ((StructTypeImpl)resultType2).getFieldNames().length : 1;
        IndexConditioningHelper ich1 = new IndexConditioningHelper(indxInfo[0], context, indexFieldsSize1, false, iterOperands, null);
        IndexConditioningHelper ich2 = new IndexConditioningHelper(indxInfo[1], context, indexFieldsSize2, false, iterOperands, null);
        int noOfIndexesToUse = intermediateResults == null || intermediateResults.isEmpty() ? 2 : 0;
        RuntimeIterator[] resultFieldsItrMapping = null;
        ArrayList allItrs = context.getCurrentIterators();
        IndexConditioningHelper singleUsableICH = null;
        IndexConditioningHelper nonUsableICH = null;
        ArrayList finalList = completeExpansionNeeded ? allItrs : (indpdntItrs == null ? new ArrayList() : null);
        HashSet<RuntimeIterator> expnItrsToIgnore = null;
        if (noOfIndexesToUse == 0) {
            noOfIndexesToUse = 2;
            StructType stype = (StructType)intermediateResults.getCollectionType().getElementType();
            String[] fieldNames = stype.getFieldNames();
            int len = fieldNames.length;
            resultFieldsItrMapping = new RuntimeIterator[len];
            String fieldName = null;
            String lhsID = ich1.indpndntItr.getInternalId();
            String rhsID = ich2.indpndntItr.getInternalId();
            for (int i = 0; i < len; ++i) {
                RuntimeIterator itrPrsntInIntermdtRes;
                fieldName = fieldNames[i];
                if (noOfIndexesToUse != 0) {
                    if (fieldName.equals(lhsID)) {
                        --noOfIndexesToUse;
                        singleUsableICH = ich2;
                        nonUsableICH = ich1;
                    } else if (fieldName.equals(rhsID)) {
                        --noOfIndexesToUse;
                        singleUsableICH = ich1;
                        nonUsableICH = ich2;
                    }
                }
                int pos = Integer.parseInt(fieldName.substring(4));
                resultFieldsItrMapping[i] = itrPrsntInIntermdtRes = (RuntimeIterator)allItrs.get(pos - 1);
                if (completeExpansionNeeded) {
                    if (expnItrsToIgnore == null) {
                        expnItrsToIgnore = new HashSet<RuntimeIterator>();
                    }
                    expnItrsToIgnore.add(itrPrsntInIntermdtRes);
                    continue;
                }
                if (indpdntItrs != null) continue;
                finalList.add(itrPrsntInIntermdtRes);
            }
            if (noOfIndexesToUse == 0) {
                singleUsableICH = null;
            }
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        if (noOfIndexesToUse == 2) {
            List data = null;
            try {
                ArrayList resultData = new ArrayList();
                observer.beforeIndexLookup(indxInfo[0]._index, 13, null);
                observer.beforeIndexLookup(indxInfo[1]._index, 13, null);
                data = context.getBucketList() != null ? QueryUtils.queryEquijoinConditionBucketIndexes(indxInfo, context) : indxInfo[0]._index.queryEquijoinCondition(indxInfo[1]._index, context);
                observer.afterIndexLookup(data);
            }
            catch (Throwable throwable) {
                observer.afterIndexLookup(data);
                throw throwable;
            }
            ArrayList<RuntimeIterator> totalExpList = new ArrayList<RuntimeIterator>();
            totalExpList.addAll(ich1.expansionList);
            totalExpList.addAll(ich2.expansionList);
            if (completeExpansionNeeded) {
                if (expnItrsToIgnore == null) {
                    Support.Assert(intermediateResults == null || intermediateResults.isEmpty(), "expnItrsToIgnore should not have been null if the intermediate result set is not empty");
                    expnItrsToIgnore = new HashSet();
                }
                expnItrsToIgnore.addAll(ich1.finalList);
                expnItrsToIgnore.addAll(ich2.finalList);
                int size = finalList.size();
                for (int i = 0; i < size; ++i) {
                    RuntimeIterator currItr = (RuntimeIterator)finalList.get(i);
                    if (expnItrsToIgnore.contains(currItr)) continue;
                    totalExpList.add(currItr);
                }
            } else if (indpdntItrs != null) {
                finalList = QueryUtils.getDependentItrChainForIndpndntItrs(indpdntItrs, context);
            } else {
                finalList.addAll(ich1.finalList);
                finalList.addAll(ich2.finalList);
            }
            List[] checkList = new List[]{ich1.checkList, ich2.checkList};
            StructType stype = QueryUtils.createStructTypeForRuntimeIterators(finalList);
            SelectResults returnSet = QueryUtils.createStructCollection(context, stype);
            RuntimeIterator[][] mappings = new RuntimeIterator[][]{ich1.indexFieldToItrsMapping, ich2.indexFieldToItrsMapping};
            List[] totalCheckList = new List[]{ich1.checkList, ich2.checkList};
            RuntimeIterator[][] resultMappings = new RuntimeIterator[][]{resultFieldsItrMapping};
            Iterator dataItr = data.iterator();
            IndexCutDownExpansionHelper[] icdeh = new IndexCutDownExpansionHelper[]{new IndexCutDownExpansionHelper(ich1.checkList, context), new IndexCutDownExpansionHelper(ich2.checkList, context)};
            ListIterator expansionListIterator = totalExpList.listIterator();
            if (dataItr.hasNext()) {
                observer = QueryObserverHolder.getInstance();
                try {
                    observer.beforeMergeJoinOfDoubleIndexResults(indxInfo[0]._index, indxInfo[1]._index, data);
                    boolean doMergeWithIntermediateResults = intermediateResults != null && !intermediateResults.isEmpty();
                    int maxCartesianDepth = totalExpList.size() + (doMergeWithIntermediateResults ? 1 : 0);
                    while (dataItr.hasNext()) {
                        Object[][] values = (Object[][])dataItr.next();
                        if (doMergeWithIntermediateResults) {
                            QueryUtils.mergeRelationshipIndexResultsWithIntermediateResults(returnSet, new SelectResults[]{intermediateResults}, resultMappings, values, mappings, expansionListIterator, finalList, context, checkList, iterOperands, icdeh, 0, maxCartesianDepth);
                        } else {
                            QueryUtils.mergeAndExpandCutDownRelationshipIndexResults(values, returnSet, mappings, expansionListIterator, finalList, context, totalCheckList, iterOperands, icdeh, 0);
                        }
                        if (!icdeh[0].cutDownNeeded) continue;
                        icdeh[0].checkSet.clear();
                    }
                }
                finally {
                    observer.afterMergeJoinOfDoubleIndexResults(returnSet);
                }
            }
            return returnSet;
        }
        if (noOfIndexesToUse == 1) {
            ArrayList<RuntimeIterator> totalExpList = new ArrayList<RuntimeIterator>();
            totalExpList.addAll(singleUsableICH.expansionList);
            if (completeExpansionNeeded) {
                Support.Assert(expnItrsToIgnore != null, "expnItrsToIgnore should not have been null as we are in this block itself indicates that intermediate results was not null");
                expnItrsToIgnore.addAll(singleUsableICH.finalList);
                int size = finalList.size();
                for (int i = 0; i < size; ++i) {
                    RuntimeIterator currItr = (RuntimeIterator)finalList.get(i);
                    if (expnItrsToIgnore.contains(currItr)) continue;
                    totalExpList.add(currItr);
                }
            } else if (indpdntItrs != null) {
                finalList = QueryUtils.getDependentItrChainForIndpndntItrs(indpdntItrs, context);
            } else {
                finalList.addAll(singleUsableICH.finalList);
            }
            StructType stype = QueryUtils.createStructTypeForRuntimeIterators(finalList);
            SelectResults returnSet = QueryUtils.createStructCollection(context, stype);
            IndexProtocol singleUsblIndex = singleUsableICH.indxInfo._index;
            CompiledValue nonUsblIndxPath = nonUsableICH.indxInfo._path;
            ObjectType singlUsblIndxResType = singleUsblIndex.getResultSetType();
            SelectResults singlUsblIndxRes = null;
            singlUsblIndxRes = singlUsblIndxResType instanceof StructType ? QueryUtils.createStructCollection(context, (StructTypeImpl)singlUsblIndxResType) : QueryUtils.createResultCollection(context, singlUsblIndxResType);
            Iterator intrmdtRsItr = intermediateResults.iterator();
            observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeIndexLookup(singleUsblIndex, 13, null);
                observer.beforeIterJoinOfSingleIndexResults(singleUsblIndex, nonUsableICH.indxInfo._index);
                while (intrmdtRsItr.hasNext()) {
                    Struct strc = (Struct)intrmdtRsItr.next();
                    Object[] val = strc.getFieldValues();
                    int len = val.length;
                    for (int i = 0; i < len; ++i) {
                        resultFieldsItrMapping[i].setCurrent(val[i]);
                    }
                    Object key = nonUsblIndxPath.evaluate(context);
                    if (key != null && key.equals(QueryService.UNDEFINED)) continue;
                    singleUsblIndex.query(key, 13, singlUsblIndxRes, context);
                    QueryUtils.cutDownAndExpandIndexResults(returnSet, singlUsblIndxRes, singleUsableICH.indexFieldToItrsMapping, totalExpList, finalList, context, singleUsableICH.checkList, iterOperands, singleUsableICH.indxInfo);
                    singlUsblIndxRes.clear();
                }
            }
            finally {
                observer.afterIterJoinOfSingleIndexResults(returnSet);
                observer.afterIndexLookup(returnSet);
            }
            return returnSet;
        }
        if (logger.isDebugEnabled()) {
            StringBuffer tempBuffLhs = new StringBuffer();
            StringBuffer tempBuffRhs = new StringBuffer();
            ich1.indxInfo._path.generateCanonicalizedExpression(tempBuffLhs, context);
            ich2.indxInfo._path.generateCanonicalizedExpression(tempBuffRhs, context);
            logger.debug("For better performance indexes are not used for the condition {} = {}", new Object[]{tempBuffLhs, tempBuffRhs});
        }
        AbstractCompiledValue finalVal = reconstructedVal = new CompiledComparison(ich1.indxInfo._path, ich2.indxInfo._path, 13);
        if (iterOperands != null) {
            finalVal = new CompiledJunction(new CompiledValue[]{iterOperands, reconstructedVal}, 90);
        }
        RuntimeIterator[][] resultMappings = new RuntimeIterator[][]{resultFieldsItrMapping};
        return QueryUtils.cartesian(new SelectResults[]{intermediateResults}, resultMappings, Collections.EMPTY_LIST, finalList, context, finalVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SelectResults getconditionedRelationshipIndexResultsExpandedToTopOrCGJLevel(List data, IndexInfo[] indxInfo, ExecutionContext context, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpdntItrs) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ObjectType resultType1 = indxInfo[0]._index.getResultSetType();
        int indexFieldsSize1 = resultType1 instanceof StructType ? ((StructTypeImpl)resultType1).getFieldNames().length : 1;
        ObjectType resultType2 = indxInfo[1]._index.getResultSetType();
        int indexFieldsSize2 = resultType2 instanceof StructType ? ((StructTypeImpl)resultType2).getFieldNames().length : 1;
        IndexConditioningHelper ich1 = new IndexConditioningHelper(indxInfo[0], context, indexFieldsSize1, false, iterOperands, null);
        IndexConditioningHelper ich2 = new IndexConditioningHelper(indxInfo[1], context, indexFieldsSize2, false, iterOperands, null);
        ArrayList<RuntimeIterator> totalExpList = new ArrayList<RuntimeIterator>();
        totalExpList.addAll(ich1.expansionList);
        totalExpList.addAll(ich2.expansionList);
        ArrayList totalFinalList = null;
        if (completeExpansionNeeded) {
            totalFinalList = context.getCurrentIterators();
            HashSet expnItrsAlreadyAccounted = new HashSet();
            expnItrsAlreadyAccounted.addAll(ich1.finalList);
            expnItrsAlreadyAccounted.addAll(ich2.finalList);
            int size = totalFinalList.size();
            for (int i = 0; i < size; ++i) {
                RuntimeIterator currItr = (RuntimeIterator)totalFinalList.get(i);
                if (expnItrsAlreadyAccounted.contains(currItr)) continue;
                totalExpList.add(currItr);
            }
        } else {
            totalFinalList = new ArrayList();
            for (int i = 0; i < indpdntItrs.length; ++i) {
                RuntimeIterator indpndntItr = indpdntItrs[i];
                if (indpndntItr == ich1.finalList.get(0)) {
                    totalFinalList.addAll(ich1.finalList);
                    continue;
                }
                if (indpndntItr == ich2.finalList.get(0)) {
                    totalFinalList.addAll(ich2.finalList);
                    continue;
                }
                List temp = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(indpndntItr);
                totalFinalList.addAll(temp);
                totalExpList.addAll(temp);
            }
        }
        Support.Assert(totalFinalList.size() > 1, " Since we are in relationship index this itself means that we have atleast two RuntimeIterators");
        StructType stype = QueryUtils.createStructTypeForRuntimeIterators(totalFinalList);
        SelectResults returnSet = QueryUtils.createStructCollection(context, stype);
        RuntimeIterator[][] mappings = new RuntimeIterator[][]{ich1.indexFieldToItrsMapping, ich2.indexFieldToItrsMapping};
        List[] totalCheckList = new List[]{ich1.checkList, ich2.checkList};
        Iterator dataItr = data.iterator();
        IndexCutDownExpansionHelper[] icdeh = new IndexCutDownExpansionHelper[]{new IndexCutDownExpansionHelper(ich1.checkList, context), new IndexCutDownExpansionHelper(ich2.checkList, context)};
        ListIterator expansionListIterator = totalExpList.listIterator();
        if (dataItr.hasNext()) {
            QueryObserver observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeMergeJoinOfDoubleIndexResults(ich1.indxInfo._index, ich2.indxInfo._index, data);
                while (dataItr.hasNext()) {
                    Object[][] values = (Object[][])dataItr.next();
                    QueryUtils.mergeAndExpandCutDownRelationshipIndexResults(values, returnSet, mappings, expansionListIterator, totalFinalList, context, totalCheckList, iterOperands, icdeh, 0);
                    if (!icdeh[0].cutDownNeeded) continue;
                    icdeh[0].checkSet.clear();
                }
            }
            finally {
                observer.afterMergeJoinOfDoubleIndexResults(returnSet);
            }
        }
        return returnSet;
    }

    static SelectResults testCutDownAndExpandIndexResults(List dataList) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return QueryUtils.cutDownAndExpandIndexResults((SelectResults)dataList.get(0), (RuntimeIterator[])dataList.get(1), (List)dataList.get(2), (List)dataList.get(3), (ExecutionContext)dataList.get(4), (List)dataList.get(5), null, null);
    }

    static List queryEquijoinConditionBucketIndexes(IndexInfo[] indxInfo, ExecutionContext context) throws QueryInvocationTargetException, TypeMismatchException, FunctionDomainException, NameResolutionException {
        List data = null;
        ArrayList resultData = new ArrayList();
        AbstractIndex index0 = (AbstractIndex)indxInfo[0]._index;
        AbstractIndex index1 = (AbstractIndex)indxInfo[1]._index;
        PartitionedRegion pr0 = null;
        PartitionedRegion pr1 = null;
        IndexProtocol i0 = null;
        IndexProtocol i1 = null;
        if (index0.getRegion() instanceof BucketRegion) {
            pr0 = ((BucketRegion)index0.getRegion()).getPartitionedRegion();
        }
        if (index1.getRegion() instanceof BucketRegion) {
            pr1 = ((BucketRegion)index1.getRegion()).getPartitionedRegion();
        }
        for (Object b : context.getBucketList()) {
            i0 = pr0 != null ? PartitionedIndex.getBucketIndex(pr0, index0.getName(), (Integer)b) : indxInfo[0]._index;
            IndexProtocol indexProtocol = i1 = pr1 != null ? PartitionedIndex.getBucketIndex(pr1, index1.getName(), (Integer)b) : indxInfo[1]._index;
            if (i0 == null || i1 == null) continue;
            data = i0.queryEquijoinCondition(i1, context);
            resultData.addAll(data);
        }
        data = resultData;
        return data;
    }
}

