/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.Ordered;
import com.gemstone.gemfire.cache.query.internal.SortedStructSet;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class LinkedStructSet
extends LinkedHashSet<Struct>
implements SelectResults<Struct>,
Ordered,
DataSerializableFixedID {
    private static final long serialVersionUID = -1687142950781718156L;
    protected StructTypeImpl structType;
    private boolean modifiable = true;

    public LinkedStructSet() {
    }

    public LinkedStructSet(StructTypeImpl structType) {
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SortedStructSet)) {
            return false;
        }
        if (!this.structType.equals(((SortedStructSet)other).structType)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public boolean add(Struct obj) {
        if (!(obj instanceof StructImpl)) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_THIS_SET_ONLY_ACCEPTS_STRUCTIMPL.toLocalizedString());
        }
        StructImpl s = (StructImpl)obj;
        if (!s.getStructType().equals(this.structType)) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_OBJ_DOES_NOT_HAVE_THE_SAME_STRUCTTYPE.toLocalizedString());
        }
        return super.add(s);
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)obj;
        if (!this.structType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.contains(s);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)o;
        if (!this.structType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.remove(s);
    }

    @Override
    public boolean addAll(Collection c) {
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return super.retainAll(c);
    }

    @Override
    public Iterator iterator() {
        return new StructIterator(this.fieldValuesIterator());
    }

    public Iterator fieldValuesIterator() {
        return super.iterator();
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Ordered.class, (ObjectType)this.structType);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (!(elementType instanceof StructTypeImpl)) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_ELEMENT_TYPE_MUST_BE_STRUCT.toLocalizedString());
        }
        this.structType = (StructTypeImpl)elementType;
    }

    @Override
    public List asList() {
        return new ArrayList<Struct>(this);
    }

    @Override
    public Set asSet() {
        return this;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public int occurrences(Struct element) {
        return this.contains(element) ? 1 : 0;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            buf.append(o == this ? "(this Collection)" : String.valueOf(o));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(",\n ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.modifiable = in.readBoolean();
        int size = in.readInt();
        this.structType = (StructTypeImpl)DataSerializer.readObject(in);
        for (int j = size; j > 0; --j) {
            Object[] fieldValues = (Object[])DataSerializer.readObject(in);
            this.add(new StructImpl(this.structType, fieldValues));
        }
    }

    @Override
    public int getDSFID() {
        return 2123;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.modifiable);
        out.writeInt(this.size());
        DataSerializer.writeObject(this.structType, out);
        for (Struct struct : this) {
            DataSerializer.writeObject(struct.getFieldValues(), out);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public Comparator comparator() {
        return null;
    }

    @Override
    public boolean dataPreordered() {
        return true;
    }

    private static class StructIterator
    implements Iterator {
        private final Iterator itr;

        StructIterator(Iterator itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            return this.itr.next();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

