/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompiledID;
import com.gemstone.gemfire.cache.query.internal.CompiledIndexOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledPath;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.PathUtils;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CompiledSortCriterion
extends AbstractCompiledValue {
    private boolean criterion = false;
    private CompiledValue expr = null;
    int columnIndex = -1;
    private CompiledValue originalCorrectedExpression = null;

    @Override
    public List getChildren() {
        return Collections.singletonList(this.originalCorrectedExpression);
    }

    @Override
    public int getType() {
        return 57;
    }

    public Object evaluate(Object data, ExecutionContext context) {
        Object value = null;
        if (this.columnIndex > 0) {
            value = ((Object[])data)[this.columnIndex];
        } else if (this.columnIndex == 0) {
            value = data instanceof Object[] ? ((Object[])data)[this.columnIndex] : data;
        } else {
            throw new IllegalStateException(" Order By Column attribute unmapped");
        }
        context.setCurrentProjectionField(value);
        try {
            return this.expr.evaluate(context);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e){};
        }
    }

    CompiledSortCriterion(boolean criterion, CompiledValue cv) {
        this.expr = cv;
        this.criterion = criterion;
        this.originalCorrectedExpression = this.expr;
    }

    public boolean getCriterion() {
        return this.criterion;
    }

    public CompiledValue getExpr() {
        return this.originalCorrectedExpression;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.expr.evaluate(context);
    }

    private void substituteExpression(CompiledValue newExpression, int columnIndex) {
        this.expr = newExpression;
        this.columnIndex = columnIndex;
    }

    private void substituteExpressionWithProjectionField(int columnIndex) {
        this.expr = ProjectionField.getProjectionField();
        this.columnIndex = columnIndex;
    }

    private CompiledValue getReconstructedExpression(String projAttribStr, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        List<CompiledValue> expressions = PathUtils.collectCompiledValuesInThePath(this.expr, context);
        StringBuffer tempBuff = new StringBuffer();
        ListIterator<CompiledValue> listIter = expressions.listIterator(expressions.size());
        while (listIter.hasPrevious()) {
            listIter.previous().generateCanonicalizedExpression(tempBuff, context);
            if (tempBuff.toString().equals(projAttribStr)) break;
            tempBuff.delete(0, tempBuff.length());
        }
        CompiledValue cvToRetainTill = listIter.previous();
        CompiledValue prevCV = null;
        ArrayList<Object> reconstruct = new ArrayList<Object>();
        CompiledValue cv = expressions.get(0);
        int index = 0;
        do {
            prevCV = cv;
            switch (cv.getType()) {
                case 53: {
                    reconstruct.add(0, ((CompiledOperation)cv).getArguments());
                    reconstruct.add(0, ((CompiledOperation)cv).getMethodName());
                    break;
                }
                case -5: {
                    reconstruct.add(0, ((CompiledPath)cv).getTailID());
                    break;
                }
                case 24: {
                    reconstruct.add(0, ((CompiledIndexOperation)cv).getExpression());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected CompiledValue in order by clause");
                }
            }
            reconstruct.add(0, prevCV.getType());
            cv = expressions.get(++index);
        } while (prevCV != cvToRetainTill);
        Iterator iter = reconstruct.iterator();
        AbstractCompiledValue currentValue = ProjectionField.getProjectionField();
        while (iter.hasNext()) {
            int type = (Integer)iter.next();
            switch (type) {
                case -5: {
                    currentValue = new CompiledPath(currentValue, (String)iter.next());
                    break;
                }
                case 53: {
                    currentValue = new CompiledOperation(currentValue, (String)iter.next(), (List)iter.next());
                    break;
                }
                case 24: {
                    currentValue = new CompiledIndexOperation(currentValue, (CompiledValue)iter.next());
                }
            }
        }
        return currentValue;
    }

    boolean mapExpressionToProjectionField(List projAttrs, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        boolean mappedColumn;
        block8: {
            block9: {
                mappedColumn = false;
                this.originalCorrectedExpression = this.expr;
                if (projAttrs == null) break block9;
                if (this.expr.getType() == 34) {
                    for (int i = 0; i < projAttrs.size() && !mappedColumn; ++i) {
                        Object[] prj = (Object[])TypeUtils.checkCast(projAttrs.get(i), Object[].class);
                        if (prj[0] == null || !prj[0].equals(((CompiledID)this.expr).getId())) continue;
                        this.substituteExpressionWithProjectionField(i);
                        this.originalCorrectedExpression = (CompiledValue)prj[1];
                        mappedColumn = true;
                    }
                }
                if (mappedColumn) break block8;
                StringBuffer orderByExprBuffer = new StringBuffer();
                StringBuffer projAttribBuffer = new StringBuffer();
                this.expr.generateCanonicalizedExpression(orderByExprBuffer, context);
                String orderByExprStr = orderByExprBuffer.toString();
                for (int i = 0; i < projAttrs.size(); ++i) {
                    Object[] prj = (Object[])TypeUtils.checkCast(projAttrs.get(i), Object[].class);
                    CompiledValue cvProj = (CompiledValue)TypeUtils.checkCast(prj[1], CompiledValue.class);
                    cvProj.generateCanonicalizedExpression(projAttribBuffer, context);
                    String projAttribStr = projAttribBuffer.toString();
                    if (projAttribStr.equals(orderByExprStr)) {
                        this.substituteExpressionWithProjectionField(i);
                        mappedColumn = true;
                        break block8;
                    }
                    if (orderByExprStr.startsWith(projAttribStr)) {
                        CompiledValue newExpr = this.getReconstructedExpression(projAttribStr, context);
                        this.substituteExpression(newExpr, i);
                        mappedColumn = true;
                        break block8;
                    }
                    projAttribBuffer.delete(0, projAttribBuffer.length());
                }
                break block8;
            }
            RuntimeIterator rIter = context.findRuntimeIterator(this.expr);
            List currentIters = context.getCurrentIterators();
            for (int i = 0; i < currentIters.size(); ++i) {
                RuntimeIterator runtimeIter = (RuntimeIterator)currentIters.get(i);
                if (runtimeIter != rIter) continue;
                StringBuffer temp = new StringBuffer();
                rIter.generateCanonicalizedExpression(temp, context);
                String projAttribStr = temp.toString();
                temp = new StringBuffer();
                this.expr.generateCanonicalizedExpression(temp, context);
                String orderbyStr = temp.toString();
                if (projAttribStr.equals(orderbyStr)) {
                    this.substituteExpressionWithProjectionField(i);
                    mappedColumn = true;
                } else {
                    CompiledValue newExpr = this.getReconstructedExpression(projAttribStr, context);
                    this.substituteExpression(newExpr, i);
                    mappedColumn = true;
                }
                break;
            }
        }
        return mappedColumn;
    }

    static class ProjectionField
    extends AbstractCompiledValue {
        private static ProjectionField singleton = new ProjectionField();

        private ProjectionField() {
        }

        @Override
        public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            return context.getCurrentProjectionField();
        }

        @Override
        public int getType() {
            return -16;
        }

        public static ProjectionField getProjectionField() {
            return singleton;
        }
    }
}

