/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CompiledNegation
extends AbstractCompiledValue {
    private CompiledValue _value;

    public CompiledNegation(CompiledValue value) {
        this._value = value;
    }

    @Override
    public List getChildren() {
        return Collections.singletonList(this._value);
    }

    @Override
    public int getType() {
        return 102;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.negateObject(this._value.evaluate(context));
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        return context.addDependencies(this, this._value.computeDependencies(context));
    }

    private Object negateObject(Object obj) throws TypeMismatchException {
        if (obj instanceof Boolean) {
            return (Boolean)obj == false;
        }
        if (obj == null || obj == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        throw new TypeMismatchException(LocalizedStrings.CompiledNegation_0_CANNOT_BE_NEGATED.toLocalizedString(obj.getClass()));
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ')');
        this._value.generateCanonicalizedExpression(clauseBuffer, context);
        clauseBuffer.insert(0, "NOT(");
    }
}

