/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.Aggregator;
import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.Bag;
import com.gemstone.gemfire.cache.query.internal.CompiledAggregateFunction;
import com.gemstone.gemfire.cache.query.internal.CompiledID;
import com.gemstone.gemfire.cache.query.internal.CompiledLiteral;
import com.gemstone.gemfire.cache.query.internal.CompiledSelect;
import com.gemstone.gemfire.cache.query.internal.CompiledSortCriterion;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.OrderByComparator;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.SortedResultsBag;
import com.gemstone.gemfire.cache.query.internal.SortedStructBag;
import com.gemstone.gemfire.cache.query.internal.StructFields;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.cache.query.internal.utils.PDXUtils;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompiledGroupBySelect
extends CompiledSelect {
    private final BitSet aggregateColsPos;
    private final CompiledAggregateFunction[] aggregateFunctions;
    private final boolean isDistinct;
    private final List<CompiledSortCriterion> originalOrderByClause;
    private final CompiledValue limit;

    @Override
    public int getType() {
        return -17;
    }

    public CompiledGroupBySelect(boolean distinct, boolean count, CompiledValue whereClause, List iterators, List projAttrs, List<CompiledSortCriterion> orderByAttrs, CompiledValue limit, List<String> hints, List<CompiledValue> groupByClause, LinkedHashMap<Integer, CompiledAggregateFunction> aggMap) {
        super(false, false, whereClause, iterators, projAttrs, null, null, hints, groupByClause);
        this.aggregateFunctions = new CompiledAggregateFunction[aggMap != null ? aggMap.size() : 0];
        this.aggregateColsPos = new BitSet(this.projAttrs.size());
        if (aggMap != null) {
            int i = 0;
            for (Map.Entry<Integer, CompiledAggregateFunction> entry : aggMap.entrySet()) {
                this.aggregateColsPos.set(entry.getKey());
                this.aggregateFunctions[i++] = entry.getValue();
            }
        }
        this.originalOrderByClause = orderByAttrs;
        this.isDistinct = distinct;
        this.limit = limit;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        if (!this.transformationDone) {
            this.replaceAggregateFunctionInProjection();
        }
        return super.computeDependencies(context);
    }

    private void replaceAggregateFunctionInProjection() {
        int bitStart = 0;
        for (CompiledAggregateFunction aggFunc : this.aggregateFunctions) {
            int index = this.aggregateColsPos.nextSetBit(bitStart);
            bitStart = index + 1;
            CompiledValue param = aggFunc.getParameter();
            if (param == null && aggFunc.getFunctionType() == 63) {
                param = new CompiledLiteral(0);
            } else if (param == null) {
                throw new QueryInvalidException("aggregate function passed invalid parameter");
            }
            Object[] projAtt = (Object[])this.projAttrs.get(index);
            projAtt[1] = param;
        }
    }

    private void revertAggregateFunctionInProjection() {
        int bitStart = 0;
        for (CompiledAggregateFunction aggFunc : this.aggregateFunctions) {
            int index = this.aggregateColsPos.nextSetBit(bitStart);
            bitStart = index + 1;
            Object[] projAtt = (Object[])this.projAttrs.get(index);
            projAtt[1] = aggFunc;
        }
    }

    @Override
    protected void doTreeTransformation(ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        if (!this.transformationDone) {
            this.checkAllProjectedFieldsInGroupBy(context);
            this.cachedElementTypeForOrderBy = this.prepareResultType(context);
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                this.modifyGroupByToOrderBy(false, context);
            }
            if (this.originalOrderByClause != null) {
                this.mapOriginalOrderByColumns(context);
            }
        }
        this.transformationDone = true;
    }

    private void mapOriginalOrderByColumns(ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        this.revertAggregateFunctionInProjection();
        for (CompiledSortCriterion csc : this.originalOrderByClause) {
            if (csc.mapExpressionToProjectionField(this.projAttrs, context)) continue;
            throw new QueryInvalidException(LocalizedStrings.DefaultQuery_ORDER_BY_ATTRIBS_NOT_PRESENT_IN_PROJ.toLocalizedString());
        }
        this.replaceAggregateFunctionInProjection();
    }

    @Override
    public SelectResults evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults sr = super.evaluate(context);
        return this.applyAggregateAndGroupBy(sr, context);
    }

    public SelectResults applyAggregateAndGroupBy(SelectResults baseResults, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ObjectType elementType = baseResults.getCollectionType().getElementType();
        boolean isStruct = elementType != null && elementType.isStructType();
        boolean isBucketNodes = context.getBucketList() != null;
        boolean createOrderedResultSet = isBucketNodes && this.orderByAttrs != null;
        boolean[] objectChangedMarker = new boolean[]{false};
        int limitValue = CompiledGroupBySelect.evaluateLimitValue(context, this.limit);
        SelectResults newResults = this.createResultSet(context, elementType, isStruct, createOrderedResultSet);
        Aggregator[] aggregators = new Aggregator[this.aggregateFunctions.length];
        this.refreshAggregators(aggregators, context);
        if (this.orderByAttrs != null) {
            this.applyGroupBy(baseResults, context, isStruct, newResults, aggregators, !createOrderedResultSet, objectChangedMarker, limitValue);
        } else {
            Iterator iter = baseResults.iterator();
            Object current = null;
            boolean unterminated = iter.hasNext();
            while (iter.hasNext()) {
                current = iter.next();
                this.accumulate(isStruct, aggregators, current, objectChangedMarker);
            }
            if (unterminated) {
                this.terminateAndAddToResults(isStruct, newResults, aggregators, current, context, !createOrderedResultSet, limitValue);
            }
        }
        return newResults;
    }

    private SelectResults createResultSet(ExecutionContext context, ObjectType elementType, boolean isStruct, boolean createOrderedResults) {
        SortedStructBag newResults;
        elementType = this.createNewElementType(elementType, isStruct);
        boolean isPrQueryNode = context.getIsPRQueryNode();
        if (isStruct) {
            if (createOrderedResults) {
                newResults = new SortedResultsBag((ObjectType)((StructTypeImpl)elementType), true);
            } else if (this.originalOrderByClause != null) {
                OrderByComparator comparator = new OrderByComparator(this.originalOrderByClause, elementType, context);
                newResults = new SortedStructBag((Comparator<Object[]>)comparator, (StructType)elementType, !this.originalOrderByClause.get(0).getCriterion());
            } else {
                newResults = QueryUtils.createStructCollection(this.isDistinct, (StructType)elementType, context);
            }
        } else if (createOrderedResults) {
            newResults = new SortedResultsBag(elementType, true);
        } else if (this.originalOrderByClause != null) {
            OrderByComparator comparator = new OrderByComparator(this.originalOrderByClause, elementType, context);
            newResults = new SortedResultsBag(comparator, elementType, !this.originalOrderByClause.get(0).getCriterion());
        } else {
            newResults = QueryUtils.createResultCollection(this.isDistinct, elementType, context);
        }
        return newResults;
    }

    private ObjectType createNewElementType(ObjectType elementType, boolean isStruct) {
        if (isStruct) {
            StructType oldType = (StructType)elementType;
            if (this.aggregateFunctions.length > 0) {
                ObjectType[] oldFieldTypes = oldType.getFieldTypes();
                ObjectType[] newFieldTypes = new ObjectType[oldFieldTypes.length];
                int i = 0;
                int aggFuncIndex = 0;
                for (ObjectType oldFieldType : oldFieldTypes) {
                    newFieldTypes[i] = this.aggregateColsPos.get(i) ? this.aggregateFunctions[aggFuncIndex++].getObjectType() : oldFieldType;
                    ++i;
                }
                return new StructTypeImpl(oldType.getFieldNames(), newFieldTypes);
            }
            return oldType;
        }
        return this.aggregateFunctions.length > 0 ? this.aggregateFunctions[0].getObjectType() : elementType;
    }

    private void applyGroupBy(SelectResults baseResults, ExecutionContext context, boolean isStruct, SelectResults newResults, Aggregator[] aggregators, boolean isStructFields, boolean[] objectChangedMarker, int limitValue) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean isSingleOrderBy;
        Iterator iter = baseResults.iterator();
        Object[] orderByTupleHolderCurrent = null;
        Object[] orderByTupleHolderPrev = null;
        Object orderByCurrent = null;
        Object orderByPrev = null;
        boolean bl = isSingleOrderBy = this.orderByAttrs.size() <= 1;
        if (!isSingleOrderBy) {
            orderByTupleHolderPrev = new Object[this.orderByAttrs.size()];
            orderByTupleHolderCurrent = new Object[this.orderByAttrs.size()];
        }
        boolean isFirst = true;
        Object prev = null;
        boolean unterminated = false;
        boolean keepAdding = true;
        while (iter.hasNext() && keepAdding) {
            Object current = iter.next();
            if (isSingleOrderBy) {
                orderByCurrent = this.getOrderByEvaluatedTuple(context, isSingleOrderBy, null, isStruct ? ((Struct)current).getFieldValues() : current, objectChangedMarker);
            } else {
                orderByTupleHolderCurrent = (Object[])this.getOrderByEvaluatedTuple(context, isSingleOrderBy, orderByTupleHolderCurrent, isStruct ? ((Struct)current).getFieldValues() : current, objectChangedMarker);
            }
            if (isFirst || this.areOrderByTupleEqual(isSingleOrderBy, orderByPrev, orderByCurrent, orderByTupleHolderPrev, orderByTupleHolderCurrent)) {
                this.accumulate(isStruct, aggregators, current, objectChangedMarker);
                unterminated = true;
                isFirst = false;
            } else {
                keepAdding = this.terminateAndAddToResults(isStruct, newResults, aggregators, prev, context, isStructFields, limitValue);
                this.accumulate(isStruct, aggregators, current, objectChangedMarker);
                unterminated = true;
            }
            Object[] temp = orderByTupleHolderCurrent;
            orderByTupleHolderCurrent = orderByTupleHolderPrev;
            orderByTupleHolderPrev = temp;
            orderByPrev = orderByCurrent;
            prev = current;
        }
        if (unterminated && keepAdding) {
            this.terminateAndAddToResults(isStruct, newResults, aggregators, prev, context, isStructFields, limitValue);
        }
        if (this.originalOrderByClause != null && limitValue > 0 && (context.getIsPRQueryNode() || context.getBucketList() == null)) {
            ((Bag)newResults).applyLimit(limitValue);
        }
    }

    private boolean terminateAndAddToResults(boolean isStruct, SelectResults newResults, Aggregator[] aggregators, Object prev, ExecutionContext context, boolean isStrucFields, int limitValue) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object[] newRowArray = isStruct ? this.copyStruct((Struct)prev) : null;
        Object newObject = null;
        int bitstart = 0;
        if (limitValue == 0) {
            return false;
        }
        for (Aggregator aggregator : aggregators) {
            if (isStruct) {
                Object scalarResult;
                int pos = this.aggregateColsPos.nextSetBit(bitstart);
                bitstart = pos + 1;
                newRowArray[pos] = scalarResult = aggregator.terminate();
                continue;
            }
            newObject = aggregator.terminate();
        }
        if (isStruct) {
            if (isStrucFields) {
                ((StructFields)((Object)newResults)).addFieldValues(newRowArray);
            } else {
                newResults.add(new StructImpl((StructTypeImpl)((Struct)prev).getStructType(), newRowArray));
            }
        } else {
            newResults.add(newObject);
        }
        boolean keepAdding = true;
        if (this.originalOrderByClause == null && limitValue > 0 && (context.getIsPRQueryNode() || context.getBucketList() == null) && newResults.size() == limitValue) {
            keepAdding = false;
        }
        this.refreshAggregators(aggregators, context);
        return keepAdding;
    }

    private void refreshAggregators(Aggregator[] aggregators, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        int i = 0;
        for (CompiledAggregateFunction aggFunc : this.aggregateFunctions) {
            Aggregator agg = (Aggregator)aggFunc.evaluate(context);
            aggregators[i++] = agg;
        }
    }

    private Object[] copyStruct(Struct struct) {
        Object[] prevValues = struct.getFieldValues();
        Object[] newRow = new Object[prevValues.length];
        System.arraycopy(prevValues, 0, newRow, 0, prevValues.length);
        return newRow;
    }

    private void accumulate(boolean isStruct, Aggregator[] aggregators, Object current, boolean[] objectChangedMarker) {
        int bitstart = 0;
        for (Aggregator aggregator : aggregators) {
            if (isStruct) {
                int pos = this.aggregateColsPos.nextSetBit(bitstart);
                bitstart = pos + 1;
                Struct struct = (Struct)current;
                Object scalar = PDXUtils.convertPDX(struct.getFieldValues()[pos], false, true, true, true, objectChangedMarker, isStruct);
                aggregator.accumulate(scalar);
                continue;
            }
            current = PDXUtils.convertPDX(current, false, true, true, true, objectChangedMarker, isStruct);
            aggregator.accumulate(current);
        }
    }

    private boolean areOrderByTupleEqual(boolean isSingleOrderBy, Object prev, Object current, Object[] prevHolder, Object[] currentHolder) {
        if (isSingleOrderBy) {
            if (prev == null && current == null) {
                return true;
            }
            if (prev != null) {
                return prev.equals(current);
            }
            return current.equals(prev);
        }
        return Arrays.equals(prevHolder, currentHolder);
    }

    private Object getOrderByEvaluatedTuple(ExecutionContext context, boolean isOrderByTupleSingle, Object[] holder, Object data, boolean[] objectChangedMarker) {
        if (isOrderByTupleSingle) {
            return PDXUtils.convertPDX(((CompiledSortCriterion)this.orderByAttrs.get(0)).evaluate(data, context), false, true, true, true, objectChangedMarker, false);
        }
        int i = 0;
        for (CompiledSortCriterion csc : this.orderByAttrs) {
            holder[i++] = PDXUtils.convertPDX(csc.evaluate(data, context), false, true, true, true, objectChangedMarker, false);
        }
        return holder;
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    private void checkAllProjectedFieldsInGroupBy(ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        int index = 0;
        for (Object o : this.projAttrs) {
            Object[] projElem = (Object[])o;
            if (!this.aggregateColsPos.get(index) && !this.checkProjectionInGroupBy(projElem, context)) {
                throw new QueryInvalidException(LocalizedStrings.DefaultQuery_PROJ_COL_ABSENT_IN_GROUP_BY.toLocalizedString());
            }
            ++index;
        }
        if (this.groupBy != null) {
            int numGroupCols = this.groupBy != null ? this.groupBy.size() : 0;
            int numColsInProj = this.projAttrs.size();
            if (numGroupCols != (numColsInProj -= this.aggregateFunctions.length)) {
                throw new QueryInvalidException(LocalizedStrings.DefaultQuery_GROUP_BY_COL_ABSENT_IN_PROJ.toLocalizedString());
            }
        }
    }

    private boolean checkProjectionInGroupBy(Object[] projElem, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        boolean found = false;
        StringBuffer projAttribBuffer = new StringBuffer();
        CompiledValue cvProj = (CompiledValue)TypeUtils.checkCast(projElem[1], CompiledValue.class);
        cvProj.generateCanonicalizedExpression(projAttribBuffer, context);
        String projAttribStr = projAttribBuffer.toString();
        if (this.groupBy != null) {
            for (CompiledValue grpBy : this.groupBy) {
                if (grpBy.getType() == 34 && projElem[0] != null && projElem[0].equals(((CompiledID)grpBy).getId())) {
                    found = true;
                    break;
                }
                StringBuffer groupByExprBuffer = new StringBuffer();
                grpBy.generateCanonicalizedExpression(groupByExprBuffer, context);
                String grpByExprStr = groupByExprBuffer.toString();
                if (!projAttribStr.equals(grpByExprStr)) continue;
                found = true;
                break;
            }
        }
        return found;
    }
}

