/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.aggregate.Avg;
import com.gemstone.gemfire.cache.query.internal.aggregate.AvgBucketNode;
import com.gemstone.gemfire.cache.query.internal.aggregate.AvgDistinct;
import com.gemstone.gemfire.cache.query.internal.aggregate.AvgDistinctPRQueryNode;
import com.gemstone.gemfire.cache.query.internal.aggregate.AvgPRQueryNode;
import com.gemstone.gemfire.cache.query.internal.aggregate.Count;
import com.gemstone.gemfire.cache.query.internal.aggregate.CountDistinct;
import com.gemstone.gemfire.cache.query.internal.aggregate.CountDistinctPRQueryNode;
import com.gemstone.gemfire.cache.query.internal.aggregate.CountPRQueryNode;
import com.gemstone.gemfire.cache.query.internal.aggregate.DistinctAggregator;
import com.gemstone.gemfire.cache.query.internal.aggregate.MaxMin;
import com.gemstone.gemfire.cache.query.internal.aggregate.Sum;
import com.gemstone.gemfire.cache.query.internal.aggregate.SumDistinct;
import com.gemstone.gemfire.cache.query.internal.aggregate.SumDistinctPRQueryNode;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;

public class CompiledAggregateFunction
extends AbstractCompiledValue {
    private final CompiledValue expr;
    private final int aggFuncType;
    private final boolean distinctOnly;

    public CompiledAggregateFunction(CompiledValue expr, int aggFunc) {
        this(expr, aggFunc, false);
    }

    public CompiledAggregateFunction(CompiledValue expr, int aggFunc, boolean distinctOnly) {
        this.expr = expr;
        this.aggFuncType = aggFunc;
        this.distinctOnly = distinctOnly;
    }

    @Override
    public int getType() {
        return 60;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean isPRQueryNode = context.getIsPRQueryNode();
        boolean isBucketNode = context.getBucketList() != null;
        switch (this.aggFuncType) {
            case 61: {
                if (isPRQueryNode) {
                    return this.distinctOnly ? new SumDistinctPRQueryNode() : new Sum();
                }
                return this.distinctOnly ? (isBucketNode ? new DistinctAggregator() : new SumDistinct()) : new Sum();
            }
            case 64: {
                return new MaxMin(true);
            }
            case 65: {
                return new MaxMin(false);
            }
            case 62: {
                if (isPRQueryNode) {
                    return this.distinctOnly ? new AvgDistinctPRQueryNode() : new AvgPRQueryNode();
                }
                return this.distinctOnly ? (isBucketNode ? new DistinctAggregator() : new AvgDistinct()) : (isBucketNode ? new AvgBucketNode() : new Avg());
            }
            case 63: {
                if (isPRQueryNode) {
                    return this.distinctOnly ? new CountDistinctPRQueryNode() : new CountPRQueryNode();
                }
                return this.distinctOnly ? (isBucketNode ? new DistinctAggregator() : new CountDistinct()) : new Count();
            }
        }
        throw new UnsupportedOperationException("Aggregate function not implemented");
    }

    private String getStringRep() {
        switch (this.aggFuncType) {
            case 61: {
                return "sum";
            }
            case 64: {
                return "max";
            }
            case 65: {
                return "min";
            }
            case 62: {
                return "avg";
            }
            case 63: {
                return "count";
            }
        }
        throw new UnsupportedOperationException("Aggregate function not implemented");
    }

    public int getFunctionType() {
        return this.aggFuncType;
    }

    public CompiledValue getParameter() {
        return this.expr;
    }

    public ObjectType getObjectType() {
        switch (this.aggFuncType) {
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                return new ObjectTypeImpl(Number.class);
            }
            case 63: {
                return new ObjectTypeImpl(Integer.class);
            }
        }
        throw new UnsupportedOperationException("Aggregate function not implemented");
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ')');
        if (this.expr != null) {
            this.expr.generateCanonicalizedExpression(clauseBuffer, context);
        } else {
            clauseBuffer.insert(0, '*');
        }
        if (this.distinctOnly) {
            clauseBuffer.insert(0, "distinct ");
        }
        clauseBuffer.insert(0, '(');
        clauseBuffer.insert(0, this.getStringRep());
    }
}

