/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.NameNotFoundException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxSerializationException;
import com.gemstone.gemfire.pdx.internal.FieldNotFoundInPdxVersion;
import com.gemstone.gemfire.pdx.internal.PdxInstanceImpl;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AttributeDescriptor {
    private final String _name;
    private static final ConcurrentMap _cache = new ConcurrentHashMap();

    public AttributeDescriptor(String name) {
        this._name = name;
    }

    public boolean validateReadType(Class targetType) {
        try {
            this.getReadMember(targetType);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    public Object read(Object target) throws NameNotFoundException, QueryInvocationTargetException {
        if (target == null || target == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        if (target instanceof PdxInstance) {
            return this.readPdx((PdxInstance)target);
        }
        return this.read(target, target.getClass());
    }

    /*
     * Exception decompiling
     */
    private Object read(Object target, Class resolutionClass) throws NameNotFoundException, QueryInvocationTargetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Member getReadMember(ObjectType targetType) throws NameNotFoundException {
        return this.getReadMember(targetType.resolveClass());
    }

    Member getReadMember(Class targetClass) throws NameNotFoundException {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(targetClass);
        key.add(this._name);
        Member m = (Member)_cache.get(key);
        if (m != null) {
            return m;
        }
        m = this.getReadField(targetClass);
        if (m == null) {
            m = this.getReadMethod(targetClass);
        }
        if (m == null) {
            throw new NameNotFoundException(LocalizedStrings.AttributeDescriptor_NO_PUBLIC_ATTRIBUTE_NAMED_0_WAS_FOUND_IN_CLASS_1.toLocalizedString(this._name, targetClass.getName()));
        }
        _cache.putIfAbsent(key, m);
        ((AccessibleObject)((Object)m)).setAccessible(true);
        return m;
    }

    private Field getReadField(Class targetType) {
        try {
            return targetType.getField(this._name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private Method getReadMethod(Class targetType) {
        String beanMethod = "get" + this._name.substring(0, 1).toUpperCase() + this._name.substring(1);
        Method m = this.getReadMethod(targetType, beanMethod);
        if (m != null) {
            return m;
        }
        return this.getReadMethod(targetType, this._name);
    }

    private Method getReadMethod(Class targetType, String methodName) {
        try {
            return targetType.getMethod(methodName, null);
        }
        catch (NoSuchMethodException e) {
            this.updateClassToMethodsMap(targetType.getCanonicalName(), this._name);
            return null;
        }
    }

    private Object readPdx(PdxInstance target) throws NameNotFoundException, QueryInvocationTargetException {
        if (target instanceof PdxInstanceImpl) {
            PdxInstanceImpl pdxInstance = (PdxInstanceImpl)target;
            if (pdxInstance.hasField(this._name)) {
                return pdxInstance.getRawField(this._name);
            }
            String className = pdxInstance.getClassName();
            if (className.equals("__GEMFIRE_JSON")) {
                return QueryService.UNDEFINED;
            }
            if (!this.isFieldAlreadySearchedAndNotFound(className, this._name)) {
                try {
                    return pdxInstance.getDefaultValueIfFieldExistsInAnyPdxVersions(this._name, className);
                }
                catch (FieldNotFoundInPdxVersion e1) {
                    this.updateClassToFieldsMap(className, this._name);
                }
            }
            if (!this.isMethodAlreadySearchedAndNotFound(className, this._name)) {
                try {
                    return this.readFieldFromDeserializedObject(pdxInstance, target);
                }
                catch (NameNotFoundException ex) {
                    this.updateClassToMethodsMap(pdxInstance.getClassName(), this._name);
                    throw ex;
                }
            }
            return QueryService.UNDEFINED;
        }
        if (target.hasField(this._name)) {
            return target.getField(this._name);
        }
        throw new NameNotFoundException(LocalizedStrings.AttributeDescriptor_FIELD_0_IN_CLASS_1_IS_NOT_ACCESSIBLE_TO_THE_QUERY_PROCESSOR.toLocalizedString(this._name, target.getClass().getName()));
    }

    private Object readFieldFromDeserializedObject(PdxInstanceImpl pdxInstance, Object target) throws NameNotFoundException, QueryInvocationTargetException {
        try {
            Object obj = pdxInstance.getCachedObject();
            return this.read(obj, obj.getClass());
        }
        catch (PdxSerializationException e) {
            throw new NameNotFoundException(LocalizedStrings.AttributeDescriptor_FIELD_0_IN_CLASS_1_IS_NOT_ACCESSIBLE_TO_THE_QUERY_PROCESSOR.toLocalizedString(this._name, target.getClass().getName()));
        }
    }

    private void updateClassToFieldsMap(String className, String field) {
        Map<String, Set<String>> map = DefaultQuery.getPdxClasstofieldsmap();
        Set<String> fields = map.get(className);
        if (fields == null) {
            fields = new HashSet<String>();
            map.put(className, fields);
        }
        fields.add(field);
    }

    private boolean isFieldAlreadySearchedAndNotFound(String className, String field) {
        Set<String> fields = DefaultQuery.getPdxClasstofieldsmap().get(className);
        if (fields != null) {
            return fields.contains(field);
        }
        return false;
    }

    private void updateClassToMethodsMap(String className, String field) {
        Map<String, Set<String>> map = DefaultQuery.getPdxClasstoMethodsmap();
        Set<String> fields = map.get(className);
        if (fields == null) {
            fields = new HashSet<String>();
            map.put(className, fields);
        }
        fields.add(field);
    }

    private boolean isMethodAlreadySearchedAndNotFound(String className, String field) {
        Set<String> fields = DefaultQuery.getPdxClasstoMethodsmap().get(className);
        if (fields != null) {
            return fields.contains(field);
        }
        return false;
    }
}

