/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.partition;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.control.RebalanceResultsImpl;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPRInfo;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.ExplicitMoveDirector;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.PercentageMoveDirector;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class PartitionRegionHelper {
    private PartitionRegionHelper() {
    }

    public static Map<String, Region<?, ?>> getColocatedRegions(Region<?, ?> r) {
        Map<String, Region> ret;
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr = (PartitionedRegion)r;
            ret = ColocationHelper.getAllColocationRegions(pr);
            if (ret.isEmpty()) {
                ret = Collections.emptyMap();
            }
        } else if (r instanceof LocalDataSet) {
            LocalDataSet lds = (LocalDataSet)r;
            InternalRegionFunctionContext fc = lds.getFunctionContext();
            if (fc != null) {
                ret = ColocationHelper.getAllColocatedLocalDataSets(lds.getProxy(), fc);
                if (ret.isEmpty()) {
                    ret = Collections.emptyMap();
                }
            } else {
                ret = ColocationHelper.getColocatedLocalDataSetsForBuckets(lds.getProxy(), lds.getBucketSet());
            }
        } else {
            throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(r.getFullPath()));
        }
        return Collections.unmodifiableMap(ret);
    }

    public static boolean isPartitionedRegion(Region<?, ?> r) {
        if (r == null) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionRegionHelper_ARGUMENT_REGION_IS_NULL.toString());
        }
        return r instanceof PartitionedRegion;
    }

    private static PartitionedRegion isPartitionedCheck(Region<?, ?> r) {
        if (!PartitionRegionHelper.isPartitionedRegion(r)) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(r.getFullPath()));
        }
        return (PartitionedRegion)r;
    }

    public static Set<PartitionRegionInfo> getPartitionRegionInfo(Cache cache) {
        TreeSet<PartitionRegionInfo> prDetailsSet = new TreeSet<PartitionRegionInfo>();
        PartitionRegionHelper.fillInPartitionedRegionInfo((GemFireCacheImpl)cache, prDetailsSet, false);
        return prDetailsSet;
    }

    public static PartitionRegionInfo getPartitionRegionInfo(Region<?, ?> region) {
        try {
            PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(region);
            GemFireCacheImpl cache = (GemFireCacheImpl)region.getCache();
            return pr.getRedundancyProvider().buildPartitionedRegionInfo(false, cache.getResourceManager().getLoadProbe());
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private static void fillInPartitionedRegionInfo(GemFireCacheImpl cache, Set prDetailsSet, boolean internal) {
        Set<PartitionedRegion> prSet = cache.getPartitionedRegions();
        if (prSet.isEmpty()) {
            return;
        }
        for (PartitionedRegion pr : prSet) {
            InternalPRInfo prDetails = pr.getRedundancyProvider().buildPartitionedRegionInfo(internal, cache.getResourceManager().getLoadProbe());
            if (prDetails == null) continue;
            prDetailsSet.add(prDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignBucketsToPartitions(Region<?, ?> region) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(region);
        PartitionedRegion.RecoveryLock lock = null;
        try {
            lock = pr.getRecoveryLock();
            lock.lock();
            for (int i = 0; i < PartitionRegionHelper.getNumberOfBuckets(pr); ++i) {
                pr.createBucket(i, 0, null);
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static int getNumberOfBuckets(PartitionedRegion pr) {
        if (pr.isFixedPartitionedRegion()) {
            int numBuckets = 0;
            HashSet<FixedPartitionAttributesImpl> fpaSet = new HashSet<FixedPartitionAttributesImpl>(pr.getRegionAdvisor().adviseAllFixedPartitionAttributes());
            if (pr.getFixedPartitionAttributesImpl() != null) {
                fpaSet.addAll(pr.getFixedPartitionAttributesImpl());
            }
            for (FixedPartitionAttributesImpl fpa : fpaSet) {
                numBuckets += fpa.getNumBuckets();
            }
            return numBuckets;
        }
        return pr.getTotalNumberOfBuckets();
    }

    public static <K, V> DistributedMember getPrimaryMemberForKey(Region<K, V> r, K key) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(r);
        int bucketId = PartitionedRegionHelper.getHashKey(pr, null, key, null, null);
        return pr.getBucketPrimary(bucketId);
    }

    public static <K, V> Set<DistributedMember> getRedundantMembersForKey(Region<K, V> r, K key) {
        DistributedMember primary = PartitionRegionHelper.getPrimaryMemberForKey(r, key);
        Set<DistributedMember> owners = PartitionRegionHelper.getAllForKey(r, key);
        if (primary != null) {
            owners.remove(primary);
        }
        return Collections.unmodifiableSet(owners);
    }

    public static <K, V> Set<DistributedMember> getAllMembersForKey(Region<K, V> r, K key) {
        return Collections.unmodifiableSet(PartitionRegionHelper.getAllForKey(r, key));
    }

    private static <K, V> Set<? extends DistributedMember> getAllForKey(Region<K, V> r, K key) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(r);
        int bucketId = PartitionedRegionHelper.getHashKey(pr, null, key, null, null);
        return pr.getRegionAdvisor().getBucketOwners(bucketId);
    }

    public static Map<String, Region<?, ?>> getLocalColocatedRegions(RegionFunctionContext c) {
        Region r = c.getDataSet();
        PartitionRegionHelper.isPartitionedCheck(r);
        InternalRegionFunctionContext rfci = (InternalRegionFunctionContext)c;
        Map<String, Region<?, ?>> ret = rfci.getColocatedLocalDataSets();
        return ret;
    }

    public static <K, V> Region<K, V> getLocalDataForContext(RegionFunctionContext c) {
        Region r = c.getDataSet();
        PartitionRegionHelper.isPartitionedCheck(r);
        InternalRegionFunctionContext rfci = (InternalRegionFunctionContext)c;
        return rfci.getLocalDataSet(r);
    }

    public static <K, V> Region<K, V> getLocalData(Region<K, V> r) {
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr = (PartitionedRegion)r;
            Set<Integer> buckets = pr.getDataStore() != null ? pr.getDataStore().getAllLocalBucketIds() : Collections.emptySet();
            return new LocalDataSet(pr, buckets);
        }
        if (r instanceof LocalDataSet) {
            return r;
        }
        throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(r.getFullPath()));
    }

    public static <K, V> Region<K, V> getLocalPrimaryData(Region<K, V> r) {
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr = (PartitionedRegion)r;
            Set<Integer> buckets = pr.getDataStore() != null ? pr.getDataStore().getAllLocalPrimaryBucketIds() : Collections.emptySet();
            return new LocalDataSet(pr, buckets);
        }
        if (r instanceof LocalDataSet) {
            return r;
        }
        throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(r.getFullPath()));
    }

    public static <K> void moveBucketByKey(Region<K, ?> region, DistributedMember source, DistributedMember destination, K key) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(region);
        if (pr.isFixedPartitionedRegion()) {
            throw new IllegalStateException("Cannot move data in a fixed partitioned region");
        }
        int bucketId = pr.getKeyInfo(key).getBucketId();
        ExplicitMoveDirector director = new ExplicitMoveDirector(key, bucketId, source, destination, region.getCache().getDistributedSystem());
        PartitionedRegionRebalanceOp rebalance = new PartitionedRegionRebalanceOp(pr, false, director, true, true);
        rebalance.execute();
    }

    public static RebalanceResults moveData(Region<?, ?> region, DistributedMember source, DistributedMember destination, float percentage) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(region);
        if (pr.isFixedPartitionedRegion()) {
            throw new IllegalStateException("Cannot move data in a fixed partitioned region");
        }
        if (percentage <= 0.0f || (double)percentage > 100.0) {
            throw new IllegalArgumentException("Percentage must be between 0 and 100");
        }
        PercentageMoveDirector director = new PercentageMoveDirector(source, destination, percentage);
        PartitionedRegionRebalanceOp rebalance = new PartitionedRegionRebalanceOp(pr, false, director, true, true);
        Set<PartitionRebalanceInfo> results = rebalance.execute();
        RebalanceResultsImpl rebalanceResults = new RebalanceResultsImpl();
        for (PartitionRebalanceInfo details : results) {
            rebalanceResults.addDetails(details);
        }
        return rebalanceResults;
    }
}

