/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.operations;

import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.operations.internal.UpdateOnlyMap;
import java.util.Map;

public class PutAllOperationContext
extends OperationContext {
    private final UpdateOnlyMap map;
    private boolean postOperation = false;
    private Object callbackArg;

    public PutAllOperationContext(Map map) {
        this.map = new UpdateOnlyMap(map);
    }

    @Override
    public OperationContext.OperationCode getOperationCode() {
        return OperationContext.OperationCode.PUTALL;
    }

    @Override
    public boolean isPostOperation() {
        return this.postOperation;
    }

    protected void setPostOperation() {
        this.postOperation = true;
    }

    public <K, V> Map<K, V> getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        if (map == this.map) {
            return;
        }
        if (map == null) {
            throw new IllegalArgumentException("PutAllOperationContext.setMap does not allow a null map.");
        }
        if (map.size() != this.map.size()) {
            throw new IllegalArgumentException("PutAllOperationContext.setMap does not allow the size of the map to be changed.");
        }
        try {
            this.map.putAll(map);
        }
        catch (UnsupportedOperationException ex) {
            throw new IllegalArgumentException("PutAllOperationContext.setMap " + ex.getMessage() + " to the original keys of the putAll");
        }
    }

    public Object getCallbackArg() {
        return this.callbackArg;
    }

    public void setCallbackArg(Object callbackArg) {
        this.callbackArg = callbackArg;
    }
}

