/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.operations;

import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.operations.KeyOperationContext;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;

public abstract class KeyValueOperationContext
extends KeyOperationContext {
    private Object value;
    private boolean isObject;

    public KeyValueOperationContext(Object key, Object value, boolean isObject) {
        super(key);
        this.setValue(value, isObject);
    }

    public KeyValueOperationContext(Object key, Object value, boolean isObject, boolean postOperation) {
        super(key, postOperation);
        this.setValue(value, isObject);
    }

    public byte[] getSerializedValue() {
        Object tmp;
        if (this.isObject() && (tmp = this.value) instanceof byte[]) {
            return (byte[])tmp;
        }
        return null;
    }

    public Object getDeserializedValue() throws SerializationException {
        byte[] blob = this.getSerializedValue();
        if (blob != null) {
            return EntryEventImpl.deserialize(blob);
        }
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public void setSerializedValue(byte[] serializedValue, boolean isObject) {
        this.setValue(serializedValue, isObject);
    }

    public void setValue(Object value, boolean isObject) {
        this.value = value;
        this.isObject = isObject;
    }
}

