/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce;

import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class GFKey
implements WritableComparable<GFKey> {
    private Object key;

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = BlobHelper.serializeToBlob(this.key);
        out.writeInt(bytes.length);
        out.write(bytes, 0, bytes.length);
    }

    public void readFields(DataInput in) throws IOException {
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.readFully(bytes, 0, len);
        try {
            this.key = BlobHelper.deserializeBlob(bytes);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public int compareTo(GFKey o) {
        try {
            byte[] b1 = BlobHelper.serializeToBlob(this.key);
            byte[] b2 = BlobHelper.serializeToBlob(o.key);
            return WritableComparator.compareBytes((byte[])b1, (int)0, (int)b1.length, (byte[])b2, (int)0, (int)b2.length);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

