/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapred;

import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.UnsortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFKey;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HDFSSplitIterator;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class AbstractGFRecordReader
extends com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.AbstractGFRecordReader
implements RecordReader<GFKey, PersistedEventImpl> {
    public void initialize(CombineFileSplit split, JobConf conf) throws IOException {
        CombineFileSplit cSplit = split;
        Path[] path = cSplit.getPaths();
        long[] start = cSplit.getStartOffsets();
        long[] len = cSplit.getLengths();
        FileSystem fs = cSplit.getPath(0).getFileSystem((Configuration)conf);
        this.splitIterator = HDFSSplitIterator.newInstance(fs, path, start, len, 0L, 0L);
    }

    public boolean next(GFKey key, PersistedEventImpl value) throws IOException {
        if (!super.hasNext()) {
            key.setKey(null);
            return false;
        }
        super.next();
        key.setKey(super.getKey().getKey());
        PersistedEventImpl usersValue = super.getValue();
        value.copy(usersValue);
        return true;
    }

    public GFKey createKey() {
        return new GFKey();
    }

    public PersistedEventImpl createValue() {
        if (this.isSequential) {
            return new UnsortedHoplogPersistedEvent();
        }
        return new SortedHoplogPersistedEvent();
    }

    public long getPos() throws IOException {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public float getProgress() throws IOException {
        return super.getProgressRatio();
    }
}

