/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.BloomFilter;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.internal.hll.ICardinality;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumMap;

public interface Hoplog
extends Closeable,
Comparable<Hoplog> {
    public static final boolean NOP_WRITE = Boolean.getBoolean("Hoplog.NOP_WRITE");
    public static final byte[] MAGIC = new byte[]{71, 83, 79, 80};

    public HoplogReader getReader() throws IOException;

    public HoplogWriter createWriter(int var1) throws IOException;

    public void setReaderActivityListener(HoplogReaderActivityListener var1);

    public String getFileName();

    public ICardinality getEntryCountEstimate() throws IOException;

    public void rename(String var1) throws IOException;

    public void delete() throws IOException;

    public boolean isClosed();

    public void close(boolean var1) throws IOException;

    public long getModificationTimeStamp();

    public long getSize();

    public static enum Meta {
        GEMFIRE_MAGIC,
        SORTED_OPLOG_VERSION,
        GEMFIRE_VERSION,
        STATISTICS,
        COMPARATORS,
        PDX,
        LOCAL_CARDINALITY_ESTIMATE,
        LOCAL_CARDINALITY_ESTIMATE_V2;


        public byte[] toBytes() {
            return ("gemfire." + this.name()).getBytes();
        }

        public static Meta fromBytes(byte[] key) {
            return Meta.valueOf(new String(key).substring("gemfire.".length()));
        }
    }

    public static enum HoplogVersion {
        V1;


        public byte[] toBytes() {
            return this.name().getBytes();
        }

        public static HoplogVersion fromBytes(byte[] version) {
            return HoplogVersion.valueOf(new String(version));
        }
    }

    public static interface HoplogWriter
    extends Closeable {
        public void append(byte[] var1, byte[] var2) throws IOException;

        public void append(ByteBuffer var1, ByteBuffer var2) throws IOException;

        public void close(EnumMap<Meta, byte[]> var1) throws IOException;

        public void hsync() throws IOException;

        public long getCurrentSize() throws IOException;
    }

    public static interface HoplogReaderActivityListener {
        public void readerCreated();

        public void readerClosed();
    }

    public static interface HoplogReader
    extends HoplogSetReader<byte[], byte[]> {
        public ByteBuffer get(byte[] var1) throws IOException;

        public BloomFilter getBloomFilter() throws IOException;

        public long getEntryCount();

        public ICardinality getCardinalityEstimator();
    }
}

