/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.hdfs.internal.QueuedPersistentEvent;
import com.gemstone.gemfire.cache.hdfs.internal.UnsortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.CompactionStatus;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.SequenceFileHoplog;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.logging.log4j.message.Message;

public class HDFSUnsortedHoplogOrganizer
extends AbstractHoplogOrganizer<UnsortedHoplogPersistedEvent> {
    public static final String HOPLOG_REGEX = "(.+?)-(\\d+?)-(\\d+?)(.shop|.tmp)";
    public static final Pattern HOPLOG_PATTERN = Pattern.compile("(.+?)-(\\d+?)-(\\d+?)(.shop|.tmp)");
    protected static String TMP_FILE_NAME_REGEX = "(.+?)-(\\d+?)-(\\d+?).shop.tmp$";
    protected static final Pattern patternForTmpHoplog = Pattern.compile(TMP_FILE_NAME_REGEX);
    private volatile Hoplog.HoplogWriter writer = null;
    private volatile Hoplog currentHoplog;
    private volatile long lastFlushTime = System.currentTimeMillis();
    private volatile boolean abortFlush = false;
    private FileSystem fileSystem;

    public HDFSUnsortedHoplogOrganizer(HDFSRegionDirector.HdfsRegionManager region, int bucketId) throws IOException {
        super(region, bucketId);
        this.sequence = new AtomicInteger(0);
        this.fileSystem = this.store.getFileSystem();
        if (!this.fileSystem.exists(this.bucketPath)) {
            return;
        }
        FileStatus[] validHoplogs = FSUtils.listStatus((FileSystem)this.fileSystem, (Path)this.bucketPath, (PathFilter)new PathFilter(){

            public boolean accept(Path file) {
                Matcher matcher = HOPLOG_PATTERN.matcher(file.getName());
                return matcher.matches();
            }
        });
        if (validHoplogs != null && validHoplogs.length > 0) {
            for (FileStatus file : validHoplogs) {
                this.incrementDiskUsage(file.getLen());
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (logger.isDebugEnabled()) {
            logger.debug("{}Closing the hoplog organizer and the open files", new Object[]{this.logPrefix});
        }
        this.abortFlush = true;
        this.synchronizedCloseWriter(true, 0L, 0);
    }

    @Override
    public synchronized void flush(Iterator<? extends QueuedPersistentEvent> bufferIter, final int count) throws IOException, ForceReattemptException {
        assert (bufferIter != null);
        if (this.abortFlush) {
            throw new CacheClosedException("Either the region has been cleared or closed. Aborting the ongoing flush operation.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}Initializing flush operation", new Object[]{this.logPrefix});
        }
        long start = this.stats.getFlush().begin();
        int byteCount = 0;
        if (this.writer == null) {
            this.currentHoplog = this.getTmpSortedOplog(0, ".shop");
            try {
                this.writer = this.store.getSingletonWriter().runSerially(new Callable<Hoplog.HoplogWriter>(){

                    @Override
                    public Hoplog.HoplogWriter call() throws Exception {
                        return HDFSUnsortedHoplogOrganizer.this.currentHoplog.createWriter(count);
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
        long timeSinceLastFlush = (System.currentTimeMillis() - this.lastFlushTime) / 1000L;
        try {
            while (bufferIter.hasNext()) {
                HeapDataOutputStream out = new HeapDataOutputStream(1024, null);
                if (this.abortFlush) {
                    this.stats.getFlush().end(byteCount, start);
                    throw new CacheClosedException("Either the region has been cleared or closed. Aborting the ongoing flush operation.");
                }
                QueuedPersistentEvent item = bufferIter.next();
                item.toHoplogEventBytes(out);
                byte[] valueBytes = out.toByteArray();
                this.writer.append(item.getRawKey(), valueBytes);
                byteCount += item.getRawKey().length + valueBytes.length;
            }
            if (!this.abortFlush) {
                this.pingSecondaries();
            }
            int maxFileSize = this.store.getWriteOnlyFileRolloverSize() * 1024 * 1024;
            int fileRolloverInterval = this.store.getWriteOnlyFileRolloverInterval();
            if (this.writer.getCurrentSize() >= (long)maxFileSize || timeSinceLastFlush >= (long)fileRolloverInterval) {
                this.closeCurrentWriter();
            } else if (!this.abortFlush) {
                this.writer.hsync();
            }
        }
        catch (IOException e) {
            this.stats.getFlush().error(start);
            this.closeCurrentWriter();
            throw e;
        }
        this.stats.getFlush().end(byteCount, start);
    }

    synchronized void synchronizedCloseWriter(boolean forceClose, long timeSinceLastFlush, int minsizeforrollover) throws IOException {
        long writerSize = 0L;
        if (this.writer != null) {
            writerSize = this.writer.getCurrentSize();
        }
        if (writerSize < (long)minsizeforrollover * 1024L) {
            return;
        }
        int maxFileSize = this.store.getWriteOnlyFileRolloverSize() * 1024 * 1024;
        int fileRolloverInterval = this.store.getWriteOnlyFileRolloverInterval();
        if (writerSize >= (long)maxFileSize || timeSinceLastFlush >= (long)fileRolloverInterval || forceClose) {
            this.closeCurrentWriter();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void closeCurrentWriter() throws IOException {
        if (this.writer != null) {
            boolean isClosing;
            block9: {
                isClosing = this.abortFlush;
                try {
                    this.incrementDiskUsage(this.writer.getCurrentSize());
                }
                catch (IOException e) {
                    if (isClosing) break block9;
                    throw e;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}Closing hoplog " + this.currentHoplog.getFileName(), new Object[]{this.logPrefix});
            }
            try {
                this.writer.close();
                HDFSUnsortedHoplogOrganizer.makeLegitimate(this.currentHoplog);
                return;
            }
            catch (IOException e) {
                if (isClosing) return;
                logger.warn((Object)LocalizedStrings.HOPLOG_FLUSH_OPERATION_FAILED, (Throwable)e);
                throw e;
            }
            finally {
                this.writer = null;
                this.lastFlushTime = System.currentTimeMillis();
            }
        }
        this.lastFlushTime = System.currentTimeMillis();
    }

    @Override
    public void clear() throws IOException {
        boolean prevAbortFlushFlag = this.abortFlush;
        this.abortFlush = true;
        try {
            this.synchronizedCloseWriter(true, 0L, 0);
        }
        catch (IOException e) {
            logger.warn((Object)LocalizedStrings.HOPLOG_CLOSE_FAILED, (Throwable)e);
        }
        this.abortFlush = prevAbortFlushFlag;
        this.markHoplogsForDeletion();
    }

    @Override
    public void performMaintenance() {
    }

    @Override
    public Future<CompactionStatus> forceCompaction(boolean isMajor) {
        return null;
    }

    @Override
    protected Hoplog getHoplog(Path hoplogPath) throws IOException {
        SequenceFileHoplog so = new SequenceFileHoplog(this.fileSystem, hoplogPath, this.stats);
        return so;
    }

    void identifyAndFixTmpHoplogs(FileSystem fs) throws IOException, ForceReattemptException {
        FileStatus[] tmpHoplogs;
        if (logger.isDebugEnabled()) {
            logger.debug("{}Fixing temporary hoplogs", new Object[]{this.logPrefix});
        }
        if ((tmpHoplogs = FSUtils.listStatus((FileSystem)fs, (Path)fs.makeQualified(this.bucketPath), (PathFilter)new PathFilter(){

            public boolean accept(Path file) {
                Matcher matcher = patternForTmpHoplog.matcher(file.getName());
                return matcher.matches();
            }
        })) == null || tmpHoplogs.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}No files to fix", new Object[]{this.logPrefix});
            }
            return;
        }
        this.pingSecondaries();
        if (logger.isDebugEnabled()) {
            logger.debug("{}Files to fix " + tmpHoplogs.length, new Object[]{this.logPrefix});
        }
        String currentHoplogName = null;
        if (this.currentHoplog != null) {
            currentHoplogName = this.currentHoplog.getFileName();
        }
        for (int i = 0; i < tmpHoplogs.length; ++i) {
            if (tmpHoplogs[i].isDirectory()) continue;
            Path p = tmpHoplogs[i].getPath();
            if (tmpHoplogs[i].getPath().getName().equals(currentHoplogName)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping current file: " + tmpHoplogs[i].getPath().getName(), new Object[]{this.logPrefix});
                continue;
            }
            SequenceFileHoplog hoplog = new SequenceFileHoplog(fs, p, this.stats);
            try {
                HDFSUnsortedHoplogOrganizer.makeLegitimate(hoplog);
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Hoplog " + p + " was a temporary " + "hoplog because the node managing it wasn't shutdown properly last time. Fixed the hoplog name."));
                continue;
            }
            catch (IOException e) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Hoplog " + p + " is still a temporary " + "hoplog because the node managing it wasn't shutdown properly last time. Failed to " + "change the hoplog name because an exception was thrown while fixing it. " + e));
            }
        }
    }

    private FileStatus[] getExpiredHoplogs() throws IOException {
        FileStatus[] files = FSUtils.listStatus((FileSystem)this.fileSystem, (Path)this.bucketPath, (PathFilter)new PathFilter(){

            public boolean accept(Path file) {
                String fileName = file.getName();
                return fileName.endsWith(".exp");
            }
        });
        return files;
    }

    private void markHoplogsForDeletion() throws IOException {
        ArrayList<IOException> errors = new ArrayList<IOException>();
        FileStatus[] validHoplogs = FSUtils.listStatus((FileSystem)this.fileSystem, (Path)this.bucketPath, (PathFilter)new PathFilter(){

            public boolean accept(Path file) {
                Matcher matcher = HOPLOG_PATTERN.matcher(file.getName());
                return matcher.matches();
            }
        });
        FileStatus[] expired = this.getExpiredHoplogs();
        if ((validHoplogs = HDFSUnsortedHoplogOrganizer.filterValidHoplogs(validHoplogs, expired)) == null || validHoplogs.length == 0) {
            return;
        }
        for (FileStatus fileStatus : validHoplogs) {
            try {
                this.addExpiryMarkerForAFile(this.getHoplog(fileStatus.getPath()));
            }
            catch (IOException e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            for (IOException e : errors) {
                logger.warn((Object)LocalizedStrings.HOPLOG_HOPLOG_REMOVE_FAILED, (Throwable)e);
            }
        }
    }

    @Override
    public HoplogOrganizer.Compactor getCompactor() {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public HoplogSetReader.HoplogIterator<byte[], UnsortedHoplogPersistedEvent> scan(long startOffset, long length) throws IOException {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    public long getfileRolloverInterval() {
        int fileRolloverInterval = this.store.getWriteOnlyFileRolloverInterval();
        return fileRolloverInterval;
    }

    @Override
    public long getLastMajorCompactionTimestamp() {
        throw new UnsupportedOperationException();
    }
}

