/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public final class HDFSStoreDirector {
    private final ConcurrentHashMap<String, HDFSStoreImpl> storeMap = new ConcurrentHashMap();
    private static volatile HDFSStoreDirector instance;

    private HDFSStoreDirector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final HDFSStoreDirector getInstance() {
        if (instance != null) return instance;
        Class<HDFSStoreDirector> clazz = HDFSStoreDirector.class;
        synchronized (HDFSStoreDirector.class) {
            if (instance != null) return instance;
            instance = new HDFSStoreDirector();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public final void addHDFSStore(HDFSStoreImpl hdfsStore) {
        this.storeMap.put(hdfsStore.getName(), hdfsStore);
    }

    public final HDFSStoreImpl getHDFSStore(String hdfsStoreName) {
        return this.storeMap.get(hdfsStoreName);
    }

    public final void removeHDFSStore(String hdfsStoreName) {
        this.storeMap.remove(hdfsStoreName);
    }

    public void closeHDFSStores() {
        for (HDFSStoreImpl hsi : this.storeMap.values()) {
            hsi.close();
        }
        this.storeMap.clear();
    }

    public ArrayList<HDFSStoreImpl> getAllHDFSStores() {
        ArrayList<HDFSStoreImpl> hdfsStores = new ArrayList<HDFSStoreImpl>();
        hdfsStores.addAll(this.storeMap.values());
        return hdfsStores;
    }
}

