/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.CloseTmpHoplogsTimerTask;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSStoreDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSUnsortedHoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HdfsSortedOplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogListener;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogOrganizer;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class HDFSRegionDirector {
    private final ConcurrentHashMap<String, HdfsRegionManager> regionManagerMap = new ConcurrentHashMap();
    private GemFireCache cache;
    private static HDFSRegionDirector instance;
    final ScheduledExecutorService janitor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "HDFSRegionJanitor");
            thread.setDaemon(true);
            return thread;
        }
    });
    private JanitorTask janitorTask;
    private static final Logger logger;
    protected static final String logPrefix = "<RegionDirector> ";

    private HDFSRegionDirector() {
        long interval = Long.getLong("hoplog.janitor.interval.secs", 120L);
        this.janitorTask = new JanitorTask();
        this.janitor.scheduleWithFixedDelay(this.janitorTask, interval, interval, TimeUnit.SECONDS);
    }

    public static synchronized HDFSRegionDirector getInstance() {
        if (instance == null) {
            instance = new HDFSRegionDirector();
        }
        return instance;
    }

    public HDFSRegionDirector setCache(GemFireCache cache) {
        this.cache = cache;
        return this;
    }

    public GemFireCache getCache() {
        return this.cache;
    }

    public synchronized HdfsRegionManager manageRegion(LocalRegion region, String storeName, HoplogListener listener) {
        HdfsRegionManager manager = this.regionManagerMap.get(region.getFullPath());
        if (manager != null) {
            this.clear(region.getFullPath());
        }
        HDFSStoreImpl store = HDFSStoreDirector.getInstance().getHDFSStore(storeName);
        manager = new HdfsRegionManager(region, store, listener, this.getStatsFactory(), this);
        this.regionManagerMap.put(region.getFullPath(), manager);
        if (logger.isDebugEnabled()) {
            logger.debug("{}Now managing region " + region.getFullPath(), new Object[]{logPrefix});
        }
        return manager;
    }

    public Collection<String> getRegionsInStore(HDFSStore store) {
        TreeSet<String> regions = new TreeSet<String>();
        for (Map.Entry<String, HdfsRegionManager> entry : this.regionManagerMap.entrySet()) {
            if (!entry.getValue().getStore().equals(store)) continue;
            regions.add(entry.getKey());
        }
        return regions;
    }

    public int getBucketCount(String regionPath) {
        HdfsRegionManager manager = this.regionManagerMap.get(regionPath);
        if (manager == null) {
            throw new IllegalStateException("Region not initialized");
        }
        return manager.bucketOrganizerMap.size();
    }

    public void closeWritersForRegion(String regionPath, int minSizeForFileRollover) throws IOException {
        this.regionManagerMap.get(regionPath).closeWriters(minSizeForFileRollover);
    }

    public synchronized void clear(String regionPath) {
        HdfsRegionManager manager = this.regionManagerMap.remove(regionPath);
        if (manager != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Closing hoplog region manager for " + regionPath, new Object[]{logPrefix});
            }
            manager.close();
        }
    }

    public static synchronized void reset() {
        if (instance == null) {
            return;
        }
        HDFSRegionDirector.instance.janitor.shutdownNow();
        for (String region : HDFSRegionDirector.instance.regionManagerMap.keySet()) {
            instance.clear(region);
        }
        HDFSRegionDirector.instance.cache = null;
        instance = null;
    }

    public static synchronized void resetJanitor() {
        HDFSRegionDirector.instance.janitorTask.terminate();
        HDFSRegionDirector hDFSRegionDirector = instance;
        hDFSRegionDirector.getClass();
        HDFSRegionDirector.instance.janitorTask = hDFSRegionDirector.new JanitorTask();
        long interval = Long.getLong("hoplog.janitor.interval.secs", 120L);
        HDFSRegionDirector.instance.janitor.scheduleWithFixedDelay(HDFSRegionDirector.instance.janitorTask, 0L, interval, TimeUnit.SECONDS);
    }

    public synchronized SortedOplogStatistics getHdfsRegionStats(String regionPath) {
        HdfsRegionManager manager = this.regionManagerMap.get(regionPath);
        return manager == null ? null : manager.getHdfsStats();
    }

    private StatisticsFactory getStatsFactory() {
        return this.cache.getDistributedSystem();
    }

    protected static void fineLog(String message, Throwable e) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, e);
        }
    }

    static {
        logger = LogService.getLogger();
    }

    private class JanitorTask
    implements Runnable {
        boolean terminated = false;

        private JanitorTask() {
        }

        @Override
        public void run() {
            if (this.terminated) {
                return;
            }
            HDFSRegionDirector.fineLog("Executing HDFS Region janitor task", null);
            Collection regions = HDFSRegionDirector.this.regionManagerMap.values();
            for (HdfsRegionManager region : regions) {
                HDFSRegionDirector.fineLog("Maintaining region:" + region.getRegionFolder(), null);
                try {
                    region.performMaintenance();
                }
                catch (Throwable e) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_IO_ERROR, region.getRegionFolder()));
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.ONE_ARG, e.getMessage()));
                    HDFSRegionDirector.fineLog(null, e);
                }
            }
        }

        public void terminate() {
            this.terminated = true;
        }
    }

    public static class HdfsRegionManager {
        private LocalRegion region;
        private HDFSStoreImpl store;
        private HoplogListener listener;
        private volatile boolean closed = false;
        private final int FILE_ROLLOVER_TASK_INTERVAL = Integer.parseInt(System.getProperty("gemfire.HDFSRegionDirector.FILE_ROLLOVER_TASK_INTERVAL_SECONDS", "60"));
        private SystemTimer hoplogCloseTimer = null;
        private final SortedOplogStatistics hdfsStats;
        private ConcurrentMap<Integer, HoplogOrganizer> bucketOrganizerMap = new ConcurrentHashMap<Integer, HoplogOrganizer>();
        private HDFSRegionDirector hdfsRegionDirector;

        HdfsRegionManager(LocalRegion region, HDFSStoreImpl store, HoplogListener listener, StatisticsFactory statsFactory, HDFSRegionDirector hdfsRegionDirector) {
            this.region = region;
            this.listener = listener;
            this.store = store;
            this.hdfsStats = new SortedOplogStatistics(statsFactory, "HDFSRegionStatistics", region.getFullPath());
            this.hdfsRegionDirector = hdfsRegionDirector;
        }

        public void closeWriters(int minSizeForFileRollover) throws IOException {
            long startTime = System.currentTimeMillis();
            long elapsedTime = 0L;
            Collection organizers = this.bucketOrganizerMap.values();
            for (HoplogOrganizer organizer : organizers) {
                try {
                    this.getRegion().checkReadiness();
                }
                catch (Exception e) {
                    break;
                }
                ((HDFSUnsortedHoplogOrganizer)organizer).synchronizedCloseWriter(true, 0L, minSizeForFileRollover);
            }
        }

        public synchronized <T extends PersistedEventImpl> HoplogOrganizer<T> create(int bucketId) throws IOException {
            assert (!this.bucketOrganizerMap.containsKey(bucketId));
            AbstractHoplogOrganizer organizer = this.region.getHDFSWriteOnly() ? new HDFSUnsortedHoplogOrganizer(this, bucketId) : new HdfsSortedOplogOrganizer(this, bucketId);
            this.bucketOrganizerMap.put(bucketId, organizer);
            if (this.region.getHDFSWriteOnly() && this.hoplogCloseTimer == null) {
                this.hoplogCloseTimer = new SystemTimer(this.hdfsRegionDirector.getCache().getDistributedSystem(), true);
                this.hoplogCloseTimer.scheduleAtFixedRate(new CloseTmpHoplogsTimerTask(this), 1000L, this.FILE_ROLLOVER_TASK_INTERVAL * 1000);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Schedulng hoplog rollover timer with interval " + this.FILE_ROLLOVER_TASK_INTERVAL + " for hoplog organizer for " + this.region.getFullPath() + ":" + bucketId + " " + organizer, new Object[]{HDFSRegionDirector.logPrefix});
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}Constructed hoplog organizer for " + this.region.getFullPath() + ":" + bucketId + " " + organizer, new Object[]{HDFSRegionDirector.logPrefix});
            }
            return organizer;
        }

        public synchronized <T extends PersistedEventImpl> void addOrganizer(int bucketId, HoplogOrganizer<T> organizer) {
            if (this.bucketOrganizerMap.containsKey(bucketId)) {
                throw new IllegalArgumentException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}added pre constructed organizer " + this.region.getFullPath() + ":" + bucketId + " " + organizer, new Object[]{HDFSRegionDirector.logPrefix});
            }
            this.bucketOrganizerMap.put(bucketId, organizer);
        }

        public void close() {
            this.closed = true;
            if (this.region.getHDFSWriteOnly() && this.hoplogCloseTimer != null) {
                this.hoplogCloseTimer.cancel();
                this.hoplogCloseTimer = null;
            }
            Iterator iterator = this.bucketOrganizerMap.keySet().iterator();
            while (iterator.hasNext()) {
                int bucket = (Integer)iterator.next();
                this.close(bucket);
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        public synchronized void close(int bucketId) {
            block4: {
                try {
                    HoplogOrganizer organizer = (HoplogOrganizer)this.bucketOrganizerMap.remove(bucketId);
                    if (organizer != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}Closing hoplog organizer for " + this.region.getFullPath() + ":" + bucketId + " " + organizer, new Object[]{HDFSRegionDirector.logPrefix});
                        }
                        organizer.close();
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("<RegionDirector> Error closing hoplog organizer for " + this.region.getFullPath() + ":" + bucketId, (Throwable)e);
                }
            }
        }

        public static String getRegionFolder(String regionPath) {
            String folder = regionPath;
            folder = folder.replace("_", "__");
            folder = folder.replaceFirst("^/", "");
            folder = folder.replace('/', '_');
            return folder;
        }

        public String getRegionFolder() {
            return HdfsRegionManager.getRegionFolder(this.region.getFullPath());
        }

        public HoplogListener getListener() {
            return this.listener;
        }

        public HDFSStoreImpl getStore() {
            return this.store;
        }

        public LocalRegion getRegion() {
            return this.region;
        }

        public SortedOplogStatistics getHdfsStats() {
            return this.hdfsStats;
        }

        public Collection<HoplogOrganizer> getBucketOrganizers() {
            return this.bucketOrganizerMap.values();
        }

        public Collection<HoplogOrganizer> getBucketOrganizers(Set<Integer> buckets) {
            HashSet<HoplogOrganizer> result = new HashSet<HoplogOrganizer>();
            for (Integer bucketId : buckets) {
                result.add((HoplogOrganizer)this.bucketOrganizerMap.get(bucketId));
            }
            return result;
        }

        public void destroyData() throws IOException {
            this.close();
            if (this.store == null) {
                return;
            }
            Path regionPath = new Path(this.store.getHomeDir(), this.getRegionFolder());
            FileSystem fs = this.getStore().getFileSystem();
            if (!fs.delete(regionPath, true) && fs.exists(regionPath)) {
                throw new IOException("Unable to delete " + regionPath);
            }
        }

        public void performMaintenance() throws IOException {
            Collection<HoplogOrganizer> buckets = this.getBucketOrganizers();
            for (HoplogOrganizer bucket : buckets) {
                bucket.performMaintenance();
            }
        }
    }
}

