/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.CompactionStatus;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class HDFSForceCompactionResultCollector
implements LocalResultCollector<Object, List<CompactionStatus>> {
    private List<CompactionStatus> reply = new ArrayList<CompactionStatus>();
    private CountDownLatch waitForResults = new CountDownLatch(1);
    private volatile boolean shouldRetry;
    private ReplyProcessor21 processor;

    @Override
    public List<CompactionStatus> getResult() throws FunctionException {
        try {
            this.waitForResults.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            GemFireCacheImpl.getExisting().getCancelCriterion().checkCancelInProgress(e);
            throw new FunctionException(e);
        }
        return this.reply;
    }

    @Override
    public List<CompactionStatus> getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addResult(DistributedMember memberID, Object resultOfSingleExecution) {
        CompactionStatus status;
        if (resultOfSingleExecution instanceof CompactionStatus && (status = (CompactionStatus)resultOfSingleExecution).getBucketId() != -1) {
            this.reply.add(status);
        }
    }

    @Override
    public void endResults() {
        this.waitForResults.countDown();
    }

    @Override
    public void clearResults() {
        this.shouldRetry = true;
        this.waitForResults.countDown();
    }

    public boolean shouldRetry() {
        return this.shouldRetry || !this.getFailedBucketIds().isEmpty();
    }

    private Set<Integer> getFailedBucketIds() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (CompactionStatus status : this.reply) {
            if (status.isStatus()) continue;
            result.add(status.getBucketId());
        }
        return result;
    }

    public Set<Integer> getSuccessfulBucketIds() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (CompactionStatus status : this.reply) {
            if (!status.isStatus()) continue;
            result.add(status.getBucketId());
        }
        return result;
    }

    @Override
    public void setProcessor(ReplyProcessor21 processor) {
        this.processor = processor;
    }

    @Override
    public ReplyProcessor21 getProcessor() {
        return this.processor;
    }

    @Override
    public void setException(Throwable exception) {
    }
}

