/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.CompactionStatus;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSForceCompactionArgs;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Logger;

public class HDFSForceCompactionFunction
implements Function,
InternalEntity {
    public static final int FORCE_COMPACTION_MAX_RETRIES = Integer.getInteger("gemfireXD.maxCompactionRetries", 3);
    public static final int BUCKET_ID_FOR_LAST_RESULT = -1;
    public static final String ID = "HDFSForceCompactionFunction";
    private static final Logger logger = LogService.getLogger();

    @Override
    public void execute(FunctionContext context) {
        if (context.isPossibleDuplicate()) {
            context.getResultSender().lastResult(new CompactionStatus(-1, false));
            return;
        }
        RegionFunctionContext rfc = (RegionFunctionContext)context;
        PartitionedRegion pr = (PartitionedRegion)rfc.getDataSet();
        HDFSForceCompactionArgs args = (HDFSForceCompactionArgs)rfc.getArguments();
        HashSet<Integer> buckets = new HashSet<Integer>(args.getBuckets());
        buckets.retainAll(pr.getDataStore().getAllLocalPrimaryBucketIds());
        List<Future<CompactionStatus>> futures = pr.forceLocalHDFSCompaction(buckets, args.isMajor(), 0L);
        int waitFor = args.getMaxWaitTime();
        for (Future<CompactionStatus> future : futures) {
            long start = System.currentTimeMillis();
            CompactionStatus status = null;
            try {
                if (!args.isSynchronous() && waitFor <= 0) break;
                status = args.isSynchronous() ? future.get() : future.get(waitFor, TimeUnit.MILLISECONDS);
                buckets.remove(status.getBucketId());
                if (logger.isDebugEnabled()) {
                    logger.debug("HDFS: ForceCompaction sending result:" + status);
                }
                context.getResultSender().sendResult(status);
                long elapsedTime = System.currentTimeMillis() - start;
                waitFor = (int)((long)waitFor - elapsedTime);
            }
            catch (InterruptedException elapsedTime) {
            }
            catch (ExecutionException elapsedTime) {
            }
            catch (TimeoutException e) {
                break;
            }
        }
        boolean status = !args.isSynchronous();
        for (Integer bucketId : buckets) {
            if (logger.isDebugEnabled()) {
                logger.debug("HDFS: ForceCompaction sending result for bucket:" + bucketId);
            }
            context.getResultSender().sendResult(new CompactionStatus(bucketId, status));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("HDFS: ForceCompaction sending last result");
        }
        context.getResultSender().lastResult(new CompactionStatus(-1, true));
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return true;
    }

    @Override
    public boolean isHA() {
        return true;
    }
}

