/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class HDFSFlushQueueArgs
implements VersionedDataSerializable {
    private static Version[] serializationVersions = new Version[]{Version.GFE_81};
    private HashSet<Integer> buckets;
    private long maxWaitTimeMillis;

    public HDFSFlushQueueArgs() {
    }

    public HDFSFlushQueueArgs(Set<Integer> buckets, long maxWaitTime) {
        this.buckets = new HashSet<Integer>(buckets);
        this.maxWaitTimeMillis = maxWaitTime;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeHashSet(this.buckets, out);
        out.writeLong(this.maxWaitTimeMillis);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.buckets = DataSerializer.readHashSet(in);
        this.maxWaitTimeMillis = in.readLong();
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    public Set<Integer> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Set<Integer> buckets) {
        this.buckets = new HashSet<Integer>(buckets);
    }

    public boolean isSynchronous() {
        return this.maxWaitTimeMillis == 0L;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTimeMillis;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getCanonicalName()).append("@").append(System.identityHashCode(this)).append(" buckets:").append(this.buckets).append(" maxWaitTime:").append(this.maxWaitTimeMillis);
        return sb.toString();
    }
}

