/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FlushStatus
implements VersionedDataSerializable {
    private static Version[] serializationVersions = new Version[]{Version.GFE_81};
    private int bucketId;
    private static final int LAST = -1;

    public FlushStatus() {
    }

    public static FlushStatus last() {
        return new FlushStatus(-1);
    }

    public FlushStatus(int bucketId) {
        this.bucketId = bucketId;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public boolean isLast() {
        return this.bucketId == -1;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.bucketId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.bucketId = in.readInt();
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getCanonicalName()).append("@").append(System.identityHashCode(this)).append(" Bucket:").append(this.bucketId);
        return sb.toString();
    }
}

