/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.QueuedPersistentEvent;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogListener;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.logging.log4j.Logger;

public abstract class AbstractHoplogOrganizer<T extends PersistedEventImpl>
implements HoplogOrganizer<T> {
    public static final String MINOR_HOPLOG_EXTENSION = ".ihop";
    public static final String MAJOR_HOPLOG_EXTENSION = ".chop";
    public static final String EXPIRED_HOPLOG_EXTENSION = ".exp";
    public static final String TEMP_HOPLOG_EXTENSION = ".tmp";
    public static final String FLUSH_HOPLOG_EXTENSION = ".hop";
    public static final String SEQ_HOPLOG_EXTENSION = ".shop";
    public static final String HOPLOG_NAME_REGEX = "(.+?)-(\\d+?)-(\\d+?)";
    public static final Pattern HOPLOG_NAME_PATTERN = Pattern.compile("(.+?)-(\\d+?)-(\\d+?)\\.(.*)");
    public static boolean JUNIT_TEST_RUN = false;
    protected static final boolean ENABLE_INTEGRITY_CHECKS = Boolean.getBoolean("gemfire.HdfsSortedOplogOrganizer.ENABLE_INTEGRITY_CHECKS") || AbstractHoplogOrganizer.assertionsEnabled();
    protected HDFSRegionDirector.HdfsRegionManager regionManager;
    protected final String regionFolder;
    protected final int bucketId;
    protected final Path basePath;
    protected final Path bucketPath;
    protected final HDFSStoreImpl store;
    protected AtomicInteger sequence;
    protected static final Logger logger = LogService.getLogger();
    protected final String logPrefix;
    protected SortedOplogStatistics stats;
    AtomicLong bucketDiskUsage = new AtomicLong(0L);
    protected HoplogListener listener;
    private volatile boolean closed = false;
    protected Object changePrimarylockObject = new Object();

    private static boolean assertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public AbstractHoplogOrganizer(HDFSRegionDirector.HdfsRegionManager region, int bucketId) {
        assert (region != null);
        this.regionManager = region;
        this.regionFolder = region.getRegionFolder();
        this.store = region.getStore();
        this.listener = region.getListener();
        this.stats = region.getHdfsStats();
        this.bucketId = bucketId;
        this.basePath = new Path(this.store.getHomeDir());
        this.bucketPath = new Path(this.basePath, this.regionFolder + "/" + bucketId);
        this.logPrefix = "<" + this.getRegionBucketStr() + "> ";
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.regionManager.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.incrementDiskUsage(-1L * this.bucketDiskUsage.get());
    }

    @Override
    public abstract void flush(Iterator<? extends QueuedPersistentEvent> var1, int var2) throws IOException, ForceReattemptException;

    @Override
    public abstract void clear() throws IOException;

    protected abstract Hoplog getHoplog(Path var1) throws IOException;

    @Override
    public void hoplogCreated(String region, int bucketId, Hoplog ... oplogs) throws IOException {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public void hoplogDeleted(String region, int bucketId, Hoplog ... oplogs) throws IOException {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public void compactionCompleted(String region, int bucket, boolean isMajor) {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public T read(byte[] key) throws IOException {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public HoplogSetReader.HoplogIterator<byte[], T> scan() throws IOException {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public HoplogSetReader.HoplogIterator<byte[], T> scan(byte[] from, byte[] to) throws IOException {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public HoplogSetReader.HoplogIterator<byte[], T> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive) throws IOException {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public long sizeEstimate() {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    protected String getPathStr(Hoplog oplog) {
        return this.bucketPath.toString() + "/" + oplog.getFileName();
    }

    protected String getRegionBucketStr() {
        return this.regionFolder + "/" + this.bucketId;
    }

    protected SortedHoplogPersistedEvent deserializeValue(byte[] val) throws IOException {
        try {
            return SortedHoplogPersistedEvent.fromBytes(val);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_CLASSNOTFOUNDEXCEPTION, (Throwable)e);
            return null;
        }
    }

    protected boolean isDeletedEntry(byte[] value, int offset) throws IOException {
        assert (value != null && value.length > 0 && offset >= 0 && offset < value.length);
        Operation op = Operation.fromOrdinal(value[offset]);
        return op.isDestroy() || op.isInvalidate();
    }

    Hoplog getTmpSortedOplog(Integer seqNum, String extension) throws IOException {
        if (seqNum == null) {
            seqNum = this.sequence.incrementAndGet();
        }
        String name = this.bucketId + "-" + System.currentTimeMillis() + "-" + seqNum + extension;
        Path soplogPath = new Path(this.bucketPath, name + TEMP_HOPLOG_EXTENSION);
        return this.getHoplog(soplogPath);
    }

    static void makeLegitimate(Hoplog so) throws IOException {
        String name = so.getFileName();
        assert (name.endsWith(TEMP_HOPLOG_EXTENSION));
        int index = name.lastIndexOf(TEMP_HOPLOG_EXTENSION);
        name = name.substring(0, index);
        so.rename(name);
    }

    protected void addExpiryMarkerForAFile(Hoplog hoplog) throws IOException {
        FileSystem fs = this.store.getFileSystem();
        Path expiryMarker = this.getExpiryMarkerPath(hoplog.getFileName());
        if (ENABLE_INTEGRITY_CHECKS) {
            Assert.assertTrue(!fs.exists(expiryMarker), "Expiry marker already exists: " + expiryMarker);
        }
        FSDataOutputStream expiryMarkerFile = fs.create(expiryMarker);
        expiryMarkerFile.close();
        if (logger.isDebugEnabled()) {
            logger.debug("Hoplog marked expired: " + this.getPathStr(hoplog));
        }
    }

    protected Path getExpiryMarkerPath(String name) {
        return new Path(this.bucketPath, name + EXPIRED_HOPLOG_EXTENSION);
    }

    protected String truncateExpiryExtension(String name) {
        if (name.endsWith(EXPIRED_HOPLOG_EXTENSION)) {
            return name.substring(0, name.length() - EXPIRED_HOPLOG_EXTENSION.length());
        }
        return name;
    }

    protected void incrementDiskUsage(long delta) {
        long newSize = this.bucketDiskUsage.addAndGet(delta);
        if (newSize < 0L && delta < 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Invalid diskUsage size:" + newSize + " caused by delta:" + delta + ", parallel del & close?" + this.isClosed(), new Object[]{this.logPrefix});
            }
            if (this.isClosed()) {
                delta += -1L * newSize;
            }
        }
        this.stats.incStoreUsageBytes(delta);
    }

    public static FileStatus[] filterValidHoplogs(FileStatus[] valid, FileStatus[] expired) {
        if (valid == null) {
            return null;
        }
        if (expired == null) {
            return valid;
        }
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus vs : valid) {
            boolean found = false;
            for (FileStatus ex : expired) {
                if (!ex.getPath().getName().equals(vs.getPath().getName() + EXPIRED_HOPLOG_EXTENSION)) continue;
                found = true;
            }
            if (found) continue;
            result.add(vs);
        }
        return result.toArray(new FileStatus[result.size()]);
    }

    protected void pingSecondaries() throws ForceReattemptException {
        if (JUNIT_TEST_RUN) {
            return;
        }
        BucketRegion br = ((PartitionedRegion)this.regionManager.getRegion()).getDataStore().getLocalBucketById(this.bucketId);
        boolean secondariesPingable = false;
        try {
            secondariesPingable = br.areSecondariesPingable();
        }
        catch (Throwable e) {
            throw new ForceReattemptException("Failed to ping secondary servers of bucket: " + this.bucketId + ", region: " + (PartitionedRegion)this.regionManager.getRegion(), e);
        }
        if (!secondariesPingable) {
            throw new ForceReattemptException("Failed to ping secondary servers of bucket: " + this.bucketId + ", region: " + (PartitionedRegion)this.regionManager.getRegion());
        }
    }

    public static long getHoplogTimestamp(Matcher matcher) {
        return Long.valueOf(matcher.group(2));
    }

    public static final class HoplogComparator
    implements Comparator<TrackedReference<Hoplog>> {
        @Override
        public int compare(TrackedReference<Hoplog> o1, TrackedReference<Hoplog> o2) {
            return o1.get().compareTo(o2.get());
        }

        public static int compareByName(String name1, String name2) {
            AbstractHoplog.HoplogDescriptor hd1 = new AbstractHoplog.HoplogDescriptor(name1);
            AbstractHoplog.HoplogDescriptor hd2 = new AbstractHoplog.HoplogDescriptor(name2);
            return hd1.compareTo(hd2);
        }
    }
}

