/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.QueuedPersistentEvent;
import com.gemstone.gemfire.cache.hdfs.internal.UnsortedHoplogPersistedEvent;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UnsortedHDFSQueuePersistedEvent
extends UnsortedHoplogPersistedEvent
implements QueuedPersistentEvent {
    protected byte[] keyBytes = null;

    public UnsortedHDFSQueuePersistedEvent(HDFSGatewayEventImpl in) throws IOException, ClassNotFoundException {
        super(in.getValue(), in.getOperation(), in.getValueIsObject(), in.getPossibleDuplicate(), in.getVersionTimeStamp() == 0L ? in.getCreationTime() : in.getVersionTimeStamp());
        this.keyBytes = in.getSerializedKey();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeByteArray(this.keyBytes, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.keyBytes = DataSerializer.readByteArray(in);
    }

    @Override
    public void toHoplogEventBytes(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public byte[] getRawKey() {
        return this.keyBytes;
    }

    public static int getSizeInBytes(int keySize, int valueSize, VersionTag versionTag) {
        int size = UnsortedHoplogPersistedEvent.getSizeInBytes(keySize, valueSize, versionTag);
        return size += keySize;
    }
}

