/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SortedHoplogPersistedEvent
extends PersistedEventImpl {
    protected VersionTag versionTag;
    protected long timestamp;

    public SortedHoplogPersistedEvent(Object valueObject, Operation operation, byte valueIsObject, boolean possibleDuplicate, VersionTag tag, long timestamp) throws ClassNotFoundException, IOException {
        super(valueObject, operation, valueIsObject, possibleDuplicate, tag != null);
        this.versionTag = tag;
        this.timestamp = timestamp;
    }

    public SortedHoplogPersistedEvent() {
    }

    @Override
    public long getTimstamp() {
        return this.versionTag == null ? this.timestamp : this.versionTag.getVersionTimeStamp();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        if (this.versionTag == null) {
            out.writeLong(this.timestamp);
        } else {
            DataSerializer.writeObject(this.versionTag, out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        if (this.hasVersionTag()) {
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        } else {
            this.timestamp = in.readLong();
        }
    }

    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    public static SortedHoplogPersistedEvent fromBytes(byte[] val) throws IOException, ClassNotFoundException {
        ByteArrayDataInput in = new ByteArrayDataInput();
        in.initialize(val, null);
        SortedHoplogPersistedEvent event = new SortedHoplogPersistedEvent();
        event.fromData(in);
        return event;
    }

    @Override
    public void copy(PersistedEventImpl usersValue) {
        super.copy(usersValue);
        this.versionTag = ((SortedHoplogPersistedEvent)usersValue).versionTag;
        this.timestamp = ((SortedHoplogPersistedEvent)usersValue).timestamp;
    }

    public static int getSizeInBytes(int keySize, int valueSize, VersionTag versionTag) {
        int size = PersistedEventImpl.getSizeInBytes(keySize, valueSize, versionTag);
        size = versionTag != null ? (size += versionTag.getSizeInBytes()) : (size += 8);
        return size;
    }
}

