/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class PersistedEventImpl {
    protected Operation op = Operation.UPDATE;
    protected Object valueObject;
    protected byte flags;
    private static final byte VALUE_IS_BYTE_ARRAY = 1;
    private static final byte VALUE_IS_OBJECT = 2;
    private static final byte POSSIBLE_DUPLICATE = 4;
    private static final byte HAS_VERSION_TAG = 8;

    public PersistedEventImpl() {
    }

    public PersistedEventImpl(Object value, Operation op, byte valueIsObject, boolean isPossibleDuplicate, boolean hasVersionTag) throws IOException, ClassNotFoundException {
        this.op = op;
        this.valueObject = value;
        this.setFlag((byte)1, valueIsObject == 0);
        this.setFlag((byte)2, valueIsObject == 1);
        this.setFlag((byte)4, isPossibleDuplicate);
        this.setFlag((byte)8, hasVersionTag);
    }

    private void setFlag(byte flag, boolean set) {
        this.flags = (byte)(set ? this.flags | flag : this.flags & ~flag);
    }

    private boolean getFlag(byte flag) {
        return (this.flags & flag) != 0;
    }

    public void toData(DataOutput out) throws IOException {
        out.writeByte(this.op.ordinal);
        out.writeByte(this.flags);
        if (this.getFlag((byte)1)) {
            DataSerializer.writeByteArray((byte[])this.valueObject, out);
        } else if (this.getFlag((byte)2)) {
            if (this.valueObject instanceof CachedDeserializable) {
                CachedDeserializable cd = (CachedDeserializable)this.valueObject;
                DataSerializer.writeObjectAsByteArray(cd.getValue(), out);
            } else {
                DataSerializer.writeObjectAsByteArray(this.valueObject, out);
            }
        } else {
            DataSerializer.writeObject(this.valueObject, out);
        }
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        byte[] newValueBytes;
        this.op = Operation.fromOrdinal(in.readByte());
        this.flags = in.readByte();
        this.valueObject = this.getFlag((byte)1) ? (Object)DataSerializer.readByteArray(in) : (this.getFlag((byte)2) ? ((newValueBytes = DataSerializer.readByteArray(in)) == null ? null : (CachedDeserializableFactory.preferObject() ? EntryEventImpl.deserialize(newValueBytes) : CachedDeserializableFactory.create(newValueBytes))) : DataSerializer.readObject(in));
    }

    public abstract long getTimstamp();

    protected boolean hasVersionTag() {
        return this.getFlag((byte)8);
    }

    public Operation getOperation() {
        return this.op;
    }

    public Object getValue() {
        return this.valueObject;
    }

    public boolean isPossibleDuplicate() {
        return this.getFlag((byte)4);
    }

    public Object getDeserializedValue() throws IOException, ClassNotFoundException {
        Object retVal = null;
        retVal = this.getFlag((byte)1) ? this.valueObject : (this.getFlag((byte)2) ? (this.valueObject instanceof CachedDeserializable ? ((CachedDeserializable)this.valueObject).getDeserializedForReading() : this.valueObject) : this.valueObject);
        return retVal;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(PersistedEventImpl.class.getSimpleName());
        str.append("@").append(System.identityHashCode(this)).append(" op:").append(this.op).append(" valueObject:").append(this.valueObject).append(" isPossibleDuplicate:").append(this.getFlag((byte)4));
        return str.toString();
    }

    public void copy(PersistedEventImpl usersValue) {
        this.op = usersValue.op;
        this.valueObject = usersValue.valueObject;
        this.flags = usersValue.flags;
    }

    public static int getSizeInBytes(int keySize, int valueSize, VersionTag versionTag) {
        int size = 0;
        size += valueSize;
        return size += 2;
    }
}

