/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.hdfs.internal.FailureTracker;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.QueuedPersistentEvent;
import com.gemstone.gemfire.cache.hdfs.internal.UnsortedHDFSQueuePersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogOrganizer;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HDFSWriteOnlyStoreEventListener
implements AsyncEventListener {
    private final LogWriterI18n logger;
    private volatile boolean senderStopped = false;
    private final FailureTracker failureTracker = new FailureTracker(10L, 60000L, 1.5f);

    public HDFSWriteOnlyStoreEventListener(LogWriterI18n logger) {
        this.logger = logger;
    }

    @Override
    public void close() {
        this.senderStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processEvents(List<AsyncEvent> events) {
        boolean bl;
        if (Hoplog.NOP_WRITE) {
            return true;
        }
        if (this.logger.fineEnabled()) {
            this.logger.fine("HDFSWriteOnlyStoreEventListener: A total of " + events.size() + " events are sent from GemFire to persist on HDFS");
        }
        boolean success = false;
        try {
            this.failureTracker.sleepIfRetry();
            GatewaySenderEventImpl hdfsEvent = null;
            int previousBucketId = -1;
            BatchManager bm = null;
            for (AsyncEvent asyncEvent : events) {
                if (this.senderStopped) {
                    if (this.logger.fineEnabled()) {
                        this.logger.fine("HDFSWriteOnlyStoreEventListener.processEvents: Cache is closing down. Ignoring the batch of data.");
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                hdfsEvent = (HDFSGatewayEventImpl)asyncEvent;
                if (previousBucketId != hdfsEvent.getBucketId()) {
                    if (previousBucketId != -1) {
                        this.persistBatch(bm, previousBucketId);
                    }
                    previousBucketId = hdfsEvent.getBucketId();
                    bm = new BatchManager();
                }
                bm.addEvent((HDFSGatewayEventImpl)hdfsEvent);
            }
            try {
                this.persistBatch(bm, hdfsEvent.getBucketId());
            }
            catch (BucketMovedException e) {
                this.logger.fine("Batch could not be written to HDFS as the bucket moved. bucket id: " + hdfsEvent.getBucketId() + " Exception: " + e);
                boolean bl3 = false;
                this.failureTracker.record(success);
                return bl3;
            }
            success = true;
        }
        catch (IOException e) {
            this.logger.warning(LocalizedStrings.HOPLOG_FLUSH_FOR_BATCH_FAILED, e);
            bl = false;
            return bl;
        }
        catch (ClassNotFoundException e) {
            this.logger.warning(LocalizedStrings.HOPLOG_FLUSH_FOR_BATCH_FAILED, e);
            bl = false;
            return bl;
        }
        catch (CacheClosedException e) {
            if (this.logger.fineEnabled()) {
                this.logger.fine(e);
            }
            bl = false;
            return bl;
        }
        catch (ForceReattemptException e) {
            if (this.logger.fineEnabled()) {
                this.logger.fine(e);
            }
            bl = false;
            return bl;
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        finally {
            this.failureTracker.record(success);
        }
        return true;
    }

    private void persistBatch(BatchManager bm, int bucketId) throws IOException, ForceReattemptException {
        Iterator<Map.Entry<LocalRegion, ArrayList<QueuedPersistentEvent>>> eventsPerRegion = bm.iterator();
        HoplogOrganizer bucketOrganizer = null;
        while (eventsPerRegion.hasNext()) {
            Map.Entry<LocalRegion, ArrayList<QueuedPersistentEvent>> eventsForARegion = eventsPerRegion.next();
            bucketOrganizer = this.getOrganizer((PartitionedRegion)eventsForARegion.getKey(), bucketId);
            if (bucketOrganizer == null) {
                throw new BucketMovedException("Bucket moved. BucketID: " + bucketId + "  HdfsRegion: " + eventsForARegion.getKey().getName());
            }
            bucketOrganizer.flush(eventsForARegion.getValue().iterator(), eventsForARegion.getValue().size());
            if (!this.logger.fineEnabled()) continue;
            this.logger.fine("Batch written to HDFS of size " + eventsForARegion.getValue().size() + " for region " + eventsForARegion.getKey());
        }
    }

    private HoplogOrganizer getOrganizer(PartitionedRegion region, int bucketId) {
        BucketRegion br = region.getDataStore().getLocalBucketById(bucketId);
        if (br == null) {
            throw new BucketMovedException("Bucket region is no longer available. BucketId: " + bucketId + " HdfsRegion: " + region.getName());
        }
        return br.getHoplogOrganizer();
    }

    private class BatchManager
    implements Iterable<Map.Entry<LocalRegion, ArrayList<QueuedPersistentEvent>>> {
        private HashMap<LocalRegion, ArrayList<QueuedPersistentEvent>> regionBatches = new HashMap();

        private BatchManager() {
        }

        public void addEvent(HDFSGatewayEventImpl hdfsEvent) throws IOException, ClassNotFoundException {
            LocalRegion region = (LocalRegion)hdfsEvent.getRegion();
            ArrayList<QueuedPersistentEvent> regionList = this.regionBatches.get(region);
            if (regionList == null) {
                regionList = new ArrayList();
                this.regionBatches.put(region, regionList);
            }
            regionList.add(new UnsortedHDFSQueuePersistedEvent(hdfsEvent));
        }

        @Override
        public Iterator<Map.Entry<LocalRegion, ArrayList<QueuedPersistentEvent>>> iterator() {
            return this.regionBatches.entrySet().iterator();
        }
    }
}

