/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreMutator;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreConfigHolder;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class HDFSStoreMutatorImpl
implements HDFSStoreMutator {
    private HDFSStoreConfigHolder configHolder;
    private Boolean autoCompact;
    private Boolean autoMajorCompact;

    public HDFSStoreMutatorImpl() {
        this.configHolder = new HDFSStoreConfigHolder();
        this.configHolder.resetDefaultValues();
    }

    public HDFSStoreMutatorImpl(HDFSStore store) {
        this.configHolder = new HDFSStoreConfigHolder(store);
    }

    @Override
    public HDFSStoreMutator setWriteOnlyFileRolloverSize(int maxFileSize) {
        this.configHolder.setWriteOnlyFileRolloverSize(maxFileSize);
        return this;
    }

    @Override
    public int getWriteOnlyFileRolloverSize() {
        return this.configHolder.getWriteOnlyFileRolloverSize();
    }

    @Override
    public HDFSStoreMutator setWriteOnlyFileRolloverInterval(int count) {
        this.configHolder.setWriteOnlyFileRolloverInterval(count);
        return this;
    }

    @Override
    public int getWriteOnlyFileRolloverInterval() {
        return this.configHolder.getWriteOnlyFileRolloverInterval();
    }

    @Override
    public HDFSStoreMutator setMinorCompaction(boolean auto) {
        this.autoCompact = auto;
        this.configHolder.setMinorCompaction(auto);
        return null;
    }

    @Override
    public Boolean getMinorCompaction() {
        return this.autoCompact;
    }

    @Override
    public HDFSStoreMutator setMinorCompactionThreads(int count) {
        this.configHolder.setMinorCompactionThreads(count);
        return this;
    }

    @Override
    public int getMinorCompactionThreads() {
        return this.configHolder.getMinorCompactionThreads();
    }

    @Override
    public HDFSStoreMutator setMajorCompaction(boolean auto) {
        this.autoMajorCompact = auto;
        this.configHolder.setMajorCompaction(auto);
        return this;
    }

    @Override
    public Boolean getMajorCompaction() {
        return this.autoMajorCompact;
    }

    @Override
    public HDFSStoreMutator setMajorCompactionInterval(int count) {
        this.configHolder.setMajorCompactionInterval(count);
        return this;
    }

    @Override
    public int getMajorCompactionInterval() {
        return this.configHolder.getMajorCompactionInterval();
    }

    @Override
    public HDFSStoreMutator setMajorCompactionThreads(int count) {
        this.configHolder.setMajorCompactionThreads(count);
        return this;
    }

    @Override
    public int getMajorCompactionThreads() {
        return this.configHolder.getMajorCompactionThreads();
    }

    @Override
    public HDFSStoreMutator setInputFileSizeMax(int size) {
        this.configHolder.setInputFileSizeMax(size);
        return this;
    }

    @Override
    public int getInputFileSizeMax() {
        return this.configHolder.getInputFileSizeMax();
    }

    @Override
    public HDFSStoreMutator setInputFileCountMin(int count) {
        this.configHolder.setInputFileCountMin(count);
        return this;
    }

    @Override
    public int getInputFileCountMin() {
        return this.configHolder.getInputFileCountMin();
    }

    @Override
    public HDFSStoreMutator setInputFileCountMax(int count) {
        this.configHolder.setInputFileCountMax(count);
        return this;
    }

    @Override
    public int getInputFileCountMax() {
        return this.configHolder.getInputFileCountMax();
    }

    @Override
    public HDFSStoreMutator setPurgeInterval(int interval) {
        this.configHolder.setPurgeInterval(interval);
        return this;
    }

    @Override
    public int getPurgeInterval() {
        return this.configHolder.getPurgeInterval();
    }

    @Override
    public int getBatchSize() {
        return this.configHolder.batchSize;
    }

    @Override
    public HDFSStoreMutator setBatchSize(int size) {
        this.configHolder.setBatchSize(size);
        return this;
    }

    @Override
    public int getBatchInterval() {
        return this.configHolder.batchIntervalMillis;
    }

    @Override
    public HDFSStoreMutator setBatchInterval(int interval) {
        this.configHolder.setBatchInterval(interval);
        return this;
    }

    public static void assertIsPositive(String name, int count) {
        if (count < 1) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_POSITIVE_NUMBER_AND_THE_VALUE_GIVEN_1_IS_NOT_ACCEPTABLE.toLocalizedString(name, count));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HDFSStoreMutatorImpl [");
        if (this.configHolder != null) {
            builder.append("configHolder=");
            builder.append(this.configHolder);
            builder.append(", ");
        }
        if (this.autoCompact != null) {
            builder.append("MinorCompaction=");
            builder.append(this.autoCompact);
            builder.append(", ");
        }
        if (this.getMajorCompaction() != null) {
            builder.append("autoMajorCompaction=");
            builder.append(this.getMajorCompaction());
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }
}

