/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache.hdfs.StoreExistsException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreConfigHolder;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class HDFSStoreCreation
implements HDFSStoreFactory {
    protected HDFSStoreConfigHolder configHolder;

    public HDFSStoreCreation() {
        this(null);
    }

    public HDFSStoreCreation(HDFSStoreCreation config) {
        this.configHolder = new HDFSStoreConfigHolder(config == null ? null : config.configHolder);
    }

    @Override
    public HDFSStoreFactory setName(String name) {
        this.configHolder.setName(name);
        return this;
    }

    @Override
    public HDFSStoreFactory setNameNodeURL(String namenodeURL) {
        this.configHolder.setNameNodeURL(namenodeURL);
        return this;
    }

    @Override
    public HDFSStoreFactory setHomeDir(String homeDir) {
        this.configHolder.setHomeDir(homeDir);
        return this;
    }

    @Override
    public HDFSStoreFactory setHDFSClientConfigFile(String clientConfigFile) {
        this.configHolder.setHDFSClientConfigFile(clientConfigFile);
        return this;
    }

    @Override
    public HDFSStoreFactory setBlockCacheSize(float percentage) {
        this.configHolder.setBlockCacheSize(percentage);
        return this;
    }

    @Override
    public HDFSStoreFactory setWriteOnlyFileRolloverSize(int maxFileSize) {
        this.configHolder.setWriteOnlyFileRolloverSize(maxFileSize);
        return this;
    }

    @Override
    public HDFSStoreFactory setWriteOnlyFileRolloverInterval(int count) {
        this.configHolder.setWriteOnlyFileRolloverInterval(count);
        return this;
    }

    @Override
    public HDFSStoreFactory setMinorCompaction(boolean auto) {
        this.configHolder.setMinorCompaction(auto);
        return this;
    }

    @Override
    public HDFSStoreFactory setMinorCompactionThreads(int count) {
        this.configHolder.setMinorCompactionThreads(count);
        return this;
    }

    @Override
    public HDFSStoreFactory setMajorCompaction(boolean auto) {
        this.configHolder.setMajorCompaction(auto);
        return this;
    }

    @Override
    public HDFSStoreFactory setMajorCompactionInterval(int count) {
        this.configHolder.setMajorCompactionInterval(count);
        return this;
    }

    @Override
    public HDFSStoreFactory setMajorCompactionThreads(int count) {
        this.configHolder.setMajorCompactionThreads(count);
        return this;
    }

    @Override
    public HDFSStoreFactory setInputFileSizeMax(int size) {
        this.configHolder.setInputFileSizeMax(size);
        return this;
    }

    @Override
    public HDFSStoreFactory setInputFileCountMin(int count) {
        this.configHolder.setInputFileCountMin(count);
        return this;
    }

    @Override
    public HDFSStoreFactory setInputFileCountMax(int count) {
        this.configHolder.setInputFileCountMax(count);
        return this;
    }

    @Override
    public HDFSStoreFactory setPurgeInterval(int interval) {
        this.configHolder.setPurgeInterval(interval);
        return this;
    }

    @Override
    public HDFSStoreFactory setDiskStoreName(String name) {
        this.configHolder.setDiskStoreName(name);
        return this;
    }

    @Override
    public HDFSStoreFactory setMaxMemory(int memory) {
        this.configHolder.setMaxMemory(memory);
        return this;
    }

    @Override
    public HDFSStoreFactory setBatchInterval(int intervalMillis) {
        this.configHolder.setBatchInterval(intervalMillis);
        return this;
    }

    @Override
    public HDFSStoreFactory setBatchSize(int size) {
        this.configHolder.setBatchSize(size);
        return this;
    }

    @Override
    public HDFSStoreFactory setBufferPersistent(boolean isPersistent) {
        this.configHolder.setBufferPersistent(isPersistent);
        return this;
    }

    @Override
    public HDFSStoreFactory setSynchronousDiskWrite(boolean isSynchronous) {
        this.configHolder.setSynchronousDiskWrite(isSynchronous);
        return this;
    }

    @Override
    public HDFSStoreFactory setDispatcherThreads(int dispatcherThreads) {
        this.configHolder.setDispatcherThreads(dispatcherThreads);
        return this;
    }

    @Override
    public HDFSStore create(String name) throws GemFireConfigException, StoreExistsException {
        throw new UnsupportedOperationException();
    }

    public static void assertIsPositive(String name, int count) {
        if (count < 1) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_POSITIVE_NUMBER_AND_THE_VALUE_GIVEN_1_IS_NOT_ACCEPTABLE.toLocalizedString(name, count));
        }
    }
}

