/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreMutator;
import com.gemstone.gemfire.cache.hdfs.StoreExistsException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.Serializable;
import org.apache.logging.log4j.Logger;

public class HDFSStoreConfigHolder
implements HDFSStore,
HDFSStoreFactory,
Serializable {
    private String name = null;
    private String namenodeURL = null;
    private String homeDir = "gemfire";
    private String clientConfigFile = null;
    private float blockCacheSize = 10.0f;
    private int maxFileSize = 256;
    private int fileRolloverInterval = 3600;
    protected boolean isAutoCompact = true;
    protected boolean autoMajorCompact = true;
    protected int maxConcurrency = 10;
    protected int majorCompactionConcurrency = 2;
    protected int majorCompactionIntervalMins = 720;
    protected int maxInputFileSizeMB = 512;
    protected int maxInputFileCount = 10;
    protected int minInputFileCount = 4;
    protected int oldFileCleanupIntervalMins = 30;
    protected int batchSize = 32;
    protected int batchIntervalMillis = 60000;
    protected int maximumQueueMemory = 100;
    protected boolean isPersistenceEnabled = false;
    protected String diskStoreName = null;
    protected boolean diskSynchronous = true;
    protected int dispatcherThreads = 5;
    private static final Logger logger = LogService.getLogger();
    protected final String logPrefix = "<" + this.getName() + "> ";

    public HDFSStoreConfigHolder() {
        this(null);
    }

    public HDFSStoreConfigHolder(HDFSStore config) {
        if (config == null) {
            return;
        }
        this.name = config.getName();
        this.namenodeURL = config.getNameNodeURL();
        this.homeDir = config.getHomeDir();
        this.clientConfigFile = config.getHDFSClientConfigFile();
        this.blockCacheSize = config.getBlockCacheSize();
        this.maxFileSize = config.getWriteOnlyFileRolloverSize();
        this.fileRolloverInterval = config.getWriteOnlyFileRolloverInterval();
        this.isAutoCompact = config.getMinorCompaction();
        this.maxConcurrency = config.getMinorCompactionThreads();
        this.autoMajorCompact = config.getMajorCompaction();
        this.majorCompactionConcurrency = config.getMajorCompactionThreads();
        this.majorCompactionIntervalMins = config.getMajorCompactionInterval();
        this.maxInputFileSizeMB = config.getInputFileSizeMax();
        this.maxInputFileCount = config.getInputFileCountMax();
        this.minInputFileCount = config.getInputFileCountMin();
        this.oldFileCleanupIntervalMins = config.getPurgeInterval();
        this.batchSize = config.getBatchSize();
        this.batchIntervalMillis = config.getBatchInterval();
        this.maximumQueueMemory = config.getMaxMemory();
        this.isPersistenceEnabled = config.getBufferPersistent();
        this.diskStoreName = config.getDiskStoreName();
        this.diskSynchronous = config.getSynchronousDiskWrite();
        this.dispatcherThreads = config.getDispatcherThreads();
    }

    public void resetDefaultValues() {
        this.name = null;
        this.namenodeURL = null;
        this.homeDir = null;
        this.clientConfigFile = null;
        this.blockCacheSize = -1.0f;
        this.maxFileSize = -1;
        this.fileRolloverInterval = -1;
        this.isAutoCompact = false;
        this.maxConcurrency = -1;
        this.maxInputFileSizeMB = -1;
        this.maxInputFileCount = -1;
        this.minInputFileCount = -1;
        this.oldFileCleanupIntervalMins = -1;
        this.autoMajorCompact = false;
        this.majorCompactionConcurrency = -1;
        this.majorCompactionIntervalMins = -1;
        this.batchSize = -1;
        this.batchIntervalMillis = -1;
        this.maximumQueueMemory = -1;
        this.isPersistenceEnabled = false;
        this.diskStoreName = null;
        this.diskSynchronous = false;
        this.dispatcherThreads = -1;
    }

    public void copyFrom(HDFSStoreMutator mutator) {
        if (mutator.getWriteOnlyFileRolloverInterval() >= 0) {
            this.logAttrMutation("fileRolloverInterval", mutator.getWriteOnlyFileRolloverInterval());
            this.setWriteOnlyFileRolloverInterval(mutator.getWriteOnlyFileRolloverInterval());
        }
        if (mutator.getWriteOnlyFileRolloverSize() >= 0) {
            this.logAttrMutation("MaxFileSize", mutator.getWriteOnlyFileRolloverInterval());
            this.setWriteOnlyFileRolloverSize(mutator.getWriteOnlyFileRolloverSize());
        }
        if (mutator.getMinorCompaction() != null) {
            this.logAttrMutation("MinorCompaction", mutator.getMinorCompaction());
            this.setMinorCompaction(mutator.getMinorCompaction());
        }
        if (mutator.getMinorCompactionThreads() >= 0) {
            this.logAttrMutation("MaxThreads", mutator.getMinorCompactionThreads());
            this.setMinorCompactionThreads(mutator.getMinorCompactionThreads());
        }
        if (mutator.getMajorCompactionInterval() > -1) {
            this.logAttrMutation("MajorCompactionIntervalMins", mutator.getMajorCompactionInterval());
            this.setMajorCompactionInterval(mutator.getMajorCompactionInterval());
        }
        if (mutator.getMajorCompactionThreads() >= 0) {
            this.logAttrMutation("MajorCompactionMaxThreads", mutator.getMajorCompactionThreads());
            this.setMajorCompactionThreads(mutator.getMajorCompactionThreads());
        }
        if (mutator.getMajorCompaction() != null) {
            this.logAttrMutation("AutoMajorCompaction", mutator.getMajorCompaction());
            this.setMajorCompaction(mutator.getMajorCompaction());
        }
        if (mutator.getInputFileCountMax() >= 0) {
            this.logAttrMutation("maxInputFileCount", mutator.getInputFileCountMax());
            this.setInputFileCountMax(mutator.getInputFileCountMax());
        }
        if (mutator.getInputFileSizeMax() >= 0) {
            this.logAttrMutation("MaxInputFileSizeMB", mutator.getInputFileSizeMax());
            this.setInputFileSizeMax(mutator.getInputFileSizeMax());
        }
        if (mutator.getInputFileCountMin() >= 0) {
            this.logAttrMutation("MinInputFileCount", mutator.getInputFileCountMin());
            this.setInputFileCountMin(mutator.getInputFileCountMin());
        }
        if (mutator.getPurgeInterval() >= 0) {
            this.logAttrMutation("OldFilesCleanupIntervalMins", mutator.getPurgeInterval());
            this.setPurgeInterval(mutator.getPurgeInterval());
        }
        if (mutator.getBatchSize() >= 0) {
            this.logAttrMutation("batchSizeMB", mutator.getWriteOnlyFileRolloverInterval());
            this.setBatchSize(mutator.getBatchSize());
        }
        if (mutator.getBatchInterval() >= 0) {
            this.logAttrMutation("batchTimeInterval", mutator.getWriteOnlyFileRolloverInterval());
            this.setBatchInterval(mutator.getBatchInterval());
        }
    }

    void logAttrMutation(String name, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Alter " + name + ":" + value, new Object[]{this.logPrefix});
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDFSStoreFactory setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getNameNodeURL() {
        return this.namenodeURL;
    }

    @Override
    public HDFSStoreFactory setNameNodeURL(String namenodeURL) {
        this.namenodeURL = namenodeURL;
        return this;
    }

    @Override
    public String getHomeDir() {
        return this.homeDir;
    }

    @Override
    public HDFSStoreFactory setHomeDir(String homeDir) {
        this.homeDir = homeDir;
        return this;
    }

    @Override
    public String getHDFSClientConfigFile() {
        return this.clientConfigFile;
    }

    @Override
    public HDFSStoreFactory setHDFSClientConfigFile(String clientConfigFile) {
        this.clientConfigFile = clientConfigFile;
        return this;
    }

    @Override
    public HDFSStoreFactory setBlockCacheSize(float percentage) {
        if (percentage < 0.0f || percentage > 100.0f) {
            throw new IllegalArgumentException("Block cache size must be between 0 and 100, inclusive");
        }
        this.blockCacheSize = percentage;
        return this;
    }

    @Override
    public float getBlockCacheSize() {
        return this.blockCacheSize;
    }

    @Override
    public HDFSStoreFactory setWriteOnlyFileRolloverSize(int maxFileSize) {
        HDFSStoreConfigHolder.assertIsPositive("write-only-file-rollover-interval", maxFileSize);
        this.maxFileSize = maxFileSize;
        return this;
    }

    @Override
    public int getWriteOnlyFileRolloverSize() {
        return this.maxFileSize;
    }

    @Override
    public HDFSStoreFactory setWriteOnlyFileRolloverInterval(int count) {
        HDFSStoreConfigHolder.assertIsPositive("file-rollover-time-secs", count);
        this.fileRolloverInterval = count;
        return this;
    }

    @Override
    public int getWriteOnlyFileRolloverInterval() {
        return this.fileRolloverInterval;
    }

    @Override
    public boolean getMinorCompaction() {
        return this.isAutoCompact;
    }

    @Override
    public HDFSStoreFactory setMinorCompaction(boolean auto) {
        this.isAutoCompact = auto;
        return this;
    }

    @Override
    public HDFSStoreFactory setMinorCompactionThreads(int count) {
        HDFSStoreConfigHolder.assertIsPositive("minor-compaction-threads", count);
        this.maxConcurrency = count;
        return this;
    }

    @Override
    public int getMinorCompactionThreads() {
        return this.maxConcurrency;
    }

    @Override
    public HDFSStoreFactory setMajorCompaction(boolean auto) {
        this.autoMajorCompact = auto;
        return this;
    }

    @Override
    public boolean getMajorCompaction() {
        return this.autoMajorCompact;
    }

    @Override
    public HDFSStoreFactory setMajorCompactionInterval(int count) {
        HDFSStoreCreation.assertIsPositive("major-compaction-interval", count);
        this.majorCompactionIntervalMins = count;
        return this;
    }

    @Override
    public int getMajorCompactionInterval() {
        return this.majorCompactionIntervalMins;
    }

    @Override
    public HDFSStoreFactory setMajorCompactionThreads(int count) {
        HDFSStoreCreation.assertIsPositive("major-compaction-threads", count);
        this.majorCompactionConcurrency = count;
        return this;
    }

    @Override
    public int getMajorCompactionThreads() {
        return this.majorCompactionConcurrency;
    }

    @Override
    public HDFSStoreFactory setInputFileSizeMax(int size) {
        HDFSStoreCreation.assertIsPositive("HDFS_COMPACTION_MAX_INPUT_FILE_SIZE_MB", size);
        this.maxInputFileSizeMB = size;
        return this;
    }

    @Override
    public int getInputFileSizeMax() {
        return this.maxInputFileSizeMB;
    }

    @Override
    public HDFSStoreFactory setInputFileCountMin(int count) {
        HDFSStoreCreation.assertIsPositive("HDFS_COMPACTION_MIN_INPUT_FILE_COUNT", count);
        this.minInputFileCount = count;
        return this;
    }

    @Override
    public int getInputFileCountMin() {
        return this.minInputFileCount;
    }

    @Override
    public HDFSStoreFactory setInputFileCountMax(int count) {
        HDFSStoreCreation.assertIsPositive("HDFS_COMPACTION_MAX_INPUT_FILE_COUNT", count);
        this.maxInputFileCount = count;
        return this;
    }

    @Override
    public int getInputFileCountMax() {
        return this.maxInputFileCount;
    }

    @Override
    public int getPurgeInterval() {
        return this.oldFileCleanupIntervalMins;
    }

    @Override
    public HDFSStoreFactory setPurgeInterval(int interval) {
        HDFSStoreConfigHolder.assertIsPositive("purge-interval", interval);
        this.oldFileCleanupIntervalMins = interval;
        return this;
    }

    protected void validate() {
        if (this.minInputFileCount > this.maxInputFileCount) {
            throw new IllegalArgumentException(LocalizedStrings.HOPLOG_MIN_IS_MORE_THAN_MAX.toLocalizedString("HDFS_COMPACTION_MIN_INPUT_FILE_COUNT", this.minInputFileCount, "HDFS_COMPACTION_MAX_INPUT_FILE_COUNT", this.maxInputFileCount));
        }
    }

    @Override
    public HDFSStore create(String name) throws GemFireConfigException, StoreExistsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    public static void assertIsPositive(String name, int count) {
        if (count < 1) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_POSITIVE_NUMBER_AND_THE_VALUE_GIVEN_1_IS_NOT_ACCEPTABLE.toLocalizedString(name, count));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HDFSStoreConfigHolder@");
        builder.append(System.identityHashCode(this));
        builder.append(" [");
        this.appendStrProp(builder, this.name, "name");
        this.appendStrProp(builder, this.namenodeURL, "namenodeURL");
        this.appendStrProp(builder, this.homeDir, "homeDir");
        this.appendStrProp(builder, this.clientConfigFile, "clientConfigFile");
        if (this.blockCacheSize > -1.0f) {
            builder.append("blockCacheSize=");
            builder.append(this.blockCacheSize);
            builder.append(", ");
        }
        this.appendIntProp(builder, this.maxFileSize, "maxFileSize");
        this.appendIntProp(builder, this.fileRolloverInterval, "fileRolloverInterval");
        this.appendBoolProp(builder, this.isAutoCompact, "isAutoCompact");
        this.appendBoolProp(builder, this.autoMajorCompact, "autoMajorCompact");
        this.appendIntProp(builder, this.maxConcurrency, "maxConcurrency");
        this.appendIntProp(builder, this.majorCompactionConcurrency, "majorCompactionConcurrency");
        this.appendIntProp(builder, this.majorCompactionIntervalMins, "majorCompactionIntervalMins");
        this.appendIntProp(builder, this.maxInputFileSizeMB, "maxInputFileSizeMB");
        this.appendIntProp(builder, this.maxInputFileCount, "maxInputFileCount");
        this.appendIntProp(builder, this.minInputFileCount, "minInputFileCount");
        this.appendIntProp(builder, this.oldFileCleanupIntervalMins, "oldFileCleanupIntervalMins");
        this.appendIntProp(builder, this.batchSize, "batchSize");
        this.appendIntProp(builder, this.batchIntervalMillis, "batchInterval");
        this.appendIntProp(builder, this.maximumQueueMemory, "maximumQueueMemory");
        this.appendIntProp(builder, this.dispatcherThreads, "dispatcherThreads");
        this.appendBoolProp(builder, this.isPersistenceEnabled, "isPersistenceEnabled");
        this.appendStrProp(builder, this.diskStoreName, "diskStoreName");
        this.appendBoolProp(builder, this.diskSynchronous, "diskSynchronous");
        builder.append("]");
        return builder.toString();
    }

    private void appendStrProp(StringBuilder builder, String value, String name) {
        if (value != null) {
            builder.append(name + "=");
            builder.append(value);
            builder.append(", ");
        }
    }

    private void appendIntProp(StringBuilder builder, int value, String name) {
        if (value > -1) {
            builder.append(name + "=");
            builder.append(value);
            builder.append(", ");
        }
    }

    private void appendBoolProp(StringBuilder builder, boolean value, String name) {
        builder.append(name + "=");
        builder.append(value);
        builder.append(", ");
    }

    @Override
    public HDFSStoreMutator createHdfsStoreMutator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HDFSStore alter(HDFSStoreMutator mutator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    @Override
    public HDFSStoreFactory setDiskStoreName(String name) {
        this.diskStoreName = name;
        return this;
    }

    @Override
    public int getBatchInterval() {
        return this.batchIntervalMillis;
    }

    @Override
    public HDFSStoreFactory setBatchInterval(int intervalMillis) {
        this.batchIntervalMillis = intervalMillis;
        return this;
    }

    @Override
    public boolean getBufferPersistent() {
        return this.isPersistenceEnabled;
    }

    @Override
    public HDFSStoreFactory setBufferPersistent(boolean isPersistent) {
        this.isPersistenceEnabled = isPersistent;
        return this;
    }

    @Override
    public int getDispatcherThreads() {
        return this.dispatcherThreads;
    }

    @Override
    public HDFSStoreFactory setDispatcherThreads(int dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
        return this;
    }

    @Override
    public int getMaxMemory() {
        return this.maximumQueueMemory;
    }

    @Override
    public HDFSStoreFactory setMaxMemory(int memory) {
        this.maximumQueueMemory = memory;
        return this;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public HDFSStoreFactory setBatchSize(int size) {
        this.batchSize = size;
        return this;
    }

    @Override
    public boolean getSynchronousDiskWrite() {
        return this.diskSynchronous;
    }

    @Override
    public HDFSStoreFactory setSynchronousDiskWrite(boolean isSynchronous) {
        this.diskSynchronous = isSynchronous;
        return this;
    }
}

