/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSBucketRegionQueue;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HDFSParallelGatewaySenderQueue
extends ParallelGatewaySenderQueue {
    private int currentBucketIndex = 0;
    private int elementsPeekedAcrossBuckets = 0;
    private SystemTimer rollListTimer = null;
    public static final String ROLL_SORTED_LIST_TIME_INTERVAL_MS__PROP = "gemfire.ROLL_SORTED_LIST_TIME_INTERVAL_MS";
    private final int ROLL_SORTED_LIST_TIME_INTERVAL_MS = Integer.getInteger("gemfire.ROLL_SORTED_LIST_TIME_INTERVAL_MS", 3000);

    public HDFSParallelGatewaySenderQueue(AbstractGatewaySender sender, Set<Region> userPRs, int idx, int nDispatcher) {
        super(sender, userPRs, idx, nDispatcher);
        if (sender.getBucketSorted() && this.index == 0) {
            this.rollListTimer = new SystemTimer(sender.getCache().getDistributedSystem(), true);
            this.rollListTimer.scheduleAtFixedRate(new RollSortedListsTimerTask(), this.ROLL_SORTED_LIST_TIME_INTERVAL_MS, this.ROLL_SORTED_LIST_TIME_INTERVAL_MS);
        }
    }

    @Override
    public Object peek() throws InterruptedException, CacheException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.cancelRollListTimer();
    }

    private void cancelRollListTimer() {
        if (this.rollListTimer != null) {
            this.rollListTimer.cancel();
            this.rollListTimer = null;
        }
    }

    @Override
    public List peek(int batchSize, int timeToWait) throws InterruptedException, CacheException {
        HDFSBucketRegionQueue hrq;
        Integer bIdIndex;
        ArrayList<HDFSGatewayEventImpl> batch = new ArrayList<HDFSGatewayEventImpl>();
        int batchSizeInBytes = batchSize * 1024 * 1024;
        PartitionedRegion prQ = this.getRandomShadowPR();
        if (prQ == null || prQ.getLocalMaxMemory() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.blockProcesorThreadIfRequired();
            return batch;
        }
        ArrayList list = null;
        ArrayList<Integer> pbuckets = new ArrayList<Integer>(prQ.getDataStore().getAllLocalPrimaryBucketIds());
        ArrayList<Integer> buckets = new ArrayList<Integer>();
        for (Integer i : pbuckets) {
            if (i % this.nDispatcher != this.index) continue;
            buckets.add(i);
        }
        if (this.resetLastPeeked) {
            int previousBucketId = -1;
            boolean stillPrimary = true;
            Iterator iter = this.peekedEvents.iterator();
            while (iter.hasNext()) {
                HDFSGatewayEventImpl hdfsEvent = (HDFSGatewayEventImpl)iter.next();
                if (previousBucketId != hdfsEvent.getBucketId()) {
                    stillPrimary = buckets.contains(hdfsEvent.getBucketId());
                    previousBucketId = hdfsEvent.getBucketId();
                }
                if (stillPrimary) {
                    batch.add(hdfsEvent);
                    continue;
                }
                iter.remove();
            }
            this.resetLastPeeked = false;
        }
        if (buckets.size() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return batch;
        }
        if (this.sender.getBucketSorted()) {
            // empty if block
        }
        if ((bIdIndex = Integer.valueOf(this.getCurrentBucketIndex(buckets.size()))) == 0 && this.getAndresetElementsPeekedAcrossBuckets() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if ((hrq = (HDFSBucketRegionQueue)prQ.getDataStore().getLocalBucketById((Integer)buckets.get(bIdIndex))) == null) {
            return batch;
        }
        long entriesWaitingTobePeeked = hrq.totalEntries();
        if (entriesWaitingTobePeeked == 0L) {
            this.blockProcesorThreadIfRequired();
            return batch;
        }
        long currentTimeInMillis = System.currentTimeMillis();
        long bucketSizeInBytes = hrq.getQueueSizeInBytes();
        if (currentTimeInMillis - hrq.getLastPeekTimeInMillis() > (long)timeToWait || bucketSizeInBytes > (long)batchSizeInBytes || hrq.shouldDrainImmediately()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Peeking queue " + hrq.getId() + ": bucketSizeInBytes " + bucketSizeInBytes + ":  batchSizeInBytes" + batchSizeInBytes + ":  timeToWait" + timeToWait + ":  (currentTimeInMillis - hrq.getLastPeekTimeInMillis())" + (currentTimeInMillis - hrq.getLastPeekTimeInMillis()));
            }
            if ((list = this.peekAhead((Integer)buckets.get(bIdIndex), hrq)) != null && list.size() != 0) {
                for (Object object : list) {
                    batch.add((HDFSGatewayEventImpl)object);
                    this.peekedEvents.add((HDFSGatewayEventImpl)object);
                }
            }
        } else {
            this.blockProcesorThreadIfRequired();
        }
        if (logger.isDebugEnabled() && batch.size() > 0) {
            logger.debug(this + ":  Peeked a batch of " + batch.size() + " entries");
        }
        this.setElementsPeekedAcrossBuckets(batch.size());
        return batch;
    }

    private int getCurrentBucketIndex(int totalBuckets) {
        int retBucket = this.currentBucketIndex;
        if (retBucket >= totalBuckets) {
            this.currentBucketIndex = 0;
            retBucket = 0;
        }
        ++this.currentBucketIndex;
        return retBucket;
    }

    @Override
    public void remove(int batchSize) throws CacheException {
        int destroyed = 0;
        HDFSGatewayEventImpl event = null;
        if (this.peekedEvents.size() > 0) {
            event = (HDFSGatewayEventImpl)this.peekedEvents.remove();
        }
        while (event != null && destroyed < batchSize) {
            Region<?, ?> currentRegion = event.getRegion();
            int currentBucketId = event.getBucketId();
            int bucketId = event.getBucketId();
            ArrayList<HDFSGatewayEventImpl> listToDestroy = new ArrayList<HDFSGatewayEventImpl>();
            ArrayList<Object> destroyedSeqNum = new ArrayList<Object>();
            while (bucketId == currentBucketId) {
                listToDestroy.add(event);
                destroyedSeqNum.add(event.getShadowKey());
                if (this.peekedEvents.size() == 0 || ++destroyed >= batchSize) {
                    event = null;
                    break;
                }
                event = (HDFSGatewayEventImpl)this.peekedEvents.remove();
                bucketId = event.getBucketId();
                if (this.sender.isRunning()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("ParallelGatewaySenderQueue#remove: Cache is closing down. Ignoring remove request.");
                }
                return;
            }
            try {
                HDFSBucketRegionQueue brq = this.getBucketRegionQueue((PartitionedRegion)currentRegion, currentBucketId);
                if (brq == null) continue;
                brq.destroyKeys(listToDestroy);
                PartitionedRegion prQ = brq.getPartitionedRegion();
                this.addRemovedEvents(prQ, currentBucketId, destroyedSeqNum);
            }
            catch (ForceReattemptException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("ParallelGatewaySenderQueue#remove: Got ForceReattemptException for " + this + " for bucket = " + bucketId);
            }
            catch (EntryNotFoundException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("ParallelGatewaySenderQueue#remove: Got EntryNotFoundException for " + this + " for bucket = " + bucketId);
            }
        }
    }

    private void setElementsPeekedAcrossBuckets(int peekedElements) {
        this.elementsPeekedAcrossBuckets += peekedElements;
    }

    private int getAndresetElementsPeekedAcrossBuckets() {
        int peekedElements = this.elementsPeekedAcrossBuckets;
        this.elementsPeekedAcrossBuckets = 0;
        return peekedElements;
    }

    @Override
    public void remove() throws CacheException {
        throw new UnsupportedOperationException("Method HDFSParallelGatewaySenderQueue#remove is not supported");
    }

    @Override
    public void put(Object object) throws InterruptedException, CacheException {
        super.put(object);
    }

    protected ArrayList peekAhead(int bucketId, HDFSBucketRegionQueue hrq) throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug(this + ": Peekahead for the bucket " + bucketId);
        }
        ArrayList list = hrq.peekABatch();
        if (logger.isDebugEnabled() && list != null) {
            logger.debug(this + ": Peeked" + list.size() + "objects from bucket " + bucketId);
        }
        return list;
    }

    @Override
    public Object take() {
        throw new UnsupportedOperationException("take() is not supported for " + HDFSParallelGatewaySenderQueue.class.toString());
    }

    @Override
    protected boolean isUsedForHDFS() {
        return true;
    }

    @Override
    protected void afterRegionAdd(PartitionedRegion userPR) {
    }

    public HDFSGatewayEventImpl get(PartitionedRegion region, byte[] regionKey, int bucketId) throws ForceReattemptException {
        try {
            HDFSBucketRegionQueue brq = this.getBucketRegionQueue(region, bucketId);
            if (brq == null) {
                return null;
            }
            return brq.getObjectForRegionKey(region, regionKey);
        }
        catch (EntryNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("HDFSParallelGatewaySenderQueue#get: Got EntryNotFoundException for " + this + " for bucket = " + bucketId);
            }
            return null;
        }
    }

    @Override
    public void clear(PartitionedRegion pr, int bucketId) {
        try {
            HDFSBucketRegionQueue brq = this.getBucketRegionQueue(pr, bucketId);
            if (brq == null) {
                return;
            }
            brq.clear();
        }
        catch (ForceReattemptException forceReattemptException) {
            // empty catch block
        }
    }

    @Override
    public int size(PartitionedRegion pr, int bucketId) throws ForceReattemptException {
        HDFSBucketRegionQueue hq = this.getBucketRegionQueue(pr, bucketId);
        return hq.size();
    }

    public HDFSBucketRegionQueue getBucketRegionQueue(PartitionedRegion region, int bucketId) throws ForceReattemptException {
        PartitionedRegion leader = ColocationHelper.getLeaderRegion(region);
        if (leader == null) {
            return null;
        }
        String leaderregionPath = leader.getFullPath();
        PartitionedRegion prQ = (PartitionedRegion)this.userRegionNameToshadowPRMap.get(leaderregionPath);
        if (prQ == null) {
            return null;
        }
        HDFSBucketRegionQueue brq = (HDFSBucketRegionQueue)prQ.getDataStore().getLocalBucketById(bucketId);
        if (brq == null) {
            prQ.getRegionAdvisor().waitForLocalBucketStorage(bucketId);
        }
        brq = (HDFSBucketRegionQueue)prQ.getDataStore().getInitializedBucketForId(null, bucketId);
        return brq;
    }

    class RollSortedListsTimerTask
    extends SystemTimer.SystemTimerTask {
        RollSortedListsTimerTask() {
        }

        @Override
        public void run2() {
            Set<PartitionedRegion> prQs = HDFSParallelGatewaySenderQueue.this.getRegions();
            for (PartitionedRegion prQ : prQs) {
                ArrayList<Integer> buckets = new ArrayList<Integer>(prQ.getDataStore().getAllLocalPrimaryBucketIds());
                for (Integer bId : buckets) {
                    HDFSBucketRegionQueue hrq = (HDFSBucketRegionQueue)prQ.getDataStore().getLocalBucketById(bId);
                    if (hrq == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rolling over the list for bucket id: " + bId);
                    }
                    hrq.rolloverSkipList();
                }
            }
        }
    }
}

