/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.hdfs.internal.FailureTracker;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHDFSQueuePersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogOrganizer;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HDFSEventListener
implements AsyncEventListener {
    private final LogWriterI18n logger;
    private volatile boolean senderStopped = false;
    private final FailureTracker failureTracker = new FailureTracker(10L, 60000L, 1.5f);

    public HDFSEventListener(LogWriterI18n logger) {
        this.logger = logger;
    }

    @Override
    public void close() {
        this.senderStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processEvents(List<AsyncEvent> events) {
        if (Hoplog.NOP_WRITE) {
            return true;
        }
        Region<?, ?> previousRegion = null;
        int prevBucketId = -1;
        ArrayList<SortedHDFSQueuePersistedEvent> list = null;
        boolean success = false;
        try {
            this.failureTracker.sleepIfRetry();
            HoplogOrganizer bucketOrganizer = null;
            for (AsyncEvent asyncEvent : events) {
                if (this.senderStopped) {
                    this.failureTracker.failure();
                    if (this.logger.fineEnabled()) {
                        this.logger.fine("HDFSEventListener.processEvents: Cache is closing down. Ignoring the batch of data.");
                    }
                    boolean bl = false;
                    return bl;
                }
                HDFSGatewayEventImpl hdfsEvent = (HDFSGatewayEventImpl)asyncEvent;
                Region<?, ?> region = hdfsEvent.getRegion();
                if (prevBucketId != hdfsEvent.getBucketId() || region != previousRegion) {
                    if (prevBucketId != -1) {
                        bucketOrganizer.flush(list.iterator(), list.size());
                        success = true;
                        if (this.logger.fineEnabled()) {
                            this.logger.fine("Batch written to HDFS of size " + list.size() + " for region " + previousRegion);
                        }
                    }
                    if ((bucketOrganizer = this.getOrganizer((PartitionedRegion)region, hdfsEvent.getBucketId())) == null) {
                        throw new BucketMovedException("Bucket moved. BucketId: " + hdfsEvent.getBucketId() + " HDFSRegion: " + region.getName());
                    }
                    list = new ArrayList<SortedHDFSQueuePersistedEvent>();
                }
                try {
                    list.add(new SortedHDFSQueuePersistedEvent(hdfsEvent));
                }
                catch (ClassNotFoundException e) {
                    this.logger.warning(new StringId(0, "Error while converting HDFSGatewayEvent to PersistedEventImpl."), e);
                    boolean bl = false;
                    this.failureTracker.record(success);
                    return bl;
                }
                prevBucketId = hdfsEvent.getBucketId();
                previousRegion = region;
            }
            if (bucketOrganizer != null) {
                bucketOrganizer.flush(list.iterator(), list.size());
                success = true;
                if (this.logger.fineEnabled()) {
                    this.logger.fine("Batch written to HDFS of size " + list.size() + " for region " + previousRegion);
                }
            }
        }
        catch (IOException e) {
            this.logger.warning(LocalizedStrings.HOPLOG_FLUSH_FOR_BATCH_FAILED, e);
            boolean bl = false;
            return bl;
        }
        catch (ForceReattemptException e) {
            if (this.logger.fineEnabled()) {
                this.logger.fine(e);
            }
            boolean bl = false;
            return bl;
        }
        catch (PrimaryBucketException e) {
            if (this.logger.fineEnabled()) {
                this.logger.fine(e);
            }
            boolean bl = false;
            return bl;
        }
        catch (BucketMovedException e) {
            if (this.logger.fineEnabled()) {
                this.logger.fine(e);
            }
            boolean bl = false;
            return bl;
        }
        catch (CacheClosedException e) {
            if (this.logger.fineEnabled()) {
                this.logger.fine(e);
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e1) {
            if (this.logger.fineEnabled()) {
                this.logger.fine(e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.failureTracker.record(success);
        }
        return true;
    }

    private HoplogOrganizer getOrganizer(PartitionedRegion region, int bucketId) {
        BucketRegion br = region.getDataStore().getLocalBucketById(bucketId);
        if (br == null) {
            throw new PrimaryBucketException("Bucket region is no longer available " + bucketId + region);
        }
        return br.getHoplogOrganizer();
    }
}

