/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.hdfs.internal.FlushObserver;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.SignalledFlushObserver;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.AbstractBucketRegionQueue;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.persistence.soplog.ByteComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.CursorIterator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.logging.log4j.message.Message;

public class HDFSBucketRegionQueue
extends AbstractBucketRegionQueue {
    private static final boolean VERBOSE = Boolean.getBoolean("hdfsBucketRegionQueue.VERBOSE");
    private final int batchSize;
    volatile HDFSEventQueue hdfsEventQueue = null;
    private final AtomicBoolean releasingPrimaryLock = new AtomicBoolean(true);
    final AtomicLong queueSizeInBytes = new AtomicLong(0L);
    public boolean isBucketSorted = true;

    public HDFSBucketRegionQueue(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        this.isBucketSorted = internalRegionArgs.getPartitionedRegion().getParallelGatewaySender().getBucketSorted();
        this.hdfsEventQueue = this.isBucketSorted ? new MultiRegionSortedQueue() : new EventQueue();
        this.batchSize = internalRegionArgs.getPartitionedRegion().getParallelGatewaySender().getBatchSize() * 1024 * 1024;
        this.keySet();
    }

    @Override
    protected void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        super.initialize(snapshotInputStream, imageTarget, internalRegionArgs);
        this.loadEventsFromTempQueue();
        this.initialized = true;
        this.notifyEventProcessor();
    }

    private TreeSet<Long> createSkipListFromMap(Set keySet) {
        TreeSet<Long> sortedKeys = null;
        if (!this.hdfsEventQueue.isEmpty()) {
            return sortedKeys;
        }
        if (!keySet.isEmpty() && !(sortedKeys = new TreeSet<Long>(keySet)).isEmpty()) {
            for (Long key : sortedKeys) {
                Object hdfsevent;
                if (this.isBucketSorted) {
                    hdfsevent = this.getNoLRU(key, true, false, false);
                    if (hdfsevent == null) {
                        if (!logger.isDebugEnabled() && !VERBOSE) continue;
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Discarding key " + key + ", no event recovered"));
                        continue;
                    }
                    int eventSize = ((HDFSGatewayEventImpl)hdfsevent).getSizeOnHDFSInBytes(!this.isBucketSorted);
                    this.hdfsEventQueue.put(key, (HDFSGatewayEventImpl)hdfsevent, eventSize);
                    this.queueSizeInBytes.getAndAdd(eventSize);
                    continue;
                }
                hdfsevent = this.getNoLRU(key, true, false, false);
                if (hdfsevent != null) {
                    this.queueSizeInBytes.getAndAdd(((HDFSGatewayEventImpl)hdfsevent).getSizeOnHDFSInBytes(!this.isBucketSorted));
                }
                ((EventQueue)this.hdfsEventQueue).put(key);
            }
            this.getEventSeqNum().setIfGreater(sortedKeys.last());
        }
        if (logger.isDebugEnabled() || VERBOSE) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "For bucket " + this.getId() + ", total keys recovered are : " + keySet.size() + " and the seqNo is " + this.getEventSeqNum()));
        }
        return sortedKeys;
    }

    @Override
    protected void basicClear(RegionEventImpl ev) {
        super.basicClear(ev);
        this.queueSizeInBytes.set(0L);
        if (this.getBucketAdvisor().isPrimary()) {
            this.hdfsEventQueue.clear();
        }
    }

    @Override
    protected void clearQueues() {
        this.queueSizeInBytes.set(0L);
        if (this.getBucketAdvisor().isPrimary()) {
            this.hdfsEventQueue.clear();
        }
    }

    @Override
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        super.basicDestroy(event, cacheWrite, expectedOldValue);
    }

    ArrayList peekABatch() {
        ArrayList result = new ArrayList();
        this.hdfsEventQueue.peek(result);
        return result;
    }

    @Override
    protected void addToEventQueue(Object key, boolean didPut, EntryEventImpl event, int sizeOfHDFSEvent) {
        if (didPut && this.getBucketAdvisor().isPrimary()) {
            HDFSGatewayEventImpl hdfsEvent = (HDFSGatewayEventImpl)event.getValue();
            if (sizeOfHDFSEvent == -1) {
                try {
                    sizeOfHDFSEvent = hdfsEvent.getSizeOnHDFSInBytes(!this.isBucketSorted);
                }
                catch (Throwable e) {
                    sizeOfHDFSEvent = 0;
                }
            }
            this.queueSizeInBytes.getAndAdd(sizeOfHDFSEvent);
            if (this.initialized) {
                Long longKey = (Long)key;
                this.hdfsEventQueue.put(longKey, hdfsEvent, sizeOfHDFSEvent);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Put successfully in the queue : " + hdfsEvent + " . Queue initialized: " + this.initialized);
            }
        }
    }

    public Long remove() throws ForceReattemptException {
        throw new UnsupportedOperationException("Individual entries cannot be removed in a HDFSBucketRegionQueue");
    }

    public Object take() throws InterruptedException, ForceReattemptException {
        throw new UnsupportedOperationException("take() cannot be called for individual entries in a HDFSBucketRegionQueue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyKeys(ArrayList<HDFSGatewayEventImpl> listToDestroy) {
        HashSet<Long> removedSeqNums = new HashSet<Long>();
        for (int index = 0; index < listToDestroy.size(); ++index) {
            HDFSGatewayEventImpl entry = null;
            entry = this.isBucketSorted ? listToDestroy.get(listToDestroy.size() - index - 1) : listToDestroy.get(index);
            try {
                boolean deleted;
                if (logger.isDebugEnabled()) {
                    logger.debug("destroying primary key " + entry.getShadowKey() + " bucket id: " + this.getId());
                }
                if (!(deleted = this.hdfsEventQueue.remove(entry))) continue;
                long entrySize = entry.getSizeOnHDFSInBytes(!this.isBucketSorted);
                this.destroyKey(entry.getShadowKey());
                long queueSize = this.queueSizeInBytes.getAndAdd(-1L * entrySize);
                if (queueSize < 0L) {
                    this.queueSizeInBytes.compareAndSet(queueSize, 0L);
                }
                removedSeqNums.add(entry.getShadowKey());
                continue;
            }
            catch (ForceReattemptException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("ParallelGatewaySenderQueue#remove->HDFSBucketRegionQueue#destroyKeys: Got ForceReattemptException for " + this + " for bucket = " + this.getId());
                continue;
            }
            catch (EntryNotFoundException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("ParallelGatewaySenderQueue#remove->HDFSBucketRegionQueue#destroyKeys: Got EntryNotFoundException for " + this + " for bucket = " + this.getId() + " and key " + entry.getShadowKey());
                continue;
            }
            finally {
                entry.release();
            }
        }
        if (this.getBucketAdvisor().isPrimary()) {
            this.hdfsEventQueue.handleRemainingElements(removedSeqNums);
        }
    }

    public boolean isReadyForPeek() {
        return !this.isEmpty() && !this.hdfsEventQueue.isEmpty() && this.getBucketAdvisor().isPrimary();
    }

    public long getLastPeekTimeInMillis() {
        return this.hdfsEventQueue.getLastPeekTimeInMillis();
    }

    public long getQueueSizeInBytes() {
        return this.queueSizeInBytes.get();
    }

    @Override
    public void beforeAcquiringPrimaryState() {
        this.queueSizeInBytes.set(0L);
        if (logger.isDebugEnabled() || VERBOSE) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "This node has become primary for bucket " + this.getId() + ". " + "Creating sorted data structure for the async queue."));
        }
        this.releasingPrimaryLock.set(false);
        this.hdfsEventQueue.clear();
        this.hdfsEventQueue = this.isBucketSorted ? new MultiRegionSortedQueue() : new EventQueue();
        TreeSet<Long> sortedKeys = this.createSkipListFromMap(this.keySet());
        if (sortedKeys != null && sortedKeys.size() > 0) {
            long batchSizeMB = this.getPartitionedRegion().getParallelGatewaySender().getBatchSize();
            long batchSizeInBytes = batchSizeMB * 1024L * 1024L;
            long totalBucketSize = this.queueSizeInBytes.get();
            totalBucketSize = totalBucketSize > 0L ? totalBucketSize : 1L;
            long totalEntriesInBucket = this.entryCount();
            totalEntriesInBucket = totalEntriesInBucket > 0L ? totalEntriesInBucket : 1L;
            long perEntryApproxSize = totalBucketSize / totalEntriesInBucket;
            perEntryApproxSize = perEntryApproxSize > 0L ? perEntryApproxSize : 1L;
            int batchSize = (int)(batchSizeInBytes / perEntryApproxSize);
            if (logger.isDebugEnabled() || VERBOSE) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Calculating batch size  batchSizeMB: " + batchSizeMB + " batchSizeInBytes: " + batchSizeInBytes + " totalBucketSize: " + totalBucketSize + " totalEntriesInBucket: " + totalEntriesInBucket + " perEntryApproxSize: " + perEntryApproxSize + " batchSize: " + batchSize));
            }
            this.markEventsAsDuplicate(batchSize, sortedKeys.iterator());
        }
    }

    @Override
    public void beforeReleasingPrimaryLockDuringDemotion() {
        this.queueSizeInBytes.set(0L);
        this.releasingPrimaryLock.set(true);
        this.hdfsEventQueue.clear();
    }

    public HDFSGatewayEventImpl getObjectForRegionKey(Region region, byte[] regionKey) {
        return this.hdfsEventQueue.get(region, regionKey, Long.MIN_VALUE);
    }

    public SortedEventQueueIterator iterator(Region region) {
        return this.hdfsEventQueue.iterator(region);
    }

    public long totalEntries() {
        return this.entryCount();
    }

    public void rolloverSkipList() {
        this.hdfsEventQueue.rollover();
    }

    public boolean shouldDrainImmediately() {
        return this.hdfsEventQueue.getFlushObserver().shouldDrainImmediately();
    }

    public FlushObserver.AsyncFlushResult flush() {
        if (logger.isDebugEnabled() || VERBOSE) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Flush requested"));
        }
        return this.hdfsEventQueue.getFlushObserver().flush();
    }

    public final class SortedEventQueueIterator
    implements CursorIterator<HDFSGatewayEventImpl> {
        private final List<SortedEventBuffer.BufferIterator> iters = new ArrayList<SortedEventBuffer.BufferIterator>();
        private HDFSGatewayEventImpl value;

        public SortedEventQueueIterator(Deque<SortedEventBuffer> queueOfLists) {
            Iterator<SortedEventBuffer> iter = queueOfLists.descendingIterator();
            while (iter.hasNext()) {
                SortedEventBuffer.BufferIterator buf = iter.next().iterator();
                if (!buf.hasNext()) continue;
                buf.next();
                this.iters.add(buf);
            }
        }

        public void close() {
            this.value = null;
            this.iters.clear();
        }

        @Override
        public boolean hasNext() {
            return !this.iters.isEmpty();
        }

        @Override
        public HDFSGatewayEventImpl next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException();
            }
            int diff = 0;
            KeyToSeqNumObject min = null;
            SortedEventBuffer.BufferIterator cursor = null;
            Iterator<SortedEventBuffer.BufferIterator> merge = this.iters.iterator();
            while (merge.hasNext()) {
                SortedEventBuffer.BufferIterator buf = merge.next();
                KeyToSeqNumObject tmp = buf.key();
                if (min == null || (diff = Bytes.compareTo((byte[])tmp.regionkey, (byte[])min.regionkey)) < 0) {
                    min = tmp;
                    cursor = buf;
                    continue;
                }
                if (diff != 0 || this.advance(buf, min)) continue;
                merge.remove();
            }
            this.value = cursor.value();
            assert (this.value != null);
            if (!this.advance(cursor, min)) {
                this.iters.remove(cursor);
            }
            return this.current();
        }

        @Override
        public final HDFSGatewayEventImpl current() {
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean advance(SortedEventBuffer.BufferIterator iter, KeyToSeqNumObject key) {
            while (iter.hasNext()) {
                if (Bytes.compareTo((byte[])iter.next().regionkey, (byte[])key.regionkey) <= 0) continue;
                return true;
            }
            return false;
        }
    }

    public class SortedEventBuffer {
        private final HDFSGatewayEventImpl NULL = new HDFSGatewayEventImpl();
        private final ConcurrentSkipListMap<KeyToSeqNumObject, HDFSGatewayEventImpl> events = new ConcurrentSkipListMap();
        private int bufferSize = 0;

        public boolean copyToBuffer(HDFSGatewayEventImpl event) {
            KeyToSeqNumObject key = new KeyToSeqNumObject(event.getSerializedKey(), event.getShadowKey());
            if (this.events.containsKey(key)) {
                HDFSGatewayEventImpl oldVal = this.events.put(key, event);
                assert (oldVal == this.NULL);
                return true;
            }
            return HDFSBucketRegionQueue.this.releasingPrimaryLock.get();
        }

        public HDFSGatewayEventImpl getFromQueueOrBuffer(KeyToSeqNumObject key) {
            KeyToSeqNumObject result = this.events.ceilingKey(key);
            if (result != null && Bytes.compareTo((byte[])key.getRegionkey(), (byte[])result.getRegionkey()) == 0) {
                HDFSGatewayEventImpl evt = this.events.get(result);
                if (evt != this.NULL) {
                    return evt;
                }
                evt = (HDFSGatewayEventImpl)HDFSBucketRegionQueue.this.getNoLRU(result.getSeqNum(), true, false, false);
                if (evt != null) {
                    return evt;
                }
                evt = this.events.get(result);
                if (evt != this.NULL) {
                    return evt;
                }
            }
            return null;
        }

        public HDFSGatewayEventImpl add(KeyToSeqNumObject key, int sizeInBytes) {
            this.bufferSize += sizeInBytes;
            return this.events.put(key, this.NULL);
        }

        public void clear() {
            this.events.clear();
        }

        public boolean isEmpty() {
            return this.events.isEmpty();
        }

        public int bufferSize() {
            return this.bufferSize;
        }

        public int size() {
            return this.events.size();
        }

        public NavigableSet<KeyToSeqNumObject> keySet() {
            return this.events.keySet();
        }

        public BufferIterator iterator() {
            return new BufferIterator(this.events.keySet().iterator());
        }

        public class BufferIterator
        implements Iterator<KeyToSeqNumObject> {
            private final Iterator<KeyToSeqNumObject> src;
            private KeyToSeqNumObject currentKey;
            private HDFSGatewayEventImpl currentVal;
            private KeyToSeqNumObject nextKey;
            private HDFSGatewayEventImpl nextVal;

            public BufferIterator(Iterator<KeyToSeqNumObject> src) {
                this.src = src;
                this.moveNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.nextVal != null;
            }

            @Override
            public KeyToSeqNumObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.currentKey = this.nextKey;
                this.currentVal = this.nextVal;
                this.moveNext();
                return this.currentKey;
            }

            public KeyToSeqNumObject key() {
                assert (this.currentKey != null);
                return this.currentKey;
            }

            public HDFSGatewayEventImpl value() {
                assert (this.currentVal != null);
                return this.currentVal;
            }

            private void moveNext() {
                while (this.src.hasNext()) {
                    this.nextKey = this.src.next();
                    this.nextVal = SortedEventBuffer.this.getFromQueueOrBuffer(this.nextKey);
                    if (this.nextVal != null) {
                        return;
                    }
                    if (!logger.isDebugEnabled() && !VERBOSE) continue;
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "The entry corresponding to the sequence number " + this.nextKey.getSeqNum() + " is missing. This can happen when an entry is already" + " dispatched before a bucket moved."));
                }
                this.nextKey = null;
                this.nextVal = null;
            }
        }
    }

    class SortedEventQueue
    implements HDFSEventQueue {
        private final SignalledFlushObserver flush = new SignalledFlushObserver();
        final Deque<SortedEventBuffer> queueOfLists = new LinkedBlockingDeque<SortedEventBuffer>();
        volatile SortedEventBuffer currentSkipList = new SortedEventBuffer();
        private final AtomicBoolean peeking = new AtomicBoolean(false);
        private long lastPeekTimeInMillis = System.currentTimeMillis();

        public SortedEventQueue() {
            this.queueOfLists.add(this.currentSkipList);
        }

        @Override
        public FlushObserver getFlushObserver() {
            return this.flush;
        }

        @Override
        public boolean remove(HDFSGatewayEventImpl event) {
            SortedEventBuffer eventBuffer = this.queueOfLists.peek();
            if (eventBuffer != null) {
                return eventBuffer.copyToBuffer(event);
            }
            return true;
        }

        @Override
        public void clear() {
            this.flush.clear();
            for (SortedEventBuffer buf : this.queueOfLists) {
                HDFSBucketRegionQueue.this.decQueueSize(buf.size());
                buf.clear();
            }
            this.queueOfLists.clear();
            this.rollList(false);
            this.peeking.set(false);
        }

        @Override
        public boolean isEmpty() {
            if (this.queueOfLists.size() == 1) {
                return this.queueOfLists.peek().isEmpty();
            }
            return false;
        }

        @Override
        public void put(long key, HDFSGatewayEventImpl event, int eventSize) {
            if (logger.isTraceEnabled() || VERBOSE) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Inserting key " + event + " into list " + System.identityHashCode(this.currentSkipList)));
            }
            this.putInList(new KeyToSeqNumObject(event.getSerializedKey(), key), eventSize);
        }

        private void putInList(KeyToSeqNumObject entry, int sizeInBytes) {
            if (this.currentSkipList.add(entry, sizeInBytes) == null) {
                this.flush.push();
                HDFSBucketRegionQueue.this.incQueueSize();
            }
        }

        public void rollover(boolean forceRollover) {
            if (this.currentSkipList.bufferSize() >= HDFSBucketRegionQueue.this.batchSize || forceRollover) {
                this.rollList(forceRollover);
            }
        }

        @Override
        public void rollover() {
            this.rollover(false);
        }

        @Override
        public void peek(ArrayList peekedEntries) {
            if (!this.peeking.compareAndSet(false, true)) {
                if (logger.isTraceEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Peek already in progress, aborting"));
                }
                return;
            }
            if (this.queueOfLists.size() == 1) {
                this.rollList(false);
            }
            Assert.assertTrue(this.queueOfLists.size() > 1, "Cannot peek from head of queue");
            SortedEventBuffer.BufferIterator itr = this.queueOfLists.peek().iterator();
            while (itr.hasNext()) {
                KeyToSeqNumObject entry = itr.next();
                if (logger.isTraceEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Peeking key " + entry + " from list " + System.identityHashCode(this.queueOfLists.peek())));
                }
                HDFSGatewayEventImpl ev = itr.value();
                ev.copyOffHeapValue();
                peekedEntries.add(ev);
            }
            if (peekedEntries.isEmpty()) {
                SortedEventBuffer empty = this.queueOfLists.remove();
                if (logger.isTraceEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Discarding empty batch " + empty));
                }
                this.peeking.set(false);
            }
            this.lastPeekTimeInMillis = System.currentTimeMillis();
        }

        @Override
        public HDFSGatewayEventImpl get(Region region, byte[] regionKey, long key) {
            KeyToSeqNumObject event = new KeyToSeqNumObject(regionKey, key);
            Iterator<SortedEventBuffer> queueIterator = this.queueOfLists.descendingIterator();
            while (queueIterator.hasNext()) {
                HDFSGatewayEventImpl evt = queueIterator.next().getFromQueueOrBuffer(event);
                if (evt == null) continue;
                return evt;
            }
            return null;
        }

        @Override
        public void handleRemainingElements(HashSet<Long> removedSeqNums) {
            if (!this.peeking.get()) {
                if (logger.isTraceEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Not peeked, just cleaning up empty batch; current list is " + this.currentSkipList));
                }
                return;
            }
            Assert.assertTrue(this.queueOfLists.size() > 1, "Cannot remove only event list");
            SortedEventBuffer buf = this.queueOfLists.remove();
            SortedEventBuffer.BufferIterator bufIter = buf.iterator();
            while (bufIter.hasNext()) {
                HDFSGatewayEventImpl evt;
                KeyToSeqNumObject key = bufIter.next();
                if (removedSeqNums.contains(key.getSeqNum()) || (evt = (HDFSGatewayEventImpl)HDFSBucketRegionQueue.this.getNoLRU(key.getSeqNum(), true, false, false)) == null) continue;
                this.flush.push();
                HDFSBucketRegionQueue.this.incQueueSize();
                this.queueOfLists.getFirst().add(key, evt.getSizeOnHDFSInBytes(!HDFSBucketRegionQueue.this.isBucketSorted));
            }
            HDFSBucketRegionQueue.this.decQueueSize(buf.size());
            this.flush.pop(buf.size());
            this.peeking.set(false);
        }

        @Override
        public long getLastPeekTimeInMillis() {
            return this.lastPeekTimeInMillis;
        }

        NavigableSet<KeyToSeqNumObject> getPeeked() {
            assert (this.peeking.get());
            return this.queueOfLists.peek().keySet();
        }

        private synchronized void rollList(boolean forceRollover) {
            if (this.currentSkipList.bufferSize() < HDFSBucketRegionQueue.this.batchSize && this.queueOfLists.size() > 1 && !forceRollover) {
                return;
            }
            SortedEventBuffer tmp = new SortedEventBuffer();
            this.queueOfLists.add(tmp);
            if (logger.isTraceEnabled() || VERBOSE) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Rolling over list from " + this.currentSkipList + " to list " + tmp));
            }
            this.currentSkipList = tmp;
        }

        @Override
        public SortedEventQueueIterator iterator(Region region) {
            return new SortedEventQueueIterator(this.queueOfLists);
        }
    }

    class EventQueue
    implements HDFSEventQueue {
        private final SignalledFlushObserver flush = new SignalledFlushObserver();
        private final BlockingQueue<Long> eventSeqNumQueue = new LinkedBlockingQueue<Long>();
        private final BlockingQueue<Long> peekedEvents = new LinkedBlockingQueue<Long>();
        private long lastPeekTimeInMillis = System.currentTimeMillis();

        @Override
        public FlushObserver getFlushObserver() {
            return this.flush;
        }

        @Override
        public void put(long key, HDFSGatewayEventImpl event, int size) {
            this.put(key);
        }

        public void put(long key) {
            this.eventSeqNumQueue.add(key);
            this.flush.push();
            HDFSBucketRegionQueue.this.incQueueSize();
        }

        @Override
        public HDFSGatewayEventImpl get(Region region, byte[] regionKey, long minValue) {
            throw new InternalGemFireError("Get not supported on unsorted queue");
        }

        @Override
        public void peek(ArrayList peekedEntries) {
            Long seqNum;
            if (this.peekedEvents.size() != 0) {
                return;
            }
            int size = 0;
            while (size < HDFSBucketRegionQueue.this.batchSize && (seqNum = (Long)this.eventSeqNumQueue.peek()) != null) {
                Object object = HDFSBucketRegionQueue.this.getNoLRU(seqNum, true, false, false);
                if (object != null) {
                    this.peekedEvents.add(seqNum);
                    size += ((HDFSGatewayEventImpl)object).getSizeOnHDFSInBytes(!HDFSBucketRegionQueue.this.isBucketSorted);
                    peekedEntries.add(object);
                } else {
                    logger.debug("The entry corresponding to the sequence number " + seqNum + " is missing. This can happen when an entry is already" + "dispatched before a bucket moved.");
                    HDFSBucketRegionQueue.this.decQueueSize();
                    this.flush.pop(1);
                }
                this.eventSeqNumQueue.poll();
            }
            this.lastPeekTimeInMillis = System.currentTimeMillis();
        }

        @Override
        public boolean isEmpty() {
            return this.eventSeqNumQueue.isEmpty();
        }

        @Override
        public boolean remove(HDFSGatewayEventImpl event) {
            boolean deleted = this.peekedEvents.remove(event.getShadowKey());
            if (deleted) {
                HDFSBucketRegionQueue.this.decQueueSize();
            }
            return deleted;
        }

        @Override
        public void handleRemainingElements(HashSet<Long> removedSeqNums) {
            this.flush.pop(removedSeqNums.size());
            this.eventSeqNumQueue.addAll(this.peekedEvents);
            this.peekedEvents.clear();
        }

        @Override
        public void clear() {
            this.flush.clear();
            HDFSBucketRegionQueue.this.decQueueSize(this.eventSeqNumQueue.size());
            this.eventSeqNumQueue.clear();
            HDFSBucketRegionQueue.this.decQueueSize(this.peekedEvents.size());
            this.peekedEvents.clear();
        }

        @Override
        public long getLastPeekTimeInMillis() {
            return this.lastPeekTimeInMillis;
        }

        @Override
        public SortedEventQueueIterator iterator(Region region) {
            throw new InternalGemFireError("not supported on unsorted queue");
        }

        @Override
        public void rollover() {
            throw new InternalGemFireError("not supported on unsorted queue");
        }
    }

    class MultiRegionSortedQueue
    implements HDFSEventQueue {
        ConcurrentMap<String, SortedEventQueue> regionToEventQueue = new ConcurrentHashMap<String, SortedEventQueue>();
        volatile Set<SortedEventQueue> peekedQueues = Collections.EMPTY_SET;
        private final AtomicBoolean peeking = new AtomicBoolean(false);
        long lastPeekTimeInMillis = System.currentTimeMillis();
        private final FlushObserver flush = new FlushObserver(){

            @Override
            public FlushObserver.AsyncFlushResult flush() {
                final HashSet<FlushObserver.AsyncFlushResult> flushes = new HashSet<FlushObserver.AsyncFlushResult>();
                for (SortedEventQueue queue : MultiRegionSortedQueue.this.regionToEventQueue.values()) {
                    flushes.add(queue.getFlushObserver().flush());
                }
                return new FlushObserver.AsyncFlushResult(){

                    @Override
                    public boolean waitForFlush(long timeout, TimeUnit unit) throws InterruptedException {
                        long start = System.nanoTime();
                        long remaining = unit.toNanos(timeout);
                        for (FlushObserver.AsyncFlushResult afr : flushes) {
                            if (!afr.waitForFlush(remaining, TimeUnit.NANOSECONDS)) {
                                return false;
                            }
                            remaining -= System.nanoTime() - start;
                        }
                        return true;
                    }
                };
            }

            @Override
            public boolean shouldDrainImmediately() {
                for (SortedEventQueue queue : MultiRegionSortedQueue.this.regionToEventQueue.values()) {
                    if (!queue.getFlushObserver().shouldDrainImmediately()) continue;
                    return true;
                }
                return false;
            }
        };

        MultiRegionSortedQueue() {
        }

        @Override
        public FlushObserver getFlushObserver() {
            return this.flush;
        }

        @Override
        public void put(long key, HDFSGatewayEventImpl event, int size) {
            String region = event.getRegionPath();
            SortedEventQueue regionQueue = (SortedEventQueue)this.regionToEventQueue.get(region);
            if (regionQueue == null) {
                this.regionToEventQueue.putIfAbsent(region, new SortedEventQueue());
                regionQueue = (SortedEventQueue)this.regionToEventQueue.get(region);
            }
            regionQueue.put(key, event, size);
        }

        @Override
        public void peek(ArrayList result) {
            if (!this.peeking.compareAndSet(false, true)) {
                if (logger.isTraceEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Peek already in progress, aborting"));
                }
                return;
            }
            this.peekedQueues = Collections.newSetFromMap(new ConcurrentHashMap(this.regionToEventQueue.size()));
            for (SortedEventQueue queue : this.regionToEventQueue.values()) {
                if (queue.isEmpty()) continue;
                queue.peek(result);
                this.peekedQueues.add(queue);
            }
            if (result.isEmpty()) {
                this.peeking.set(false);
            }
            this.lastPeekTimeInMillis = System.currentTimeMillis();
        }

        @Override
        public boolean isEmpty() {
            for (SortedEventQueue queue : this.regionToEventQueue.values()) {
                if (queue.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean remove(HDFSGatewayEventImpl event) {
            String region = event.getRegionPath();
            SortedEventQueue regionQueue = (SortedEventQueue)this.regionToEventQueue.get(region);
            return regionQueue.remove(event);
        }

        @Override
        public void handleRemainingElements(HashSet<Long> removedSeqNums) {
            for (SortedEventQueue queue : this.peekedQueues) {
                queue.handleRemainingElements(removedSeqNums);
            }
            this.peekedQueues.clear();
            this.peeking.set(false);
        }

        @Override
        public void clear() {
            for (SortedEventQueue queue : this.regionToEventQueue.values()) {
                queue.clear();
            }
            this.peekedQueues.clear();
            this.peeking.set(false);
        }

        @Override
        public long getLastPeekTimeInMillis() {
            return this.lastPeekTimeInMillis;
        }

        @Override
        public HDFSGatewayEventImpl get(Region region, byte[] regionKey, long minValue) {
            SortedEventQueue queue = (SortedEventQueue)this.regionToEventQueue.get(region.getFullPath());
            if (queue == null) {
                return null;
            }
            return queue.get(region, regionKey, minValue);
        }

        @Override
        public SortedEventQueueIterator iterator(Region region) {
            SortedEventQueue queue = (SortedEventQueue)this.regionToEventQueue.get(region.getFullPath());
            if (queue == null) {
                return new SortedEventQueueIterator(new LinkedBlockingDeque<SortedEventBuffer>());
            }
            return queue.iterator(region);
        }

        @Override
        public void rollover() {
            for (SortedEventQueue queue : this.regionToEventQueue.values()) {
                queue.rollover();
            }
        }
    }

    public static interface HDFSEventQueue {
        public FlushObserver getFlushObserver();

        public void put(long var1, HDFSGatewayEventImpl var3, int var4);

        public SortedEventQueueIterator iterator(Region var1);

        public void rollover();

        public HDFSGatewayEventImpl get(Region var1, byte[] var2, long var3);

        public void peek(ArrayList var1);

        public boolean isEmpty();

        public boolean remove(HDFSGatewayEventImpl var1);

        public void handleRemainingElements(HashSet<Long> var1);

        public void clear();

        public long getLastPeekTimeInMillis();
    }

    static class KeyToSeqNumObject
    implements Comparable<KeyToSeqNumObject> {
        private byte[] regionkey;
        private Long seqNum;

        KeyToSeqNumObject(byte[] regionkey, Long seqNum) {
            this.regionkey = regionkey;
            this.seqNum = seqNum;
        }

        @Override
        public int compareTo(KeyToSeqNumObject o) {
            int compareOutput = ByteComparator.compareBytes(this.getRegionkey(), 0, this.getRegionkey().length, o.getRegionkey(), 0, o.getRegionkey().length);
            if (compareOutput != 0) {
                return compareOutput;
            }
            if (this.getSeqNum() == Long.MIN_VALUE) {
                return -1;
            }
            if (o.getSeqNum() == Long.MIN_VALUE) {
                return 1;
            }
            return this.getSeqNum().compareTo(o.getSeqNum()) * -1;
        }

        public boolean equals(Object o) {
            KeyToSeqNumObject obj = null;
            if (o == null) {
                return false;
            }
            if (!(o instanceof KeyToSeqNumObject)) {
                return false;
            }
            obj = (KeyToSeqNumObject)o;
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return -1;
        }

        byte[] getRegionkey() {
            return this.regionkey;
        }

        public Long getSeqNum() {
            return this.seqNum;
        }

        public void setSeqNum(Long seqNum) {
            this.seqNum = seqNum;
        }

        public String toString() {
            return EntryEventImpl.deserialize(this.regionkey) + " {" + this.seqNum + "}";
        }
    }
}

