/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs;

import com.gemstone.gemfire.cache.hdfs.HDFSStoreMutator;

public interface HDFSStore {
    public static final String DEFAULT_HOME_DIR = "gemfire";
    public static final float DEFAULT_BLOCK_CACHE_SIZE = 10.0f;
    public static final int DEFAULT_WRITE_ONLY_FILE_SIZE_LIMIT = 256;
    public static final int DEFAULT_WRITE_ONLY_FILE_ROLLOVER_INTERVAL = 3600;
    public static final int DEFAULT_BATCH_SIZE_MB = 32;
    public static final int DEFAULT_BATCH_INTERVAL_MILLIS = 60000;
    public static final boolean DEFAULT_WRITEONLY_HDFSSTORE = false;
    public static final boolean DEFAULT_BUFFER_PERSISTANCE = false;
    public static final boolean DEFAULT_DISK_SYNCHRONOUS = true;
    public static final int DEFAULT_MAX_BUFFER_MEMORY = 100;
    public static final int DEFAULT_DISPATCHER_THREADS = 5;
    public static final boolean DEFAULT_MINOR_COMPACTION = true;
    public static final int DEFAULT_MINOR_COMPACTION_THREADS = 10;
    public static final boolean DEFAULT_MAJOR_COMPACTION = true;
    public static final int DEFAULT_MAJOR_COMPACTION_THREADS = 2;
    public static final int DEFAULT_INPUT_FILE_SIZE_MAX_MB = 512;
    public static final int DEFAULT_INPUT_FILE_COUNT_MAX = 10;
    public static final int DEFAULT_INPUT_FILE_COUNT_MIN = 4;
    public static final int DEFAULT_MAJOR_COMPACTION_INTERVAL_MINS = 720;
    public static final int DEFAULT_OLD_FILE_CLEANUP_INTERVAL_MINS = 30;

    public String getName();

    public String getNameNodeURL();

    public String getHomeDir();

    public String getHDFSClientConfigFile();

    public int getMaxMemory();

    public float getBlockCacheSize();

    public int getBatchSize();

    public int getBatchInterval();

    public int getDispatcherThreads();

    public boolean getBufferPersistent();

    public String getDiskStoreName();

    public boolean getSynchronousDiskWrite();

    public int getWriteOnlyFileRolloverSize();

    public int getWriteOnlyFileRolloverInterval();

    public boolean getMinorCompaction();

    public int getMinorCompactionThreads();

    public boolean getMajorCompaction();

    public int getMajorCompactionInterval();

    public int getMajorCompactionThreads();

    public int getPurgeInterval();

    public void destroy();

    public HDFSStoreMutator createHdfsStoreMutator();

    public HDFSStore alter(HDFSStoreMutator var1);

    public int getInputFileSizeMax();

    public int getInputFileCountMin();

    public int getInputFileCountMax();
}

