/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.client.internal.locator.SerializationHelper;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationRequest;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public class QueueConnectionRequest
extends ServerLocationRequest {
    private ClientProxyMembershipID proxyId;
    private Set excludedServers;
    private int redundantCopies;
    private boolean findDurable = false;

    public QueueConnectionRequest() {
    }

    public QueueConnectionRequest(ClientProxyMembershipID proxyId, int redundantCopies, Set excludedServers, String serverGroup, boolean findDurable) {
        super(serverGroup);
        this.proxyId = proxyId;
        this.excludedServers = excludedServers;
        this.redundantCopies = redundantCopies;
        this.findDurable = findDurable;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.proxyId = ClientProxyMembershipID.readCanonicalized(in);
        this.redundantCopies = DataSerializer.readPrimitiveInt(in);
        this.excludedServers = SerializationHelper.readServerLocationSet(in);
        this.findDurable = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.proxyId, out);
        DataSerializer.writePrimitiveInt(this.redundantCopies, out);
        SerializationHelper.writeServerLocationSet(this.excludedServers, out);
        out.writeBoolean(this.findDurable);
    }

    public Set getExcludedServers() {
        return this.excludedServers;
    }

    public ClientProxyMembershipID getProxyId() {
        return this.proxyId;
    }

    public int getRedundantCopies() {
        return this.redundantCopies;
    }

    public boolean isFindDurable() {
        return this.findDurable;
    }

    public String toString() {
        return "QueueConnectionRequest{group=" + this.getServerGroup() + ", excluded=" + this.getExcludedServers() + ", redundant= " + this.redundantCopies + ",findDurable=" + this.findDurable + ",proxyId=" + this.proxyId + "}";
    }

    @Override
    public int getDSFID() {
        return -52;
    }
}

