/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator;

import com.gemstone.gemfire.cache.client.internal.locator.SerializationHelper;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationResponse;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class LocatorListResponse
extends ServerLocationResponse {
    private List<ServerLocation> controllers;
    private boolean isBalanced;
    private boolean locatorsFound = false;

    public LocatorListResponse() {
    }

    public LocatorListResponse(List<ServerLocation> locators, boolean isBalanced) {
        this.controllers = locators;
        if (locators != null && !locators.isEmpty()) {
            this.locatorsFound = true;
        }
        this.isBalanced = isBalanced;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.controllers = SerializationHelper.readServerLocationList(in);
        this.isBalanced = in.readBoolean();
        if (this.controllers != null && !this.controllers.isEmpty()) {
            this.locatorsFound = true;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        SerializationHelper.writeServerLocationList(this.controllers, out);
        out.writeBoolean(this.isBalanced);
    }

    public List<ServerLocation> getLocators() {
        return this.controllers;
    }

    public boolean isBalanced() {
        return this.isBalanced;
    }

    public String toString() {
        return "LocatorListResponse{locators=" + this.controllers + ",isBalanced=" + this.isBalanced + "}";
    }

    @Override
    public int getDSFID() {
        return -51;
    }

    @Override
    public boolean hasResult() {
        return this.locatorsFound;
    }
}

