/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator;

import com.gemstone.gemfire.cache.client.internal.locator.SerializationHelper;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationRequest;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public class ClientConnectionRequest
extends ServerLocationRequest {
    Set excludedServers;

    public ClientConnectionRequest() {
    }

    public ClientConnectionRequest(Set excludedServers, String serverGroup) {
        super(serverGroup);
        this.excludedServers = excludedServers;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.excludedServers = SerializationHelper.readServerLocationSet(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        SerializationHelper.writeServerLocationSet(this.excludedServers, out);
    }

    public Set getExcludedServers() {
        return this.excludedServers;
    }

    public String toString() {
        return "ClientConnectionRequest{group=" + this.getServerGroup() + ", excluded=" + this.getExcludedServers() + "}";
    }

    @Override
    public int getDSFID() {
        return -53;
    }
}

